/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.common;

import java.lang.reflect.Executable;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.logging.Logger;
import oracle.jdbc.OracleShardingKey;
import oracle.jdbc.internal.OracleConnection;
import oracle.ucp.ConnectionAffinityCallback;
import oracle.ucp.ConnectionRetrievalInfo;
import oracle.ucp.ShardConnectionStatistics;
import oracle.ucp.UniversalConnectionPoolException;
import oracle.ucp.UniversalPooledConnection;
import oracle.ucp.common.ConnectionSource;
import oracle.ucp.common.CoreConnection;
import oracle.ucp.common.CoreConnectionImpl;
import oracle.ucp.common.Counter;
import oracle.ucp.common.CriStats;
import oracle.ucp.common.CriStatsRegistry;
import oracle.ucp.common.Database;
import oracle.ucp.common.FailoverDriver;
import oracle.ucp.common.Limits;
import oracle.ucp.common.LoadBalancer;
import oracle.ucp.common.ONSDriver;
import oracle.ucp.common.Selector;
import oracle.ucp.common.Selectors;
import oracle.ucp.common.Service;
import oracle.ucp.common.ServiceMember;
import oracle.ucp.common.UniversalPooledConnectionImpl;
import oracle.ucp.jdbc.JDBCConnectionRetrievalInfo;
import oracle.ucp.jdbc.oracle.OracleUniversalPooledConnection;
import oracle.ucp.logging.ClioSupport;
import oracle.ucp.logging.annotations.DefaultLogger;
import oracle.ucp.logging.annotations.Feature;
import oracle.ucp.logging.annotations.Supports;
import oracle.ucp.routing.DataDependentRoutingCache;
import oracle.ucp.routing.ShardRoutingCache;
import oracle.ucp.util.UCPErrorHandler;
import oracle.ucp.util.Util;

@DefaultLogger(value="oracle.ucp.common")
@Supports(value={Feature.CHECK_IN, Feature.CHECK_OUT, Feature.CONN_CONSTRUCTION, Feature.CONN_DESTRUCTION, Feature.LOAD_BALANCING, Feature.HIGH_AVAILABILITY})
public abstract class Topology
extends Database {
    private final AtomicReference<ConnectionRetrievalInfo> defaultCri = new AtomicReference<Object>(null);
    private String defaultServiceName = null;
    private final Map<String, Service> services = new ConcurrentHashMap<String, Service>();
    private Service latestRegisteredService = null;
    private final AtomicReference<ONSDriver> onsDriver = new AtomicReference<Object>(null);
    private boolean onsStarted = false;
    private boolean isShardedDatabase = false;
    private boolean isCatalogDatabase = false;
    private boolean isMultitenantDatabase = false;
    private boolean isRacDataAffinityEnabled = false;
    private boolean isDataDependentRoutingEnabled = false;
    private String poolRegionName = null;
    private final AtomicBoolean fanHeuristicallyEnabled = new AtomicBoolean(false);
    private volatile int outboundConnectTimeout = 0;
    protected boolean replayable = false;
    private final CriStatsRegistry criStatsRegistry = new CriStatsRegistry();
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;
    private static Executable $$$methodRef$$$12;
    private static Logger $$$loggerRef$$$12;
    private static Executable $$$methodRef$$$13;
    private static Logger $$$loggerRef$$$13;
    private static Executable $$$methodRef$$$14;
    private static Logger $$$loggerRef$$$14;
    private static Executable $$$methodRef$$$15;
    private static Logger $$$loggerRef$$$15;
    private static Executable $$$methodRef$$$16;
    private static Logger $$$loggerRef$$$16;
    private static Executable $$$methodRef$$$17;
    private static Logger $$$loggerRef$$$17;
    private static Executable $$$methodRef$$$18;
    private static Logger $$$loggerRef$$$18;
    private static Executable $$$methodRef$$$19;
    private static Logger $$$loggerRef$$$19;
    private static Executable $$$methodRef$$$20;
    private static Logger $$$loggerRef$$$20;
    private static Executable $$$methodRef$$$21;
    private static Logger $$$loggerRef$$$21;
    private static Executable $$$methodRef$$$22;
    private static Logger $$$loggerRef$$$22;
    private static Executable $$$methodRef$$$23;
    private static Logger $$$loggerRef$$$23;
    private static Executable $$$methodRef$$$24;
    private static Logger $$$loggerRef$$$24;
    private static Executable $$$methodRef$$$25;
    private static Logger $$$loggerRef$$$25;
    private static Executable $$$methodRef$$$26;
    private static Logger $$$loggerRef$$$26;
    private static Executable $$$methodRef$$$27;
    private static Logger $$$loggerRef$$$27;
    private static Executable $$$methodRef$$$28;
    private static Logger $$$loggerRef$$$28;
    private static Executable $$$methodRef$$$29;
    private static Logger $$$loggerRef$$$29;
    private static Executable $$$methodRef$$$30;
    private static Logger $$$loggerRef$$$30;
    private static Executable $$$methodRef$$$31;
    private static Logger $$$loggerRef$$$31;
    private static Executable $$$methodRef$$$32;
    private static Logger $$$loggerRef$$$32;
    private static Executable $$$methodRef$$$33;
    private static Logger $$$loggerRef$$$33;
    private static Executable $$$methodRef$$$34;
    private static Logger $$$loggerRef$$$34;
    private static Executable $$$methodRef$$$35;
    private static Logger $$$loggerRef$$$35;
    private static Executable $$$methodRef$$$36;
    private static Logger $$$loggerRef$$$36;
    private static Executable $$$methodRef$$$37;
    private static Logger $$$loggerRef$$$37;
    private static Executable $$$methodRef$$$38;
    private static Logger $$$loggerRef$$$38;
    private static Executable $$$methodRef$$$39;
    private static Logger $$$loggerRef$$$39;
    private static Executable $$$methodRef$$$40;
    private static Logger $$$loggerRef$$$40;
    private static Executable $$$methodRef$$$41;
    private static Logger $$$loggerRef$$$41;
    private static Executable $$$methodRef$$$42;
    private static Logger $$$loggerRef$$$42;
    private static Executable $$$methodRef$$$43;
    private static Logger $$$loggerRef$$$43;
    private static Executable $$$methodRef$$$44;
    private static Logger $$$loggerRef$$$44;
    private static Executable $$$methodRef$$$45;
    private static Logger $$$loggerRef$$$45;
    private static Executable $$$methodRef$$$46;
    private static Logger $$$loggerRef$$$46;
    private static Executable $$$methodRef$$$47;
    private static Logger $$$loggerRef$$$47;
    private static Executable $$$methodRef$$$48;
    private static Logger $$$loggerRef$$$48;
    private static Executable $$$methodRef$$$49;
    private static Logger $$$loggerRef$$$49;
    private static Executable $$$methodRef$$$50;
    private static Logger $$$loggerRef$$$50;
    private static Executable $$$methodRef$$$51;
    private static Logger $$$loggerRef$$$51;
    private static Executable $$$methodRef$$$52;
    private static Logger $$$loggerRef$$$52;

    Topology() {
    }

    protected abstract String getONSConfig() throws UniversalConnectionPoolException;

    protected abstract AtomicLong cumulativeConnectionUseTime();

    public abstract Limits limits();

    protected abstract boolean shardingMode();

    @Override
    public CoreConnection create(ConnectionRetrievalInfo cri, ConnectionAffinityCallback affinityCallback, EnumSet<ConnectionSource.CreateMode> createModes, long timeToRetry) throws UniversalConnectionPoolException {
        timeToRetry = Math.max(0L, timeToRetry);
        JDBCConnectionRetrievalInfo jdbcCri = cri instanceof JDBCConnectionRetrievalInfo ? (JDBCConnectionRetrievalInfo)cri : null;
        String requestedServiceName = jdbcCri != null ? this.serviceName(jdbcCri) : this.defaultServiceName;
        Service service = this.service(requestedServiceName);
        if (service == null) {
            throw UCPErrorHandler.newUniversalConnectionPoolException(204, "Unknown service " + requestedServiceName);
        }
        CoreConnection conn = service.create(cri, affinityCallback, createModes, timeToRetry);
        if (null == conn) {
            return null;
        }
        String connSvcName = conn.serviceName();
        if (jdbcCri != null) {
            if (jdbcCri.getUserRequestedServiceName() == null && !requestedServiceName.equalsIgnoreCase(connSvcName)) {
                if (!this.failoverEnabled() || connSvcName != null && !"".equalsIgnoreCase(connSvcName) && this.service((String)this.defaultServiceName).activeMembers.get() == 0 && this.service((String)connSvcName).activeMembers.get() == 1) {
                    this.defaultServiceName = connSvcName;
                    this.defaultCri.set(((JDBCConnectionRetrievalInfo)this.defaultCri.get()).getCopyWithService(connSvcName));
                }
            } else if (jdbcCri.getUserRequestedServiceName() != null && !requestedServiceName.equalsIgnoreCase(connSvcName)) {
                conn.close();
                throw UCPErrorHandler.newUniversalConnectionPoolException(204, "Unknown service " + requestedServiceName);
            }
        }
        return conn;
    }

    private static String logicalServiceName(String serviceName) {
        if (serviceName == null) {
            return null;
        }
        if (!serviceName.contains("%")) {
            return serviceName;
        }
        return serviceName.substring(serviceName.indexOf(37) + 1);
    }

    private static String extractRegionName(String serviceName) {
        if (serviceName == null || !serviceName.contains("%")) {
            return null;
        }
        return serviceName.substring(0, serviceName.indexOf(37));
    }

    private String prefixRegionName(String serviceName) {
        if (serviceName == null) {
            return null;
        }
        String regionPrefix = this.poolRegionName == null ? "" : this.poolRegionName + "%";
        return regionPrefix + Topology.logicalServiceName(serviceName);
    }

    @Override
    public void start(ConnectionRetrievalInfo cri, Consumer<String> serviceNameConsumer, Consumer<CoreConnection> connectionConsumer) throws UniversalConnectionPoolException {
        if (!this.isOracle()) {
            ClioSupport.ilogFinest(null, null, null, null, "non-oracle case, no metadata connection needed");
            if (Objects.nonNull(serviceNameConsumer)) {
                this.defaultServiceName = "";
                serviceNameConsumer.accept(this.prefixRegionName(""));
            }
            this.defaultCri.compareAndSet(null, this.newCri(cri));
            return;
        }
        ClioSupport.ilogFinest(null, null, null, null, "oracle case, metadata connection will be attempted to be created");
        Util.disableDriverHA();
        Util.disableImplicitBeginRequest();
        UniversalPooledConnection upc = null;
        try {
            upc = this.createPooledConnection(cri);
            assert (Objects.nonNull(upc));
            if (!(upc instanceof UniversalPooledConnectionImpl)) {
                this.defaultCri.compareAndSet(null, this.newCri(cri));
                return;
            }
            UniversalPooledConnectionImpl upci = (UniversalPooledConnectionImpl)upc;
            this.defaultServiceName = Topology.logicalServiceName(upci.getService());
            this.defaultCri.compareAndSet(null, this.newCri(cri));
            upci.setConnectionRetrievalInfo(this.newCri(cri));
            if (!(upci instanceof OracleUniversalPooledConnection)) {
                return;
            }
            OracleUniversalPooledConnection oupc = (OracleUniversalPooledConnection)upci;
            boolean[] shardingMode = oupc.getShardingMode();
            this.isShardedDatabase = shardingMode[0];
            if (this.isShardedDatabase && !this.shardingMode()) {
                this.isShardedDatabase = false;
            }
            this.isCatalogDatabase = shardingMode[1];
            this.isMultitenantDatabase = oupc.isMultitenantDatabase();
            this.isRacDataAffinityEnabled = shardingMode[2];
            this.isDataDependentRoutingEnabled = this.isShardedDatabase | this.isRacDataAffinityEnabled;
            this.poolRegionName = Topology.extractRegionName(upci.getService());
            this.enableFANHeuristically(oupc);
            Connection conn = oupc.getSQLConnection(oupc.getPhysicalConnection());
            OracleConnection oconn = conn.unwrap(OracleConnection.class);
            this.outboundConnectTimeout = oconn.getOutboundConnectTimeout() / 1000;
            ClioSupport.ilogFine(null, null, null, null, "outbound connection timeout is " + this.outboundConnectTimeout + " seconds");
        }
        catch (SQLException e) {
            ClioSupport.ilogThrowing(null, null, null, null, e);
            throw new UniversalConnectionPoolException(e);
        }
        finally {
            if (Objects.nonNull(upc)) {
                if (Objects.nonNull(connectionConsumer) && Objects.nonNull(serviceNameConsumer) && Objects.nonNull(this.defaultServiceName) && 0 != this.defaultServiceName.length()) {
                    serviceNameConsumer.accept(this.defaultServiceName);
                    upc.plugDelegator(CoreConnectionImpl.create(this.service(this.defaultServiceName), upc));
                    connectionConsumer.accept(upc.getDelegator());
                } else {
                    this.connectionsCreated().decrementAndGet();
                    ((UniversalPooledConnectionImpl)upc).closeNoStatsUpdate();
                }
            }
        }
    }

    private ConnectionRetrievalInfo newCri(ConnectionRetrievalInfo cri) {
        ConnectionRetrievalInfo noLabelsCopyCri = cri.getCopyWithNoLabels();
        return noLabelsCopyCri instanceof JDBCConnectionRetrievalInfo ? ((JDBCConnectionRetrievalInfo)noLabelsCopyCri).getCopyWithService(this.defaultServiceName) : noLabelsCopyCri;
    }

    @Override
    public void stop() {
        if (null != this.onsDriver.getAndSet(null)) {
            this.onsStarted = false;
            this.services.forEach((name, service) -> {
                service.stop();
                service.routingCache().destroy();
            });
            this.defaultCri.set(null);
        }
        this.services.clear();
        this.fanHeuristicallyEnabled.set(false);
    }

    @Override
    public boolean isReplayable() {
        return this.replayable;
    }

    @Override
    public void setReplayable(boolean isReplayable) {
        this.replayable = isReplayable;
    }

    @Override
    public LoadBalancer.Stats loadBalancerStats(String serviceName) {
        Service service;
        if (serviceName == null) {
            if (this.defaultCri() instanceof JDBCConnectionRetrievalInfo) {
                JDBCConnectionRetrievalInfo jdbcCri = (JDBCConnectionRetrievalInfo)this.defaultCri();
                serviceName = jdbcCri.getServiceName();
            } else {
                serviceName = this.defaultServiceName();
            }
        }
        if (serviceName != null && (service = this.service(serviceName)) != null) {
            return this.service(serviceName).loadBalancerStats();
        }
        return new LoadBalancer.Stats();
    }

    @Override
    public FailoverDriver.Stats failoverDriverStats(String serviceName) {
        Service service;
        if (serviceName == null) {
            if (this.defaultCri() instanceof JDBCConnectionRetrievalInfo) {
                JDBCConnectionRetrievalInfo jdbcCri = (JDBCConnectionRetrievalInfo)this.defaultCri();
                serviceName = jdbcCri.getServiceName();
            } else {
                serviceName = this.defaultServiceName();
            }
        }
        if (serviceName != null && (service = this.service(serviceName)) != null) {
            return this.service(serviceName).failoverDriverStats();
        }
        return new FailoverDriver.Stats();
    }

    @Override
    public Selector loadBalancedBorrowSelector(ConnectionRetrievalInfo cri, ConnectionAffinityCallback affinityCallback) {
        return this.service(this.serviceName(cri)).loadBalancedBorrowSelector(cri, affinityCallback);
    }

    @Override
    public Selector routingKeyBasedBorrowSelector(ConnectionRetrievalInfo cri, boolean usePriority) {
        if (this.isDataDependentRoutingEnabled) {
            final DataDependentRoutingCache routingCache = this.service(this.serviceName(cri)).routingCache();
            if (!(cri instanceof JDBCConnectionRetrievalInfo)) {
                return Selectors.EVERY;
            }
            JDBCConnectionRetrievalInfo jdbcCri = (JDBCConnectionRetrievalInfo)cri;
            OracleShardingKey key = jdbcCri.getShardingKey();
            if (key == null) {
                return Selectors.EVERY;
            }
            final HashSet<ServiceMember> instanceSet = new HashSet<ServiceMember>();
            if (usePriority) {
                instanceSet.addAll(routingCache.allPriorityInstances(cri));
            } else {
                instanceSet.addAll(routingCache.allInstances(cri));
            }
            return new Selector(){
                private static Executable $$$methodRef$$$0;
                private static Logger $$$loggerRef$$$0;
                private static Executable $$$methodRef$$$1;
                private static Logger $$$loggerRef$$$1;

                @Override
                public boolean selected(CoreConnection connection) {
                    return routingCache.selected(connection, instanceSet);
                }

                static {
                    try {
                        $$$methodRef$$$1 = 1.class.getDeclaredConstructor(Topology.class, DataDependentRoutingCache.class, Set.class);
                    }
                    catch (Throwable throwable) {}
                    $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                    try {
                        $$$methodRef$$$0 = 1.class.getDeclaredMethod("selected", CoreConnection.class);
                    }
                    catch (Throwable throwable) {}
                    $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                }
            };
        }
        return Selectors.EVERY;
    }

    @Override
    public String serviceName(ConnectionRetrievalInfo cri) {
        if (!(cri instanceof JDBCConnectionRetrievalInfo)) {
            return this.defaultServiceName();
        }
        JDBCConnectionRetrievalInfo jdbcCri = (JDBCConnectionRetrievalInfo)cri;
        String logicalSvcName = jdbcCri.getServiceName();
        return this.poolRegionName == null ? logicalSvcName : this.prefixRegionName(logicalSvcName);
    }

    @Override
    public ConnectionRetrievalInfo defaultCri() {
        return this.defaultCri.get();
    }

    @Override
    public String defaultServiceName() {
        if (Objects.isNull(this.defaultServiceName)) {
            return "";
        }
        return this.defaultServiceName;
    }

    public ONSDriver onsDriver(String onsConfig) throws UniversalConnectionPoolException {
        if (this.onsDriver.compareAndSet(null, ONSDriver.instance())) {
            ONSDriver onsDrvr = this.onsDriver.get();
            this.onsStarted = onsDrvr.start(onsConfig);
        }
        if (this.onsStarted) {
            return this.onsDriver.get();
        }
        return null;
    }

    public Service service(String serviceName) {
        if (Objects.nonNull(this.poolRegionName)) {
            serviceName = this.prefixRegionName(serviceName);
        }
        if (serviceName == null) {
            serviceName = this.defaultServiceName();
        }
        if (1 == this.services.size() && null != this.latestRegisteredService && this.latestRegisteredService.name().equals(serviceName)) {
            return this.latestRegisteredService;
        }
        return this.services.get(serviceName);
    }

    @Override
    public void registerService(String serviceName, ConnectionSource.FailoverCallback failoverCallback, ConnectionSource.RebalanceCallback rebalanceCallback) {
        if (Objects.isNull(this.service(serviceName))) {
            if (Objects.nonNull(this.poolRegionName)) {
                serviceName = this.prefixRegionName(serviceName);
            }
            this.services.computeIfAbsent(serviceName, p -> {
                this.latestRegisteredService = new Service(this, (String)p, failoverCallback, rebalanceCallback);
                return this.latestRegisteredService;
            });
        }
    }

    @Override
    public boolean isServiceRegistered(String serviceName) {
        return Objects.nonNull(this.service(serviceName));
    }

    @Override
    public Selector serviceSelector(String serviceName) {
        return conn -> {
            String connServiceName = conn.serviceName();
            assert (Objects.nonNull(connServiceName));
            assert (Objects.nonNull(serviceName));
            String prefixRegionName = this.prefixRegionName(serviceName);
            assert (Objects.nonNull(prefixRegionName));
            return connServiceName.equals(prefixRegionName);
        };
    }

    @Override
    public boolean isShardedDatabase() {
        return this.isShardedDatabase;
    }

    @Override
    public boolean isCatalogDatabase() {
        return this.isCatalogDatabase;
    }

    @Override
    public boolean isMultitenantDatabase() {
        return this.isMultitenantDatabase;
    }

    @Override
    public boolean isRacDataAffinityEnabled() {
        return this.isRacDataAffinityEnabled;
    }

    boolean isDataDependentRoutingEnabled() {
        return this.isDataDependentRoutingEnabled;
    }

    @Override
    public boolean validateCri(ConnectionRetrievalInfo cri) {
        if (!(cri instanceof JDBCConnectionRetrievalInfo)) {
            return true;
        }
        JDBCConnectionRetrievalInfo jdbcCri = (JDBCConnectionRetrievalInfo)cri;
        if (!this.isServiceRegistered(jdbcCri.getServiceName())) {
            return false;
        }
        if (this.isDataDependentRoutingEnabled) {
            return this.service(this.serviceName(cri)).routingCache().validateCri(jdbcCri);
        }
        return true;
    }

    @Override
    public boolean available(ConnectionRetrievalInfo cri) {
        String svcName = this.serviceName(cri);
        if (!this.isServiceRegistered(svcName)) {
            return false;
        }
        CriStats criMetadata = this.getCriMetadata(cri);
        return (long)(criMetadata.totalConnCount().get() - criMetadata.borrowedConnCount().get()) - criMetadata.getBorrowSemaphore().getWaitingAcquires() > 0L;
    }

    @Override
    public Selector serviceBasedRepurposeSelector(ConnectionRetrievalInfo cri, boolean balanced) {
        String svcName = this.serviceName(cri);
        if (!(cri instanceof JDBCConnectionRetrievalInfo) || !this.isServiceRegistered(svcName)) {
            return Selectors.NONE;
        }
        return this.service(svcName).serviceBasedRepurposeSelector(cri, balanced);
    }

    String getDatabaseTopologyInfo() {
        StringBuilder sb = new StringBuilder();
        if (this.services.isEmpty()) {
            sb.append("[]");
        } else {
            for (Service svc : this.services.values()) {
                sb.append("[service name=").append(svc.name()).append(": insts=").append(svc.getAllMembers()).append("]");
            }
        }
        return sb.toString();
    }

    String getShardedDatabaseInfo() {
        StringBuffer infoStr = new StringBuffer();
        if (this.isDataDependentRoutingEnabled && this.isServiceRegistered(this.defaultServiceName)) {
            infoStr.append(this.service(this.defaultServiceName).routingCache().metadataInfo());
        } else {
            infoStr.append("not populated or not connected");
        }
        return infoStr.toString();
    }

    String getShardRoutingCacheInfo() {
        StringBuffer infoStr = new StringBuffer();
        if (this.isDataDependentRoutingEnabled && this.isServiceRegistered(this.defaultServiceName)) {
            infoStr.append(this.service(this.defaultServiceName).routingCache().cacheEntries());
        } else {
            infoStr.append("not populated or not connected");
        }
        return infoStr.toString();
    }

    private void enableFANHeuristically(OracleUniversalPooledConnection oupc) {
        OracleConnection oconn = null;
        try {
            Connection conn = oupc.getSQLConnection(oupc.getPhysicalConnection());
            if (conn instanceof OracleConnection) {
                oconn = (OracleConnection)conn;
            }
        }
        catch (Exception exc) {
            oconn = null;
            ClioSupport.ilogThrowing(null, null, null, null, exc);
        }
        if (oconn == null) {
            return;
        }
        boolean fanEnabled = true;
        try {
            Util.getClassForName("oracle.ons.ONS", false, Thread.currentThread().getContextClassLoader(), this.getClass().getClassLoader());
        }
        catch (Throwable err) {
            fanEnabled = false;
            ClioSupport.ilogFine(null, null, null, null, "ons.jar is not on the classpath, FAN is disabled, " + err);
        }
        if (fanEnabled) {
            ClioSupport.ilogFine(null, null, null, null, "Heuristically determine whether to enable FAN");
            try {
                short dbver = oconn.getVersionNumber();
                if (dbver < 12101) {
                    fanEnabled = false;
                    ClioSupport.ilogFine(null, null, null, null, "Pre-12c DB, FAN is heuristically disabled");
                } else {
                    Properties connSig = oconn.getServerSessionInfo();
                    String autoONSConfig = connSig.getProperty("AUTH_ONS_CONFIG");
                    if (autoONSConfig == null) {
                        fanEnabled = false;
                        ClioSupport.ilogFine(null, null, null, null, "Single-instance 12.x DB, FAN is heuristically disabled");
                    } else {
                        fanEnabled = true;
                        ClioSupport.ilogFine(null, null, null, null, "RAC/GDS 12.x, FAN is heuristically enabled");
                    }
                }
            }
            catch (Throwable exc) {
                fanEnabled = false;
                ClioSupport.ilogFine(null, null, null, null, "Internal error happened, FAN is heuristically disabled, " + exc);
            }
        }
        this.fanHeuristicallyEnabled.set(fanEnabled);
    }

    boolean isFANHeuristicallyEnabled() {
        return this.fanHeuristicallyEnabled.get();
    }

    @Override
    public Counter totalCount(ConnectionRetrievalInfo cri) {
        return this.criStatsRegistry.getCriStats(cri).totalConnCount();
    }

    @Override
    public Counter borrowedCount(ConnectionRetrievalInfo cri) {
        return this.criStatsRegistry.getCriStats(cri).borrowedConnCount();
    }

    @Override
    public CriStats getCriMetadata(ConnectionRetrievalInfo cri) {
        return this.criStatsRegistry.getCriStats(cri);
    }

    Map<String, ShardConnectionStatistics> getShardConnectionStats() {
        if (this.isShardedDatabase) {
            Service svc = this.service(this.defaultServiceName);
            return svc != null ? ((ShardRoutingCache)svc.routingCache()).getShardConnectionStats() : Collections.emptyMap();
        }
        return Collections.emptyMap();
    }

    @Override
    public int getOutboundConnectTimeout() {
        return this.outboundConnectTimeout;
    }

    static {
        try {
            $$$methodRef$$$52 = Topology.class.getDeclaredConstructor(new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$52 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$51 = Topology.class.getDeclaredMethod("lambda$stop$0", String.class, Service.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$51 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$50 = Topology.class.getDeclaredMethod("lambda$registerService$1", ConnectionSource.FailoverCallback.class, ConnectionSource.RebalanceCallback.class, String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$50 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$49 = Topology.class.getDeclaredMethod("lambda$serviceSelector$2", String.class, CoreConnection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$49 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$48 = Topology.class.getDeclaredMethod("costComparator", Properties.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$48 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$47 = Topology.class.getDeclaredMethod("perfectCostSelector", Properties.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$47 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$46 = Topology.class.getDeclaredMethod("physicalConnectionSelector", Object.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$46 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$45 = Topology.class.getDeclaredMethod("wrongCostSelector", Properties.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$45 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$44 = Topology.class.getDeclaredMethod("matchingCriSelector", ConnectionRetrievalInfo.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$44 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$43 = Topology.class.getDeclaredMethod("availableConnectionsSelector", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$43 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$42 = Topology.class.getDeclaredMethod("harvestableConnectionSelector", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$42 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$41 = Topology.class.getDeclaredMethod("inactiveConnectionsSelector", Long.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$41 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$40 = Topology.class.getDeclaredMethod("abandonedConnectionsSelector", Long.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$40 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$39 = Topology.class.getDeclaredMethod("ttlConnectionsSelector", Long.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$39 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$38 = Topology.class.getDeclaredMethod("getOutboundConnectTimeout", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$38 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$37 = Topology.class.getDeclaredMethod("getShardConnectionStats", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$37 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$36 = Topology.class.getDeclaredMethod("getCriMetadata", ConnectionRetrievalInfo.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$36 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$35 = Topology.class.getDeclaredMethod("borrowedCount", ConnectionRetrievalInfo.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$35 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$34 = Topology.class.getDeclaredMethod("totalCount", ConnectionRetrievalInfo.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$34 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$33 = Topology.class.getDeclaredMethod("isFANHeuristicallyEnabled", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$33 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$32 = Topology.class.getDeclaredMethod("enableFANHeuristically", OracleUniversalPooledConnection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$32 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$31 = Topology.class.getDeclaredMethod("getShardRoutingCacheInfo", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$31 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$30 = Topology.class.getDeclaredMethod("getShardedDatabaseInfo", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$30 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$29 = Topology.class.getDeclaredMethod("getDatabaseTopologyInfo", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$29 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$28 = Topology.class.getDeclaredMethod("serviceBasedRepurposeSelector", ConnectionRetrievalInfo.class, Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$28 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$27 = Topology.class.getDeclaredMethod("available", ConnectionRetrievalInfo.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$27 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$26 = Topology.class.getDeclaredMethod("validateCri", ConnectionRetrievalInfo.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$26 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$25 = Topology.class.getDeclaredMethod("isDataDependentRoutingEnabled", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$25 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$24 = Topology.class.getDeclaredMethod("isRacDataAffinityEnabled", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$24 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$23 = Topology.class.getDeclaredMethod("isMultitenantDatabase", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$23 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$22 = Topology.class.getDeclaredMethod("isCatalogDatabase", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$22 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$21 = Topology.class.getDeclaredMethod("isShardedDatabase", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$21 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$20 = Topology.class.getDeclaredMethod("serviceSelector", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$20 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$19 = Topology.class.getDeclaredMethod("isServiceRegistered", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$19 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$18 = Topology.class.getDeclaredMethod("registerService", String.class, ConnectionSource.FailoverCallback.class, ConnectionSource.RebalanceCallback.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$18 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$17 = Topology.class.getDeclaredMethod("service", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$17 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$16 = Topology.class.getDeclaredMethod("onsDriver", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$16 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$15 = Topology.class.getDeclaredMethod("defaultServiceName", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$15 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$14 = Topology.class.getDeclaredMethod("defaultCri", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$14 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$13 = Topology.class.getDeclaredMethod("serviceName", ConnectionRetrievalInfo.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$13 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$12 = Topology.class.getDeclaredMethod("routingKeyBasedBorrowSelector", ConnectionRetrievalInfo.class, Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$11 = Topology.class.getDeclaredMethod("loadBalancedBorrowSelector", ConnectionRetrievalInfo.class, ConnectionAffinityCallback.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$10 = Topology.class.getDeclaredMethod("failoverDriverStats", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$9 = Topology.class.getDeclaredMethod("loadBalancerStats", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$8 = Topology.class.getDeclaredMethod("setReplayable", Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$7 = Topology.class.getDeclaredMethod("isReplayable", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$6 = Topology.class.getDeclaredMethod("stop", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$5 = Topology.class.getDeclaredMethod("newCri", ConnectionRetrievalInfo.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$4 = Topology.class.getDeclaredMethod("start", ConnectionRetrievalInfo.class, Consumer.class, Consumer.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$3 = Topology.class.getDeclaredMethod("prefixRegionName", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$2 = Topology.class.getDeclaredMethod("extractRegionName", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$1 = Topology.class.getDeclaredMethod("logicalServiceName", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$0 = Topology.class.getDeclaredMethod("create", ConnectionRetrievalInfo.class, ConnectionAffinityCallback.class, EnumSet.class, Long.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
    }
}

