/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.nt;

import java.io.IOException;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketOption;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SocketChannel;
import java.util.Set;
import java.util.function.Consumer;

public abstract class SocketChannelWrapper
extends SocketChannel {
    protected SocketChannel socketChannel = null;
    protected int bufferSize = 8192;

    SocketChannelWrapper(SocketChannel socketChannel) {
        super(socketChannel != null ? socketChannel.provider() : null);
        this.socketChannel = socketChannel;
    }

    abstract void disconnect() throws IOException;

    public SocketChannel getUnderlyingChannel() {
        return this.socketChannel;
    }

    public void setBufferSize(int n2) {
        this.bufferSize = n2;
    }

    void setUnderlyingChannel(SocketChannel socketChannel) {
        this.socketChannel = socketChannel;
    }

    void setSoTimeout(int n2) {
        if (!(this.socketChannel instanceof SocketChannelWrapper)) {
            throw new UnsupportedOperationException();
        }
        ((SocketChannelWrapper)this.socketChannel).setSoTimeout(n2);
    }

    int getSoTimeout() {
        if (this.socketChannel instanceof SocketChannelWrapper) {
            return ((SocketChannelWrapper)this.socketChannel).getSoTimeout();
        }
        throw new UnsupportedOperationException();
    }

    void registerForNonBlockingRead(Consumer<Throwable> consumer) throws IOException {
        if (!(this.socketChannel instanceof SocketChannelWrapper)) {
            throw new UnsupportedOperationException();
        }
        ((SocketChannelWrapper)this.socketChannel).registerForNonBlockingRead(consumer);
    }

    void registerForNonBlockingWrite(Consumer<Throwable> consumer) throws IOException {
        if (!(this.socketChannel instanceof SocketChannelWrapper)) {
            throw new UnsupportedOperationException();
        }
        ((SocketChannelWrapper)this.socketChannel).registerForNonBlockingWrite(consumer);
    }

    @Override
    public <T> T getOption(SocketOption<T> socketOption) throws IOException {
        return this.requireOpenChannel().getOption(socketOption);
    }

    @Override
    public Set<SocketOption<?>> supportedOptions() {
        return this.requireNonNullChannel().supportedOptions();
    }

    @Override
    public SocketChannel bind(SocketAddress socketAddress) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> SocketChannel setOption(SocketOption<T> socketOption, T t2) throws IOException {
        return this.requireOpenChannel().setOption((SocketOption)socketOption, (Object)t2);
    }

    @Override
    public SocketChannel shutdownInput() throws IOException {
        return this.requireOpenChannel().shutdownInput();
    }

    @Override
    public SocketChannel shutdownOutput() throws IOException {
        return this.requireOpenChannel().shutdownOutput();
    }

    @Override
    public Socket socket() {
        return this.requireNonNullChannel().socket();
    }

    @Override
    public boolean isConnected() {
        return this.socketChannel != null && this.socketChannel.isConnected();
    }

    @Override
    public boolean isConnectionPending() {
        return this.requireNonNullChannel().isConnectionPending();
    }

    @Override
    public boolean connect(SocketAddress socketAddress) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean finishConnect() throws IOException {
        return this.requireOpenChannel().finishConnect();
    }

    @Override
    public SocketAddress getRemoteAddress() throws IOException {
        return this.requireOpenChannel().getRemoteAddress();
    }

    @Override
    public long read(ByteBuffer[] byteBufferArray, int n2, int n3) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public long write(ByteBuffer[] byteBufferArray, int n2, int n3) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public SocketAddress getLocalAddress() throws IOException {
        return this.requireOpenChannel().getLocalAddress();
    }

    @Override
    protected void implCloseSelectableChannel() throws IOException {
        this.requireOpenChannel().close();
    }

    @Override
    protected void implConfigureBlocking(boolean bl) throws IOException {
        this.requireOpenChannel().configureBlocking(bl);
    }

    protected SocketChannel requireOpenChannel() throws ClosedChannelException {
        SocketChannel socketChannel = this.socketChannel;
        if (socketChannel == null) {
            throw new ClosedChannelException();
        }
        return socketChannel;
    }

    private SocketChannel requireNonNullChannel() throws IllegalStateException {
        try {
            return this.requireOpenChannel();
        }
        catch (ClosedChannelException closedChannelException) {
            throw new IllegalStateException("Socket is closed.", closedChannelException);
        }
    }

    static SocketChannel unwrap(SocketChannel socketChannel) {
        SocketChannel socketChannel2 = socketChannel;
        while (socketChannel2 instanceof SocketChannelWrapper) {
            socketChannel2 = ((SocketChannelWrapper)socketChannel2).getUnderlyingChannel();
        }
        return socketChannel2;
    }
}

