/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.jdbc.proxy.oracle;

import java.lang.reflect.Executable;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLRecoverableException;
import java.sql.Statement;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Logger;
import javax.sql.XAConnection;
import oracle.jdbc.OracleConnection;
import oracle.jdbc.driver.OracleConnection;
import oracle.jdbc.internal.ClientDataSupport;
import oracle.ucp.AbandonedConnectionTimeoutCallback;
import oracle.ucp.ConnectionHarvestingCallback;
import oracle.ucp.ConnectionRetrievalInfo;
import oracle.ucp.TimeToLiveConnectionTimeoutCallback;
import oracle.ucp.UniversalConnectionPool;
import oracle.ucp.UniversalConnectionPoolException;
import oracle.ucp.UniversalPooledConnection;
import oracle.ucp.UniversalPooledConnectionStatus;
import oracle.ucp.common.Clock;
import oracle.ucp.common.UniversalConnectionPoolBase;
import oracle.ucp.jdbc.ConnectionWithAbandonedTimeout;
import oracle.ucp.jdbc.ConnectionWithTimeToLiveTimeout;
import oracle.ucp.jdbc.HarvestableConnection;
import oracle.ucp.jdbc.JDBCConnectionRetrievalInfo;
import oracle.ucp.jdbc.LabelableConnection;
import oracle.ucp.jdbc.ValidConnection;
import oracle.ucp.jdbc.oracle.Poolable;
import oracle.ucp.jdbc.proxy.Creator;
import oracle.ucp.jdbc.proxy.LogicalObject;
import oracle.ucp.jdbc.proxy.oracle.StatementProxy;
import oracle.ucp.logging.ClioSupport;
import oracle.ucp.logging.annotations.DisableTrace;
import oracle.ucp.proxy.annotation.ProxyResult;
import oracle.ucp.proxy.annotation.ProxyResultPolicy;
import oracle.ucp.util.Chain;
import oracle.ucp.util.MapChain;
import oracle.ucp.util.UCPErrorHandler;

@DisableTrace
abstract class ConnectionProxyBase
implements LabelableConnection,
HarvestableConnection,
ConnectionWithAbandonedTimeout,
ConnectionWithTimeToLiveTimeout,
ValidConnection,
XAConnection,
LogicalObject,
Poolable,
ClientDataSupport {
    protected final long creationTS = Clock.clock();
    final AtomicBoolean closed = new AtomicBoolean(false);
    protected final AtomicBoolean actuallyReturned = new AtomicBoolean(false);
    protected Chain<StatementProxy> statementsToClose = new MapChain<StatementProxy>();
    private volatile UniversalPooledConnection proxiedPooledConnection = null;
    private volatile UniversalConnectionPool proxiedPool = null;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;
    private static Executable $$$methodRef$$$12;
    private static Logger $$$loggerRef$$$12;
    private static Executable $$$methodRef$$$13;
    private static Logger $$$loggerRef$$$13;
    private static Executable $$$methodRef$$$14;
    private static Logger $$$loggerRef$$$14;
    private static Executable $$$methodRef$$$15;
    private static Logger $$$loggerRef$$$15;
    private static Executable $$$methodRef$$$16;
    private static Logger $$$loggerRef$$$16;
    private static Executable $$$methodRef$$$17;
    private static Logger $$$loggerRef$$$17;
    private static Executable $$$methodRef$$$18;
    private static Logger $$$loggerRef$$$18;
    private static Executable $$$methodRef$$$19;
    private static Logger $$$loggerRef$$$19;
    private static Executable $$$methodRef$$$20;
    private static Logger $$$loggerRef$$$20;
    private static Executable $$$methodRef$$$21;
    private static Logger $$$loggerRef$$$21;
    private static Executable $$$methodRef$$$22;
    private static Logger $$$loggerRef$$$22;
    private static Executable $$$methodRef$$$23;
    private static Logger $$$loggerRef$$$23;
    private static Executable $$$methodRef$$$24;
    private static Logger $$$loggerRef$$$24;
    private static Executable $$$methodRef$$$25;
    private static Logger $$$loggerRef$$$25;
    private static Executable $$$methodRef$$$26;
    private static Logger $$$loggerRef$$$26;
    private static Executable $$$methodRef$$$27;
    private static Logger $$$loggerRef$$$27;
    private static Executable $$$methodRef$$$28;
    private static Logger $$$loggerRef$$$28;
    private static Executable $$$methodRef$$$29;
    private static Logger $$$loggerRef$$$29;
    private static Executable $$$methodRef$$$30;
    private static Logger $$$loggerRef$$$30;
    private static Executable $$$methodRef$$$31;
    private static Logger $$$loggerRef$$$31;
    private static Executable $$$methodRef$$$32;
    private static Logger $$$loggerRef$$$32;
    private static Executable $$$methodRef$$$33;
    private static Logger $$$loggerRef$$$33;
    private static Executable $$$methodRef$$$34;
    private static Logger $$$loggerRef$$$34;
    private static Executable $$$methodRef$$$35;
    private static Logger $$$loggerRef$$$35;
    private static Executable $$$methodRef$$$36;
    private static Logger $$$loggerRef$$$36;

    ConnectionProxyBase() {
    }

    UniversalPooledConnection getUPC() {
        Object c;
        UniversalPooledConnection upc = this.proxiedPooledConnection;
        if (null == upc && null != (c = this.getCreator())) {
            this.proxiedPooledConnection = c instanceof Creator ? ((Creator)c).getUPC() : ((ConnectionProxyBase)c).getUPC();
            upc = this.proxiedPooledConnection;
        }
        return upc;
    }

    UniversalConnectionPool getUCP() {
        Object c;
        UniversalConnectionPool ucp = this.proxiedPool;
        if (null == ucp && null != (c = this.getCreator())) {
            this.proxiedPool = c instanceof Creator ? ((Creator)c).getUCP() : ((ConnectionProxyBase)c).getUCP();
            ucp = this.proxiedPool;
        }
        return ucp;
    }

    protected abstract Connection getDelegate();

    protected abstract Object getCreator();

    private void handleExceptionHelper() {
        if (!this.actuallyReturned.get()) {
            try {
                try {
                    ClioSupport.ilogFinest(null, null, null, null, "about to close statements");
                    for (StatementProxy stmt : this.statementsToClose.toList()) {
                        stmt.close();
                    }
                }
                catch (Throwable t) {
                    ClioSupport.ilogThrowing(null, null, null, null, t);
                }
                this.statementsToClose.clear();
                ClioSupport.ilogFinest(null, null, null, null, "about to set STATUS_BAD");
                UniversalPooledConnection upc = this.getUPC();
                assert (null != upc) : "upc shold be defined at this point";
                try {
                    upc.setStatus(UniversalPooledConnectionStatus.STATUS_BAD);
                }
                catch (Throwable t) {
                    ClioSupport.ilogThrowing(null, null, null, null, t);
                }
                ClioSupport.ilogFinest(null, null, null, null, "about to return bad connection back to a pool");
                UniversalConnectionPool ucp = this.getUCP();
                assert (null != ucp) : "ucp shold be defined at this point";
                ucp.returnConnection(upc);
                this.actuallyReturned.set(true);
                this.closed.set(true);
            }
            catch (UniversalConnectionPoolException ucpe) {
                ClioSupport.ilogThrowing(null, null, null, null, ucpe);
            }
        }
    }

    protected void handleSQLRecoverableException(SQLException e) throws SQLException {
        ClioSupport.ilogFinest(null, null, null, null, "about to handle SQLException");
        ClioSupport.ilogThrowing(null, null, null, null, e);
        if (e instanceof SQLRecoverableException) {
            this.handleExceptionHelper();
        }
        ClioSupport.ilogFinest(null, null, null, null, "done handling SQLException");
    }

    protected void handleRuntimeException(RuntimeException e) throws RuntimeException {
        ClioSupport.ilogWarning(null, null, null, null, "driver threw RuntimeException: " + e.getMessage());
    }

    @Override
    public void close() throws SQLException {
        UniversalPooledConnection upc = this.getUPC();
        assert (null != upc) : "upc shold be defined at this point";
        upc.heartbeat();
        if (this.closed.get()) {
            return;
        }
        try {
            try {
                for (StatementProxy stmt : this.statementsToClose.toList()) {
                    stmt.close();
                }
            }
            catch (Throwable t) {
                ClioSupport.ilogThrowing(null, null, null, null, t);
            }
            this.statementsToClose.clear();
            UniversalConnectionPool ucp = this.getUCP();
            assert (null != ucp) : "ucp shold be defined at this point";
            ucp.returnConnection(upc);
            this.closed.set(true);
            this.actuallyReturned.set(true);
            upc.heartbeat();
        }
        catch (UniversalConnectionPoolException e) {
            Throwable cause = e.getCause();
            if (null == cause) {
                throw new SQLException(e);
            }
            Throwable cause2 = cause.getCause();
            if (null == cause2 || !(cause2 instanceof SQLException)) {
                throw new SQLException(e);
            }
            throw (SQLException)cause2;
        }
    }

    public void close(int code) throws SQLException {
        ConnectionRetrievalInfo cri;
        UniversalPooledConnection upc = this.getUPC();
        assert (null != upc) : "upc shold be defined at this point";
        upc.heartbeat();
        ((oracle.jdbc.internal.OracleConnection)this.getDelegate()).close(code);
        if (1 == code && (cri = upc.getConnectionRetrievalInfo()) instanceof JDBCConnectionRetrievalInfo) {
            JDBCConnectionRetrievalInfo jdbcCri = (JDBCConnectionRetrievalInfo)cri;
            upc.setConnectionRetrievalInfo(jdbcCri.getCopyWithNewProxyProperties(-1, null));
        }
        upc.heartbeat();
    }

    public void close(Properties props) throws SQLException {
        UniversalPooledConnection upc = this.getUPC();
        assert (null != upc) : "upc shold be defined at this point";
        upc.heartbeat();
        ((oracle.jdbc.internal.OracleConnection)this.getDelegate()).close(props);
        upc.heartbeat();
    }

    public boolean isUsable() {
        if (this.closed.get()) {
            return false;
        }
        return ((oracle.jdbc.internal.OracleConnection)this.getDelegate()).isUsable();
    }

    public boolean isValid(int timeout) throws SQLException {
        if (this.closed.get()) {
            return false;
        }
        return this.getDelegate().isValid(timeout);
    }

    public boolean isValid(OracleConnection.ConnectionValidation effort, int timeout) throws SQLException {
        if (this.closed.get()) {
            return false;
        }
        return ((oracle.jdbc.internal.OracleConnection)this.getDelegate()).isValid(effort, timeout);
    }

    @Override
    public boolean isValid() throws SQLException {
        if (this.closed.get()) {
            return false;
        }
        UniversalPooledConnection upc = this.getUPC();
        assert (null != upc) : "upc shold be defined at this point";
        return upc.isValid();
    }

    @Override
    public void setInvalid() throws SQLException {
        UniversalPooledConnection upc = this.getUPC();
        assert (null != upc) : "upc shold be defined at this point";
        upc.heartbeat();
        try {
            upc.setStatus(UniversalPooledConnectionStatus.STATUS_BAD);
        }
        catch (UniversalConnectionPoolException e) {
            throw new SQLException(e);
        }
    }

    public boolean isClosed() throws SQLException {
        if (this.closed.get()) {
            return true;
        }
        boolean alreadyClosedOnDriver = this.getDelegate().isClosed();
        if (alreadyClosedOnDriver) {
            ClioSupport.ilogFine(null, null, null, null, "this connection was closed/killed/aborted on the driver, lets invalidate it and return");
            UniversalPooledConnection upc = this.getUPC();
            assert (null != upc) : "upc shold be defined at this point";
            try {
                upc.setStatus(UniversalPooledConnectionStatus.STATUS_BAD);
                ClioSupport.ilogFine(null, null, null, null, "invalidated");
            }
            catch (Throwable t) {
                ClioSupport.ilogThrowing(null, null, null, null, t);
            }
            ClioSupport.ilogFinest(null, null, null, null, "about to return bad connection back to a pool");
            UniversalConnectionPool ucp = this.getUCP();
            assert (null != ucp) : "ucp shold be defined at this point";
            try {
                ucp.returnConnection(upc);
                ClioSupport.ilogFine(null, null, null, null, "returned back to a pool");
            }
            catch (UniversalConnectionPoolException ucpe) {
                ClioSupport.ilogThrowing(null, null, null, null, ucpe);
            }
            this.actuallyReturned.set(true);
            this.closed.set(true);
        }
        return alreadyClosedOnDriver;
    }

    @Override
    public UniversalPooledConnection getPooledObject() {
        UniversalPooledConnection upc = this.getUPC();
        assert (null != upc) : "upc shold be defined at this point";
        return upc;
    }

    @Override
    public boolean isLogicallyClosed() {
        return this.closed.get();
    }

    @Override
    public void applyConnectionLabel(String key, String value) throws SQLException {
        if (this.closed.get()) {
            throw UCPErrorHandler.newSQLException(31);
        }
        UniversalPooledConnection upc = this.getUPC();
        assert (null != upc) : "upc shold be defined at this point";
        try {
            upc.applyConnectionLabel(key, value);
        }
        catch (UniversalConnectionPoolException ucpExc) {
            UCPErrorHandler.throwSQLException(32, ucpExc);
        }
    }

    @Override
    public void removeConnectionLabel(String key) throws SQLException {
        if (this.closed.get()) {
            throw UCPErrorHandler.newSQLException(31);
        }
        UniversalPooledConnection upc = this.getUPC();
        assert (null != upc) : "upc shold be defined at this point";
        try {
            upc.removeConnectionLabel(key);
        }
        catch (UniversalConnectionPoolException ucpExc) {
            UCPErrorHandler.throwSQLException(33, ucpExc);
        }
    }

    @Override
    public Properties getConnectionLabels() throws SQLException {
        if (this.closed.get()) {
            throw UCPErrorHandler.newSQLException(31);
        }
        UniversalPooledConnection upc = this.getUPC();
        assert (null != upc) : "upc shold be defined at this point";
        Properties props = null;
        try {
            props = upc.getConnectionLabels();
        }
        catch (UniversalConnectionPoolException ucpExc) {
            UCPErrorHandler.throwSQLException(34, ucpExc);
        }
        return props;
    }

    @Override
    public Properties getUnmatchedConnectionLabels(Properties requestedLabels) throws SQLException {
        if (this.closed.get()) {
            throw UCPErrorHandler.newSQLException(31);
        }
        Properties props = null;
        UniversalPooledConnection upc = this.getUPC();
        assert (null != upc) : "upc shold be defined at this point";
        try {
            props = upc.getUnmatchedConnectionLabels(requestedLabels);
        }
        catch (UniversalConnectionPoolException ucpExc) {
            UCPErrorHandler.throwSQLException(35, ucpExc);
        }
        return props;
    }

    @Override
    public void setConnectionHarvestable(boolean isConnectionHarvestable) throws SQLException {
        if (this.closed.get()) {
            throw UCPErrorHandler.newSQLException(31);
        }
        UniversalPooledConnection upc = this.getUPC();
        assert (null != upc) : "upc shold be defined at this point";
        try {
            upc.setConnectionHarvestable(isConnectionHarvestable);
        }
        catch (UniversalConnectionPoolException ucpExc) {
            UCPErrorHandler.throwSQLException(36, ucpExc);
        }
    }

    @Override
    public boolean isConnectionHarvestable() throws SQLException {
        if (this.closed.get()) {
            throw UCPErrorHandler.newSQLException(31);
        }
        UniversalPooledConnection upc = this.getUPC();
        assert (null != upc) : "upc shold be defined at this point";
        return upc.isConnectionHarvestable();
    }

    @Override
    public void registerConnectionHarvestingCallback(ConnectionHarvestingCallback cbk) throws SQLException {
        if (this.closed.get()) {
            throw UCPErrorHandler.newSQLException(31);
        }
        UniversalPooledConnection upc = this.getUPC();
        assert (null != upc) : "upc shold be defined at this point";
        try {
            upc.registerConnectionHarvestingCallback(cbk);
        }
        catch (UniversalConnectionPoolException ucpExc) {
            UCPErrorHandler.throwSQLException(37, ucpExc);
        }
    }

    @Override
    public void removeConnectionHarvestingCallback() throws SQLException {
        if (this.closed.get()) {
            throw UCPErrorHandler.newSQLException(31);
        }
        UniversalPooledConnection upc = this.getUPC();
        assert (null != upc) : "upc shold be defined at this point";
        try {
            upc.removeConnectionHarvestingCallback();
        }
        catch (UniversalConnectionPoolException ucpExc) {
            UCPErrorHandler.throwSQLException(38, ucpExc);
        }
    }

    @Override
    public void registerAbandonedConnectionTimeoutCallback(AbandonedConnectionTimeoutCallback cbk) throws SQLException {
        if (this.closed.get()) {
            throw UCPErrorHandler.newSQLException(31);
        }
        UniversalPooledConnection upc = this.getUPC();
        assert (null != upc) : "upc shold be defined at this point";
        try {
            upc.registerAbandonedConnectionTimeoutCallback(cbk);
        }
        catch (UniversalConnectionPoolException ucpExc) {
            UCPErrorHandler.throwSQLException(39, ucpExc);
        }
    }

    @Override
    public void removeAbandonedConnectionTimeoutCallback() throws SQLException {
        if (this.closed.get()) {
            throw UCPErrorHandler.newSQLException(31);
        }
        UniversalPooledConnection upc = this.getUPC();
        assert (null != upc) : "upc shold be defined at this point";
        try {
            upc.removeAbandonedConnectionTimeoutCallback();
        }
        catch (UniversalConnectionPoolException ucpExc) {
            UCPErrorHandler.throwSQLException(40, ucpExc);
        }
    }

    @Override
    public void registerTimeToLiveConnectionTimeoutCallback(TimeToLiveConnectionTimeoutCallback cbk) throws SQLException {
        if (this.closed.get()) {
            throw UCPErrorHandler.newSQLException(31);
        }
        UniversalPooledConnection upc = this.getUPC();
        assert (null != upc) : "upc shold be defined at this point";
        try {
            upc.registerTimeToLiveConnectionTimeoutCallback(cbk);
        }
        catch (UniversalConnectionPoolException ucpExc) {
            UCPErrorHandler.throwSQLException(41, ucpExc);
        }
    }

    @Override
    public void removeTimeToLiveConnectionTimeoutCallback() throws SQLException {
        if (this.closed.get()) {
            throw UCPErrorHandler.newSQLException(31);
        }
        UniversalPooledConnection upc = this.getUPC();
        assert (null != upc) : "upc shold be defined at this point";
        try {
            upc.removeTimeToLiveConnectionTimeoutCallback();
        }
        catch (UniversalConnectionPoolException ucpExc) {
            UCPErrorHandler.throwSQLException(42, ucpExc);
        }
    }

    public boolean equals(Object thatObj) {
        if (null == thatObj) {
            return false;
        }
        if (this == thatObj) {
            return true;
        }
        return this.getDelegate().equals(thatObj instanceof ConnectionProxyBase ? ((ConnectionProxyBase)thatObj).getDelegate() : thatObj);
    }

    public int hashCode() {
        return this.getDelegate().hashCode();
    }

    public Object getClientData(Object obj) {
        return ((OracleConnection)this.getDelegate()).getClientData(obj);
    }

    public Object setClientData(Object obj1, Object obj2) {
        return ((OracleConnection)this.getDelegate()).setClientData(obj1, obj2);
    }

    public Object removeClientData(Object obj) {
        return ((OracleConnection)this.getDelegate()).removeClientData(obj);
    }

    protected void saveStatementProxy(Object result) {
        if (result instanceof StatementProxy) {
            StatementProxy statementProxy = (StatementProxy)result;
            statementProxy.setStatementChainAtom(this.statementsToClose.add(statementProxy));
        }
    }

    @Override
    @ProxyResult(value=ProxyResultPolicy.MANUAL)
    public Connection getConnection() throws SQLException {
        UniversalPooledConnection upc = this.getUPC();
        assert (null != upc) : "upc shold be defined at this point";
        upc.heartbeat();
        try {
            Connection delegate = this.getDelegate();
            if (delegate instanceof XAConnection) {
                Connection connection = ((XAConnection)((Object)this.getDelegate())).getConnection();
                return connection;
            }
            throw new IllegalStateException("this is not an XAConnection");
        }
        finally {
            upc.heartbeat();
        }
    }

    protected void setDefaultQueryTimeout(Statement statement) {
        UniversalConnectionPool ucp = this.getUCP();
        assert (null != ucp) : "ucp shold be defined at this point";
        int queryTimeout = ((UniversalConnectionPoolBase)ucp).getQueryTimeout();
        if (queryTimeout > 0) {
            try {
                statement.setQueryTimeout(queryTimeout);
            }
            catch (SQLException e) {
                ClioSupport.ilogThrowing(null, null, null, null, e);
            }
        }
    }

    static {
        try {
            $$$methodRef$$$36 = ConnectionProxyBase.class.getDeclaredConstructor(new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$36 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$35 = ConnectionProxyBase.class.getDeclaredMethod("setDefaultQueryTimeout", Statement.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$35 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$34 = ConnectionProxyBase.class.getDeclaredMethod("getConnection", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$34 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$33 = ConnectionProxyBase.class.getDeclaredMethod("saveStatementProxy", Object.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$33 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$32 = ConnectionProxyBase.class.getDeclaredMethod("removeClientData", Object.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$32 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$31 = ConnectionProxyBase.class.getDeclaredMethod("setClientData", Object.class, Object.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$31 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$30 = ConnectionProxyBase.class.getDeclaredMethod("getClientData", Object.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$30 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$29 = ConnectionProxyBase.class.getDeclaredMethod("hashCode", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$29 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$28 = ConnectionProxyBase.class.getDeclaredMethod("equals", Object.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$28 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$27 = ConnectionProxyBase.class.getDeclaredMethod("removeTimeToLiveConnectionTimeoutCallback", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$27 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$26 = ConnectionProxyBase.class.getDeclaredMethod("registerTimeToLiveConnectionTimeoutCallback", TimeToLiveConnectionTimeoutCallback.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$26 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$25 = ConnectionProxyBase.class.getDeclaredMethod("removeAbandonedConnectionTimeoutCallback", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$25 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$24 = ConnectionProxyBase.class.getDeclaredMethod("registerAbandonedConnectionTimeoutCallback", AbandonedConnectionTimeoutCallback.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$24 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$23 = ConnectionProxyBase.class.getDeclaredMethod("removeConnectionHarvestingCallback", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$23 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$22 = ConnectionProxyBase.class.getDeclaredMethod("registerConnectionHarvestingCallback", ConnectionHarvestingCallback.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$22 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$21 = ConnectionProxyBase.class.getDeclaredMethod("isConnectionHarvestable", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$21 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$20 = ConnectionProxyBase.class.getDeclaredMethod("setConnectionHarvestable", Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$20 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$19 = ConnectionProxyBase.class.getDeclaredMethod("getUnmatchedConnectionLabels", Properties.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$19 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$18 = ConnectionProxyBase.class.getDeclaredMethod("getConnectionLabels", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$18 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$17 = ConnectionProxyBase.class.getDeclaredMethod("removeConnectionLabel", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$17 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$16 = ConnectionProxyBase.class.getDeclaredMethod("applyConnectionLabel", String.class, String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$16 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$15 = ConnectionProxyBase.class.getDeclaredMethod("isLogicallyClosed", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$15 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$14 = ConnectionProxyBase.class.getDeclaredMethod("getPooledObject", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$14 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$13 = ConnectionProxyBase.class.getDeclaredMethod("isClosed", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$13 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$12 = ConnectionProxyBase.class.getDeclaredMethod("setInvalid", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$11 = ConnectionProxyBase.class.getDeclaredMethod("isValid", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$10 = ConnectionProxyBase.class.getDeclaredMethod("isValid", OracleConnection.ConnectionValidation.class, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$9 = ConnectionProxyBase.class.getDeclaredMethod("isValid", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$8 = ConnectionProxyBase.class.getDeclaredMethod("isUsable", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$7 = ConnectionProxyBase.class.getDeclaredMethod("close", Properties.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$6 = ConnectionProxyBase.class.getDeclaredMethod("close", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$5 = ConnectionProxyBase.class.getDeclaredMethod("close", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$4 = ConnectionProxyBase.class.getDeclaredMethod("handleRuntimeException", RuntimeException.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$3 = ConnectionProxyBase.class.getDeclaredMethod("handleSQLRecoverableException", SQLException.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$2 = ConnectionProxyBase.class.getDeclaredMethod("handleExceptionHelper", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$1 = ConnectionProxyBase.class.getDeclaredMethod("getUCP", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$0 = ConnectionProxyBase.class.getDeclaredMethod("getUPC", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
    }
}

