/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.common.waitfreepool;

import java.lang.reflect.Executable;
import java.util.ArrayList;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.logging.Logger;
import oracle.ucp.common.waitfreepool.Pool;
import oracle.ucp.common.waitfreepool.PoolElement;
import oracle.ucp.common.waitfreepool.PoolIterator;
import oracle.ucp.common.waitfreepool.PoolIteratorQueue;
import oracle.ucp.common.waitfreepool.Queue;
import oracle.ucp.common.waitfreepool.SkipList;
import oracle.ucp.common.waitfreepool.SkipListTuple;

final class LinkedListPool<T>
implements Pool<T> {
    private final AtomicLong elementsInstantiated = new AtomicLong(0L);
    private long listLength = 1L;
    private final Element listHead = new Element();
    private final AtomicReference<Element> fillRef = new AtomicReference<Element>(this.listHead);
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;
    private static Executable $$$methodRef$$$12;
    private static Logger $$$loggerRef$$$12;
    private static Executable $$$methodRef$$$13;
    private static Logger $$$loggerRef$$$13;
    private static Executable $$$methodRef$$$14;
    private static Logger $$$loggerRef$$$14;
    private static Executable $$$methodRef$$$15;
    private static Logger $$$loggerRef$$$15;

    final long elementsInstantiated() {
        return this.elementsInstantiated.get();
    }

    final long listLength() {
        return this.listLength;
    }

    LinkedListPool() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void put(T data) {
        Element element = this.fillRef.get();
        Element newElement = null;
        while (true) {
            if (element.tryReserve()) {
                try {
                    if (element.data == null) {
                        element.data = data;
                        this.fillRef.set(element);
                        return;
                    }
                }
                finally {
                    element.release();
                }
            }
            if (element.next.get() == null && newElement == null) {
                newElement = new Element(data);
            }
            if (element.next.compareAndSet(null, newElement)) {
                this.fillRef.set(newElement);
                ++this.listLength;
                return;
            }
            element = (Element)element.next.get();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T findFirst(Predicate<T> selector, Consumer<T> applicator, ThreadLocal<Deque<PoolElement<T>>> tlCache, int cacheMaxSize) {
        Object d;
        Deque<PoolElement<T>> cache = tlCache.get();
        PoolElement elm = null;
        T data = null;
        if (null != cache) {
            PoolIterator<PoolElement<T>> cacheIt = this.poolElementsIterator(false, cache.iterator());
            try {
                while (cacheIt.hasNext()) {
                    elm = (PoolElement)cacheIt.next();
                    d = elm.getData();
                    if (!selector.test(d)) continue;
                    applicator.accept(d);
                    data = d;
                    break;
                }
            }
            finally {
                cacheIt.release();
            }
            if (null != data) {
                cache.remove(elm);
                cache.addFirst(elm);
                return data;
            }
        }
        elm = null;
        data = null;
        PoolIterator<PoolElement<T>> it = this.poolElementsIterator(false, null);
        try {
            while (it.hasNext()) {
                elm = (PoolElement)it.next();
                d = elm.getData();
                if (!selector.test(d)) continue;
                applicator.accept(d);
                data = d;
                break;
            }
        }
        finally {
            it.release();
        }
        if (null != data) {
            cache.addFirst(elm);
            while (cache.size() > cacheMaxSize) {
                cache.removeLast();
            }
            return data;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void buildSkipLists(SkipListTuple<T> ... tuples) {
        final ArrayList queues = new ArrayList();
        for (int i = 0; i < tuples.length; ++i) {
            queues.add(new Queue());
        }
        final LinkedListPool outerThis = this;
        PoolIterator<PoolElement<T>> it = this.poolElementsIterator(true, null);
        try {
            while (it.hasNext()) {
                PoolElement element = (PoolElement)it.next();
                for (int i = 0; i < tuples.length; ++i) {
                    if (null == element.getData()) {
                        throw new NullPointerException("no data");
                    }
                    if (!tuples[i].getPredicate().test(element.getData())) continue;
                    ((Queue)queues.get(i)).enqueue(element);
                }
            }
        }
        finally {
            it.release();
        }
        for (int i = 0; i < queues.size(); ++i) {
            final int index = i;
            tuples[i].getConsumer().accept(new SkipList<T>(){
                private static Executable $$$methodRef$$$0;
                private static Logger $$$loggerRef$$$0;
                private static Executable $$$methodRef$$$1;
                private static Logger $$$loggerRef$$$1;

                @Override
                public PoolIterator<T> poolIterator(boolean revisit) {
                    return outerThis.poolIterator(revisit, ((Queue)queues.get(index)).Iterator());
                }

                static {
                    try {
                        $$$methodRef$$$1 = 1.class.getDeclaredConstructor(LinkedListPool.class, LinkedListPool.class, List.class, Integer.TYPE);
                    }
                    catch (Throwable throwable) {}
                    $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                    try {
                        $$$methodRef$$$0 = 1.class.getDeclaredMethod("poolIterator", Boolean.TYPE);
                    }
                    catch (Throwable throwable) {}
                    $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                }
            });
        }
    }

    @Override
    public PoolIterator<T> poolIterator(boolean revisit) {
        return this.poolIterator(revisit, null);
    }

    private PoolIterator<T> poolIterator(final boolean revisit, final Iterator<PoolElement<T>> iterator) {
        return new PoolIterator<T>(){
            private final PoolIterator<PoolElement<T>> it;
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;
            private static Executable $$$methodRef$$$3;
            private static Logger $$$loggerRef$$$3;
            private static Executable $$$methodRef$$$4;
            private static Logger $$$loggerRef$$$4;
            private static Executable $$$methodRef$$$5;
            private static Logger $$$loggerRef$$$5;
            private static Executable $$$methodRef$$$6;
            private static Logger $$$loggerRef$$$6;
            {
                this.it = LinkedListPool.this.poolElementsIterator(revisit, iterator);
            }

            @Override
            public boolean hasNext() {
                return this.it.hasNext();
            }

            @Override
            public T next() {
                return ((PoolElement)this.it.next()).getData();
            }

            @Override
            public void remove() {
                this.it.remove();
            }

            @Override
            public void release() {
                this.it.release();
            }

            @Override
            public boolean isSleeping() {
                return this.it.isSleeping();
            }

            @Override
            public boolean isAlive() {
                return this.it.isAlive();
            }

            static {
                try {
                    $$$methodRef$$$6 = 2.class.getDeclaredConstructor(LinkedListPool.class, Boolean.TYPE, Iterator.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$5 = 2.class.getDeclaredMethod("isAlive", new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$4 = 2.class.getDeclaredMethod("isSleeping", new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$3 = 2.class.getDeclaredMethod("release", new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$2 = 2.class.getDeclaredMethod("remove", new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$1 = 2.class.getDeclaredMethod("next", new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$0 = 2.class.getDeclaredMethod("hasNext", new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            }
        };
    }

    private PoolIterator<PoolElement<T>> poolElementsIterator(final boolean revisit, final Iterator<PoolElement<T>> iterator) {
        final Thread iteratorThread = Thread.currentThread();
        return new PoolIterator<PoolElement<T>>(){
            volatile Iterator<PoolElement<T>> it;
            volatile Element currentElement;
            volatile boolean outerReservation;
            volatile boolean nextReserved;
            final AtomicBoolean released;
            private boolean sleeping;
            private final Queue<Element> revisitQueue;
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;
            private static Executable $$$methodRef$$$3;
            private static Logger $$$loggerRef$$$3;
            private static Executable $$$methodRef$$$4;
            private static Logger $$$loggerRef$$$4;
            private static Executable $$$methodRef$$$5;
            private static Logger $$$loggerRef$$$5;
            private static Executable $$$methodRef$$$6;
            private static Logger $$$loggerRef$$$6;
            private static Executable $$$methodRef$$$7;
            private static Logger $$$loggerRef$$$7;
            private static Executable $$$methodRef$$$8;
            private static Logger $$$loggerRef$$$8;
            private static Executable $$$methodRef$$$9;
            private static Logger $$$loggerRef$$$9;
            private static Executable $$$methodRef$$$10;
            private static Logger $$$loggerRef$$$10;
            {
                this.it = null != iterator ? iterator : LinkedListPool.this.elementsIterator();
                this.currentElement = null;
                this.outerReservation = false;
                this.nextReserved = false;
                this.released = new AtomicBoolean(false);
                this.sleeping = false;
                this.revisitQueue = new Queue();
            }

            @Override
            public boolean isAlive() {
                return !this.released.get() && iteratorThread.isAlive();
            }

            @Override
            public boolean isSleeping() {
                return this.sleeping;
            }

            private void throwIfWrongThread() {
                if (iteratorThread != Thread.currentThread()) {
                    throw new IllegalStateException("PoolIterator has been run by a wrong thread");
                }
            }

            private boolean preReserved(Element element) {
                return element.reserved.get() == Thread.currentThread();
            }

            private Element reserveNext() {
                Element element;
                while (this.it.hasNext()) {
                    PoolElement poolElement = this.it.next();
                    element = (Element)poolElement;
                    if (element.tryReserve()) {
                        if (element.data != null) {
                            Element elementToReturn = element;
                            return elementToReturn;
                        }
                        element.release();
                        continue;
                    }
                    if (this.preReserved(element)) {
                        if (element.data == null) continue;
                        this.outerReservation = true;
                        return element;
                    }
                    if (!revisit) continue;
                    element.poolIteratorQueue.enqueue(this);
                    this.revisitQueue.enqueue(element);
                }
                Element first = null;
                while (revisit) {
                    element = this.revisitQueue.dequeue();
                    if (element == null) {
                        return null;
                    }
                    if (element == first) {
                        first = null;
                        Thread.yield();
                    }
                    if (null == first) {
                        first = element;
                    }
                    if (element.poolIteratorQueue.peek(this)) {
                        if (element.tryReserve()) {
                            element.poolIteratorQueue.disable(this);
                            if (element.data != null) {
                                return element;
                            }
                            element.release();
                            continue;
                        }
                        this.revisitQueue.enqueue(element);
                        continue;
                    }
                    this.revisitQueue.enqueue(element);
                }
                return null;
            }

            @Override
            public boolean hasNext() {
                this.throwIfWrongThread();
                if (this.nextReserved) {
                    return true;
                }
                if (this.currentElement != null) {
                    if (this.outerReservation) {
                        this.outerReservation = false;
                    } else {
                        this.currentElement.release();
                    }
                }
                this.nextReserved = (this.currentElement = this.reserveNext()) != null;
                return this.nextReserved;
            }

            @Override
            public Element next() {
                this.throwIfWrongThread();
                if (this.hasNext()) {
                    this.nextReserved = false;
                    return this.currentElement;
                }
                throw new NoSuchElementException();
            }

            @Override
            public void remove() {
                this.throwIfWrongThread();
                if (this.currentElement != null) {
                    this.currentElement.data = null;
                    if (this.currentElement.id < ((Element)LinkedListPool.this.fillRef.get()).id) {
                        LinkedListPool.this.fillRef.set(this.currentElement);
                    }
                } else {
                    throw new IllegalStateException();
                }
            }

            @Override
            public void release() {
                this.throwIfWrongThread();
                if (this.released.compareAndSet(false, true)) {
                    this.revisitQueue.clear();
                    if (this.currentElement != null) {
                        if (this.outerReservation) {
                            this.outerReservation = false;
                        } else {
                            this.currentElement.release();
                        }
                        this.currentElement = null;
                    }
                }
            }

            static {
                try {
                    $$$methodRef$$$10 = 3.class.getDeclaredConstructor(LinkedListPool.class, Iterator.class, Thread.class, Boolean.TYPE);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$9 = 3.class.getDeclaredMethod("next", new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$8 = 3.class.getDeclaredMethod("release", new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$7 = 3.class.getDeclaredMethod("remove", new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$6 = 3.class.getDeclaredMethod("next", new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$5 = 3.class.getDeclaredMethod("hasNext", new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$4 = 3.class.getDeclaredMethod("reserveNext", new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$3 = 3.class.getDeclaredMethod("preReserved", Element.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$2 = 3.class.getDeclaredMethod("throwIfWrongThread", new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$1 = 3.class.getDeclaredMethod("isSleeping", new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$0 = 3.class.getDeclaredMethod("isAlive", new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            }
        };
    }

    private Iterator<PoolElement<T>> elementsIterator() {
        return new Iterator<PoolElement<T>>(){
            private Element current;
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;
            private static Executable $$$methodRef$$$3;
            private static Logger $$$loggerRef$$$3;
            {
                this.current = LinkedListPool.this.listHead;
            }

            @Override
            public boolean hasNext() {
                return null != this.current;
            }

            @Override
            public PoolElement<T> next() {
                if (null != this.current) {
                    Element element = this.current;
                    this.current = (Element)this.current.next.get();
                    return element;
                }
                return null;
            }

            static {
                try {
                    $$$methodRef$$$3 = 4.class.getDeclaredConstructor(LinkedListPool.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$2 = 4.class.getDeclaredMethod("next", new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$1 = 4.class.getDeclaredMethod("next", new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$0 = 4.class.getDeclaredMethod("hasNext", new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            }
        };
    }

    static {
        try {
            $$$methodRef$$$15 = LinkedListPool.class.getDeclaredConstructor(new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$15 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$14 = LinkedListPool.class.getDeclaredMethod("access$1300", LinkedListPool.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$14 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$13 = LinkedListPool.class.getDeclaredMethod("access$1200", LinkedListPool.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$13 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$12 = LinkedListPool.class.getDeclaredMethod("access$800", LinkedListPool.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$11 = LinkedListPool.class.getDeclaredMethod("access$700", LinkedListPool.class, Boolean.TYPE, Iterator.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$10 = LinkedListPool.class.getDeclaredMethod("access$600", LinkedListPool.class, Boolean.TYPE, Iterator.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$9 = LinkedListPool.class.getDeclaredMethod("access$000", LinkedListPool.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$8 = LinkedListPool.class.getDeclaredMethod("elementsIterator", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$7 = LinkedListPool.class.getDeclaredMethod("poolElementsIterator", Boolean.TYPE, Iterator.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$6 = LinkedListPool.class.getDeclaredMethod("poolIterator", Boolean.TYPE, Iterator.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$5 = LinkedListPool.class.getDeclaredMethod("poolIterator", Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$4 = LinkedListPool.class.getDeclaredMethod("buildSkipLists", SkipListTuple[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$3 = LinkedListPool.class.getDeclaredMethod("findFirst", Predicate.class, Consumer.class, ThreadLocal.class, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$2 = LinkedListPool.class.getDeclaredMethod("put", Object.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$1 = LinkedListPool.class.getDeclaredMethod("listLength", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$0 = LinkedListPool.class.getDeclaredMethod("elementsInstantiated", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
    }

    private final class Element
    implements PoolElement<T> {
        private final long id;
        private final AtomicReference<Thread> reserved = new AtomicReference<Object>(null);
        private final AtomicReference<Element> next = new AtomicReference<Object>(null);
        volatile T data;
        private final PoolIteratorQueue<PoolElement<T>> poolIteratorQueue = new PoolIteratorQueue();
        private static Executable $$$methodRef$$$0;
        private static Logger $$$loggerRef$$$0;
        private static Executable $$$methodRef$$$1;
        private static Logger $$$loggerRef$$$1;
        private static Executable $$$methodRef$$$2;
        private static Logger $$$loggerRef$$$2;
        private static Executable $$$methodRef$$$3;
        private static Logger $$$loggerRef$$$3;
        private static Executable $$$methodRef$$$4;
        private static Logger $$$loggerRef$$$4;
        private static Executable $$$methodRef$$$5;
        private static Logger $$$loggerRef$$$5;
        private static Executable $$$methodRef$$$6;
        private static Logger $$$loggerRef$$$6;
        private static Executable $$$methodRef$$$7;
        private static Logger $$$loggerRef$$$7;
        private static Executable $$$methodRef$$$8;
        private static Logger $$$loggerRef$$$8;
        private static Executable $$$methodRef$$$9;
        private static Logger $$$loggerRef$$$9;
        private static Executable $$$methodRef$$$10;
        private static Logger $$$loggerRef$$$10;
        private static Executable $$$methodRef$$$11;
        private static Logger $$$loggerRef$$$11;
        private static Executable $$$methodRef$$$12;
        private static Logger $$$loggerRef$$$12;

        private Element() {
            this((Object)null);
        }

        private Element(T data) {
            this.data = data;
            this.id = LinkedListPool.this.elementsInstantiated.getAndIncrement();
        }

        private boolean tryReserve() {
            return this.reserved.compareAndSet(null, Thread.currentThread());
        }

        private void release() {
            Thread currentThread = Thread.currentThread();
            if (!this.reserved.compareAndSet(currentThread, null)) {
                throw new IllegalStateException("element is released by wrong thread: " + currentThread);
            }
        }

        @Override
        public T getData() {
            return this.data;
        }

        static {
            try {
                $$$methodRef$$$12 = Element.class.getDeclaredConstructor(LinkedListPool.class, Object.class, 1.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            try {
                $$$methodRef$$$11 = Element.class.getDeclaredConstructor(LinkedListPool.class, 1.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            try {
                $$$methodRef$$$10 = Element.class.getDeclaredConstructor(LinkedListPool.class, Object.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            try {
                $$$methodRef$$$9 = Element.class.getDeclaredConstructor(LinkedListPool.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            try {
                $$$methodRef$$$8 = Element.class.getDeclaredMethod("access$1100", Element.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            try {
                $$$methodRef$$$7 = Element.class.getDeclaredMethod("access$1000", Element.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            try {
                $$$methodRef$$$6 = Element.class.getDeclaredMethod("access$900", Element.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            try {
                $$$methodRef$$$5 = Element.class.getDeclaredMethod("access$400", Element.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            try {
                $$$methodRef$$$4 = Element.class.getDeclaredMethod("access$300", Element.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            try {
                $$$methodRef$$$3 = Element.class.getDeclaredMethod("access$200", Element.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            try {
                $$$methodRef$$$2 = Element.class.getDeclaredMethod("getData", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            try {
                $$$methodRef$$$1 = Element.class.getDeclaredMethod("release", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            try {
                $$$methodRef$$$0 = Element.class.getDeclaredMethod("tryReserve", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        }
    }
}

