/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver.json.tree;

import java.sql.SQLException;
import oracle.jdbc.driver.json.Jsonp;
import oracle.jdbc.driver.json.OracleJsonExceptions;
import oracle.jdbc.driver.json.binary.JsonSerializerImpl;
import oracle.jdbc.driver.json.tree.JakartaPrimitive;
import oracle.jdbc.driver.json.tree.JsonpPrimitive;
import oracle.sql.CHAR;
import oracle.sql.CharacterSet;
import oracle.sql.json.OracleJsonException;
import oracle.sql.json.OracleJsonString;
import oracle.sql.json.OracleJsonValue;

public class OracleJsonStringImpl
implements OracleJsonString {
    String value;

    public OracleJsonStringImpl(String string) {
        this.value = string;
    }

    @Override
    public String getString() {
        return this.value;
    }

    @Override
    public OracleJsonValue.OracleJsonType getOracleJsonType() {
        return OracleJsonValue.OracleJsonType.STRING;
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof OracleJsonString)) {
            return false;
        }
        return this == object || this.getString().equals(((OracleJsonString)object).getString());
    }

    @Override
    public int hashCode() {
        return this.getString().hashCode();
    }

    @Override
    public CharSequence getChars() {
        return this.getString();
    }

    @Override
    public String toString() {
        return JsonSerializerImpl.serializeString(this.getString());
    }

    @Override
    public <T> T wrap(Class<T> clazz) {
        if (Jsonp.isJakartaJson(clazz)) {
            return clazz.cast(new JakartaPrimitive.JakartaStringImpl(this.value));
        }
        return clazz.cast(new JsonpPrimitive.JsonpStringImpl(this.value));
    }

    @Override
    public CHAR getCHAR() {
        try {
            return new CHAR(this.getString(), CharacterSet.make(871));
        }
        catch (SQLException sQLException) {
            throw new OracleJsonException(sQLException.getMessage(), sQLException);
        }
    }

    protected OracleJsonExceptions.ExceptionFactory getExceptionFactory() {
        return OracleJsonExceptions.ORACLE_FACTORY;
    }
}

