/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.sql.SQLException;
import oracle.jdbc.driver.CRC64;
import oracle.jdbc.driver.T4CConnection;
import oracle.jdbc.driver.T4CTTIoer11;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;

@DefaultLogger(value="oracle.jdbc")
@Supports(value={Feature.THIN_INTERNAL})
class T4CTTIoer19
extends T4CTTIoer11 {
    long oercn2;
    long oerrcd2;
    private static final String _Copyright_2014_Oracle_All_Rights_Reserved_ = null;
    public static final boolean TRACE = false;

    T4CTTIoer19(T4CConnection t4CConnection) {
        super(t4CConnection);
    }

    @Override
    void init() {
        super.init();
        this.oerrcd2 = 0L;
        this.oercn2 = 0L;
    }

    @Override
    int unmarshal() throws IOException, SQLException {
        this.unmarshalAttributes();
        if (this.oerrcd2 != 0L) {
            this.unmarshalErrorMessage();
        }
        return this.currCursorID;
    }

    @Override
    void unmarshalAttributes() throws IOException, SQLException {
        super.unmarshalAttributes();
        this.oerrcd2 = this.meg.unmarshalUB4();
        this.oercn2 = this.meg.unmarshalSB8();
    }

    @Override
    void print() throws SQLException {
        super.print();
        if (this.oerrcd2 != 0L) {
        }
    }

    @Override
    long getCurRowNumber() throws SQLException {
        return this.oercn2;
    }

    @Override
    long getRetCode() {
        return this.oerrcd2;
    }

    @Override
    long updateChecksum(long l2) throws SQLException {
        l2 = super.updateChecksum(l2);
        l2 = CRC64.updateChecksum(l2, this.oerrcd2);
        l2 = CRC64.updateChecksum(l2, this.oercn2);
        return l2;
    }
}

