/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.xa.client;

import java.sql.Connection;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import oracle.jdbc.internal.Monitor;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;
import oracle.jdbc.xa.OracleXAResource;
import oracle.jdbc.xa.client.OracleXAConnection;
import oracle.jdbc.xa.client.OracleXAHeteroResource;

@DefaultLogger(value="oracle.jdbc")
@Supports(value={Feature.XA})
public class OracleXAHeteroConnection
extends OracleXAConnection {
    private int rmid = -1;
    private String xaCloseString = null;

    public OracleXAHeteroConnection() throws XAException {
    }

    public OracleXAHeteroConnection(Connection connection) throws XAException {
        super(connection);
    }

    @Override
    public XAResource getXAResource() {
        try (Monitor.CloseableLock closeableLock = this.acquireCloseableLock();){
            try {
                if (this.xaResource == null) {
                    this.xaResource = new OracleXAHeteroResource((Connection)this.physicalConn, this);
                    ((OracleXAHeteroResource)this.xaResource).setRmid(this.rmid);
                    if (this.logicalHandle != null) {
                        ((OracleXAResource)this.xaResource).setLogicalConnection(this.logicalHandle);
                    }
                }
            }
            catch (XAException xAException) {
                this.xaResource = null;
            }
            XAResource xAResource = this.xaResource;
            return xAResource;
        }
    }

    void setRmid(int n2) {
        try (Monitor.CloseableLock closeableLock = this.acquireCloseableLock();){
            this.rmid = n2;
        }
    }

    int getRmid() {
        try (Monitor.CloseableLock closeableLock = this.acquireCloseableLock();){
            int n2 = this.rmid;
            return n2;
        }
    }

    void setXaCloseString(String string) {
        try (Monitor.CloseableLock closeableLock = this.acquireCloseableLock();){
            this.xaCloseString = string;
        }
    }

    String getXaCloseString() {
        try (Monitor.CloseableLock closeableLock = this.acquireCloseableLock();){
            String string = this.xaCloseString;
            return string;
        }
    }
}

