/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.replay.driver;

import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.sql.SQLException;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.internal.ACProxyable;
import oracle.jdbc.internal.OracleBlob;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;
import oracle.jdbc.proxy.annotation.GetCreator;
import oracle.jdbc.proxy.annotation.GetDelegate;
import oracle.jdbc.proxy.annotation.Methods;
import oracle.jdbc.proxy.annotation.OnError;
import oracle.jdbc.proxy.annotation.Post;
import oracle.jdbc.proxy.annotation.Pre;
import oracle.jdbc.proxy.annotation.ProxyAccess;
import oracle.jdbc.proxy.annotation.ProxyFor;
import oracle.jdbc.proxy.annotation.ProxyResult;
import oracle.jdbc.proxy.annotation.ProxyResultPolicy;
import oracle.jdbc.proxy.annotation.SetDelegate;
import oracle.jdbc.proxy.annotation.Signature;
import oracle.jdbc.replay.driver.JDBCReplayable;
import oracle.jdbc.replay.driver.TxnFailoverManagerImpl;
import oracle.jdbc.replay.driver.TxnReplayableBase;
import oracle.jdbc.replay.driver.TxnReplayableConnection;

@ProxyFor(value={OracleBlob.class})
@ProxyAccess(value=ACProxyable.class)
@DefaultLogger(value="oracle.jdbc.internal.replay")
@Supports(value={Feature.APPLICATION_CONTINUITY})
public abstract class TxnReplayableBlob
extends TxnReplayableBase
implements JDBCReplayable {
    private static final Method GETBINSTREAM_METHOD = TxnReplayableBlob.getGetBinaryStreamMethod();
    private static final Method GETBINSTREAM_LONG_METHOD = TxnReplayableBlob.getGetBinaryStreamLongMethod();
    private static final Method GETBINSTREAM_LONG_LONG_METHOD = TxnReplayableBlob.getGetBinaryStreamLongLongMethod();
    private static final Method SETBINSTREAM_LONG_METHOD = TxnReplayableBlob.getSetBinaryStreamLongMethod();

    protected TxnReplayableBlob() {
        this.thisProxyNameInLog = "BLOB" + this.thisProxyNameInLog;
    }

    private static final Method getGetBinaryStreamMethod() {
        try {
            return OracleBlob.class.getMethod("getBinaryStream", new Class[0]);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static final Method getGetBinaryStreamLongMethod() {
        try {
            return OracleBlob.class.getMethod("getBinaryStream", Long.TYPE);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static final Method getGetBinaryStreamLongLongMethod() {
        try {
            return OracleBlob.class.getMethod("getBinaryStream", Long.TYPE, Long.TYPE);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static final Method getSetBinaryStreamLongMethod() {
        try {
            return OracleBlob.class.getMethod("setBinaryStream", Long.TYPE);
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Override
    @Pre
    protected void preForAll(Method method, Object object, Object ... objectArray) {
        super.preForAll(method, object, objectArray);
    }

    @Override
    @Post
    protected void postForAll(Method method) {
        this.postForAll(method, null);
    }

    @Override
    @Post
    protected Object postForAll(Method method, Object object) {
        if (object instanceof TxnReplayableBase) {
            TxnReplayableBase txnReplayableBase = (TxnReplayableBase)object;
            txnReplayableBase.setFailoverManager(this.getFailoverManager());
        }
        return super.postForAll(method, object);
    }

    @Post
    @Methods(signatures={@Signature(name="close", args={})})
    protected void postForClose(Method method) {
        this.postForAll(method);
        TxnFailoverManagerImpl.ReplayLifecycle replayLifecycle = this.failoverMngr.getReplayLifecycle();
        if (replayLifecycle == TxnFailoverManagerImpl.ReplayLifecycle.ENABLED_NOT_REPLAYING) {
            this.isLogicallyClosed = true;
            try {
                TxnReplayableConnection txnReplayableConnection = (TxnReplayableConnection)this.failoverMngr.getConnectionProxy();
                txnReplayableConnection.checkImplicitRequestBoundary();
            }
            catch (Throwable throwable) {
            }
        }
    }

    @Post
    @Methods(signatures={@Signature(name="free", args={})})
    protected void postForFree(Method method) {
        TxnFailoverManagerImpl.ReplayLifecycle replayLifecycle;
        super.postForAll(method);
        if (!this.isFreed && (replayLifecycle = this.failoverMngr.getReplayLifecycle()) == TxnFailoverManagerImpl.ReplayLifecycle.ENABLED_NOT_REPLAYING) {
            this.failoverMngr.setStateSignatureSyncUp();
            try {
                TxnReplayableConnection txnReplayableConnection = (TxnReplayableConnection)this.failoverMngr.getConnectionProxy();
                txnReplayableConnection.checkImplicitRequestBoundary();
            }
            catch (Throwable throwable) {
            }
        }
        this.isFreed = true;
    }

    @Override
    @OnError(value=SQLException.class)
    protected void onErrorVoidForAll(Method method, SQLException sQLException) throws SQLException {
        super.onErrorVoidForAll(method, sQLException);
    }

    @Override
    @OnError(value=SQLException.class)
    protected Object onErrorForAll(Method method, SQLException sQLException) throws SQLException {
        return super.onErrorForAll(method, sQLException);
    }

    @Override
    @GetDelegate
    protected abstract Object getDelegate();

    @Override
    @SetDelegate
    protected abstract void setDelegate(Object var1);

    @Override
    @GetCreator
    protected abstract Object getCreator();

    public InputStream getBinaryStream() throws SQLException {
        if (GETBINSTREAM_METHOD == null) {
            throw DatabaseError.createSqlException(1, "Cannot get binary stream");
        }
        Method method = GETBINSTREAM_METHOD;
        this.failoverMngr.setLobStreamInRequest(true);
        this.preForAll(method, this, new Object[0]);
        try {
            OracleBlob oracleBlob = (OracleBlob)this.getDelegate();
            if (this.isFreed) {
                SQLException sQLException = DatabaseError.createSqlException(oracleBlob.getInternalConnection(), 192);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            InputStream inputStream = oracleBlob.canReadBasicLobDataInLocator() ? oracleBlob.getBinaryStream() : oracleBlob.getDBAccess().newInputStream((OracleBlob)((Object)this), oracleBlob.getBufferSize(), 0L);
            return (InputStream)this.postForAll(method, inputStream);
        }
        catch (SQLException sQLException) {
            return (InputStream)this.postForAll(method, this.onErrorForAll(method, sQLException));
        }
    }

    public InputStream getBinaryStream(long l2) throws SQLException {
        if (GETBINSTREAM_LONG_METHOD == null) {
            throw DatabaseError.createSqlException(1, "Cannot get binary stream");
        }
        Method method = GETBINSTREAM_LONG_METHOD;
        this.failoverMngr.setLobStreamInRequest(true);
        this.preForAll(method, this, l2);
        try {
            InputStream inputStream;
            OracleBlob oracleBlob = (OracleBlob)this.getDelegate();
            if (this.isFreed) {
                SQLException sQLException = DatabaseError.createSqlException(oracleBlob.getInternalConnection(), 192);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (oracleBlob.canReadBasicLobDataInLocator()) {
                inputStream = oracleBlob.getBinaryStream(l2);
            } else {
                if (l2 < 1L) {
                    SQLException sQLException = DatabaseError.createSqlException(oracleBlob.getInternalConnection(), 68);
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                inputStream = oracleBlob.getDBAccess().newInputStream((OracleBlob)((Object)this), oracleBlob.getBufferSize(), l2);
            }
            return (InputStream)this.postForAll(method, inputStream);
        }
        catch (SQLException sQLException) {
            return (InputStream)this.postForAll(method, this.onErrorForAll(method, sQLException));
        }
    }

    public InputStream getBinaryStream(long l2, long l3) throws SQLException {
        if (GETBINSTREAM_LONG_LONG_METHOD == null) {
            throw DatabaseError.createSqlException(1, "Cannot get binary stream");
        }
        Method method = GETBINSTREAM_LONG_LONG_METHOD;
        this.failoverMngr.setLobStreamInRequest(true);
        this.preForAll(method, this, l2, l3);
        try {
            InputStream inputStream;
            OracleBlob oracleBlob = (OracleBlob)this.getDelegate();
            if (this.isFreed) {
                SQLException sQLException = DatabaseError.createSqlException(oracleBlob.getInternalConnection(), 192);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (oracleBlob.canReadBasicLobDataInLocator()) {
                inputStream = oracleBlob.getBinaryStream(l2, l3);
            } else {
                long l4 = oracleBlob.length();
                if (l2 < 1L || l3 < 0L || l2 > l4 || l2 - 1L + l3 > l4) {
                    SQLException sQLException = DatabaseError.createSqlException(oracleBlob.getInternalConnection(), 68);
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                inputStream = oracleBlob.getDBAccess().newInputStream((OracleBlob)((Object)this), oracleBlob.getBufferSize(), l2, l3);
            }
            return (InputStream)this.postForAll(method, inputStream);
        }
        catch (SQLException sQLException) {
            return (InputStream)this.postForAll(method, this.onErrorForAll(method, sQLException));
        }
    }

    public OutputStream setBinaryStream(long l2) throws SQLException {
        if (SETBINSTREAM_LONG_METHOD == null) {
            throw DatabaseError.createSqlException(1, "Cannot set binary stream");
        }
        Method method = SETBINSTREAM_LONG_METHOD;
        this.failoverMngr.setLobStreamInRequest(true);
        this.preForAll(method, this, l2);
        try {
            OracleBlob oracleBlob = (OracleBlob)this.getDelegate();
            if (this.isFreed) {
                SQLException sQLException = DatabaseError.createSqlException(oracleBlob.getInternalConnection(), 192);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            OutputStream outputStream = oracleBlob.getDBAccess().newOutputStream((OracleBlob)((Object)this), oracleBlob.getBufferSize(), l2, true);
            return (OutputStream)this.postForAll(method, outputStream);
        }
        catch (SQLException sQLException) {
            return (OutputStream)this.postForAll(method, this.onErrorForAll(method, sQLException));
        }
    }

    public OutputStream getBinaryOutputStream() throws SQLException {
        return this.setBinaryStream(1L);
    }

    public OutputStream getBinaryOutputStream(long l2) throws SQLException {
        return this.setBinaryStream(l2);
    }

    @ProxyResult(value=ProxyResultPolicy.MANUAL)
    public OracleConnection getInternalConnection() throws SQLException {
        OracleBlob oracleBlob = (OracleBlob)this.getDelegate();
        return oracleBlob.getInternalConnection();
    }
}

