/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.actors;

import java.lang.reflect.Executable;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Predicate;
import java.util.logging.Logger;
import oracle.ucp.logging.ClioSupport;
import oracle.ucp.util.Chain;
import oracle.ucp.util.ListChain;
import oracle.ucp.util.Pair;

public class InterruptableActor<R, D, E extends Throwable> {
    private static final int DEFAULT_AWAIT_TIMEOUT = 10;
    private static final int DEFAULT_POLL_COUNT = 10;
    private static final int DEFAULT_POLL_TIMEOUT = 1;
    private final int awaitTimeout;
    private final int pollCount;
    private final int pollTimeout;
    private final Lock lock = new ReentrantLock();
    private final Condition condition = this.lock.newCondition();
    private final ListChain<Pair<Action<R, D, E>, Thread>> chain = new ListChain();
    private final AtomicReference<Predicate<Pair<Action<R, D, E>, Thread>>> predicate = new AtomicReference<Predicate<Pair>>(p -> false);
    private final Thread controlThread;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;

    private Thread buildControlThread() {
        return new Thread(() -> {
            block7: while (true) {
                try {
                    this.lock.lock();
                    this.condition.await(this.awaitTimeout, TimeUnit.SECONDS);
                }
                catch (InterruptedException e) {
                    ClioSupport.ilogThrowing(null, null, null, null, e);
                }
                finally {
                    this.lock.unlock();
                }
                int i = 0;
                while (true) {
                    if (i >= this.pollCount) continue block7;
                    this.interruptAllAppropriateActions();
                    try {
                        Thread.sleep((long)this.pollTimeout * 1000L);
                    }
                    catch (InterruptedException e) {
                        ClioSupport.ilogThrowing(null, null, null, null, e);
                    }
                    ++i;
                }
                break;
            }
        }, InterruptableActor.class.getName() + "-control");
    }

    private void interruptAllAppropriateActions() {
        this.chain.forEach(p -> {
            if (this.predicate.get().test((Pair<Action<R, D, E>, Thread>)p)) {
                ClioSupport.ilogFinest(null, null, null, null, "about to interrupt:" + p.get2nd());
                ((Thread)p.get2nd()).interrupt();
            }
        });
    }

    public InterruptableActor(int awaitTimeout, int pollCount, int pollTimeout) {
        this.awaitTimeout = awaitTimeout;
        this.pollCount = pollCount;
        this.pollTimeout = pollTimeout;
        this.controlThread = this.buildControlThread();
        this.controlThread.setDaemon(true);
        this.controlThread.start();
    }

    public InterruptableActor() {
        this(10, 10, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public R doAction(Action<R, D, E> action) throws E {
        Chain.Atom atom = this.chain.add((Object)new Pair<Action<R, D, E>, Thread>(action, Thread.currentThread()));
        try {
            R r = action.exec();
            return r;
        }
        catch (InterruptedException e) {
            ClioSupport.ilogThrowing(null, null, null, null, e);
            R r = null;
            return r;
        }
        finally {
            ((ListChain.Atom)atom).remove();
        }
    }

    public void registerPredicate(Predicate<Pair<Action<R, D, E>, Thread>> predicate) {
        this.predicate.set(predicate);
    }

    public void triggerInterrupts() {
        this.lock.lock();
        try {
            this.condition.signalAll();
        }
        finally {
            this.lock.unlock();
        }
    }

    static {
        try {
            $$$methodRef$$$9 = InterruptableActor.class.getDeclaredConstructor(new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$8 = InterruptableActor.class.getDeclaredConstructor(Integer.TYPE, Integer.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$7 = InterruptableActor.class.getDeclaredMethod("lambda$new$0", Pair.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$6 = InterruptableActor.class.getDeclaredMethod("lambda$buildControlThread$1", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$5 = InterruptableActor.class.getDeclaredMethod("lambda$interruptAllAppropriateActions$2", Pair.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$4 = InterruptableActor.class.getDeclaredMethod("triggerInterrupts", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$3 = InterruptableActor.class.getDeclaredMethod("registerPredicate", Predicate.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$2 = InterruptableActor.class.getDeclaredMethod("doAction", Action.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$1 = InterruptableActor.class.getDeclaredMethod("interruptAllAppropriateActions", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$0 = InterruptableActor.class.getDeclaredMethod("buildControlThread", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
    }

    public static interface Action<R, D, E extends Throwable> {
        public R exec() throws InterruptedException, E;

        default public D getDescriptor() {
            return null;
        }
    }
}

