#/bin/make
###############################################################################
#                       Make file for OCI and OCCI demos
###############################################################################
#  Usage :
# For compiling & linking the cdemo81.c file
#    make -f demo.mk buildoci EXE=cdemo81 OBJS=cdemo81.o 
#
# For compiling & linking the occidml.cpp
#    make -f demo.mk buildocci EXE=occidml OBJS=occidml.o
#
# For compiling & linking the occiobj.cpp
#    make -f demo.mk occiobj 
#
# In general, for any occi program
#    make -f demo.mk buildocci EXE=<exename> OBJS="<list of dependent objs>"
#
# For compiling all demos
#    make -f demo.mk
#
# NOTE: Please change cc and CC to point to the appropiate location on your
#       machine.
#
###############################################################################

.SUFFIXES: .o .c .cpp

CC=/usr/local/bin/xlC -q64
cc=/usr/local/bin/xlc -q64

ICINCHOME=../
ICLIBHOME=../../
ICLIBPATH=-L$(ICLIBHOME)
THREADLIBS=-lpthread
CCLIB=$(ICLIBPATH) -locci -lclntsh $(THREADLIBS)

CCINCLUDES = -I$(ICINCHOME)include

CCFLAGS=$(CCINCLUDES) -D_REENTRANT -g -xs 
LDFLAGS=
SO_EXT=.so

REMOVE=rm -rf
MAKE=make
MAKEFILE=demo.mk
CLNCACHE=cleancache
CACHEDIR=SunWS_cache

CDEMOEXE=cdemo81
CDEMOOBJS=cdemo81.o
OCCIDEMO=occidml
OCCIOBJDEMO=occiobj
OTT=../ott
OCCIOTTUSR=scott
OCCIOTTPWD=tiger

.cpp.o:
	$(CC) -c -I$(ICINCHOME)include $(CCFLAGS) $<

.c.o:
	$(cc) -c -I$(ICINCHOME)include $(CCFLAGS) $<

all: clean buildoci $(OCCIDEMO) $(OCCIOBJDEMO)

buildoci: $(CLNCACHE) $(LIBCLNT) $(CDEMOOBJS)
	$(CC) -o $(CDEMOEXE) $(LDFLAGS) $(CDEMOOBJS) $(CCLIB)

buildocci: $(CLNCACHE) $(LIBCLNT) $(OBJS)
	$(CC) -o $(EXE) $(LDFLAGS) $(OBJS) $(CCLIB)

$(OCCIDEMO):
	$(MAKE) -f $(MAKEFILE) buildocci OBJS=$@.o EXE=$@

$(OCCIOBJDEMO):
	$(OTT) userid=$(OCCIOTTUSR)/$(OCCIOTTPWD) \
                intype=$@.typ \
                outtype=$@out.type \
                code=cpp \
                hfile=$@.h \
                cppfile=$@o.cpp \
                attraccess=private \
                unicode=none
	$(MAKE) -f $(MAKEFILE) buildocci OBJS="$@.o $@m.o $@o.o" EXE=$@

cleancache:
	$(REMOVE) $(CACHEDIR)

clean: $(CLNCACHE)
	$(REMOVE) cdemo81 cdemo81.o occidml occidml.o occiobj occiobj.o occiobjo* occiobjm* occiobj.h occiobjout.type

#
# This port-specific file is currently empty on Solaris. Product
# lines may use this file to override compiler definitions and
# flags used in occi.mk.
#

# Linux PowerPPC compiler definitions

OCCILIBPATH32=-L$(SRCHOME)/rdbms/lib/ -L$(SRCHOME)/lib/ $(ICLIBPATH)
OCCILIBPATH64=-L$(SRCHOME)/rdbms/lib/ -L$(SRCHOME)/lib/ $(ICLIBPATH)

DISTRO=$(shell if test -f /etc/redhat-release ; then echo "RH4"; else echo "NotRH4"; fi)

LoPLINK=g++

ifeq ($(COMPILER), VAC)
  ifdef PPC_OS_VERSION
## used in BUILD/QA setup only
      ifeq ($(PPC_OS_VERSION), RH4)
         gcc_ver := $(shell gcc --version | grep 3.4.6)
         ifeq ($(gcc_ver),)
            VACCFG=-F/usr/local/packages/vac/vac/$(VAC_VERSION)/etc/vac3.4.5.cfg
         else
            VACCFG=-F/usr/local/packages/vac/vac/$(VAC_VERSION)/etc/vac3.4.6.cfg
         endif
      else
        ifeq ($(PPC_OS_VERSION), RH5)
            VACCFG=-F/usr/local/packages/vac/vac/$(VAC_VERSION)/etc/vac4.1.1.cfg
        else
            VACCFG=-F/usr/local/packages/vac/xlC/$(VAC_VERSION)/etc/xlc.cfg 
        endif
    endif
    LoPCC=/usr/local/packages/vac/xlC/$(VAC_VERSION)/bin/xlC $(VACCFG)
    LoPcc=/usr/local/packages/vac/xlC/$(VAC_VERSION)/bin/xlc $(VACCFG)
  else
    LoPCC=xlC
    LoPcc=xlc
  endif
  BIT_MODE32=-q32
  BIT_MODE64=-q64
else
  ifeq ($(DISTRO), RH4)
    LoPCC=g++32
    LoPLINK=g++32
  else
    LoPCC=g++
  endif
  LoPcc=gcc
  BIT_MODE32=-m32
  BIT_MODE64=-m64
endif

VACLIBS32=-L/opt/ibmcmp/vac/$(VAC_VERSION)/lib -lxl -Wl,-rpath /opt/ibmcmp/lib /opt/ibmcmp/lib/libibmc++.so.1
VACLIBS64= -lxl -Wl,-rpath /usr/local/remote/packages/vac_remote/$(VAC_VERSION)/lib/ -L/usr/local/packages/vac/xlC/$(VAC_VERSION)/lib -libmc++

CCLIB32=$(OCCILIBPATH32) -locci -lclntsh $(VACLIBS32) $(THREADLIBS)
CCLIB64=$(OCCILIBPATH64) -locci -lclntsh $(VACLIBS64) $(THREADLIBS)

ifeq ($(COMPILER_MODE), 32)
  CC=$(LoPCC) $(BIT_MODE32)
  cc=$(LoPcc) $(BIT_MODE32)
  CCFLAGS = -DBUILD32
  CCLIB=$(CCLIB32)
  VACLIBS=$(VACLIBS32)
  LINK=$(LoPLINK) -m32
else
  CC=$(LoPCC) $(BIT_MODE64)
  cc=$(LoPcc) $(BIT_MODE64)
  CCFLAGS = -D__LP64__
  CCLIB=$(CCLIB64)
  VACLIBS=$(VACLIBS64)
  LINK=$(LoPLINK) -m64
endif

CCFLAGS+=$(CCINCLUDES) -DLINUX -DLINUX_PPC64LE -D_GNU_SOURCE -D_REENTRANT -g 
LDFLAGS=-g
CLNCACHE=
THREADLIBS=-lpthread

ifdef BUILD_ICC
COMPDIR=/usr/local/packages/icc_remote/10.1.022
CC=$(COMPDIR)/bin/icpc
CCFLAGS += -DOCCI_NO_WSTRING=1
endif

build: $(CLNCACHE) $(OBJS) $(OTHEROBJS) $(MOBJS)
	$(LINK) -o $(EXE) $(LDFLAGS) $(OTHEROBJS) $(MOBJS) $(OBJS) $(CCLIB)

