/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.proxy;

import java.lang.reflect.Executable;
import java.util.logging.Logger;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;

class Utils {
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;
    private static Executable $$$methodRef$$$12;
    private static Logger $$$loggerRef$$$12;
    private static Executable $$$methodRef$$$13;
    private static Logger $$$loggerRef$$$13;
    private static Executable $$$methodRef$$$14;
    private static Logger $$$loggerRef$$$14;
    private static Executable $$$methodRef$$$15;
    private static Logger $$$loggerRef$$$15;
    private static Executable $$$methodRef$$$16;
    private static Logger $$$loggerRef$$$16;
    private static Executable $$$methodRef$$$17;
    private static Logger $$$loggerRef$$$17;

    Utils() {
    }

    static String makeSlashed(Class type) {
        return Utils.makeSlashed(type.getName());
    }

    static String makeSlashed(String name) {
        return name.replace('.', '/');
    }

    static String makeSlashed(String packageName, String name) {
        return Utils.makeSlashed(packageName) + '/' + name;
    }

    static String makeType(Class type) {
        return Utils.makeType(type.getName());
    }

    static String makeType(String name) {
        String slashedName = Utils.makeSlashed(name);
        if ("boolean".equals(slashedName)) {
            return "Z";
        }
        if ("char".equals(slashedName)) {
            return "C";
        }
        if ("byte".equals(slashedName)) {
            return "B";
        }
        if ("short".equals(slashedName)) {
            return "S";
        }
        if ("int".equals(slashedName)) {
            return "I";
        }
        if ("long".equals(slashedName)) {
            return "J";
        }
        if ("float".equals(slashedName)) {
            return "F";
        }
        if ("double".equals(slashedName)) {
            return "D";
        }
        if ("void".equals(slashedName)) {
            return "V";
        }
        if (slashedName.startsWith("[")) {
            return slashedName;
        }
        return 'L' + slashedName + ';';
    }

    static String makeSignature(Class[] parameterTypes, Class returnType) {
        StringBuilder sb = new StringBuilder();
        sb.append('(');
        for (Class parameterType : parameterTypes) {
            sb.append(Utils.makeType(Utils.makeSlashed(parameterType.getName())));
        }
        sb.append(')').append(Utils.makeType(Utils.makeSlashed(returnType.getName())));
        return sb.toString();
    }

    static String[] makeThrowables(Class[] exceptionTypes) {
        String[] throwables;
        int len = exceptionTypes.length;
        if (0 == len) {
            throwables = null;
        } else {
            throwables = new String[len];
            for (int i = 0; i < len; ++i) {
                throwables[i] = Utils.makeSlashed(exceptionTypes[i].getName());
            }
        }
        return throwables;
    }

    static int loadOpcode(Class type) {
        String name = type.getName();
        if ("boolean".equals(name) || "byte".equals(name) || "char".equals(name) || "short".equals(name) || "int".equals(name)) {
            return 21;
        }
        if ("long".equals(name)) {
            return 22;
        }
        if ("float".equals(name)) {
            return 23;
        }
        if ("double".equals(name)) {
            return 24;
        }
        return 25;
    }

    static int storeOpcode(Class type) {
        String name = type.getName();
        if ("boolean".equals(name) || "byte".equals(name) || "char".equals(name) || "short".equals(name) || "int".equals(name)) {
            return 54;
        }
        if ("long".equals(name)) {
            return 55;
        }
        if ("float".equals(name)) {
            return 56;
        }
        if ("double".equals(name)) {
            return 57;
        }
        return 58;
    }

    static int returnOpcode(Class type) {
        String name = type.getName();
        if ("boolean".equals(name) || "byte".equals(name) || "char".equals(name) || "short".equals(name) || "int".equals(name)) {
            return 172;
        }
        if ("long".equals(name)) {
            return 173;
        }
        if ("float".equals(name)) {
            return 174;
        }
        if ("double".equals(name)) {
            return 175;
        }
        if ("void".equals(name)) {
            return 177;
        }
        return 176;
    }

    static int varSize(Class type) {
        String name = type.getName();
        if ("double".equals(name) || "long".equals(name)) {
            return 2;
        }
        return 1;
    }

    static void cast(MethodVisitor mv, Class from, Class to) {
        boolean isFromPrimitive = Utils.isPrimitive(from);
        boolean isToPrimitive = Utils.isPrimitive(to);
        if (!isFromPrimitive && isToPrimitive) {
            Utils.autoUnbox(mv, to);
        } else if (isFromPrimitive && !isToPrimitive) {
            Utils.autoBox(mv, from);
        } else if (!(isFromPrimitive || isToPrimitive || from.equals(to))) {
            mv.visitTypeInsn(192, Utils.makeSlashed(to));
        }
    }

    static boolean isPrimitive(Class type) {
        return Boolean.TYPE.equals(type) || Character.TYPE.equals(type) || Byte.TYPE.equals(type) || Short.TYPE.equals(type) || Integer.TYPE.equals(type) || Long.TYPE.equals(type) || Float.TYPE.equals(type) || Double.TYPE.equals(type);
    }

    static void autoBox(MethodVisitor methodVisitor, Class type) {
        if (Boolean.TYPE.equals(type)) {
            methodVisitor.visitMethodInsn(184, "java/lang/Boolean", "valueOf", "(Z)Ljava/lang/Boolean;");
        } else if (Character.TYPE.equals(type)) {
            methodVisitor.visitMethodInsn(184, "java/lang/Character", "valueOf", "(C)Ljava/lang/Character;");
        } else if (Byte.TYPE.equals(type)) {
            methodVisitor.visitMethodInsn(184, "java/lang/Byte", "valueOf", "(B)Ljava/lang/Byte;");
        } else if (Short.TYPE.equals(type)) {
            methodVisitor.visitMethodInsn(184, "java/lang/Short", "valueOf", "(S)Ljava/lang/Short;");
        } else if (Integer.TYPE.equals(type)) {
            methodVisitor.visitMethodInsn(184, "java/lang/Integer", "valueOf", "(I)Ljava/lang/Integer;");
        } else if (Long.TYPE.equals(type)) {
            methodVisitor.visitMethodInsn(184, "java/lang/Long", "valueOf", "(J)Ljava/lang/Long;");
        } else if (Float.TYPE.equals(type)) {
            methodVisitor.visitMethodInsn(184, "java/lang/Float", "valueOf", "(F)Ljava/lang/Float;");
        } else if (Double.TYPE.equals(type)) {
            methodVisitor.visitMethodInsn(184, "java/lang/Double", "valueOf", "(D)Ljava/lang/Double;");
        }
    }

    static void autoUnbox(MethodVisitor methodVisitor, Class type) {
        if (Boolean.TYPE.equals(type)) {
            methodVisitor.visitTypeInsn(192, "java/lang/Boolean");
            methodVisitor.visitMethodInsn(182, "java/lang/Boolean", "booleanValue", "()Z");
        } else if (Character.TYPE.equals(type)) {
            methodVisitor.visitTypeInsn(192, "java/lang/Character");
            methodVisitor.visitMethodInsn(182, "java/lang/Character", "charValue", "()C");
        } else if (Byte.TYPE.equals(type)) {
            methodVisitor.visitTypeInsn(192, "java/lang/Byte");
            methodVisitor.visitMethodInsn(182, "java/lang/Byte", "byteValue", "()B");
        } else if (Short.TYPE.equals(type)) {
            methodVisitor.visitTypeInsn(192, "java/lang/Short");
            methodVisitor.visitMethodInsn(182, "java/lang/Short", "shortValue", "()S");
        } else if (Integer.TYPE.equals(type)) {
            methodVisitor.visitTypeInsn(192, "java/lang/Integer");
            methodVisitor.visitMethodInsn(182, "java/lang/Integer", "intValue", "()I");
        } else if (Long.TYPE.equals(type)) {
            methodVisitor.visitTypeInsn(192, "java/lang/Long");
            methodVisitor.visitMethodInsn(182, "java/lang/Long", "longValue", "()J");
        } else if (Float.TYPE.equals(type)) {
            methodVisitor.visitTypeInsn(192, "java/lang/Float");
            methodVisitor.visitMethodInsn(182, "java/lang/Float", "floatValue", "()F");
        } else if (Double.TYPE.equals(type)) {
            methodVisitor.visitTypeInsn(192, "java/lang/Double");
            methodVisitor.visitMethodInsn(182, "java/lang/Double", "doubleValue", "()D");
        } else {
            methodVisitor.visitTypeInsn(192, Utils.makeSlashed(type));
        }
    }

    static void loadClass(MethodVisitor mv, Class type) {
        String name = type.getName();
        if ("boolean".equals(name)) {
            mv.visitFieldInsn(178, "java/lang/Boolean", "TYPE", "Ljava/lang/Class;");
        } else if ("char".equals(name)) {
            mv.visitFieldInsn(178, "java/lang/Character", "TYPE", "Ljava/lang/Class;");
        } else if ("byte".equals(name)) {
            mv.visitFieldInsn(178, "java/lang/Byte", "TYPE", "Ljava/lang/Class;");
        } else if ("short".equals(name)) {
            mv.visitFieldInsn(178, "java/lang/Short", "TYPE", "Ljava/lang/Class;");
        } else if ("int".equals(name)) {
            mv.visitFieldInsn(178, "java/lang/Integer", "TYPE", "Ljava/lang/Class;");
        } else if ("long".equals(name)) {
            mv.visitFieldInsn(178, "java/lang/Long", "TYPE", "Ljava/lang/Class;");
        } else if ("float".equals(name)) {
            mv.visitFieldInsn(178, "java/lang/Float", "TYPE", "Ljava/lang/Class;");
        } else if ("double".equals(name)) {
            mv.visitFieldInsn(178, "java/lang/Double", "TYPE", "Ljava/lang/Class;");
        } else {
            mv.visitLdcInsn((Object)Type.getType((Class)type));
        }
    }

    static void loadConst(MethodVisitor mv, int n) {
        switch (n) {
            case 0: {
                mv.visitInsn(3);
                return;
            }
            case 1: {
                mv.visitInsn(4);
                return;
            }
            case 2: {
                mv.visitInsn(5);
                return;
            }
            case 3: {
                mv.visitInsn(6);
                return;
            }
            case 4: {
                mv.visitInsn(7);
                return;
            }
            case 5: {
                mv.visitInsn(8);
                return;
            }
        }
        if (n >= -128 && n <= 127) {
            mv.visitIntInsn(16, n);
            return;
        }
        throw new RuntimeException("do not know how to load " + n);
    }

    static {
        try {
            $$$methodRef$$$17 = Utils.class.getDeclaredConstructor(new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$17 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$16 = Utils.class.getDeclaredMethod("loadConst", MethodVisitor.class, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$16 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$15 = Utils.class.getDeclaredMethod("loadClass", MethodVisitor.class, Class.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$15 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$14 = Utils.class.getDeclaredMethod("autoUnbox", MethodVisitor.class, Class.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$14 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$13 = Utils.class.getDeclaredMethod("autoBox", MethodVisitor.class, Class.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$13 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$12 = Utils.class.getDeclaredMethod("isPrimitive", Class.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$11 = Utils.class.getDeclaredMethod("cast", MethodVisitor.class, Class.class, Class.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$10 = Utils.class.getDeclaredMethod("varSize", Class.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$9 = Utils.class.getDeclaredMethod("returnOpcode", Class.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$8 = Utils.class.getDeclaredMethod("storeOpcode", Class.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$7 = Utils.class.getDeclaredMethod("loadOpcode", Class.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$6 = Utils.class.getDeclaredMethod("makeThrowables", Class[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$5 = Utils.class.getDeclaredMethod("makeSignature", Class[].class, Class.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$4 = Utils.class.getDeclaredMethod("makeType", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$3 = Utils.class.getDeclaredMethod("makeType", Class.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$2 = Utils.class.getDeclaredMethod("makeSlashed", String.class, String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$1 = Utils.class.getDeclaredMethod("makeSlashed", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$0 = Utils.class.getDeclaredMethod("makeSlashed", Class.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
    }
}

