/*
 * Decompiled with CFR 0.152.
 */
package oracle.streams;

import java.math.BigInteger;
import oracle.sql.Datum;
import oracle.streams.ChunkColumnValue;
import oracle.streams.DefaultColumnValue;
import oracle.streams.StreamsException;

public class DefaultChunkColumnValue
extends DefaultColumnValue
implements ChunkColumnValue {
    protected BigInteger chunkOffset = null;
    protected BigInteger chunkOperationSize = null;
    protected int chunkType = 0;
    protected boolean emptyChunk = false;
    protected boolean xmlDiff = false;
    protected boolean lastChunk = false;
    protected boolean endOfRow = false;
    protected int charSetId = 0;
    protected Datum updatedRowId = null;

    public DefaultChunkColumnValue(String string, Datum datum, int n) throws StreamsException {
        if (null == string) {
            throw new StreamsException("columnName cannot be null");
        }
        this.columnName = string;
        this.columnData = datum;
        this.setChunkType(n);
    }

    public DefaultChunkColumnValue(String string, Datum datum, int n, BigInteger bigInteger, BigInteger bigInteger2) throws StreamsException {
        if (null == string) {
            throw new StreamsException("columnName cannot be null");
        }
        this.columnName = string;
        this.columnData = datum;
        this.setChunkType(n);
        this.setChunkOffset(bigInteger);
        this.setChunkOperationSize(bigInteger2);
    }

    @Override
    public int getChunkType() {
        return this.chunkType;
    }

    @Override
    public void setChunkType(int n) throws StreamsException {
        this.chunkType = n;
        switch (n) {
            case 1: {
                this.columnDataType = 1;
                break;
            }
            case 3: {
                this.columnDataType = 1;
                break;
            }
            case 2: {
                this.columnDataType = 23;
                break;
            }
            case 4: {
                this.columnDataType = 23;
                break;
            }
            case 5: {
                this.columnDataType = 1;
                break;
            }
            case 6: {
                this.columnDataType = 23;
                break;
            }
            default: {
                throw new StreamsException("XStream: unsupported chunk type");
            }
        }
    }

    @Override
    public Datum getUpdatedRowId() {
        return this.updatedRowId;
    }

    @Override
    public void setUpdatedRowId(Datum datum) {
        this.updatedRowId = datum;
    }

    public void setColumnData(Datum datum) {
        this.columnData = datum;
    }

    @Override
    public void setColumnData(Datum datum, int n) throws StreamsException {
        super.setColumnData(datum, this.columnDataType);
    }

    @Override
    public BigInteger getChunkOffset() {
        return this.chunkOffset;
    }

    @Override
    public int getCharSetId() {
        return this.charSetId;
    }

    @Override
    public void setChunkOffset(BigInteger bigInteger) {
        this.chunkOffset = bigInteger;
    }

    @Override
    public BigInteger getChunkOperationSize() {
        return this.chunkOperationSize;
    }

    @Override
    public void setChunkOperationSize(BigInteger bigInteger) {
        this.chunkOperationSize = bigInteger;
    }

    @Override
    public boolean isLastChunk() {
        return this.lastChunk;
    }

    @Override
    public boolean isEmptyChunk() {
        return this.emptyChunk;
    }

    @Override
    public boolean isXMLDiff() {
        return this.xmlDiff;
    }

    @Override
    public boolean isEndOfRow() {
        return this.endOfRow;
    }

    @Override
    public void setLastChunk(boolean bl) {
        this.lastChunk = bl;
    }

    @Override
    public void setEmptyChunk(boolean bl) {
        this.emptyChunk = bl;
    }

    @Override
    public void setXMLDiff(boolean bl) {
        this.xmlDiff = bl;
    }

    @Override
    public void setEndOfRow(boolean bl) {
        this.endOfRow = bl;
    }

    @Override
    public void setCharSetId(int n) {
        this.charSetId = n;
    }

    @Override
    public String toString() {
        return "DefaultChunkColumnValue(offset:" + this.chunkOffset + ", size:" + this.chunkOperationSize + ", chunkType:" + this.chunkType + ", emptyChunk:" + this.emptyChunk + ", lastChunk:" + this.lastChunk + ", xmlDiff:" + this.xmlDiff + ", endOfRow:" + this.endOfRow + ", charSetId:" + this.charSetId + ", " + super.toString() + ")";
    }
}

