/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.jdbc.oracle;

import java.lang.reflect.Executable;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Properties;
import java.util.logging.Logger;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;
import oracle.jdbc.replay.OracleDataSource;
import oracle.jdbc.replay.internal.ReplayableConnection;
import oracle.ucp.ConnectionRetrievalInfo;
import oracle.ucp.UniversalConnectionPoolException;
import oracle.ucp.UniversalPooledConnectionStatus;
import oracle.ucp.common.CoreConnection;
import oracle.ucp.jdbc.ConnectionInitializationCallback;
import oracle.ucp.jdbc.ConnectionLabelingCallback;
import oracle.ucp.jdbc.JDBCConnectionFactoryAdapter;
import oracle.ucp.jdbc.oracle.OracleConnectionConnectionPool;
import oracle.ucp.jdbc.oracle.OracleUniversalPooledConnection;
import oracle.ucp.jdbc.oracle.Poolable;
import oracle.ucp.jdbc.oracle.ReplayDataSourceConnectionFactoryAdapter;
import oracle.ucp.logging.runtime.TraceControllerImpl;
import oracle.ucp.util.UCPErrorHandler;

@DefaultLogger(value="oracle.ucp.jdbc.oracle")
@Supports(value={Feature.CHECK_IN, Feature.CHECK_OUT, Feature.CONN_CONSTRUCTION, Feature.CONN_DESTRUCTION})
public class OracleReplayableConnectionConnectionPool
extends OracleConnectionConnectionPool
implements oracle.jdbc.replay.internal.ConnectionInitializationCallback {
    static final String ORDS_REST_LABEL = "oracle.dbtools.jdbc.label.schema";
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;

    public OracleReplayableConnectionConnectionPool(JDBCConnectionFactoryAdapter connectionFactoryAdapter) throws UniversalConnectionPoolException {
        super(connectionFactoryAdapter);
        this.core.connectionSource().setReplayable(true);
    }

    @Override
    public void start() throws UniversalConnectionPoolException {
        block3: {
            boolean bl;
            boolean bl2 = bl = (0x36000000000000L & TraceControllerImpl.feature) != 0L;
            if (!this.useVanillaObjects) {
                ReplayDataSourceConnectionFactoryAdapter rcfa = (ReplayDataSourceConnectionFactoryAdapter)this.getConnectionFactoryAdapter();
                OracleDataSource rds = (OracleDataSource)rcfa.getDataSource();
                try {
                    rds.registerConnectionInitializationCallback((oracle.jdbc.replay.internal.ConnectionInitializationCallback)this);
                }
                catch (SQLException sqlexc) {
                    if (!bl) break block3;
                    this.ilogThrowing($$$loggerRef$$$0, OracleReplayableConnectionConnectionPool.class, $$$methodRef$$$0, this, sqlexc);
                }
            }
        }
        super.start();
    }

    /*
     * WARNING - void declaration
     */
    public void initialize(Connection connection) throws SQLException {
        block19: {
            boolean bl = (0x36000000000000L & TraceControllerImpl.feature) != 0L;
            try {
                oracle.ucp.ConnectionLabelingCallback labelingCbk;
                void connection2;
                if (connection2 == null) {
                    throw UCPErrorHandler.newSQLException(65);
                }
                Object ucpConnProxy = ((ReplayableConnection)connection2).getProxyObject();
                if (ucpConnProxy == null || !(ucpConnProxy instanceof Poolable)) {
                    throw UCPErrorHandler.newSQLException(66);
                }
                OracleUniversalPooledConnection oupc = (OracleUniversalPooledConnection)((Poolable)ucpConnProxy).getPooledObject();
                oupc.setStatus(UniversalPooledConnectionStatus.STATUS_RECONNECTING);
                if (bl) {
                    this.ilogFinest($$$loggerRef$$$1, OracleReplayableConnectionConnectionPool.class, $$$methodRef$$$1, this, "AC initialize(): found UPC for " + connection2 + ", status: RECONNECTING");
                }
                if (this.isFailoverEnabled()) {
                    CoreConnection coreConn = oupc.getDelegator();
                    coreConn.reinitialize();
                    if (this.m_racManager != null) {
                        this.m_racManager.connectionClosed(oupc);
                    }
                    oupc.initFailoverParameters();
                    oupc.updateInstanceNumber();
                    if (this.m_racManager != null) {
                        this.m_racManager.connectionOpened(oupc);
                    }
                }
                oupc.setStatus(UniversalPooledConnectionStatus.STATUS_NORMAL);
                if (bl) {
                    this.ilogFinest($$$loggerRef$$$1, OracleReplayableConnectionConnectionPool.class, $$$methodRef$$$1, this, "AC initialize(): metadata update done for " + connection2 + ", status: NORMAL");
                }
                if ((labelingCbk = this.getConnectionLabelingCallback()) != null) {
                    Properties reqLabels;
                    if (bl) {
                        this.ilogFinest($$$loggerRef$$$1, OracleReplayableConnectionConnectionPool.class, $$$methodRef$$$1, this, "Registered labeling callback: " + labelingCbk);
                    }
                    Properties properties = reqLabels = labelingCbk instanceof ConnectionLabelingCallback ? ((ConnectionLabelingCallback)labelingCbk).getRequestedLabels() : oupc.getConnectionLabels();
                    if (bl) {
                        this.ilogFinest($$$loggerRef$$$1, OracleReplayableConnectionConnectionPool.class, $$$methodRef$$$1, this, "Requested labels: " + reqLabels);
                    }
                    if (reqLabels.getProperty(ORDS_REST_LABEL) != null) {
                        ConnectionRetrievalInfo criNoLabels = oupc.getConnectionRetrievalInfo().getCopyWithNoLabels();
                        oupc.setConnectionRetrievalInfo(criNoLabels);
                        if (bl) {
                            this.ilogFinest($$$loggerRef$$$1, OracleReplayableConnectionConnectionPool.class, $$$methodRef$$$1, this, "Cleared labels on new connection");
                        }
                    }
                    labelingCbk.configure(reqLabels, this.getConnectionObjectForLabelingConfigure(oupc));
                    if (bl) {
                        this.ilogFinest($$$loggerRef$$$1, OracleReplayableConnectionConnectionPool.class, $$$methodRef$$$1, this, "After configure, new labels: " + oupc.getConnectionLabels());
                    }
                } else {
                    ConnectionInitializationCallback connInitCallback = this.getConnectionInitializationCallback();
                    if (connInitCallback != null) {
                        connInitCallback.initialize((Connection)connection2);
                    }
                }
                this.incrementConnectionsCreatedCount();
                this.incrementCumulativeConnectionsCreated();
            }
            catch (SQLException sqlexc) {
                if (bl) {
                    this.ilogThrowing($$$loggerRef$$$1, OracleReplayableConnectionConnectionPool.class, $$$methodRef$$$1, this, sqlexc);
                }
                throw sqlexc;
            }
            catch (Exception exc) {
                if (!bl) break block19;
                this.ilogThrowing($$$loggerRef$$$1, OracleReplayableConnectionConnectionPool.class, $$$methodRef$$$1, this, exc);
            }
        }
    }

    static {
        try {
            $$$methodRef$$$2 = OracleReplayableConnectionConnectionPool.class.getDeclaredConstructor(JDBCConnectionFactoryAdapter.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.oracle");
        try {
            $$$methodRef$$$1 = OracleReplayableConnectionConnectionPool.class.getDeclaredMethod("initialize", Connection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.oracle");
        try {
            $$$methodRef$$$0 = OracleReplayableConnectionConnectionPool.class.getDeclaredMethod("start", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.oracle");
    }
}

