/*
 * Decompiled with CFR 0.152.
 */
package oracle.i18n.util;

import java.io.IOException;
import java.io.Reader;

public class DualReaderBuilder {
    private static int DEFAULT_BUFFER_SIZE = 8192;
    private static int DEFAULT_STREAM_NUMBER = 2;
    private char[] m_buf;
    private int m_count;
    private int[] m_pos;
    private final boolean[] m_isClosed;
    private Reader m_in;
    private Reader[] m_subReader;

    public DualReaderBuilder(Reader reader, int n) {
        this.m_in = reader;
        this.m_buf = new char[n];
        this.m_pos = new int[DEFAULT_STREAM_NUMBER];
        this.m_isClosed = new boolean[DEFAULT_STREAM_NUMBER];
        this.m_subReader = new Reader[DEFAULT_STREAM_NUMBER];
        for (int i = 0; i < DEFAULT_STREAM_NUMBER; ++i) {
            this.m_pos[i] = 0;
            this.m_isClosed[i] = false;
        }
    }

    public DualReaderBuilder(Reader reader) {
        this(reader, DEFAULT_BUFFER_SIZE);
    }

    public Reader getFirstReader() {
        return this.getReader(0);
    }

    public Reader getSecondReader() {
        return this.getReader(1);
    }

    private void ensureOpen(int n) throws IOException {
        if (this.m_in == null || this.m_isClosed[n]) {
            throw new IOException("Stream closed");
        }
    }

    private synchronized Reader getReader(int n) {
        if (this.m_subReader[n] == null) {
            this.m_subReader[n] = new SubReader(this, n);
        }
        return this.m_subReader[n];
    }

    private int getMinPos() {
        int n = Integer.MAX_VALUE;
        for (int i = 0; i < DEFAULT_STREAM_NUMBER; ++i) {
            if (this.m_pos[i] < 0 || n < this.m_pos[i]) continue;
            n = this.m_pos[i];
        }
        return n;
    }

    private void fill(int n, int n2) throws IOException {
        int n3;
        if (this.m_pos[n] >= this.m_buf.length) {
            int n4 = n3 = n2 < 0 ? this.getMinPos() : n2;
            if (n3 > 0) {
                int n5 = this.m_pos[n] - n3;
                System.arraycopy(this.m_buf, n3, this.m_buf, 0, n5);
                int n6 = 0;
                while (n6 < DEFAULT_STREAM_NUMBER) {
                    int n7 = n6++;
                    this.m_pos[n7] = this.m_pos[n7] - n3;
                }
                this.m_count -= n3;
            } else {
                int n8 = this.m_pos[n] * 2;
                char[] cArray = new char[n8];
                System.arraycopy(this.m_buf, 0, cArray, 0, this.m_pos[n]);
                this.m_buf = cArray;
                this.m_count = this.m_pos[n];
            }
        }
        if ((n3 = this.m_in.read(this.m_buf, this.m_pos[n], this.m_buf.length - this.m_pos[n])) > 0) {
            this.m_count = n3 + this.m_pos[n];
        }
    }

    private synchronized int read(int n) throws IOException {
        this.ensureOpen(n);
        if (this.m_pos[n] >= this.m_count) {
            this.fill(n, -1);
            if (this.m_pos[n] >= this.m_count) {
                return -1;
            }
        }
        int n2 = n;
        int n3 = this.m_pos[n2];
        this.m_pos[n2] = n3 + 1;
        return this.m_buf[n3] & 0xFF;
    }

    private int read1(int n, char[] cArray, int n2, int n3) throws IOException {
        int n4;
        int n5 = this.m_count - this.m_pos[n];
        if (n5 <= 0) {
            n4 = this.getMinPos();
            this.fill(n, n4);
            n5 = this.m_count - this.m_pos[n];
            if (n5 <= 0) {
                return -1;
            }
        }
        n4 = n5 < n3 ? n5 : n3;
        System.arraycopy(this.m_buf, this.m_pos[n], cArray, n2, n4);
        int n6 = n;
        this.m_pos[n6] = this.m_pos[n6] + n4;
        return n4;
    }

    private synchronized int read(int n, char[] cArray, int n2, int n3) throws IOException {
        int n4;
        this.ensureOpen(n);
        if ((n2 | n3 | n2 + n3 | cArray.length - (n2 + n3)) < 0) {
            throw new IndexOutOfBoundsException("b.length=" + cArray.length + ", off=" + n2 + ", len=" + n3);
        }
        if (n3 == 0) {
            return 0;
        }
        int n5 = this.read1(n, cArray, n2, n3);
        if (n5 <= 0) {
            return n5;
        }
        while (n5 < n3 && (n4 = this.read1(n, cArray, n2 + n5, n3 - n5)) > 0) {
            n5 += n4;
        }
        return n5;
    }

    private void close(int n) throws IOException {
        if (this.m_in == null) {
            return;
        }
        this.m_isClosed[n] = true;
        this.m_pos[n] = -1;
        boolean bl = true;
        for (int i = 0; i < DEFAULT_STREAM_NUMBER; ++i) {
            bl &= this.m_isClosed[i];
        }
        if (bl) {
            this.m_in.close();
            this.m_in = null;
            this.m_buf = null;
        }
    }

    private synchronized long skip(int n, long l) throws IOException {
        this.ensureOpen(n);
        if (l <= 0L) {
            return 0L;
        }
        long l2 = this.m_count - this.m_pos[n];
        if (l2 <= 0L) {
            this.fill(n, -1);
            l2 = this.m_count - this.m_pos[n];
            if (l2 <= 0L) {
                return 0L;
            }
        }
        long l3 = l2 < l ? l2 : l;
        int n2 = n;
        this.m_pos[n2] = (int)((long)this.m_pos[n2] + l3);
        return l3;
    }

    private boolean ready(int n) throws IOException {
        this.ensureOpen(n);
        return this.m_count - this.m_pos[n] > 0 || this.m_in.ready();
    }

    private class SubReader
    extends Reader {
        private DualReaderBuilder m_dups;
        private int m_index;

        public SubReader(DualReaderBuilder dualReaderBuilder2, int n) {
            this.m_dups = dualReaderBuilder2;
            this.m_index = n;
        }

        @Override
        public synchronized int read() throws IOException {
            return this.m_dups.read(this.m_index);
        }

        @Override
        public void close() throws IOException {
            this.m_dups.close(this.m_index);
        }

        @Override
        public void mark(int n) {
        }

        @Override
        public boolean markSupported() {
            return false;
        }

        @Override
        public int read(char[] cArray, int n, int n2) throws IOException {
            return this.m_dups.read(this.m_index, cArray, n, n2);
        }

        @Override
        public int read(char[] cArray) throws IOException {
            return this.read(cArray, 0, cArray.length);
        }

        @Override
        public void reset() throws IOException {
        }

        @Override
        public long skip(long l) throws IOException {
            return this.m_dups.skip(this.m_index, l);
        }

        @Override
        public boolean ready() throws IOException {
            return this.m_dups.ready(this.m_index);
        }
    }
}

