/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver.json.tree;

import java.io.IOException;
import java.math.BigDecimal;
import oracle.jdbc.driver.json.OracleJsonExceptions;
import oracle.jdbc.driver.json.binary.JsonpOsonValueFactory;
import oracle.jdbc.driver.json.tree.OracleJsonNumberImpl;
import oracle.sql.NUMBER;
import oracle.sql.json.OracleJsonDecimal;
import oracle.sql.json.OracleJsonValue;

public class OracleJsonStringNumberImpl
extends OracleJsonNumberImpl
implements OracleJsonDecimal {
    String value;

    public OracleJsonStringNumberImpl(String string) {
        this.value = string;
    }

    @Override
    public String getString() {
        return this.value;
    }

    @Override
    public OracleJsonValue.OracleJsonType getOracleJsonType() {
        return OracleJsonValue.OracleJsonType.DECIMAL;
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof OracleJsonDecimal)) {
            return false;
        }
        OracleJsonDecimal oracleJsonDecimal = (OracleJsonDecimal)object;
        return this.bigDecimalValue().equals(oracleJsonDecimal.bigDecimalValue());
    }

    @Override
    public int hashCode() {
        return this.bigDecimalValue().hashCode();
    }

    @Override
    public BigDecimal bigDecimalValue() {
        return new BigDecimal(this.value);
    }

    public void serialize(Appendable appendable) {
        try {
            appendable.append(this.value);
        }
        catch (IOException iOException) {
            throw OracleJsonExceptions.IO.create(this.getExceptionFactory(), iOException, new Object[0]);
        }
    }

    @Override
    public NUMBER getNUMBER() {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> T wrap(Class<T> clazz) {
        return clazz.cast(JsonpOsonValueFactory.INSTANCE.createStringNumber(this.value));
    }

    @Override
    public OracleJsonDecimal.TargetType getTargetType() {
        return null;
    }
}

