/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver.json.tree;

import java.io.StringWriter;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import oracle.jdbc.driver.json.binary.JsonSerializerImpl;
import oracle.jdbc.driver.json.tree.JsonpArrayImpl;
import oracle.jdbc.driver.json.tree.OracleJsonBinaryImpl;
import oracle.jdbc.driver.json.tree.OracleJsonDecimalImpl;
import oracle.jdbc.driver.json.tree.OracleJsonDoubleImpl;
import oracle.jdbc.driver.json.tree.OracleJsonObjectImpl;
import oracle.jdbc.driver.json.tree.OracleJsonStringImpl;
import oracle.jdbc.driver.json.tree.OracleJsonTimestampImpl;
import oracle.jdbc.driver.json.tree.OracleJsonTimestampTZImpl;
import oracle.sql.json.OracleJsonArray;
import oracle.sql.json.OracleJsonException;
import oracle.sql.json.OracleJsonNumber;
import oracle.sql.json.OracleJsonValue;

public class OracleJsonArrayImpl
implements OracleJsonArray {
    List<OracleJsonValue> list = new ArrayList<OracleJsonValue>();

    public OracleJsonArrayImpl() {
    }

    public OracleJsonArrayImpl(OracleJsonArray oracleJsonArray) {
        block4: for (OracleJsonValue oracleJsonValue : oracleJsonArray) {
            switch (oracleJsonValue.getOracleJsonType()) {
                case OBJECT: {
                    this.list.add(new OracleJsonObjectImpl(oracleJsonValue.asJsonObject()));
                    continue block4;
                }
                case ARRAY: {
                    this.list.add(new OracleJsonArrayImpl(oracleJsonValue.asJsonArray()));
                    continue block4;
                }
            }
            this.list.add(oracleJsonValue);
        }
    }

    @Override
    public OracleJsonValue.OracleJsonType getOracleJsonType() {
        return OracleJsonValue.OracleJsonType.ARRAY;
    }

    @Override
    public int size() {
        return this.list.size();
    }

    @Override
    public boolean isEmpty() {
        return this.list.isEmpty();
    }

    @Override
    public boolean contains(Object object) {
        return this.list.contains(object);
    }

    @Override
    public Iterator<OracleJsonValue> iterator() {
        return this.list.iterator();
    }

    @Override
    public Object[] toArray() {
        return this.list.toArray();
    }

    @Override
    public <T> T[] toArray(T[] TArray) {
        return this.list.toArray(TArray);
    }

    @Override
    public boolean containsAll(Collection<?> collection) {
        return this.list.containsAll(collection);
    }

    @Override
    public void clear() {
        this.list.clear();
    }

    @Override
    public OracleJsonValue get(int n2) {
        return this.list.get(n2);
    }

    @Override
    public int indexOf(Object object) {
        return this.list.indexOf(object);
    }

    @Override
    public int lastIndexOf(Object object) {
        return this.list.lastIndexOf(object);
    }

    @Override
    public ListIterator<OracleJsonValue> listIterator() {
        return this.list.listIterator();
    }

    @Override
    public ListIterator<OracleJsonValue> listIterator(int n2) {
        return this.list.listIterator(n2);
    }

    @Override
    public <T extends OracleJsonValue> List<T> getValuesAs(Class<T> clazz) {
        return this;
    }

    @Override
    public String getString(int n2) {
        return this.list.get(n2).asJsonString().getString();
    }

    @Override
    public int getInt(int n2) {
        return ((OracleJsonNumber)this.list.get(n2)).intValue();
    }

    @Override
    public double getDouble(int n2) {
        return ((OracleJsonNumber)this.list.get(n2)).doubleValue();
    }

    @Override
    public BigDecimal getBigDecimal(int n2) {
        return ((OracleJsonNumber)this.list.get(n2)).bigDecimalValue();
    }

    @Override
    public long getLong(int n2) {
        return ((OracleJsonNumber)this.list.get(n2)).longValue();
    }

    @Override
    public boolean getBoolean(int n2) {
        OracleJsonValue oracleJsonValue = this.list.get(n2);
        if (oracleJsonValue.equals(OracleJsonValue.TRUE)) {
            return true;
        }
        if (oracleJsonValue.equals(OracleJsonValue.FALSE)) {
            return false;
        }
        throw new ClassCastException();
    }

    @Override
    public boolean isNull(int n2) {
        return OracleJsonValue.NULL.equals(this.list.get(n2));
    }

    @Override
    public LocalDateTime getLocalDateTime(int n2) {
        OracleJsonValue oracleJsonValue = this.list.get(n2);
        if (oracleJsonValue.getOracleJsonType() == OracleJsonValue.OracleJsonType.DATE) {
            return oracleJsonValue.asJsonDate().getLocalDateTime();
        }
        return oracleJsonValue.asJsonTimestamp().getLocalDateTime();
    }

    @Override
    public OffsetDateTime getOffsetDateTime(int n2) {
        OracleJsonValue oracleJsonValue = this.list.get(n2);
        return oracleJsonValue.asJsonTimestampTZ().getOffsetDateTime();
    }

    @Override
    public byte[] getBytes(int n2) {
        return this.list.get(n2).asJsonBinary().getBytes();
    }

    @Override
    public OracleJsonValue set(int n2, OracleJsonValue oracleJsonValue) {
        this.checkNull(oracleJsonValue);
        return this.list.set(n2, oracleJsonValue);
    }

    public OracleJsonArray subList(int n2, int n3) {
        OracleJsonArrayImpl oracleJsonArrayImpl = new OracleJsonArrayImpl();
        for (int i2 = n2; i2 < n3; ++i2) {
            oracleJsonArrayImpl.add(this.get(i2));
        }
        return oracleJsonArrayImpl;
    }

    @Override
    public void add(double d2) {
        this.add(new OracleJsonDoubleImpl(d2));
    }

    @Override
    public void add(long l2) {
        this.add(new OracleJsonDecimalImpl(l2));
    }

    @Override
    public void add(BigDecimal bigDecimal) {
        this.add(new OracleJsonDecimalImpl(bigDecimal));
    }

    @Override
    public void add(boolean bl) {
        this.add(bl ? OracleJsonValue.TRUE : OracleJsonValue.FALSE);
    }

    @Override
    public void add(String string) {
        this.add(new OracleJsonStringImpl(string));
    }

    @Override
    public void add(int n2) {
        this.add(new OracleJsonDecimalImpl(n2));
    }

    @Override
    public boolean addAll(Collection<? extends OracleJsonValue> collection) {
        for (OracleJsonValue oracleJsonValue : collection) {
            this.checkNull(oracleJsonValue);
            this.list.add(oracleJsonValue);
        }
        return collection.size() > 0;
    }

    @Override
    public boolean addAll(int n2, Collection<? extends OracleJsonValue> collection) {
        for (OracleJsonValue oracleJsonValue : collection) {
            this.checkNull(oracleJsonValue);
        }
        return this.list.addAll(n2, collection);
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        return this.list.removeAll(collection);
    }

    @Override
    public boolean retainAll(Collection<?> collection) {
        return this.list.retainAll(collection);
    }

    @Override
    public OracleJsonValue set(int n2, boolean bl) {
        return this.list.set(n2, bl ? OracleJsonValue.TRUE : OracleJsonValue.FALSE);
    }

    @Override
    public void add(int n2, OracleJsonValue oracleJsonValue) {
        this.checkNull(oracleJsonValue);
        this.list.add(n2, oracleJsonValue);
    }

    private void checkNull(OracleJsonValue oracleJsonValue) {
        if (oracleJsonValue == null) {
            throw new NullPointerException();
        }
    }

    @Override
    public OracleJsonValue remove(int n2) {
        return this.list.remove(n2);
    }

    @Override
    public OracleJsonValue set(int n2, String string) {
        return this.list.set(n2, new OracleJsonStringImpl(string));
    }

    @Override
    public OracleJsonValue set(int n2, int n3) {
        return this.list.set(n2, new OracleJsonDecimalImpl(n3));
    }

    @Override
    public OracleJsonValue set(int n2, double d2) {
        return this.list.set(n2, new OracleJsonDoubleImpl(d2));
    }

    @Override
    public OracleJsonValue set(int n2, long l2) {
        return this.list.set(n2, new OracleJsonDecimalImpl(l2));
    }

    @Override
    public OracleJsonValue set(int n2, BigDecimal bigDecimal) throws OracleJsonException {
        return this.list.set(n2, new OracleJsonDecimalImpl(bigDecimal));
    }

    @Override
    public OracleJsonValue setNull(int n2) {
        return this.list.set(n2, OracleJsonValue.NULL);
    }

    @Override
    public void addNull() {
        this.list.add(OracleJsonValue.NULL);
    }

    @Override
    public OracleJsonValue set(int n2, LocalDateTime localDateTime) {
        return this.list.set(n2, new OracleJsonTimestampImpl(localDateTime));
    }

    @Override
    public OracleJsonValue set(int n2, OffsetDateTime offsetDateTime) {
        return this.list.set(n2, new OracleJsonTimestampTZImpl(offsetDateTime));
    }

    @Override
    public void add(LocalDateTime localDateTime) {
        this.list.add(new OracleJsonTimestampImpl(localDateTime));
    }

    @Override
    public void add(OffsetDateTime offsetDateTime) {
        this.list.add(new OracleJsonTimestampTZImpl(offsetDateTime));
    }

    @Override
    public boolean remove(Object object) {
        return this.list.remove(object);
    }

    @Override
    public OracleJsonValue set(int n2, byte[] byArray) {
        return this.list.set(n2, new OracleJsonBinaryImpl(byArray, false));
    }

    @Override
    public void add(byte[] byArray) {
        this.list.add(new OracleJsonBinaryImpl(byArray, false));
    }

    @Override
    public boolean add(OracleJsonValue oracleJsonValue) {
        this.checkNull(oracleJsonValue);
        return this.list.add(oracleJsonValue);
    }

    @Override
    public String toString() {
        StringWriter stringWriter = new StringWriter();
        JsonSerializerImpl jsonSerializerImpl = new JsonSerializerImpl(stringWriter);
        jsonSerializerImpl.write(this);
        jsonSerializerImpl.close();
        return stringWriter.toString();
    }

    @Override
    public boolean equals(Object object) {
        return this.list.equals(object);
    }

    @Override
    public int hashCode() {
        return this.list.hashCode();
    }

    @Override
    public <T> T wrap(Class<T> clazz) {
        return clazz.cast(new JsonpArrayImpl(this));
    }
}

