/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.jdbc.proxy.oracle;

import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import oracle.jdbc.internal.OracleCallableStatement;
import oracle.jdbc.internal.OraclePreparedStatement;
import oracle.jdbc.internal.OracleStatement;
import oracle.jdbc.logging.annotations.DisableTrace;
import oracle.ucp.UniversalConnectionPool;
import oracle.ucp.UniversalPooledConnection;
import oracle.ucp.common.Clock;
import oracle.ucp.common.UniversalConnectionPoolBase;
import oracle.ucp.jdbc.proxy.LogicalObject;
import oracle.ucp.jdbc.proxy.ProxyException;
import oracle.ucp.jdbc.proxy.oracle.ConnectionProxyBase;
import oracle.ucp.jdbc.proxy.oracle.ResultSetProxy;
import oracle.ucp.logging.ClioSupport;
import oracle.ucp.proxy.annotation.GetCreator;
import oracle.ucp.proxy.annotation.GetDelegate;
import oracle.ucp.proxy.annotation.Methods;
import oracle.ucp.proxy.annotation.OnError;
import oracle.ucp.proxy.annotation.Post;
import oracle.ucp.proxy.annotation.Pre;
import oracle.ucp.proxy.annotation.ProxyFor;
import oracle.ucp.proxy.annotation.ProxyResult;
import oracle.ucp.proxy.annotation.ProxyResultPolicy;
import oracle.ucp.proxy.annotation.Signature;
import oracle.ucp.util.Chain;
import oracle.ucp.util.MapChain;
import oracle.ucp.util.UCPErrorHandler;

@DisableTrace
@ProxyFor(value={OracleCallableStatement.class, OraclePreparedStatement.class, OracleStatement.class, LogicalObject.class})
@ProxyResult(value=ProxyResultPolicy.CREATE)
public abstract class StatementProxy
implements LogicalObject {
    private final long creationTS = Clock.clock();
    private final AtomicBoolean closed = new AtomicBoolean(false);
    private static final int ORAERROR_INVALID_SHARDKEYS = 45582;
    private AtomicBoolean initialQueryTimeoutSet = new AtomicBoolean(false);
    protected Chain<ResultSetProxy> resultSetsToClose = new MapChain<ResultSetProxy>();
    private Chain.Atom<StatementProxy> statementChainAtom = null;
    private volatile boolean sqlWithQueryTimeoutInProgress = false;
    private volatile int queryTimeout = 0;
    private static final Set<String> queryMethods = new HashSet<String>();

    void setStatementChainAtom(Chain.Atom<StatementProxy> atom) {
        this.statementChainAtom = atom;
    }

    private void prepare() {
        this.getUPC().heartbeat();
        if (this.initialQueryTimeoutSet.compareAndSet(false, true)) {
            try {
                this.getDelegate().setQueryTimeout(((UniversalConnectionPoolBase)this.getUCP()).getQueryTimeout());
            }
            catch (SQLException e) {
                ClioSupport.ilogThrowing(null, null, null, null, e);
            }
        }
    }

    @GetDelegate
    protected abstract Statement getDelegate();

    @GetCreator
    protected abstract Object getCreator();

    UniversalPooledConnection getUPC() {
        return ((ConnectionProxyBase)this.getCreator()).getUPC();
    }

    UniversalConnectionPool getUCP() {
        return ((ConnectionProxyBase)this.getCreator()).getUCP();
    }

    @Override
    public boolean isLogicallyClosed() {
        this.prepare();
        return this.closed.get();
    }

    @ProxyResult(value=ProxyResultPolicy.MANUAL)
    public Connection getConnection() throws SQLException {
        this.prepare();
        if (this.isClosed()) {
            throw UCPErrorHandler.newSQLException(44);
        }
        return (Connection)this.getCreator();
    }

    public void setQueryTimeout(int queryTimeout) throws SQLException {
        this.queryTimeout = queryTimeout;
        this.prepare();
        this.getDelegate().setQueryTimeout(queryTimeout);
        this.getUPC().heartbeat();
    }

    public void closeOnCompletion() throws SQLException {
        this.prepare();
        this.getDelegate().closeOnCompletion();
        this.getUPC().heartbeat();
    }

    public boolean isClosed() throws SQLException {
        this.prepare();
        return this.closed.get() || this.getDelegate().isClosed() || ((ConnectionProxyBase)this.getCreator()).closed.get();
    }

    public void close() throws SQLException {
        this.prepare();
        if (this.closed.get()) {
            return;
        }
        for (ResultSetProxy rs : this.resultSetsToClose.toList()) {
            rs.close();
        }
        this.resultSetsToClose.clear();
        this.statementChainAtom.remove();
        this.closed.set(true);
        this.getDelegate().close();
        this.getUPC().heartbeat();
    }

    @ProxyResult(value=ProxyResultPolicy.MANUAL)
    public <T> T unwrap(Class<T> iface) throws SQLException {
        this.prepare();
        if (iface.isInterface()) {
            if (iface.isInstance(this.getDelegate())) {
                return (T)this.getDelegate();
            }
            return this.getDelegate().unwrap(iface);
        }
        throw new SQLException("unable to unwrap interface " + iface.toString());
    }

    @Pre
    @Methods(signatures={@Signature(name="creationState", args={}), @Signature(name="getACProxy", args={}), @Signature(name="getExecuteBatch", args={}), @Signature(name="getFixedString", args={}), @Signature(name="getRowPrefetch", args={}), @Signature(name="getcacheState", args={}), @Signature(name="getserverCursor", args={}), @Signature(name="getstatementType", args={}), @Signature(name="setACProxy", args={Object.class}), @Signature(name="setCheckBindTypes", args={boolean.class}), @Signature(name="setDisableStmtCaching", args={boolean.class}), @Signature(name="setFixedString", args={boolean.class}), @Signature(name="setFormOfUse", args={int.class, short.class})})
    protected void preNoThrow(Method m, Object receiver, Object ... args) {
        try {
            this.pre(m, receiver, args);
        }
        catch (SQLException e) {
            throw new ProxyException(e);
        }
    }

    private static boolean isQueryMethod(Method m) {
        return queryMethods.contains(Objects.requireNonNull(m).getName());
    }

    @Pre
    protected void pre(Method m, Object receiver, Object ... args) throws SQLException {
        ConnectionProxyBase connProxy;
        if (this.closed.get()) {
            throw UCPErrorHandler.newSQLException(44);
        }
        this.prepare();
        if (StatementProxy.isQueryMethod(m)) {
            this.sqlWithQueryTimeoutInProgress = this.queryTimeout > 0;
            this.getUPC().setSqlWithQueryTimeoutInProgress(this.sqlWithQueryTimeoutInProgress);
        }
        if (Clock.isBefore(this.creationTS, this.getUPC().getAvailableStartTime()) || Clock.isBefore(this.creationTS, this.getUPC().getBorrowedStartTime())) {
            this.closed.set(true);
            ((Connection)this.getCreator()).close();
        }
        if ((connProxy = (ConnectionProxyBase)this.getCreator()).isLogicallyClosed()) {
            throw UCPErrorHandler.newSQLException(31);
        }
    }

    @Post
    protected Object postRest(Method m, Object result) {
        this.getUPC().heartbeat();
        if (StatementProxy.isQueryMethod(m)) {
            this.sqlWithQueryTimeoutInProgress = false;
            this.getUPC().setSqlWithQueryTimeoutInProgress(false);
        }
        this.saveResultSetProxy(result);
        return result;
    }

    protected void saveResultSetProxy(Object result) {
        if (result instanceof ResultSetProxy) {
            ResultSetProxy resultSetProxy = (ResultSetProxy)result;
            resultSetProxy.setResultSetChainAtom(this.resultSetsToClose.add(resultSetProxy));
        }
    }

    @Post
    protected void postRestVoid(Method m) {
        this.getUPC().heartbeat();
    }

    @OnError(value=SQLException.class)
    protected void onErrorVoid(Method m, SQLException e) throws SQLException {
        this.onError(m, e);
    }

    @OnError(value=SQLException.class)
    protected Object onError(Method m, SQLException e) throws SQLException {
        int errNo;
        this.getUPC().heartbeat();
        ((ConnectionProxyBase)this.getCreator()).handleSQRecoverableException(e);
        if (e instanceof SQLException && (errNo = e.getErrorCode()) == 45582) {
            this.getUPC().getDelegator().onError();
        }
        throw e;
    }

    public boolean equals(Object thatObj) {
        if (null == thatObj) {
            return false;
        }
        if (this == thatObj) {
            return true;
        }
        return this.getDelegate().equals(thatObj instanceof StatementProxy ? ((StatementProxy)thatObj).getDelegate() : thatObj);
    }

    public int hashCode() {
        return this.getDelegate().hashCode();
    }

    static {
        queryMethods.add("execute");
        queryMethods.add("executeUpdate");
        queryMethods.add("executeLargeUpdate");
        queryMethods.add("executeQuery");
        queryMethods.add("executeBatch");
        queryMethods.add("executeLargeBatch");
        queryMethods.add("getGenerateKeys");
        queryMethods.add("getMoreResults");
    }
}

