/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.util;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Random;
import oracle.jdbc.logging.annotations.DisableTrace;

@DisableTrace
public class OpaqueString
implements Serializable,
AutoCloseable {
    public static final OpaqueString NULL = new OpaqueString(null);
    public static final OpaqueString EMPTY = new OpaqueString("");
    private char[] c;
    private final int superHashCode = super.hashCode();

    public static OpaqueString newOpaqueString(String s) {
        if (s == null) {
            return NULL;
        }
        if ("".equals(s)) {
            return EMPTY;
        }
        return new OpaqueString(s);
    }

    private OpaqueString(String s) {
        if (s != null) {
            this.c = new char[s.length()];
            for (int i = 0; i < s.length(); ++i) {
                this.c[i] = s.charAt(i);
            }
            this.xor();
        } else {
            this.c = null;
        }
    }

    public String get() {
        if (this.c == null) {
            return null;
        }
        Random rand = new Random(this.superHashCode + this.getClass().hashCode());
        char[] c1 = new char[this.c.length];
        for (int i = 0; i < this.c.length; ++i) {
            c1[i] = (char)(this.c[i] ^ rand.nextInt());
        }
        String str = new String(c1);
        return str;
    }

    @Override
    public void close() {
        Random rand = new Random();
        for (int i = 0; i < this.c.length; ++i) {
            this.c[i] = (char)(this.c[i] ^ (char)rand.nextInt());
        }
    }

    private void xor() {
        Random rand = new Random(this.superHashCode + this.getClass().hashCode());
        for (int i = 0; i < this.c.length; ++i) {
            this.c[i] = (char)(this.c[i] ^ rand.nextInt());
        }
    }

    public boolean isNull() {
        return this.c == null;
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        short[] sh = new short[this.c.length * 2];
        for (int i = 0; i < this.c.length; ++i) {
            sh[i] = (short)this.c[i];
        }
        Random rand = new Random(this.superHashCode + this.getClass().hashCode());
        int i = this.c.length;
        int j = 0;
        while (i < 2 * this.c.length) {
            sh[i] = (short)rand.nextInt();
            ++i;
            ++j;
        }
        oos.writeObject(sh);
    }

    private void readObject(ObjectInputStream ois) throws ClassNotFoundException, IOException {
        int i;
        short[] sh = (short[])ois.readObject();
        this.c = new char[sh.length / 2];
        char[] ui = new char[sh.length / 2];
        int l = sh.length / 2;
        for (i = 0; i < l; ++i) {
            this.c[i] = (char)sh[i];
        }
        i = l;
        int j = 0;
        while (i < 2 * l) {
            ui[j] = (char)sh[i];
            ++i;
            ++j;
        }
        for (i = 0; i < l; ++i) {
            this.c[i] = (char)(this.c[i] ^ ui[i]);
        }
        this.xor();
    }

    private void readObjectNoData() throws InvalidObjectException {
        throw new InvalidObjectException("Stream data required");
    }

    public boolean equals(Object obj) {
        OpaqueString os = (OpaqueString)obj;
        if (this == os) {
            return true;
        }
        if (this == NULL || os == NULL) {
            return false;
        }
        if (this.c.length != os.c.length) {
            return false;
        }
        Random rand = new Random(this.superHashCode + this.getClass().hashCode());
        Random rand1 = new Random(os.superHashCode + os.getClass().hashCode());
        for (int i = 0; i < this.c.length; ++i) {
            char c2;
            char c1 = (char)(this.c[i] ^ rand.nextInt());
            if (c1 == (c2 = (char)(os.c[i] ^ rand1.nextInt()))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        String str = this.get();
        int hashcode = str == null ? "".hashCode() : this.get().hashCode();
        return hashcode;
    }
}

