/*
 * Decompiled with CFR 0.152.
 */
package oracle.streams;

import oracle.sql.NUMBER;
import oracle.streams.StreamsException;

public class XStreamUtility {
    public static final int POS_VERSION_V1 = 1;
    public static final int POS_VERSION_V2 = 2;
    public static final int SCN_START_V1 = 14;
    public static final int SCN_START_V2 = 16;
    public static final int POS_LENGTH_V1 = 29;
    public static final int POS_LENGTH_V2 = 33;
    public static final int MAX_POS_LENGTH = 64;

    public static NUMBER getSCNFromPosition(byte[] byArray) throws StreamsException {
        int n = 0;
        long l = 0L;
        try {
            if (null == byArray) {
                throw new StreamsException("XStream getSCNFromPosition: invalid position.");
            }
            int n2 = byArray.length;
            byte by = byArray[byArray.length - 1];
            if (29 != n2 && 33 != n2 || 1 == by && 29 != n2 || 2 == by && 33 != n2) {
                throw new StreamsException("XStream getSCNFromPosition: invalid position. " + n2);
            }
            if (29 == n2) {
                n = 14;
                l = ((byArray[n] & 0xFF) << 40) + ((byArray[n + 1] & 0xFF) << 32) + ((byArray[n + 2] & 0xFF) << 24) + ((byArray[n + 3] & 0xFF) << 16) + ((byArray[n + 4] & 0xFF) << 8) + (byArray[n + 5] & 0xFF);
            } else if (33 == n2) {
                long l2 = 0L;
                n = 16;
                l2 = byArray[n] & 0xFF;
                l += (l2 <<= 56);
                l2 = byArray[n + 1] & 0xFF;
                l += (l2 <<= 48);
                l2 = byArray[n + 2] & 0xFF;
                l += (l2 <<= 40);
                l2 = byArray[n + 3] & 0xFF;
                l += (l2 <<= 32);
                l2 = byArray[n + 4] & 0xFF;
                l += (l2 <<= 24);
                l2 = byArray[n + 5] & 0xFF;
                l += (l2 <<= 16);
                l2 = byArray[n + 6] & 0xFF;
                l += (l2 <<= 8);
                l2 = byArray[n + 7] & 0xFF;
                l += l2;
            }
        }
        catch (Exception exception) {
            throw new StreamsException("XStream getSCNFromPosition: invalid position. ", exception);
        }
        return new NUMBER(l);
    }

    public static NUMBER getCommitSCNFromPosition(byte[] byArray) throws StreamsException {
        long l = 0L;
        try {
            if (null == byArray) {
                throw new StreamsException("XStream getCommitSCNFromPosition: invalid position.");
            }
            int n = byArray.length;
            byte by = byArray[byArray.length - 1];
            if (29 != n && 33 != n || 1 == by && 29 != n || 2 == by && 33 != n) {
                throw new StreamsException("XStream getCommitSCNFromPosition:  invalid position.");
            }
            if (29 == n) {
                l = ((byArray[0] & 0xFF) << 40) + ((byArray[1] & 0xFF) << 32) + ((byArray[2] & 0xFF) << 24) + ((byArray[3] & 0xFF) << 16) + ((byArray[4] & 0xFF) << 8) + (byArray[5] & 0xFF);
            } else if (33 == n) {
                long l2 = 0L;
                l2 = byArray[0] & 0xFF;
                l += (l2 <<= 56);
                l2 = byArray[1] & 0xFF;
                l += (l2 <<= 48);
                l2 = byArray[2] & 0xFF;
                l += (l2 <<= 40);
                l2 = byArray[3] & 0xFF;
                l += (l2 <<= 32);
                l2 = byArray[4] & 0xFF;
                l += (l2 <<= 24);
                l2 = byArray[5] & 0xFF;
                l += (l2 <<= 16);
                l2 = byArray[6] & 0xFF;
                l += (l2 <<= 8);
                l2 = byArray[7] & 0xFF;
                l += l2;
            }
        }
        catch (Exception exception) {
            throw new StreamsException("XStream getCommitSCNFromPosition:  invalid position.", exception);
        }
        return new NUMBER(l);
    }

    public static byte[] convertSCNToPosition(NUMBER nUMBER) throws StreamsException {
        long l;
        byte[] byArray = new byte[29];
        int n = 14;
        try {
            l = nUMBER.longValue();
        }
        catch (Exception exception) {
            throw new StreamsException("XStream convertSCNToPosition: invalid input SCN \n", exception);
        }
        byArray[0] = (byte)(l >> 40 & 0xFFL);
        byArray[1] = (byte)(l >> 32 & 0xFFL);
        byArray[2] = (byte)(l >> 24 & 0xFFL);
        byArray[3] = (byte)(l >> 16 & 0xFFL);
        byArray[4] = (byte)(l >> 8 & 0xFFL);
        byArray[5] = (byte)(l >> 0 & 0xFFL);
        byArray[n] = (byte)(l >> 40 & 0xFFL);
        byArray[n + 1] = (byte)(l >> 32 & 0xFFL);
        byArray[n + 2] = (byte)(l >> 24 & 0xFFL);
        byArray[n + 3] = (byte)(l >> 16 & 0xFFL);
        byArray[n + 4] = (byte)(l >> 8 & 0xFFL);
        byArray[n + 5] = (byte)(l >> 0 & 0xFFL);
        byArray[28] = 1;
        return byArray;
    }

    public static byte[] convertSCNToPosition(NUMBER nUMBER, int n) throws StreamsException {
        byte[] byArray = null;
        int n2 = 0;
        long l = 0L;
        byte by = 0;
        try {
            l = nUMBER.longValue();
            switch (n) {
                case 1: {
                    byArray = new byte[29];
                    n2 = 14;
                    by = (byte)(l >> 48 & 0xFFL);
                    by = (byte)(by + (byte)(l >> 56 & 0xFFL));
                    if (0 < by) {
                        throw new StreamsException("XStream convertSCNToPosition:  SCN doesn't fit in LCRID.");
                    }
                    byArray[0] = (byte)(l >> 40 & 0xFFL);
                    byArray[1] = (byte)(l >> 32 & 0xFFL);
                    byArray[2] = (byte)(l >> 24 & 0xFFL);
                    byArray[3] = (byte)(l >> 16 & 0xFFL);
                    byArray[4] = (byte)(l >> 8 & 0xFFL);
                    byArray[5] = (byte)(l >> 0 & 0xFFL);
                    byArray[n2] = (byte)(l >> 40 & 0xFFL);
                    byArray[n2 + 1] = (byte)(l >> 32 & 0xFFL);
                    byArray[n2 + 2] = (byte)(l >> 24 & 0xFFL);
                    byArray[n2 + 3] = (byte)(l >> 16 & 0xFFL);
                    byArray[n2 + 4] = (byte)(l >> 8 & 0xFFL);
                    byArray[n2 + 5] = (byte)(l >> 0 & 0xFFL);
                    byArray[28] = (byte)n;
                    break;
                }
                case 2: {
                    byArray = new byte[33];
                    n2 = 16;
                    byArray[0] = (byte)(l >> 56 & 0xFFL);
                    byArray[1] = (byte)(l >> 48 & 0xFFL);
                    byArray[2] = (byte)(l >> 40 & 0xFFL);
                    byArray[3] = (byte)(l >> 32 & 0xFFL);
                    byArray[4] = (byte)(l >> 24 & 0xFFL);
                    byArray[5] = (byte)(l >> 16 & 0xFFL);
                    byArray[6] = (byte)(l >> 8 & 0xFFL);
                    byArray[7] = (byte)(l >> 0 & 0xFFL);
                    byArray[n2] = (byte)(l >> 56 & 0xFFL);
                    byArray[n2 + 1] = (byte)(l >> 48 & 0xFFL);
                    byArray[n2 + 2] = (byte)(l >> 40 & 0xFFL);
                    byArray[n2 + 3] = (byte)(l >> 32 & 0xFFL);
                    byArray[n2 + 4] = (byte)(l >> 24 & 0xFFL);
                    byArray[n2 + 5] = (byte)(l >> 16 & 0xFFL);
                    byArray[n2 + 6] = (byte)(l >> 8 & 0xFFL);
                    byArray[n2 + 7] = (byte)(l >> 0 & 0xFFL);
                    byArray[32] = (byte)n;
                    break;
                }
                default: {
                    throw new StreamsException("XStream convertSCNToPosition: invalid version: " + n + "\n");
                }
            }
        }
        catch (StreamsException streamsException) {
            throw streamsException;
        }
        catch (Exception exception) {
            throw new StreamsException("XStream convertSCNToPosition: invalid input SCN.\n", exception);
        }
        return byArray;
    }
}

