/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.common;

import java.lang.reflect.Executable;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLRecoverableException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.DisableTrace;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;
import oracle.jdbc.pool.OraclePooledConnection;
import oracle.ucp.ConnectionAffinityCallback;
import oracle.ucp.ConnectionHarvestingCallback;
import oracle.ucp.ConnectionRetrievalInfo;
import oracle.ucp.UniversalConnectionPoolException;
import oracle.ucp.UniversalPooledConnection;
import oracle.ucp.UniversalPooledConnectionStatus;
import oracle.ucp.actors.InterruptableActor;
import oracle.ucp.common.AffinityContext;
import oracle.ucp.common.Clock;
import oracle.ucp.common.ConnectionSource;
import oracle.ucp.common.CoreConnection;
import oracle.ucp.common.FailoverDriver;
import oracle.ucp.common.Instantiator;
import oracle.ucp.common.LoadBalancer;
import oracle.ucp.common.ONSDriver;
import oracle.ucp.common.Selector;
import oracle.ucp.common.Selectors;
import oracle.ucp.common.ServiceMember;
import oracle.ucp.common.Topology;
import oracle.ucp.common.UniversalPooledConnectionImpl;
import oracle.ucp.jdbc.JDBCConnectionRetrievalInfo;
import oracle.ucp.jdbc.oracle.OracleJDBCConnectionRetrievalInfo;
import oracle.ucp.jdbc.oracle.OracleUniversalPooledConnection;
import oracle.ucp.logging.ClioSupport;
import oracle.ucp.routing.DataDependentRoutingCache;
import oracle.ucp.routing.RACDataAffinityRoutingCache;
import oracle.ucp.routing.ShardRoutingCache;
import oracle.ucp.util.Pair;
import oracle.ucp.util.UCPErrorHandler;

@DefaultLogger(value="oracle.ucp.common")
@Supports(value={Feature.CHECK_IN, Feature.CHECK_OUT, Feature.CONN_CONSTRUCTION, Feature.CONN_DESTRUCTION, Feature.LOAD_BALANCING, Feature.HIGH_AVAILABILITY})
public class Service {
    private static final short DB_VERSION_122 = 12200;
    private String name;
    private final Set<String> placement = Collections.newSetFromMap(new ConcurrentHashMap());
    private final Topology connectionSource;
    private final AtomicReference<ConnectionSource.FailoverCallback> failoverHandler = new AtomicReference<Object>(null);
    private final AtomicReference<ConnectionSource.RebalanceCallback> rebalanceHandler = new AtomicReference<Object>(null);
    private final FailoverDriver failoverDriver = this.prepareFailoverDriver();
    private final LoadBalancer loadBalancer = this.prepareLoadBalancer();
    private final AtomicInteger activeCount = new AtomicInteger(0);
    private final AtomicInteger borrowedCount = new AtomicInteger(0);
    private final AtomicInteger pendingCreateCount = new AtomicInteger(0);
    private final ConcurrentMap<ServiceMember.Key, ServiceMember> serviceMembers = new ConcurrentHashMap<ServiceMember.Key, ServiceMember>();
    final AtomicInteger activeMembers = new AtomicInteger(0);
    final AtomicInteger idCount = new AtomicInteger(0);
    public final LoadBalancer.Stats lbStats = new LoadBalancer.Stats();
    public final FailoverDriver.Stats fdStats = new FailoverDriver.Stats();
    final AtomicReference<ConnectionSource.RebalanceCallback.Result> pendingRebalance = new AtomicReference<ConnectionSource.RebalanceCallback.Result>(new ConnectionSource.RebalanceCallback.Result());
    final AtomicInteger pendingCloseCount = new AtomicInteger(0);
    private String containerName = null;
    final AtomicInteger lastDrainTimeout = new AtomicInteger(0);
    private volatile CountDownLatch registered = null;
    private final AtomicReference<DataDependentRoutingCache> routingCache = new AtomicReference<Object>(null);
    private final Instantiator instantiator;
    private String hostName = null;
    private AtomicReference<String[]> distributionTable = new AtomicReference<String[]>(new String[0]);
    private static Random rand;
    private final AtomicReference<Object> mostRecentONSEvent = new AtomicReference<Object>(null);
    private static final InterruptableActor<UniversalPooledConnection, String, UniversalConnectionPoolException> interruptableActor;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;
    private static Executable $$$methodRef$$$12;
    private static Logger $$$loggerRef$$$12;
    private static Executable $$$methodRef$$$13;
    private static Logger $$$loggerRef$$$13;
    private static Executable $$$methodRef$$$14;
    private static Logger $$$loggerRef$$$14;
    private static Executable $$$methodRef$$$15;
    private static Logger $$$loggerRef$$$15;
    private static Executable $$$methodRef$$$16;
    private static Logger $$$loggerRef$$$16;
    private static Executable $$$methodRef$$$17;
    private static Logger $$$loggerRef$$$17;
    private static Executable $$$methodRef$$$18;
    private static Logger $$$loggerRef$$$18;
    private static Executable $$$methodRef$$$19;
    private static Logger $$$loggerRef$$$19;
    private static Executable $$$methodRef$$$20;
    private static Logger $$$loggerRef$$$20;
    private static Executable $$$methodRef$$$21;
    private static Logger $$$loggerRef$$$21;
    private static Executable $$$methodRef$$$22;
    private static Logger $$$loggerRef$$$22;
    private static Executable $$$methodRef$$$23;
    private static Logger $$$loggerRef$$$23;
    private static Executable $$$methodRef$$$24;
    private static Logger $$$loggerRef$$$24;
    private static Executable $$$methodRef$$$25;
    private static Logger $$$loggerRef$$$25;
    private static Executable $$$methodRef$$$26;
    private static Logger $$$loggerRef$$$26;
    private static Executable $$$methodRef$$$27;
    private static Logger $$$loggerRef$$$27;
    private static Executable $$$methodRef$$$28;
    private static Logger $$$loggerRef$$$28;
    private static Executable $$$methodRef$$$29;
    private static Logger $$$loggerRef$$$29;
    private static Executable $$$methodRef$$$30;
    private static Logger $$$loggerRef$$$30;
    private static Executable $$$methodRef$$$31;
    private static Logger $$$loggerRef$$$31;
    private static Executable $$$methodRef$$$32;
    private static Logger $$$loggerRef$$$32;
    private static Executable $$$methodRef$$$33;
    private static Logger $$$loggerRef$$$33;
    private static Executable $$$methodRef$$$34;
    private static Logger $$$loggerRef$$$34;
    private static Executable $$$methodRef$$$35;
    private static Logger $$$loggerRef$$$35;
    private static Executable $$$methodRef$$$36;
    private static Logger $$$loggerRef$$$36;
    private static Executable $$$methodRef$$$37;
    private static Logger $$$loggerRef$$$37;
    private static Executable $$$methodRef$$$38;
    private static Logger $$$loggerRef$$$38;
    private static Executable $$$methodRef$$$39;
    private static Logger $$$loggerRef$$$39;
    private static Executable $$$methodRef$$$40;
    private static Logger $$$loggerRef$$$40;
    private static Executable $$$methodRef$$$41;
    private static Logger $$$loggerRef$$$41;
    private static Executable $$$methodRef$$$42;
    private static Logger $$$loggerRef$$$42;
    private static Executable $$$methodRef$$$43;
    private static Logger $$$loggerRef$$$43;
    private static Executable $$$methodRef$$$44;
    private static Logger $$$loggerRef$$$44;
    private static Executable $$$methodRef$$$45;
    private static Logger $$$loggerRef$$$45;
    private static Executable $$$methodRef$$$46;
    private static Logger $$$loggerRef$$$46;
    private static Executable $$$methodRef$$$47;
    private static Logger $$$loggerRef$$$47;
    private static Executable $$$methodRef$$$48;
    private static Logger $$$loggerRef$$$48;
    private static Executable $$$methodRef$$$49;
    private static Logger $$$loggerRef$$$49;
    private static Executable $$$methodRef$$$50;
    private static Logger $$$loggerRef$$$50;
    private static Executable $$$methodRef$$$51;
    private static Logger $$$loggerRef$$$51;
    private static Executable $$$methodRef$$$52;
    private static Logger $$$loggerRef$$$52;
    private static Executable $$$methodRef$$$53;
    private static Logger $$$loggerRef$$$53;
    private static Executable $$$methodRef$$$54;
    private static Logger $$$loggerRef$$$54;
    private static Executable $$$methodRef$$$55;
    private static Logger $$$loggerRef$$$55;
    private static Executable $$$methodRef$$$56;
    private static Logger $$$loggerRef$$$56;
    private static Executable $$$methodRef$$$57;
    private static Logger $$$loggerRef$$$57;
    private static Executable $$$methodRef$$$58;
    private static Logger $$$loggerRef$$$58;
    private static Executable $$$methodRef$$$59;
    private static Logger $$$loggerRef$$$59;
    private static Executable $$$methodRef$$$60;
    private static Logger $$$loggerRef$$$60;

    Service(Instantiator instantiator, Topology connectionSource, String name) {
        this.instantiator = instantiator;
        this.connectionSource = connectionSource;
        this.name = name;
    }

    private void onRegister() {
        if (this.registered != null) {
            this.registered.countDown();
        }
    }

    private void awaitRegister() {
        try {
            if (this.registered == null) {
                return;
            }
            this.registered.await();
        }
        catch (InterruptedException e) {
            ClioSupport.ilogThrowing(null, null, null, null, e);
        }
    }

    private void checkAndRegister() {
        if (this.registered == null) {
            this.registered = new CountDownLatch(1);
        }
    }

    public int activeMembersCount() {
        return this.activeMembers.get();
    }

    public void setName(String name) {
        this.name = name;
    }

    String containerName() {
        return this.containerName;
    }

    void setContainerName(String containerName) {
        this.containerName = containerName;
    }

    public ServiceMember insertMember(ServiceMember memberToInsert) {
        String h;
        if (this.name == null) {
            this.name = memberToInsert.service();
        }
        if (null == this.hostName) {
            this.hostName = memberToInsert.host();
        }
        String host = null == (h = memberToInsert.host()) || "".equals(h) ? this.hostName : h;
        ServiceMember inst = this.getMember(memberToInsert.name(), memberToInsert.database(), memberToInsert.service());
        if (null != inst) {
            if (!inst.host().equals("")) {
                return inst;
            }
            if (!memberToInsert.host().equals("")) {
                this.serviceMembers.remove(inst.key());
                this.serviceMembers.putIfAbsent(memberToInsert.key(), memberToInsert);
                return memberToInsert;
            }
            return inst;
        }
        if (null == this.serviceMembers.putIfAbsent(memberToInsert.key(), memberToInsert)) {
            memberToInsert.initId();
            this.activeMembers.incrementAndGet();
        }
        return memberToInsert;
    }

    public ServiceMember getMember(String instName, String dbName, String hostName, String serviceName) {
        return (ServiceMember)this.serviceMembers.get(new ServiceMember.Key(instName, dbName, hostName, serviceName));
    }

    public ServiceMember getMember(String instName, String dbName, String serviceName) {
        for (ServiceMember inst : this.getAllMembers()) {
            if (!inst.name().equals(instName) || !inst.database().equals(dbName) || !inst.service().equals(serviceName)) continue;
            return inst;
        }
        return null;
    }

    public Collection<ServiceMember> getAllMembers() {
        return this.serviceMembers.values();
    }

    public Collection<ServiceMember> getAllMembers(ConnectionRetrievalInfo cri) {
        return this.getAllMembers(cri, false);
    }

    public Collection<ServiceMember> getAllMembers(ConnectionRetrievalInfo cri, boolean checkRoomToGrow) {
        if (!this.connectionSource().isDataDependentRoutingEnabled() || cri == null || this.routingCache() == null) {
            return this.getAllMembers();
        }
        if (checkRoomToGrow) {
            return this.routingCache().instancesToGrow(cri);
        }
        return this.routingCache().allInstances(cri);
    }

    public void markup(FailoverDriver.Event event) {
        FailoverDriver.Event.Status status = event.status();
        String instname = event.instance();
        String hostname = event.host();
        String service = event.serviceName();
        String database = event.database();
        FailoverDriver.Event.EventType eventType = event.event_type();
        ClioSupport.ilogFinest(null, null, null, null, "FF markup:" + " event=" + event.toString());
        if ((FailoverDriver.Event.EventType.INSTANCE == eventType || FailoverDriver.Event.EventType.SERVICEMEMBER == eventType) && null != instname) {
            this.insertMember(new ServiceMember(instname, database, hostname, service, this));
        }
        for (ServiceMember instance : this.serviceMembers.values()) {
            instance.clearRLBHistory();
            if ((FailoverDriver.Event.EventType.INSTANCE == eventType || FailoverDriver.Event.EventType.SERVICEMEMBER == eventType) && instname.equals(instance.name()) && database.equals(instance.database()) && service.equals(instance.service())) {
                instance.markActive(FailoverDriver.Event.Status.UP == status);
                continue;
            }
            if (FailoverDriver.Event.EventType.SERVICE == eventType && database.equals(instance.database()) && service.equals(instance.service())) {
                instance.markActive(FailoverDriver.Event.Status.UP == status);
                continue;
            }
            if (FailoverDriver.Event.EventType.NODE != eventType || !hostname.equals(instance.host())) continue;
            instance.markActive(FailoverDriver.Event.Status.UP == status);
        }
    }

    public void markup(LoadBalancer.Event event) {
        ClioSupport.ilogFinest(null, null, null, null, "load balancer markup:" + " event=" + event.toString());
        for (String instname : event.instances()) {
            if (null == instname) {
                ClioSupport.ilogWarning(null, null, null, null, "instaname is null, skipping");
                continue;
            }
            ServiceMember instance = this.insertMember(new ServiceMember(instname, event.database(), event.host(), event.service(), this));
            instance.markAffined(event.affinity(instname));
            ClioSupport.ilogFinest(null, null, null, null, " instance " + instance.toString() + " marked as affined");
            LoadBalancer.Event.Flag flag = event.flag(instname);
            instance.markActive(LoadBalancer.Event.Flag.NO_DATA != flag && LoadBalancer.Event.Flag.BLOCKED != flag);
            instance.markViolating(LoadBalancer.Event.Flag.VIOLATING == flag);
        }
    }

    public int activeCount() {
        return this.activeCount.get();
    }

    public int borrowedCount() {
        return this.borrowedCount.get();
    }

    private static int gcd(Integer ... n) {
        switch (n.length) {
            case 0: {
                return 1;
            }
            case 1: {
                return n[0];
            }
            case 2: {
                return 0 == n[1] ? n[0] : Service.gcd(n[1], n[0] % n[1]);
            }
        }
        Integer[] rest = new Integer[n.length - 1];
        rest[0] = Service.gcd(n[0], n[1]);
        System.arraycopy(n, 2, rest, 1, rest.length - 1);
        return Service.gcd(rest);
    }

    void buildDistributionTable() {
        ArrayList<String> listNames = new ArrayList<String>();
        ArrayList<Integer> listConns = new ArrayList<Integer>();
        for (ServiceMember inst : this.getAllMembers()) {
            int count = inst.activeCount.get();
            if (count <= 0) continue;
            listConns.add(count);
            listNames.add(inst.name());
        }
        Integer[] conns = listConns.toArray(new Integer[0]);
        String[] names = listNames.toArray(new String[0]);
        int gcd = Service.gcd(conns);
        ArrayList<String> dt = new ArrayList<String>();
        for (int i = 0; i < conns.length; ++i) {
            dt.addAll(Collections.nCopies(conns[i] / gcd, names[i]));
        }
        this.distributionTable.set(dt.toArray(new String[0]));
    }

    Selector proportionalDistributionSelector() {
        return new Selector(){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;

            @Override
            public boolean selected(CoreConnection conn) {
                String[] dt = (String[])Service.this.distributionTable.get();
                return 0 == dt.length ? true : conn.serviceMember().name().equals(dt[rand.nextInt(dt.length)]);
            }

            static {
                try {
                    $$$methodRef$$$1 = 1.class.getDeclaredConstructor(Service.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$0 = 1.class.getDeclaredMethod("selected", CoreConnection.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            }
        };
    }

    public Topology connectionSource() {
        return this.connectionSource;
    }

    DataDependentRoutingCache routingCache() {
        if (this.routingCache.get() != null) {
            return this.routingCache.get();
        }
        this.routingCache.compareAndSet(null, this.prepareRoutingCache());
        return this.routingCache.get();
    }

    public String name() {
        return this.name;
    }

    public CoreConnection create(ConnectionRetrievalInfo cri, ConnectionAffinityCallback affinityCallback, EnumSet<ConnectionSource.CreateMode> createModes, long timeToRetry) throws UniversalConnectionPoolException {
        long POLL_INTERVAL = 100L;
        long giveUp = Clock.clock() + Math.max(0L, timeToRetry);
        UniversalConnectionPoolException ucpEx = null;
        do {
            this.pendingCreateCount.incrementAndGet();
            try {
                if (this.activeCount.get() + this.pendingCreateCount.get() > this.connectionSource().limits().getMaxPerService()) {
                    ClioSupport.ilogFinest(null, null, null, null, "Cannot create new connections, max connections per service limit reached");
                    CoreConnection coreConnection = null;
                    return coreConnection;
                }
                CoreConnection conn = this.create(cri, affinityCallback, createModes);
                if (null != conn) {
                    ClioSupport.ilogFinest(null, null, null, null, conn + " created");
                    CoreConnection coreConnection = conn;
                    return coreConnection;
                }
            }
            catch (UniversalConnectionPoolException e) {
                ClioSupport.ilogThrowing(null, null, null, null, e);
                ucpEx = e;
                if (e.getCause() instanceof SQLRecoverableException || Service.isUnableToCreateConnection(e)) {
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    if (!Service.isUnableToCreateConnection(e)) continue;
                    createModes = EnumSet.noneOf(ConnectionSource.CreateMode.class);
                    ClioSupport.ilogFinest(null, null, null, null, " unable to connect to specific instance, setting createModes = EnumSet.noneOf(CreateMode.class)");
                    continue;
                }
                throw e;
            }
            finally {
                this.pendingCreateCount.decrementAndGet();
            }
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        } while (Clock.clock() <= giveUp);
        if (ucpEx != null) {
            throw ucpEx;
        }
        ClioSupport.ilogFinest(null, null, null, null, "gave up to create a connection");
        return null;
    }

    private static boolean isUnableToCreateConnection(UniversalConnectionPoolException e) {
        return e.getErrorCode() == 45067;
    }

    private UniversalPooledConnection createConnectionInterruptably(final ConnectionRetrievalInfo cri) throws UniversalConnectionPoolException {
        return interruptableActor.doAction(new InterruptableActor.Action<UniversalPooledConnection, String, UniversalConnectionPoolException>(){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;
            private static Executable $$$methodRef$$$3;
            private static Logger $$$loggerRef$$$3;
            private static Executable $$$methodRef$$$4;
            private static Logger $$$loggerRef$$$4;

            @Override
            public UniversalPooledConnection exec() throws UniversalConnectionPoolException {
                return Service.this.connectionSource().createPooledConnection(cri);
            }

            @Override
            public String getDescriptor() {
                return ((OracleJDBCConnectionRetrievalInfo)cri).getInstanceName();
            }

            static {
                try {
                    $$$methodRef$$$4 = 2.class.getDeclaredConstructor(Service.class, ConnectionRetrievalInfo.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$3 = 2.class.getDeclaredMethod("exec", new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$2 = 2.class.getDeclaredMethod("getDescriptor", new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$1 = 2.class.getDeclaredMethod("getDescriptor", new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$0 = 2.class.getDeclaredMethod("exec", new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            }
        });
    }

    void interruptPendingCreations() {
        Map<String, ServiceMember> memberMap = this.getAllMembers().stream().collect(Collectors.toMap(ServiceMember::name, p -> p));
        ClioSupport.ilogFinest(null, null, null, null, "memberMap: " + memberMap.toString());
        interruptableActor.registerPredicate(p -> {
            String instName = (String)((InterruptableActor.Action)p.get1st()).getDescriptor();
            if (null == instName) {
                return false;
            }
            ServiceMember sm = (ServiceMember)memberMap.get(instName);
            return null == sm ? false : !sm.active();
        });
        interruptableActor.triggerInterrupts();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CoreConnection create(final ConnectionRetrievalInfo cri, ConnectionAffinityCallback affinityCallback, EnumSet<ConnectionSource.CreateMode> createModes) throws UniversalConnectionPoolException {
        UniversalPooledConnection upc;
        Object context;
        Set<Object> possibleInstances;
        final ServiceMember[] bestInstance = new ServiceMember[]{null};
        boolean isRoutingEnabled = this.connectionSource().isDataDependentRoutingEnabled();
        if (isRoutingEnabled && !this.routingCache().hasInstanceToGrow(cri)) {
            return null;
        }
        Set<Object> set = possibleInstances = isRoutingEnabled ? this.routingCache().instancesToGrow(cri) : new HashSet();
        if (isRoutingEnabled && possibleInstances.size() == 0) {
            createModes = EnumSet.noneOf(ConnectionSource.CreateMode.class);
        }
        if (createModes.contains((Object)ConnectionSource.CreateMode.USE_BEST_INSTANCE) && null != affinityCallback && null != (context = affinityCallback.getConnectionAffinityContext()) && context instanceof AffinityContext) {
            AffinityContext affinityContext = (AffinityContext)context;
            String affInstName = affinityContext.getInstanceName();
            if (null != affInstName) {
                int upperLimit;
                Object event = this.mostRecentONSEvent.get();
                if (null == event || event instanceof FailoverDriver.Event) {
                    upperLimit = this.connectionSource().limits().getMax();
                } else if (event instanceof LoadBalancer.Event) {
                    int max = this.connectionSource().limits().getMax();
                    if (max < Integer.MAX_VALUE) {
                        switch (affinityCallback.getAffinityPolicy()) {
                            case WEBSESSION_BASED_AFFINITY: 
                            case DATA_BASED_AFFINITY: {
                                LoadBalancer.Event lbEvent = (LoadBalancer.Event)event;
                                upperLimit = (int)((float)max * lbEvent.normalizedPercent(affInstName) / 100.0f);
                                break;
                            }
                            case TRANSACTION_BASED_AFFINITY: {
                                upperLimit = max;
                                break;
                            }
                            default: {
                                ClioSupport.ilogWarning(null, null, null, null, "unknown affinity policy");
                                upperLimit = max;
                                break;
                            }
                        }
                    } else {
                        upperLimit = Integer.MAX_VALUE;
                    }
                } else {
                    throw new IllegalStateException("wrong ONS event object");
                }
                ServiceMember inst = this.getMember(affInstName, affinityContext.getDatabaseUniqueName(), affinityContext.getServiceName());
                if (null != inst && inst.activeCount.get() < upperLimit) {
                    if (!possibleInstances.stream().anyMatch(k -> k.name().equals(affInstName))) {
                        this.lbStats.onFailedAffBorrowed();
                        inst.lbStats.onFailedAffBorrowed();
                        affinityCallback.setConnectionAffinityContext(null);
                    } else {
                        bestInstance[0] = inst;
                        this.lbStats.onSuccessfulAffBorrowed();
                        inst.lbStats.onSuccessfulAffBorrowed();
                    }
                } else {
                    this.lbStats.onFailedAffBorrowed();
                    inst.lbStats.onFailedAffBorrowed();
                    affinityCallback.setConnectionAffinityContext(null);
                }
            } else {
                affinityCallback.setConnectionAffinityContext(null);
                throw new IllegalStateException("wrong affinity context (missing instance name)");
            }
        }
        if (createModes.contains((Object)ConnectionSource.CreateMode.USE_BEST_INSTANCE) && null == bestInstance[0]) {
            bestInstance[0] = this.underloadedInstance(cri);
        }
        try {
            if (bestInstance[0] == null && isRoutingEnabled) {
                bestInstance[0] = this.routingCache().getBestInstanceToGrow(cri);
                if (bestInstance[0] != null) {
                    this.routingCache().onConnectionRequest(bestInstance[0]);
                }
            }
            String targetInst = bestInstance[0] != null ? bestInstance[0].name() : null;
            ClioSupport.ilogFinest(null, null, null, null, "targetInst=" + targetInst);
            ClioSupport.ilogFinest(null, null, null, null, "instances=" + this.serviceMembers.values().toString());
            ConnectionRetrievalInfo targetCri = cri instanceof JDBCConnectionRetrievalInfo ? new OracleJDBCConnectionRetrievalInfo((JDBCConnectionRetrievalInfo)cri, targetInst) : cri;
            ClioSupport.ilogFinest(null, null, null, null, "about to make an attempt to create a connection");
            UniversalPooledConnection lupc = null;
            try {
                lupc = this.createConnectionInterruptably(targetCri);
            }
            catch (UniversalConnectionPoolException e) {
                ClioSupport.ilogThrowing(null, null, null, null, e);
                Throwable cause = e.getCause();
                if (null == cause) {
                    throw e;
                }
                int errorCode = ((SQLException)cause).getErrorCode();
                ClioSupport.ilogFinest(null, null, null, null, "errorCode=" + errorCode);
                if (cause instanceof SQLException && 12521 == errorCode) {
                    ClioSupport.ilogFinest(null, null, null, null, "caught ORA-12521, TNS:listener does not currently know of instance requested in connect descriptor");
                    UCPErrorHandler.throwUniversalConnectionPoolException(67);
                } else {
                    ClioSupport.ilogFinest(null, null, null, null, "caught e.getCause.getErrorCode()= " + ((SQLException)cause).getErrorCode());
                }
                throw e;
            }
            upc = lupc;
        }
        finally {
            if (isRoutingEnabled && bestInstance[0] != null) {
                this.routingCache().onConnectionRequestComplete(bestInstance[0]);
            }
        }
        if (null == upc) {
            ClioSupport.ilogFine(null, null, null, null, "unable to create a connection");
            return null;
        }
        this.checkAndRegister();
        Instantiator instantiator = this.instantiator;
        instantiator.getClass();
        upc.plugDelegator(new Instantiator.Connection(instantiator){
            private final Object physicalConn = this.getPhysicalConnection();
            private final Properties props = Service.access$200(Service.this, this);
            private String onsConfig = Service.this.connectionSource().getONSConfig();
            private ServiceMember serviceMember = new ServiceMember(this.props, Service.this);
            private boolean replayable = false;
            private String connContainerName = this.fetchContainerName();
            private AtomicBoolean pendingClose;
            private final Semaphore acSemaphore;
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;
            private static Executable $$$methodRef$$$3;
            private static Logger $$$loggerRef$$$3;
            private static Executable $$$methodRef$$$4;
            private static Logger $$$loggerRef$$$4;
            private static Executable $$$methodRef$$$5;
            private static Logger $$$loggerRef$$$5;
            private static Executable $$$methodRef$$$6;
            private static Logger $$$loggerRef$$$6;
            private static Executable $$$methodRef$$$7;
            private static Logger $$$loggerRef$$$7;
            private static Executable $$$methodRef$$$8;
            private static Logger $$$loggerRef$$$8;
            private static Executable $$$methodRef$$$9;
            private static Logger $$$loggerRef$$$9;
            private static Executable $$$methodRef$$$10;
            private static Logger $$$loggerRef$$$10;
            private static Executable $$$methodRef$$$11;
            private static Logger $$$loggerRef$$$11;
            private static Executable $$$methodRef$$$12;
            private static Logger $$$loggerRef$$$12;
            private static Executable $$$methodRef$$$13;
            private static Logger $$$loggerRef$$$13;
            private static Executable $$$methodRef$$$14;
            private static Logger $$$loggerRef$$$14;
            private static Executable $$$methodRef$$$15;
            private static Logger $$$loggerRef$$$15;
            private static Executable $$$methodRef$$$16;
            private static Logger $$$loggerRef$$$16;
            private static Executable $$$methodRef$$$17;
            private static Logger $$$loggerRef$$$17;
            private static Executable $$$methodRef$$$18;
            private static Logger $$$loggerRef$$$18;
            private static Executable $$$methodRef$$$19;
            private static Logger $$$loggerRef$$$19;
            private static Executable $$$methodRef$$$20;
            private static Logger $$$loggerRef$$$20;
            private static Executable $$$methodRef$$$21;
            private static Logger $$$loggerRef$$$21;
            private static Executable $$$methodRef$$$22;
            private static Logger $$$loggerRef$$$22;
            private static Executable $$$methodRef$$$23;
            private static Logger $$$loggerRef$$$23;
            private static Executable $$$methodRef$$$24;
            private static Logger $$$loggerRef$$$24;
            private static Executable $$$methodRef$$$25;
            private static Logger $$$loggerRef$$$25;
            private static Executable $$$methodRef$$$26;
            private static Logger $$$loggerRef$$$26;
            private static Executable $$$methodRef$$$27;
            private static Logger $$$loggerRef$$$27;
            private static Executable $$$methodRef$$$28;
            private static Logger $$$loggerRef$$$28;
            private static Executable $$$methodRef$$$29;
            private static Logger $$$loggerRef$$$29;
            private static Executable $$$methodRef$$$30;
            private static Logger $$$loggerRef$$$30;
            private static Executable $$$methodRef$$$31;
            private static Logger $$$loggerRef$$$31;
            private static Executable $$$methodRef$$$32;
            private static Logger $$$loggerRef$$$32;
            private static Executable $$$methodRef$$$33;
            private static Logger $$$loggerRef$$$33;
            private static Executable $$$methodRef$$$34;
            private static Logger $$$loggerRef$$$34;
            private static Executable $$$methodRef$$$35;
            private static Logger $$$loggerRef$$$35;
            private static Executable $$$methodRef$$$36;
            private static Logger $$$loggerRef$$$36;
            private static Executable $$$methodRef$$$37;
            private static Logger $$$loggerRef$$$37;
            {
                ONSDriver onsDrvr;
                Service.this.setName(this.serviceMember.service());
                Service.this.setContainerName(this.connContainerName);
                Service.this.placement.addAll(this.fetchServicePlacement());
                if (null != bestInstance[0] && !this.serviceMember.name().equals(bestInstance[0].name())) {
                    ClioSupport.ilogFinest(null, null, null, null, "per-instance connections distribution has changed and the " + this.serviceMember.name() + "is now the best instance");
                }
                if (null == this.onsConfig || "".equals(this.onsConfig)) {
                    this.onsConfig = this.props.getProperty("AUTH_ONS_CONFIG");
                }
                if (Service.this.connectionSource().failoverEnabled() && (onsDrvr = Service.this.connectionSource().onsDriver(this.onsConfig)) != null) {
                    Service.this.failoverDriver.start(onsDrvr);
                    String service = this.serviceMember.service();
                    if (null != service) {
                        Service.this.loadBalancer.start(onsDrvr, service);
                    }
                }
                this.serviceMember = Service.this.insertMember(this.serviceMember);
                this.serviceMember.activeCount.incrementAndGet();
                this.serviceMember.serviceRef.lbStats.onOpened();
                this.serviceMember.lbStats.onOpened();
                Service.this.connectionSource().totalCount().incrementAndGet();
                this.serviceMember.serviceRef.activeCount.incrementAndGet();
                Service.this.connectionSource().totalCount(upc.getConnectionRetrievalInfo()).incrementAndGet();
                if (Service.this.connectionSource().isDataDependentRoutingEnabled()) {
                    onsDrvr = Service.this.connectionSource().onsDriver(this.onsConfig);
                    Service.this.routingCache().startEventHandler(onsDrvr);
                    Service.this.routingCache().onConnectionCreation((Connection)this.physicalConn, cri);
                }
                Service.this.onRegister();
                this.pendingClose = new AtomicBoolean(false);
                this.acSemaphore = new Semaphore(1);
            }

            @Override
            public ServiceMember serviceMember() {
                if (null == this.serviceMember || null == this.serviceMember.name()) {
                    throw new IllegalStateException();
                }
                return this.serviceMember;
            }

            @Override
            public Object getDelegate() {
                return upc;
            }

            @Override
            public long lastAccessedTime() {
                return upc.getLastAccessedTime();
            }

            @Override
            public boolean reusable() {
                return upc.isReusable();
            }

            @Override
            public boolean valid() {
                return upc.isValid();
            }

            @Override
            public boolean closed() {
                return UniversalPooledConnectionStatus.STATUS_CLOSED.equals(upc.getStatus());
            }

            @Override
            public boolean normal() {
                return UniversalPooledConnectionStatus.STATUS_NORMAL.equals(upc.getStatus());
            }

            @Override
            public boolean bad() {
                return UniversalPooledConnectionStatus.STATUS_BAD.equals(upc.getStatus());
            }

            @Override
            public boolean markedToReplace() {
                return UniversalPooledConnectionStatus.STATUS_REPLACE_ON_RETURN.equals(upc.getStatus());
            }

            @Override
            public void markToReplace() {
                try {
                    upc.setStatus(UniversalPooledConnectionStatus.STATUS_REPLACE_ON_RETURN);
                }
                catch (UniversalConnectionPoolException e) {
                    ClioSupport.ilogThrowing(null, null, null, null, e);
                }
                if (this.pendingClose.compareAndSet(false, true)) {
                    this.serviceMember.pendingCloseCount.incrementAndGet();
                    this.serviceMember.serviceRef.pendingCloseCount.incrementAndGet();
                }
            }

            @Override
            public boolean markedCloseOnReturn() {
                return UniversalPooledConnectionStatus.STATUS_CLOSE_ON_RETURN.equals(upc.getStatus());
            }

            @Override
            public void markCloseOnReturn() {
                try {
                    upc.setStatus(UniversalPooledConnectionStatus.STATUS_CLOSE_ON_RETURN);
                }
                catch (UniversalConnectionPoolException e) {
                    ClioSupport.ilogThrowing(null, null, null, null, e);
                }
                if (this.pendingClose.compareAndSet(false, true)) {
                    this.serviceMember.pendingCloseCount.incrementAndGet();
                    this.serviceMember.serviceRef.pendingCloseCount.incrementAndGet();
                }
            }

            @Override
            public void cleanupToHarvest() {
                try {
                    ConnectionHarvestingCallback callback = upc.getConnectionHarvestingCallback();
                    if (callback != null) {
                        callback.cleanup();
                    }
                }
                catch (UniversalConnectionPoolException e) {
                    ClioSupport.ilogThrowing(null, null, null, null, e);
                }
            }

            @Override
            public ConnectionRetrievalInfo cri() {
                return upc.getConnectionRetrievalInfo();
            }

            @Override
            public void abort() {
                upc.abort();
                this.serviceMember.serviceRef.lbStats.onAborted();
                this.serviceMember.lbStats.onAborted();
            }

            @Override
            public void handleTimeout() {
                upc.handleTimeout();
            }

            @Override
            public void close() {
                boolean reconnecting;
                block7: {
                    UniversalPooledConnectionStatus current;
                    do {
                        if (UniversalPooledConnectionStatus.STATUS_CLOSED.equals(current = ((UniversalPooledConnectionImpl)upc).m_status.get()) && ((UniversalPooledConnectionImpl)upc).m_status.compareAndSet(current, UniversalPooledConnectionStatus.STATUS_CLOSED)) {
                            return;
                        }
                        if (!UniversalPooledConnectionStatus.STATUS_RECONNECTING.equals(current) || !((UniversalPooledConnectionImpl)upc).m_status.compareAndSet(current, UniversalPooledConnectionStatus.STATUS_RECONNECTING)) continue;
                        reconnecting = true;
                        break block7;
                    } while (!((UniversalPooledConnectionImpl)upc).m_status.compareAndSet(current, UniversalPooledConnectionStatus.STATUS_CLOSED));
                    reconnecting = false;
                }
                if (!this.available()) {
                    long delta = Clock.clock() - upc.getBorrowedStartTime();
                    this.serviceMember.serviceRef.lbStats.onReturned(delta);
                    this.serviceMember.lbStats.onReturned(delta);
                    this.serviceMember.borrowedCount.decrementAndGet();
                    this.serviceMember.serviceRef.borrowedCount.decrementAndGet();
                    if (!reconnecting) {
                        Service.this.connectionSource().borrowedCount().decrementAndGet();
                        Service.this.connectionSource().borrowedCount(upc.getConnectionRetrievalInfo()).decrementAndGet();
                    }
                    Service.this.connectionSource().cumulativeConnectionUseTime().addAndGet(delta);
                }
                Service.this.connectionSource().connectionsClosed().incrementAndGet();
                this.serviceMember.activeCount.decrementAndGet();
                this.serviceMember.serviceRef.activeCount.decrementAndGet();
                this.serviceMember.serviceRef.lbStats.onClosed();
                this.serviceMember.lbStats.onClosed();
                if (Service.this.connectionSource().isDataDependentRoutingEnabled()) {
                    Service.this.routingCache().onConnectionClosure((Connection)this.physicalConn);
                }
                if (!reconnecting) {
                    Service.this.connectionSource().totalCount().decrementAndGet();
                    Service.this.connectionSource().totalCount(upc.getConnectionRetrievalInfo()).decrementAndGet();
                }
                if (this.pendingClose.compareAndSet(true, false)) {
                    this.serviceMember.pendingCloseCount.decrementAndGet();
                    this.serviceMember.serviceRef.pendingCloseCount.decrementAndGet();
                }
                ((UniversalPooledConnectionImpl)upc).closeNoStatsUpdate();
            }

            @Override
            public boolean available() {
                return upc.isAvailable();
            }

            @Override
            public void makeAvailable() {
                upc.heartbeat();
                upc.setAvailableStartTime();
                try {
                    upc.removeConnectionHarvestingCallback();
                }
                catch (UniversalConnectionPoolException e) {
                    ClioSupport.ilogThrowing(null, null, null, null, e);
                }
                if (upc.setAvailable()) {
                    long delta = Clock.clock() - upc.getBorrowedStartTime();
                    this.serviceMember.serviceRef.lbStats.onReturned(delta);
                    this.serviceMember.lbStats.onReturned(delta);
                    this.serviceMember.borrowedCount.decrementAndGet();
                    Service.this.connectionSource().borrowedCount().decrementAndGet();
                    this.serviceMember.serviceRef.borrowedCount.decrementAndGet();
                    Service.this.connectionSource().cumulativeConnectionUseTime().addAndGet(delta);
                    Service.this.connectionSource().borrowedCount(upc.getConnectionRetrievalInfo()).decrementAndGet();
                }
            }

            @Override
            public void makeUnavailable() {
                upc.heartbeat();
                upc.setBorrowedStartTime();
                if (upc.setBorrowed()) {
                    this.serviceMember.lbStats.onBorrowed(this.serviceMember.borrowedCount.incrementAndGet());
                    this.serviceMember.serviceRef.lbStats.onBorrowed(Service.this.connectionSource().borrowedCount().incrementAndGet());
                    this.serviceMember.serviceRef.borrowedCount.incrementAndGet();
                    Service.this.connectionSource().borrowedCount(upc.getConnectionRetrievalInfo()).incrementAndGet();
                }
            }

            @Override
            public int labelingCost(Properties reqLabels) {
                return upc.labelingCost(reqLabels);
            }

            @Override
            public void onBorrow(ConnectionRetrievalInfo cri2) throws UniversalConnectionPoolException {
                try {
                    if (Service.this.connectionSource().isDataDependentRoutingEnabled()) {
                        Service.this.routingCache().onConnectionBorrow((Connection)this.physicalConn, cri2);
                    }
                    if (Service.this.connectionSource().isMultitenantDatabase() && upc instanceof OracleUniversalPooledConnection) {
                        ((OracleUniversalPooledConnection)upc).initPdbSession(cri2);
                    }
                    this.openProxySession(cri2);
                }
                catch (SQLException e) {
                    throw new UniversalConnectionPoolException(e.getMessage(), e);
                }
            }

            @Override
            public void onReturn() throws UniversalConnectionPoolException {
                try {
                    this.closeProxySession();
                }
                catch (SQLException e) {
                    throw new UniversalConnectionPoolException(e.getMessage(), e);
                }
            }

            @Override
            public boolean reconnecting() {
                return UniversalPooledConnectionStatus.STATUS_RECONNECTING.equals(upc.getStatus());
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void markReconnecting() {
                block11: {
                    if (this.normal()) {
                        String origInst = this.serviceMember().name();
                        try {
                            this.acSemaphore.acquire();
                            if (origInst == null || !origInst.equals(this.serviceMember().name())) break block11;
                            try {
                                upc.setStatus(UniversalPooledConnectionStatus.STATUS_RECONNECTING);
                            }
                            catch (UniversalConnectionPoolException e) {
                                ClioSupport.ilogThrowing(null, null, null, null, e);
                            }
                            finally {
                                this.abort();
                                this.close();
                            }
                        }
                        catch (InterruptedException e) {
                            ClioSupport.ilogThrowing(null, null, null, null, e);
                        }
                        finally {
                            this.acSemaphore.release();
                        }
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void reinitialize() {
                try {
                    this.acSemaphore.acquire();
                    ServiceMember oldInst = this.serviceMember();
                    Properties props = Service.this.getProperties(this);
                    this.serviceMember = new ServiceMember(props, Service.this);
                    this.serviceMember = Service.this.insertMember(this.serviceMember);
                    this.serviceMember.activeCount.incrementAndGet();
                    this.serviceMember.lbStats.onOpened();
                    this.serviceMember.serviceRef.lbStats.onOpened();
                    oldInst.activeCount.decrementAndGet();
                    oldInst.lbStats.onClosed();
                    oldInst.serviceRef.lbStats.onClosed();
                    try {
                        upc.setStatus(UniversalPooledConnectionStatus.STATUS_NORMAL);
                    }
                    catch (UniversalConnectionPoolException e) {
                        ClioSupport.ilogThrowing(null, null, null, null, e);
                    }
                }
                catch (InterruptedException e) {
                    ClioSupport.ilogThrowing(null, null, null, null, e);
                }
                finally {
                    this.acSemaphore.release();
                }
            }

            @Override
            public boolean isReplayable() {
                return this.replayable;
            }

            @Override
            public void setReplayable(boolean isReplayable) {
                this.replayable = isReplayable;
            }

            @Override
            public String serviceName() {
                return this.serviceMember.service();
            }

            Set<String> fetchServicePlacement() {
                if (!upc.isOracle()) {
                    return new HashSet<String>();
                }
                OracleConnection oConn = (OracleConnection)this.physicalConn;
                HashSet<String> instances = new HashSet<String>();
                instances.add(this.serviceMember().name());
                if (!Service.this.connectionSource().isMultitenantDatabase()) {
                    return instances;
                }
                if (oConn == null) {
                    return instances;
                }
                try {
                    if (oConn.getVersionNumber() < 12200 || !Service.this.connectionSource().isShareable()) {
                        return instances;
                    }
                    String sql = "select dbms_service_prvt.get_topology('" + this.serviceName() + "') from dual";
                    try (Statement stmt = oConn.createStatement();
                         ResultSet rs = stmt.executeQuery(sql);){
                        String instancesStr = "";
                        if (rs.next()) {
                            instancesStr = rs.getString(1);
                        }
                        if (instancesStr != null && instancesStr.length() > 0) {
                            for (String instName : instancesStr.split(",")) {
                                instances.add(instName);
                            }
                        }
                    }
                }
                catch (SQLException e) {
                    ClioSupport.ilogThrowing(null, null, null, null, e);
                }
                return instances;
            }

            public String containerName() {
                return this.connContainerName;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private String fetchContainerName() {
                if (!Service.this.connectionSource().isMultitenantDatabase()) {
                    return "";
                }
                OracleConnection oConn = (OracleConnection)this.physicalConn;
                if (oConn == null) {
                    return "";
                }
                Statement stmt = null;
                ResultSet rs = null;
                try {
                    stmt = oConn.createStatement();
                    String updateStr = "select sys_context('userenv','con_name') from dual";
                    rs = stmt.executeQuery("select sys_context('userenv','con_name') from dual");
                    if (rs.next()) {
                        String string = rs.getString(1);
                        return string;
                    }
                }
                catch (SQLException e) {
                    ClioSupport.ilogThrowing(null, null, null, null, e);
                }
                finally {
                    try {
                        if (rs != null) {
                            rs.close();
                        }
                        if (stmt != null) {
                            stmt.close();
                        }
                    }
                    catch (SQLException e) {
                        ClioSupport.ilogThrowing(null, null, null, null, e);
                    }
                }
                return "";
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public boolean repurpose(ConnectionRetrievalInfo newCri) {
                if (!(cri instanceof JDBCConnectionRetrievalInfo)) {
                    return false;
                }
                if (!(newCri instanceof JDBCConnectionRetrievalInfo)) {
                    return false;
                }
                if (!(this.cri() instanceof JDBCConnectionRetrievalInfo)) {
                    return false;
                }
                if (this.closed()) return false;
                if (!this.valid()) {
                    return false;
                }
                OracleConnection oConn = (OracleConnection)this.physicalConn;
                if (oConn == null) {
                    return false;
                }
                JDBCConnectionRetrievalInfo repurposeCri = (JDBCConnectionRetrievalInfo)newCri;
                String repurposeSvcName = repurposeCri.getServiceName();
                JDBCConnectionRetrievalInfo connCri = (JDBCConnectionRetrievalInfo)this.cri();
                if (!repurposeCri.equals(connCri.getCopyWithService(repurposeSvcName))) {
                    return false;
                }
                try (Statement stmt = oConn.createStatement();){
                    Service newSvc = Service.this.connectionSource().service(repurposeSvcName);
                    String setContainerStr = "alter session set container=" + newSvc.containerName() + " service=\"" + newSvc.name() + "\"";
                    stmt.execute(setContainerStr);
                    String newContainerName = this.fetchContainerName();
                    Properties connProps = Service.this.getProperties(this);
                    String newServiceName = connProps.getProperty("SERVICE_NAME");
                    if (!newSvc.name().equalsIgnoreCase(newServiceName) && !newSvc.containerName().equalsIgnoreCase(newContainerName)) {
                        ClioSupport.ilogWarning(null, null, null, null, "Repurposing connection from service " + this.serviceName() + "to service " + newSvc.name() + "failed");
                        boolean bl2 = false;
                        return bl2;
                    }
                    ClioSupport.ilogFinest(null, null, null, null, "Repurposed connection from service " + this.serviceName() + "to service " + newSvc.name());
                    if (this.getDelegate() instanceof OracleUniversalPooledConnection) {
                        OracleUniversalPooledConnection jdbcConn = (OracleUniversalPooledConnection)this.getDelegate();
                        jdbcConn.setPdbSessionInitialized(false);
                        Service.this.connectionSource().totalCount(connCri).decrementAndGet();
                        ConnectionRetrievalInfo repurposedCri = repurposeCri.getCopyWithService(newServiceName).getCopyWithNoLabels();
                        jdbcConn.setConnectionRetrievalInfo(repurposedCri);
                        Service.this.connectionSource().totalCount(repurposedCri).incrementAndGet();
                    }
                    this.serviceMember.activeCount.decrementAndGet();
                    this.serviceMember.lbStats.onClosed();
                    this.serviceMember.serviceRef.activeCount.decrementAndGet();
                    this.serviceMember.serviceRef.lbStats.onClosed();
                    this.serviceMember = new ServiceMember(connProps, newSvc);
                    this.connContainerName = newContainerName;
                    this.serviceMember = newSvc.insertMember(this.serviceMember);
                    this.serviceMember.activeCount.incrementAndGet();
                    newSvc.lbStats.onOpened();
                    this.serviceMember.lbStats.onOpened();
                    newSvc.activeCount.incrementAndGet();
                    boolean bl = true;
                    return bl;
                }
                catch (SQLException e) {
                    ClioSupport.ilogThrowing(null, null, null, null, e);
                    return false;
                }
            }

            @Override
            public void onError() {
                UniversalPooledConnectionImpl upc2 = (UniversalPooledConnectionImpl)this.getDelegate();
                Service.this.routingCache().onError(upc2.getBorrowCRI(), this.serviceMember());
            }

            @Override
            public Object getPhysicalConnection() {
                block6: {
                    if (!(this.getDelegate() instanceof UniversalPooledConnection)) {
                        return null;
                    }
                    try {
                        UniversalPooledConnection upc2 = (UniversalPooledConnection)this.getDelegate();
                        Object conn = upc2.getPhysicalConnection();
                        if (upc2.isOracle()) {
                            if (conn instanceof OracleConnection) {
                                return conn;
                            }
                            if (conn instanceof OraclePooledConnection) {
                                return ((OraclePooledConnection)conn).getConnection();
                            }
                            break block6;
                        }
                        return conn;
                    }
                    catch (SQLException e) {
                        ClioSupport.ilogThrowing(null, null, null, null, e);
                    }
                }
                return null;
            }

            void openProxySession(ConnectionRetrievalInfo borrowCri) throws SQLException {
                if (!(borrowCri instanceof JDBCConnectionRetrievalInfo)) {
                    return;
                }
                if (!upc.isOracle()) {
                    return;
                }
                OracleConnection oConn = (OracleConnection)this.physicalConn;
                if (oConn == null) {
                    return;
                }
                if (oConn.isProxySession()) {
                    return;
                }
                JDBCConnectionRetrievalInfo jdbcCri = (JDBCConnectionRetrievalInfo)borrowCri;
                Properties newProxyProps = jdbcCri.getProxyProperties();
                if (newProxyProps == null) {
                    return;
                }
                int proxyType = jdbcCri.getProxyType();
                ClioSupport.ilogFinest(null, null, null, null, " Opening proxy session with Properties = " + newProxyProps);
                oConn.openProxySession(proxyType, newProxyProps);
                ConnectionRetrievalInfo newConnCri = jdbcCri.getCopyWithNewProxyProperties(proxyType, newProxyProps);
                upc.setConnectionRetrievalInfo(newConnCri);
            }

            void closeProxySession() throws SQLException {
                if (!upc.isOracle()) {
                    return;
                }
                OracleConnection oConn = (OracleConnection)this.physicalConn;
                ConnectionRetrievalInfo cri2 = upc.getConnectionRetrievalInfo();
                if (!(cri2 instanceof JDBCConnectionRetrievalInfo)) {
                    return;
                }
                JDBCConnectionRetrievalInfo jdbcCri = (JDBCConnectionRetrievalInfo)cri2;
                if (jdbcCri.getProxyProperties() == null) {
                    return;
                }
                if (oConn == null) {
                    return;
                }
                oConn.close(1);
                upc.setConnectionRetrievalInfo(jdbcCri.getCopyWithNewProxyProperties(-1, null));
            }

            static {
                try {
                    $$$methodRef$$$37 = 3.class.getDeclaredConstructor(Service.class, Instantiator.class, ServiceMember[].class, UniversalPooledConnection.class, ConnectionRetrievalInfo.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$37 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$36 = 3.class.getDeclaredMethod("closeProxySession", new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$36 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$35 = 3.class.getDeclaredMethod("openProxySession", ConnectionRetrievalInfo.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$35 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$34 = 3.class.getDeclaredMethod("getPhysicalConnection", new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$34 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$33 = 3.class.getDeclaredMethod("onError", new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$33 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$32 = 3.class.getDeclaredMethod("repurpose", ConnectionRetrievalInfo.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$32 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$31 = 3.class.getDeclaredMethod("fetchContainerName", new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$31 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$30 = 3.class.getDeclaredMethod("containerName", new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$30 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$29 = 3.class.getDeclaredMethod("fetchServicePlacement", new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$29 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$28 = 3.class.getDeclaredMethod("serviceName", new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$28 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$27 = 3.class.getDeclaredMethod("setReplayable", Boolean.TYPE);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$27 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$26 = 3.class.getDeclaredMethod("isReplayable", new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$26 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$25 = 3.class.getDeclaredMethod("reinitialize", new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$25 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$24 = 3.class.getDeclaredMethod("markReconnecting", new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$24 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$23 = 3.class.getDeclaredMethod("reconnecting", new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$23 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$22 = 3.class.getDeclaredMethod("onReturn", new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$22 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$21 = 3.class.getDeclaredMethod("onBorrow", ConnectionRetrievalInfo.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$21 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$20 = 3.class.getDeclaredMethod("labelingCost", Properties.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$20 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$19 = 3.class.getDeclaredMethod("makeUnavailable", new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$19 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$18 = 3.class.getDeclaredMethod("makeAvailable", new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$18 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$17 = 3.class.getDeclaredMethod("available", new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$17 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$16 = 3.class.getDeclaredMethod("close", new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$16 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$15 = 3.class.getDeclaredMethod("handleTimeout", new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$15 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$14 = 3.class.getDeclaredMethod("abort", new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$14 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$13 = 3.class.getDeclaredMethod("cri", new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$13 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$12 = 3.class.getDeclaredMethod("cleanupToHarvest", new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$11 = 3.class.getDeclaredMethod("markCloseOnReturn", new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$10 = 3.class.getDeclaredMethod("markedCloseOnReturn", new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$9 = 3.class.getDeclaredMethod("markToReplace", new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$8 = 3.class.getDeclaredMethod("markedToReplace", new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$7 = 3.class.getDeclaredMethod("bad", new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$6 = 3.class.getDeclaredMethod("normal", new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$5 = 3.class.getDeclaredMethod("closed", new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$4 = 3.class.getDeclaredMethod("valid", new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$3 = 3.class.getDeclaredMethod("reusable", new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$2 = 3.class.getDeclaredMethod("lastAccessedTime", new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$1 = 3.class.getDeclaredMethod("getDelegate", new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$0 = 3.class.getDeclaredMethod("serviceMember", new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            }
        });
        return upc.getDelegator();
    }

    private FailoverDriver prepareFailoverDriver() {
        return new FailoverDriver(){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            protected ConnectionSource.FailoverCallback.Result onEvent(FailoverDriver.Event event, Selector cleanupSelector, Selector markupSelector, boolean isGracefulDraining, boolean restoreAfterCleanup) {
                ConnectionSource.FailoverCallback handler;
                Service.this.mostRecentONSEvent.set(event);
                if (Service.this.connectionSource().isDataDependentRoutingEnabled()) {
                    Service.this.routingCache().onHAEvent(event);
                }
                return null != (handler = (ConnectionSource.FailoverCallback)Service.this.failoverHandler.get()) ? handler.handle(cleanupSelector, markupSelector, isGracefulDraining, restoreAfterCleanup) : new ConnectionSource.FailoverCallback.Result();
            }

            @Override
            protected Service service() {
                return Service.this;
            }

            static {
                try {
                    $$$methodRef$$$2 = 4.class.getDeclaredConstructor(Service.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$1 = 4.class.getDeclaredMethod("service", new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$0 = 4.class.getDeclaredMethod("onEvent", FailoverDriver.Event.class, Selector.class, Selector.class, Boolean.TYPE, Boolean.TYPE);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            }
        };
    }

    private LoadBalancer prepareLoadBalancer() {
        return new LoadBalancer(){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            protected ConnectionSource.RebalanceCallback.Result onEvent(LoadBalancer.Event event, Selector gravitationCleanupSelector, Selector gravitationMarkupSelector) {
                Service.this.mostRecentONSEvent.set(event);
                ConnectionSource.RebalanceCallback handler = (ConnectionSource.RebalanceCallback)Service.this.rebalanceHandler.get();
                return null != handler ? handler.handle(gravitationCleanupSelector, gravitationMarkupSelector) : new ConnectionSource.RebalanceCallback.Result();
            }

            @Override
            protected Service service() {
                return Service.this;
            }

            static {
                try {
                    $$$methodRef$$$2 = 5.class.getDeclaredConstructor(Service.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$1 = 5.class.getDeclaredMethod("service", new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$0 = 5.class.getDeclaredMethod("onEvent", LoadBalancer.Event.class, Selector.class, Selector.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            }
        };
    }

    public FailoverDriver.Stats failoverDriverStats() {
        return this.fdStats;
    }

    public LoadBalancer.Stats loadBalancerStats() {
        return this.lbStats;
    }

    ServiceMember underloadedInstance() {
        return this.underloadedInstance(null);
    }

    ServiceMember underloadedInstance(ConnectionRetrievalInfo cri) {
        Object event = this.mostRecentONSEvent.get();
        if (null == event) {
            return null;
        }
        ServiceMember underloadedInstance = null;
        if (event instanceof LoadBalancer.Event) {
            underloadedInstance = this.loadBalancer.underloadedInstance(cri);
        } else if (event instanceof FailoverDriver.Event) {
            underloadedInstance = this.failoverDriver.underloadedInstance(cri);
        } else {
            throw new IllegalStateException("wrong ONS event object");
        }
        return underloadedInstance;
    }

    public void registerFailoverCallback(ConnectionSource.FailoverCallback handler) {
        if (null == handler) {
            throw new IllegalArgumentException("failover handler is null");
        }
        if (!this.failoverHandler.compareAndSet(null, handler)) {
            ClioSupport.ilogWarning(null, null, null, null, "failover handler has been already plugged");
        }
    }

    public void registerRebalanceCallback(ConnectionSource.RebalanceCallback handler) {
        if (null == handler) {
            throw new IllegalArgumentException("rebalance handler is null");
        }
        if (!this.rebalanceHandler.compareAndSet(null, handler)) {
            ClioSupport.ilogWarning(null, null, null, null, "rebalance handler has been already plugged");
        }
    }

    public Selector loadBalancedBorrowSelector(ConnectionRetrievalInfo cri, ConnectionAffinityCallback affCallback) {
        return this.loadBalancer.borrowSelector(cri, affCallback);
    }

    private Properties getProperties(CoreConnection conn) {
        UniversalPooledConnection upc = (UniversalPooledConnection)conn.getDelegate();
        return upc.getDatabaseConnectionProperties();
    }

    void stop() {
        this.failoverDriver.stop();
        this.loadBalancer.stop();
    }

    @DisableTrace
    public String toString() {
        return this.name == null ? "Unnamed Service" : this.name;
    }

    public long totalBorrowTimes(ConnectionRetrievalInfo cri, Collection<ServiceMember> allMembers) {
        if (cri == null) {
            return this.lbStats.borrowTimes.totalDelta();
        }
        return allMembers.stream().mapToLong(sm -> sm.lbStats.borrowTimes.totalDelta()).sum();
    }

    int getLastDrainTimeout() {
        return this.lastDrainTimeout.get();
    }

    void setLastDrainTimeout(int drainTimeout) {
        this.lastDrainTimeout.set(drainTimeout);
    }

    private DataDependentRoutingCache prepareRoutingCache() {
        if (this.connectionSource().isShardedDatabase()) {
            return new ShardRoutingCache(){
                private static Executable $$$methodRef$$$0;
                private static Logger $$$loggerRef$$$0;
                private static Executable $$$methodRef$$$1;
                private static Logger $$$loggerRef$$$1;

                @Override
                protected Service service() {
                    return Service.this;
                }

                static {
                    try {
                        $$$methodRef$$$1 = 6.class.getDeclaredConstructor(Service.class);
                    }
                    catch (Throwable throwable) {}
                    $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                    try {
                        $$$methodRef$$$0 = 6.class.getDeclaredMethod("service", new Class[0]);
                    }
                    catch (Throwable throwable) {}
                    $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                }
            };
        }
        return new RACDataAffinityRoutingCache(){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;

            @Override
            protected Service service() {
                return Service.this;
            }

            static {
                try {
                    $$$methodRef$$$1 = 7.class.getDeclaredConstructor(Service.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$0 = 7.class.getDeclaredMethod("service", new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            }
        };
    }

    public Selector serviceBasedRepurposeSelector(ConnectionRetrievalInfo cri, boolean balanced) {
        this.awaitRegister();
        if (this.activeCount.get() + this.pendingCreateCount.get() >= this.connectionSource().limits().getMaxPerService()) {
            return Selectors.NONE;
        }
        final HashSet<String> dbInstsForRepurpose = new HashSet<String>(this.placement.size());
        ServiceMember underLoadedInst = this.underloadedInstance();
        if (balanced && underLoadedInst != null) {
            dbInstsForRepurpose.add(underLoadedInst.name());
        } else {
            dbInstsForRepurpose.addAll(this.placement);
        }
        return new Selector(){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;

            @Override
            public boolean selected(CoreConnection conn) {
                if (!conn.available()) {
                    return false;
                }
                if (conn.closed()) {
                    return false;
                }
                return dbInstsForRepurpose.size() > 0 && dbInstsForRepurpose.contains(conn.serviceMember().name());
            }

            static {
                try {
                    $$$methodRef$$$1 = 8.class.getDeclaredConstructor(Service.class, Set.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$0 = 8.class.getDeclaredMethod("selected", CoreConnection.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            }
        };
    }

    static {
        try {
            $$$methodRef$$$60 = Service.class.getDeclaredConstructor(Instantiator.class, Topology.class, String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$60 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$59 = Service.class.getDeclaredMethod("access$1100", Service.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$59 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$58 = Service.class.getDeclaredMethod("access$1000", Service.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$58 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$57 = Service.class.getDeclaredMethod("access$900", Service.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$57 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$56 = Service.class.getDeclaredMethod("access$800", Service.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$56 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$55 = Service.class.getDeclaredMethod("access$700", Service.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$55 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$54 = Service.class.getDeclaredMethod("access$600", Service.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$54 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$53 = Service.class.getDeclaredMethod("access$500", Service.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$53 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$52 = Service.class.getDeclaredMethod("access$400", Service.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$52 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$51 = Service.class.getDeclaredMethod("access$300", Service.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$51 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$50 = Service.class.getDeclaredMethod("access$200", Service.class, CoreConnection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$50 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$49 = Service.class.getDeclaredMethod("access$100", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$49 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$48 = Service.class.getDeclaredMethod("access$000", Service.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$48 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$47 = Service.class.getDeclaredMethod("lambda$interruptPendingCreations$0", ServiceMember.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$47 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$46 = Service.class.getDeclaredMethod("lambda$interruptPendingCreations$1", Map.class, Pair.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$46 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$45 = Service.class.getDeclaredMethod("lambda$create$2", String.class, ServiceMember.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$45 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$44 = Service.class.getDeclaredMethod("lambda$totalBorrowTimes$3", ServiceMember.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$44 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$43 = Service.class.getDeclaredMethod("serviceBasedRepurposeSelector", ConnectionRetrievalInfo.class, Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$43 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$42 = Service.class.getDeclaredMethod("prepareRoutingCache", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$42 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$41 = Service.class.getDeclaredMethod("setLastDrainTimeout", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$41 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$40 = Service.class.getDeclaredMethod("getLastDrainTimeout", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$40 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$39 = Service.class.getDeclaredMethod("totalBorrowTimes", ConnectionRetrievalInfo.class, Collection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$39 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$38 = Service.class.getDeclaredMethod("stop", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$38 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$37 = Service.class.getDeclaredMethod("getProperties", CoreConnection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$37 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$36 = Service.class.getDeclaredMethod("loadBalancedBorrowSelector", ConnectionRetrievalInfo.class, ConnectionAffinityCallback.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$36 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$35 = Service.class.getDeclaredMethod("registerRebalanceCallback", ConnectionSource.RebalanceCallback.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$35 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$34 = Service.class.getDeclaredMethod("registerFailoverCallback", ConnectionSource.FailoverCallback.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$34 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$33 = Service.class.getDeclaredMethod("underloadedInstance", ConnectionRetrievalInfo.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$33 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$32 = Service.class.getDeclaredMethod("underloadedInstance", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$32 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$31 = Service.class.getDeclaredMethod("loadBalancerStats", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$31 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$30 = Service.class.getDeclaredMethod("failoverDriverStats", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$30 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$29 = Service.class.getDeclaredMethod("prepareLoadBalancer", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$29 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$28 = Service.class.getDeclaredMethod("prepareFailoverDriver", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$28 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$27 = Service.class.getDeclaredMethod("create", ConnectionRetrievalInfo.class, ConnectionAffinityCallback.class, EnumSet.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$27 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$26 = Service.class.getDeclaredMethod("interruptPendingCreations", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$26 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$25 = Service.class.getDeclaredMethod("createConnectionInterruptably", ConnectionRetrievalInfo.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$25 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$24 = Service.class.getDeclaredMethod("isUnableToCreateConnection", UniversalConnectionPoolException.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$24 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$23 = Service.class.getDeclaredMethod("create", ConnectionRetrievalInfo.class, ConnectionAffinityCallback.class, EnumSet.class, Long.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$23 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$22 = Service.class.getDeclaredMethod("name", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$22 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$21 = Service.class.getDeclaredMethod("routingCache", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$21 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$20 = Service.class.getDeclaredMethod("connectionSource", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$20 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$19 = Service.class.getDeclaredMethod("proportionalDistributionSelector", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$19 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$18 = Service.class.getDeclaredMethod("buildDistributionTable", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$18 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$17 = Service.class.getDeclaredMethod("gcd", Integer[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$17 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$16 = Service.class.getDeclaredMethod("borrowedCount", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$16 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$15 = Service.class.getDeclaredMethod("activeCount", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$15 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$14 = Service.class.getDeclaredMethod("markup", LoadBalancer.Event.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$14 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$13 = Service.class.getDeclaredMethod("markup", FailoverDriver.Event.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$13 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$12 = Service.class.getDeclaredMethod("getAllMembers", ConnectionRetrievalInfo.class, Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$11 = Service.class.getDeclaredMethod("getAllMembers", ConnectionRetrievalInfo.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$10 = Service.class.getDeclaredMethod("getAllMembers", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$9 = Service.class.getDeclaredMethod("getMember", String.class, String.class, String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$8 = Service.class.getDeclaredMethod("getMember", String.class, String.class, String.class, String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$7 = Service.class.getDeclaredMethod("insertMember", ServiceMember.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$6 = Service.class.getDeclaredMethod("setContainerName", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$5 = Service.class.getDeclaredMethod("containerName", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$4 = Service.class.getDeclaredMethod("setName", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$3 = Service.class.getDeclaredMethod("activeMembersCount", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$2 = Service.class.getDeclaredMethod("checkAndRegister", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$1 = Service.class.getDeclaredMethod("awaitRegister", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$0 = Service.class.getDeclaredMethod("onRegister", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        rand = new Random();
        interruptableActor = new InterruptableActor();
    }
}

