Rem
Rem $Header: dbgendev/src/langdata/plsql/semantic-cache/semantic_cache_pkg.pkb /main/2 2025/08/17 19:34:27 deveverm Exp $
Rem
Rem semantic_cache_pkg.pkb
Rem
Rem Copyright (c) 2025, Oracle and/or its affiliates.
Rem
Rem    NAME
Rem      semantic_cache_pkg.pkb - Package specification for the semantic cache.
Rem
Rem    DESCRIPTION
Rem      Package for handling search for the semantic cache, along with,
Rem      seeding of the cache.
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    BEGIN SQL_FILE_METADATA
Rem    SQL_SOURCE_FILE: dbgendev/src/langdata/plsql/semantic-cache/semantic_cache_pkg.pkb
Rem    SQL_SHIPPED_FILE:
Rem    SQL_PHASE:
Rem    SQL_STARTUP_MODE: NORMAL
Rem    SQL_IGNORABLE_ERRORS: NONE
Rem    END SQL_FILE_METADATA
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    deveverm    08/08/25 - DBAI-1148: Added procedure cache_purge_reports,
Rem                           cache_delete_report_by_id
Rem    deveverm    08/06/25 - DBAI-1152: Added procedure cache_create_report
Rem    dadoshi     08/04/25 - JIRA_DBAI1147: Add vector based error handling to
Rem                           cache_search_from_query
Rem    dadoshi     07/31/25 - JIRA_DBAI1147: Add cache_search_from_query
Rem    dadoshi     07/31/25 - Created
Rem

CREATE OR REPLACE PACKAGE BODY lang_data_semantic_cache_pkg IS
    PROCEDURE cache_search_from_query (
        p_query                         IN VARCHAR2,
        p_namespace                     IN VARCHAR2,
        p_min_confidence                IN NUMBER DEFAULT 0,
        p_query_vector                  IN VECTOR DEFAULT NULL,
        p_search_id                     OUT VARCHAR2,
        p_report_id                     OUT VARCHAR2,
        p_match_document                OUT JSON
    )
    IS
        v_search_id                     VARCHAR2(36);
        v_top_report_match              JSON_OBJECT_T;
        v_vector_distance               NUMBER;
        v_match_confidence              NUMBER;
        v_match_document_obj            JSON_OBJECT_T;
        v_prev_aug_enabled              VARCHAR2(10);
        v_query_vector_dimensions       NUMBER;
        v_vec_dim                       NUMBER;
    BEGIN
        lang_data_auth_pkg.assert_minimum_role_access;
        v_prev_aug_enabled := lang_data_config_pkg.get_config_parameter(
            'LANG_DATA_NER_AUGMENTATION_ENABLED'
        );
        lang_data_config_pkg.update_config_parameter(
            'LANG_DATA_NER_AUGMENTATION_ENABLED',
            'false'
        );
        IF p_namespace IS NULL THEN
            lang_data_errors_pkg.raise_error(
                lang_data_errors_pkg.c_invalid_parameters_code
            );
        END IF;
        
        lang_data_search_pkg.search_from_query(
            p_query         => p_query,
            p_domain        => p_domain_name,
            p_query_vector  => p_query_vector,
            p_search_id     => v_search_id
        );
        p_search_id := v_search_id;

        v_top_report_match := lang_data_search_pkg.get_top_report_match(
            p_search_id     => v_search_id
        );
        lang_data_logger_pkg.log_debug(
            'v_top_report_match = ' || v_top_report_match.to_string
        );

        v_vector_distance := v_top_report_match.get_number('vector_distance');
        lang_data_logger_pkg.log_debug(
            'v_vector_distance = ' || v_vector_distance
        );

        v_match_confidence := lang_data_utils_pkg.get_match_confidence(
            p_distance      => v_vector_distance,
            p_domain        => p_domain_name
        );

        lang_data_logger_pkg.log_debug(
            'v_match_confidence = ' || v_match_confidence
        );

        v_match_document_obj := TREAT(
            v_top_report_match.get('report_match_document') AS JSON_OBJECT_T
        );
        lang_data_logger_pkg.log_debug(
            'v_match_document_obj = ' || v_match_document_obj.to_string
        );

        IF v_match_confidence >= p_min_confidence THEN
            v_match_document_obj := TREAT(
                v_top_report_match.get('report_match_document') AS JSON_OBJECT_T
            );
            lang_data_logger_pkg.log_debug(
                'v_match_document_obj = ' || v_match_document_obj.to_string
            );
            p_match_document := JSON(v_match_document_obj.to_string);
            p_report_id := v_top_report_match.get_string('report_id');
        ELSE
            p_match_document := NULL;
            p_report_id := NULL;
        END IF;
        lang_data_config_pkg.update_config_parameter(
            'LANG_DATA_NER_AUGMENTATION_ENABLED',
            v_prev_aug_enabled
        );
        commit;
    EXCEPTION
        WHEN OTHERS THEN
            rollback;
            lang_data_config_pkg.update_config_parameter(
                'LANG_DATA_NER_AUGMENTATION_ENABLED',
                v_prev_aug_enabled
            );
            lang_data_logger_pkg.log_fatal(
                'An unknown error occurred for query: ' || 
                p_query || '. Error: ' || SQLERRM
            );
            RAISE;
    END cache_search_from_query;

    PROCEDURE cache_create_report (
        p_query_text            IN VARCHAR2,
        p_match_document        IN JSON,
        p_related_queries       IN SYS.ODCIVARCHAR2LIST,
        p_namespace             IN VARCHAR2,
        p_query_vector          IN VECTOR DEFAULT NULL,
        p_report_id             OUT VARCHAR2
    )
    IS
        v_report_id             VARCHAR2(36);
        v_description_id        VARCHAR2(36);
    begin
        lang_data_auth_pkg.assert_app_expert_role;
        
        IF p_namespace IS NULL THEN
            lang_data_errors_pkg.raise_error(
                lang_data_errors_pkg.c_invalid_parameters_code
            );
        END IF;

        lang_data.validate_match_document_and_grant_table_privileges(
            p_match_document
        );

        lang_data_reports_pkg.create_report(
            p_title              => p_query_text,
            p_match_document     => p_match_document,
            p_description_text   => p_query_text,
            p_description_status => 'Published',
            p_report_status      => 'Published',
            p_sample_queries     => p_related_queries,
            p_description_vector => p_query_vector,
            p_domain             => p_namespace,
            p_report_id          => p_report_id,
            p_description_id     => v_description_id
        );
        COMMIT;
    EXCEPTION
        WHEN OTHERS THEN
            ROLLBACK;
            RAISE;
    end cache_create_report;

    PROCEDURE cache_delete_report_by_id(
        p_report_id IN SYS.ODCIVARCHAR2LIST
    ) IS
    BEGIN
        FOR i IN 1 .. p_report_id.COUNT LOOP
            lang_data.delete_report(
                p_report_id => p_report_id(i)
            );
        END LOOP;
    end cache_delete_report_by_id;

    PROCEDURE cache_purge_reports(
        p_namespace         IN VARCHAR2,
        p_timestamp         IN TIMESTAMP DEFAULT NULL,
        p_hit_limit         IN NUMBER DEFAULT NULL,
        p_action            IN VARCHAR2 DEFAULT 'COUNT',
        p_num_reports       OUT NUMBER
    ) IS
    BEGIN
        lang_data_auth_pkg.assert_app_expert_role;
        lang_data_reports_pkg.purge_reports(
            p_timestamp         => p_timestamp,
            p_domain            => p_namespace,
            p_hit_limit         => p_hit_limit,
            p_action            => p_action,
            p_num_reports       => p_num_reports
        );
        COMMIT;
    EXCEPTION
        WHEN OTHERS THEN
            ROLLBACK;
            RAISE;
    END cache_purge_reports;
END lang_data_semantic_cache_pkg;
/