Rem
Rem $Header: dbgendev/src/langdata/plsql/migration/migration_pkg.pkb /main/6 2025/03/24 22:54:42 pryarla Exp $
Rem
Rem migration_pkg.pkb
Rem
Rem Copyright (c) 2024, 2025, Oracle and/or its affiliates.
Rem
Rem    NAME
Rem      migration_pkg.pkb - Package body of migration_pkg
Rem
Rem    DESCRIPTION
Rem      Defines the procedures/functions responsible for the migration of
Rem 	 the schema of database based on Schema Versions of Lang-Data.
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    BEGIN SQL_FILE_METADATA
Rem    SQL_SOURCE_FILE: dbgendev/src/langdata/plsql/migration/migration_pkg.pkb
Rem    SQL_SHIPPED_FILE:
Rem    SQL_PHASE:
Rem    SQL_STARTUP_MODE: NORMAL
Rem    SQL_IGNORABLE_ERRORS: NONE
Rem    END SQL_FILE_METADATA
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    dadoshi     02/24/25 - JIRA_DBAI578: Add config_pkg usage
Rem    jiangnhu    02/14/25 - DBAI-575: Remove c_unknown_exception_code
Rem    dadoshi     10/21/24 - Remove text wrapping
Rem    dadoshi     10/18/24 - JIRA_DBAI399: Update template
Rem    pryarla     10/16/24 - Created
Rem

CREATE OR REPLACE PACKAGE BODY lang_data_migration_pkg AS

    PROCEDURE migrate_schema
    IS
        v_backend_schema_version VARCHAR2(20);
        v_db_schema_version VARCHAR2(20);
        v_backend_schema_version_substr VARCHAR(20);
        v_backend_schema_version_substr_modified VARCHAR(20);
        v_db_schema_version_substr VARCHAR(20);
        v_current_db_schema_version NUMBER;
        v_required_db_schema_version NUMBER;
        v_version_no NUMBER;
        v_sql_command VARCHAR2(4000);
    BEGIN
        v_backend_schema_version := lang_data_config_pkg.get_config_parameter(
                                        'LANG_DATA_SCHEMA_VERSION'
                                    );
        lang_data_logger_pkg.log_info(
            'Migrate Schema Procedure started with backend schema version = ' ||
            v_backend_schema_version
        );
        
        -- Fetch the latest version number from database schema version table
        SELECT version_number
        INTO v_db_schema_version
        FROM langdata$schemaversion
        ORDER BY created_at DESC
        FETCH FIRST ROW ONLY;

        lang_data_logger_pkg.log_info(
            'Database Schema Version: ' || v_db_schema_version
        );

        -- Extract the major and minor parts of the version (e.g., 23.0.0)
        v_backend_schema_version_substr := REGEXP_SUBSTR(
            v_backend_schema_version, '^(.*)\.[^.]+$', 1, 1, NULL, 1);
        v_db_schema_version_substr := REGEXP_SUBSTR(
            v_db_schema_version, '^(.*)\.[^.]+$', 1, 1, NULL, 1);

        -- If the major/minor versions are not the same, stop migration
        IF v_backend_schema_version_substr != v_db_schema_version_substr THEN
            lang_data_logger_pkg.log_error(
                'Unable to migrate schema. Please update the database version.'
            );
            RETURN;
        END IF;

        -- Extract the patch versions (e.g., .0.3) for comparison
        v_current_db_schema_version := TO_NUMBER(REGEXP_SUBSTR(
            v_db_schema_version, '[^.]+$', 1, 1));
        v_required_db_schema_version := TO_NUMBER(REGEXP_SUBSTR(
            v_backend_schema_version, '[^.]+$', 1, 1));

        -- Replace dots in the backend schema version for constructing the
        -- procedure name (e.g., 23_0_0)
        v_backend_schema_version_substr_modified := REPLACE(
            v_backend_schema_version_substr, '.', '_');

        -- Loop through each schema version from the current DB version up to 
        -- the required version
        FOR v_version_no IN v_current_db_schema_version + 1 .. 
                            v_required_db_schema_version LOOP
            lang_data_logger_pkg.log_info(
                'Migrating to version: ' || v_version_no
            );

            -- Construct the dynamic procedure name 
            -- (e.g., migrate_to_23_0_0_1, migrate_to_23_0_0_2, etc.)
            v_sql_command := 'BEGIN lang_data_migration_pkg.migrate_to_' || 
                                v_backend_schema_version_substr_modified || 
                                '_' || TO_CHAR(v_version_no) || 
                                '; END;';
            lang_data_logger_pkg.log_info(
                'Executing migration procedure: ' || v_sql_command
            );

            -- Execute the migration procedure
            BEGIN
                EXECUTE IMMEDIATE v_sql_command;
            EXCEPTION
                WHEN OTHERS THEN
                    lang_data_logger_pkg.log_fatal(
                        'Error executing migration procedure for version ' || 
                        v_backend_schema_version_substr || 
                        '.' || v_version_no || ': ' 
                        || SQLERRM);
                    RAISE;            
            END;

            -- Log successful completion of the migration for current version
            lang_data_logger_pkg.log_info(
                'Migration to version ' || v_version_no || 
                ' completed successfully.'
            );

            -- Insert the schema version into the database to mark the 
            -- migration as completed
            BEGIN
                INSERT INTO langdata$schemaversion
                VALUES (
                    v_backend_schema_version_substr || '.' || v_version_no, 
                    'Migration done for ' || v_backend_schema_version_substr || 
                    '.' || v_version_no, 
                    DEFAULT
                );
            EXCEPTION
                WHEN OTHERS THEN
                    lang_data_logger_pkg.log_fatal(
                        'Error inserting schema version into database: ' || 
                        SQLERRM
                    );
                    RAISE;
            END;
        END LOOP;
    END migrate_schema;

    -- Procedure for migration to version 23.0.0.1
    PROCEDURE migrate_to_23_0_0_1 IS
    BEGIN
        lang_data_logger_pkg.log_info(
            'Current system date and time: ' || 
            TO_CHAR(SYSDATE, 'YYYY-MM-DD HH24:MI:SS')
        );
    END migrate_to_23_0_0_1;

    -- Procedure for migration to version 23.0.0.2
    PROCEDURE migrate_to_23_0_0_2 IS
    BEGIN
        -- Add a new column `username` to the `langdata$searchrecords` table
        EXECUTE IMMEDIATE 'ALTER TABLE langdata$searchrecords ADD ' || 
        '(username VARCHAR2(32) DEFAULT ''anonymous'' NOT NULL)';
        lang_data_logger_pkg.log_info(
            'Migration to 23.0.0.2 completed: username column added to ' || 
            'langdata$searchrecords'
        );
    EXCEPTION
        WHEN OTHERS THEN
            lang_data_logger_pkg.log_fatal(
                'Error during migration to 23.0.0.2: ' || SQLERRM
            );
            RAISE;
    END migrate_to_23_0_0_2;

END lang_data_migration_pkg;
/

