Rem
Rem $Header: dbgendev/src/langdata/plsql/config/config_pkg.pkb /main/23 2025/08/17 19:34:27 deveverm Exp $
Rem
Rem config_pkg.pkb
Rem
Rem Copyright (c) 2025, Oracle and/or its affiliates.
Rem
Rem    NAME
Rem      config_pkg.pkb - Package Body of lang_data_config_pkg
Rem
Rem    DESCRIPTION
Rem      This package contains implementation of the procedures and functions
Rem      to manage the configuration of LangData.
Rem
Rem    NOTES
Rem      NONE
Rem
Rem    BEGIN SQL_FILE_METADATA
Rem    SQL_SOURCE_FILE: dbgendev/src/langdata/plsql/config/config_pkg.pkb
Rem    SQL_SHIPPED_FILE:
Rem    SQL_PHASE:
Rem    SQL_STARTUP_MODE: NORMAL
Rem    SQL_IGNORABLE_ERRORS: NONE
Rem    END SQL_FILE_METADATA
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    deveverm    08/14/25 - DBAI-1148: Added config parameter for  
Rem                           LANG_DATA_MODEL_* config parameters.
Rem    dadoshi     07/30/25 - Add optional mount dir parameter to populate
Rem                           procedure for SQLcl
Rem    jiangnhu    07/16/25 - Add config LANG_DATA_GENAI_RERANK_ENDPOINT_ID; add
Rem                           p_genAI_rerank_endpoint_id in set_oci_credential
Rem    sathyavc    07/11/25 - DBAI-881: Add config parameter for same question
Rem                           similarity threshold
Rem    deveverm    07/04/25 - changed user_credentials to all_credentials in
Rem                           set_oci_credentials
Rem    anisbans    07/03/25 - DBAI-878: Remove config_tablespace_limits
Rem    jiangnhu    07/02/25 - DBAI-1006: Parameterize hard-coded names in
Rem                           create_resource_plan
Rem    arevathi    07/01/25 - Add MOUNT_DIR config parameter
Rem    deveverm    06/25/25 - DBAI-771: disabled config_tablespace_limits for
Rem                           ADB
Rem    jiangnhu    06/03/25 - DBAI-844: Add config parameter for flashback
Rem                           lookback time period length
Rem    deveverm    06/02/25 - DBAI-794: modified set_oci_credential to take
Rem                           genAI endpoint
Rem    lachoud     05/09/25 - Added log_level population
Rem    pryarla     05/15/25 - DBAI-737: Add config parameters for LLM
Rem    dadoshi     05/05/25 - JIRA_DBAI777: Add documentation
Rem    dadoshi     04/23/25 - JIRA_DBAI525: Add LANG_DATA_REPORT_TEXTS_N
Rem    deveverm    04/17/25 - DBAI-735: added OCI endpoints in config
Rem    deveverm    04/10/25 - DBAI-721: added set_oci_credential
Rem    dadoshi     04/07/25 - Add lang_data_value_vector_table_k
Rem    jiangnhu    03/26/25 - Add LANG_DATA_REPORT_SIMILARITY_K,
Rem                           LANG_DATA_DRILLDOWN_SIMILARITY_K,
Rem                           add validate config value
Rem    jiangnhu    03/24/25 - Add LANG_DATA_NER_AUGMENTATION_ENABLED
Rem    dadoshi     03/20/25 - JIRA_DBAI525: Add LANG_DATA_RERANK_RESULTS
Rem                           configuration parameter
Rem    arevathi    03/07/25 - Add config_tablespace_limits Procedure
Rem    jiangnhu    03/07/25 - Add lang_data_search_typ,
Rem                           lang_data_cpu_limit_group,
Rem                           lang_data_cpu_limit_other_groups
Rem    dadoshi     02/24/25 - Created
Rem

DECLARE
    v_cloud_service VARCHAR2(10);
BEGIN
    SELECT sys_context('USERENV', 'CLOUD_SERVICE') 
    INTO v_cloud_service FROM dual;

    IF v_cloud_service IS NOT NULL THEN
        EXECUTE IMMEDIATE 'ALTER SESSION SET PLSQL_CCFLAGS = ''Is_Cloud:true''';
    ELSE
        EXECUTE IMMEDIATE 
            'ALTER SESSION SET PLSQL_CCFLAGS = ''Is_Cloud:false''';
    END IF;
END;
/

CREATE OR REPLACE PACKAGE BODY lang_data_config_pkg IS

    PROCEDURE populate_config_table (
        p_mount_dir     IN varchar2 default ''
    )
    AS
        v_cloud_service varchar2(10);
    BEGIN

        SELECT sys_context('USERENV', 'CLOUD_SERVICE') 
        INTO v_cloud_service FROM dual;

        IF v_cloud_service IS NULL THEN
            INSERT INTO langdata$config (variable_name, variable_value)
            VALUES ('LANG_DATA_IS_AUTONOMOUS_DB', 'false');

            -- This should be of the format DB_{model_name} or OCI_{model_name}
            INSERT INTO langdata$config (variable_name, variable_value)
            VALUES ('LANG_DATA_EMBEDDING_MODEL', 'DB_MULTILINGUAL_E5_BASE');
        ELSE
            INSERT INTO langdata$config (variable_name, variable_value)
            VALUES ('LANG_DATA_IS_AUTONOMOUS_DB', 'true');

            -- This should be of the format DB_{model_name} or OCI_{model_name}
            INSERT INTO langdata$config (variable_name, variable_value)
            VALUES ('LANG_DATA_EMBEDDING_MODEL', 
                'REST_cohere.embed-multilingual-v3.0');
        END IF;
        
        INSERT INTO langdata$config (variable_name, variable_value)
        VALUES ('LANG_DATA_SCHEMA_VERSION', '23.0.0.2');

        INSERT INTO langdata$config (variable_name, variable_value)
        VALUES ('LANG_DATA_SAMPLE_QUERY_WEIGHT', '10');

        INSERT INTO langdata$config (variable_name, variable_value)
        VALUES ('LANG_DATA_POST_VALIDATION_FUZZY_MATCH_THRESHOLD', '80');

        INSERT INTO langdata$config (variable_name, variable_value)
        VALUES ('LANG_DATA_AUGMENT_QUERY_FUZZY_MATCH_THRESHOLD', '70');

        INSERT INTO langdata$config (variable_name, variable_value)
        VALUES ('LANG_DATA_REPORT_SIMILARITY_K', '5');

        INSERT INTO langdata$config (variable_name, variable_value)
        VALUES ('LANG_DATA_DRILLDOWN_SIMILARITY_K', '5');

        INSERT INTO langdata$config (variable_name, variable_value)
        VALUES ('LANG_DATA_PREV_CONTEXT_LEN', '5');

        INSERT INTO langdata$config (variable_name, variable_value)
        VALUES ('LANG_DATA_POST_CONTEXT_LEN', '2');

        INSERT INTO langdata$config (variable_name, variable_value)
        VALUES ('LANG_DATA_VALUE_VECTOR_TABLE_K', '3');

        INSERT INTO langdata$config (variable_name, variable_value)
        VALUES ('LANG_DATA_TESTING', 'false');

        INSERT INTO langdata$config (variable_name, variable_value)
        VALUES ('LANG_DATA_USING_CENTROID', 'false');

        INSERT INTO langdata$config (variable_name, variable_value)
        VALUES ('LANG_DATA_SEARCH_TYPE', 'Hierarchical');

        INSERT INTO langdata$config (variable_name, variable_value)
        VALUES ('LANG_DATA_RERANK_RESULTS', 'false');

        INSERT INTO langdata$config (variable_name, variable_value)
        VALUES ('LANG_DATA_REPORT_TEXTS_N', '3');

        INSERT INTO langdata$config (variable_name, variable_value)
        VALUES ('LANG_DATA_DRILLDOWN_TEXTS_N', '3');

        INSERT INTO langdata$config (variable_name, variable_value)
        VALUES ('LANG_DATA_CPU_LIMIT', '50');

        INSERT INTO langdata$config (variable_name, variable_value)
        VALUES ('LANG_DATA_CPU_LIMIT_OTHER_GROUPS', '20');

        INSERT INTO langdata$config (variable_name, variable_value)
        VALUES ('LANG_DATA_NER_AUGMENTATION_ENABLED', 'false');

        INSERT INTO langdata$config (variable_name, variable_value)
        VALUES ('LANG_DATA_TABLESPACE_MIN_SIZE', '500');

        INSERT INTO langdata$config (variable_name, variable_value)
        VALUES ('LANG_DATA_TABLESPACE_MAX_SIZE', '10240');

        INSERT INTO langdata$config (variable_name, variable_value)
        VALUES ('LANG_DATA_VECTOR_TABLE_ENUMERATION_LIMIT', '100000');


        INSERT INTO langdata$config (variable_name, variable_value)
        VALUES ('LANG_DATA_GENAI_ENDPOINT', NULL);

        INSERT INTO langdata$config (variable_name, variable_value)
        VALUES ('LANG_DATA_GENAI_RERANK_ENDPOINT_ID', NULL);

        INSERT INTO langdata$config (variable_name, variable_value)
        VALUES ('LANG_DATA_OCI_CRED', NULL);

        INSERT INTO langdata$config (variable_name, variable_value)
        VALUES ('LANG_DATA_OCI_COMPARTMENT', NULL);

        INSERT INTO langdata$config (variable_name, variable_value)
        VALUES ('LANG_DATA_OCI_REGION', NULL);

        --User can set this to add a Cap to max limit of API calls
        INSERT INTO langdata$config (variable_name, variable_value)
        VALUES ('LANG_DATA_MAX_API_CALLS', NULL);

        -- Create the profile using the following:
        -- BEGIN
        --     DBMS_CLOUD.DROP_CREDENTIAL(credential_name  => 'GENAI_CRED');
        --     DBMS_CLOUD.CREATE_CREDENTIAL(
        --         credential_name => 'GENAI_CRED',
        --         user_ocid       => '',
        --         tenancy_ocid    => '',
        --         private_key     => '',
        --         fingerprint     => ''
        --     );
        --     DBMS_CLOUD_AI.drop_profile(profile_name => 'GENAI_OPENAI');
        --     DBMS_CLOUD_AI.create_profile(
        --         profile_name => 'GENAI_OPENAI',
        --         attributes => '{"provider": "oci",
        --                         "credential_name": "GENAI_CRED",
        --                         "model" : "openai.gpt-4o",
        --                         "region": "us-chicago-1",
        --                         "oci_compartment_id":""
        --         }');
        -- END;
        -- /
        INSERT INTO langdata$config (variable_name, variable_value)
        VALUES ('LANG_DATA_DBMS_CLOUD_AI_PROFILE_NAME', '');

        INSERT INTO langdata$config (variable_name, variable_value)
        VALUES ('LANG_DATA_USE_LLM', 'false');

        INSERT INTO langdata$config (variable_name, variable_value)
        VALUES ('LANG_DATA_FLASHBACK_LOOKBACK_MINUTES', '15');

        -- This is the default log level
        INSERT INTO langdata$config (variable_name, variable_value)
        VALUES (
            'LANG_DATA_LOG_LEVEL', 
            lang_data_logger_pkg.C_LOG_LEVEL_ERROR
            );

        -- This is the base directory where langdata components like 
        -- model_cache is stored
        INSERT INTO langdata$config (variable_name, variable_value)
        VALUES ('MOUNT_DIR', p_mount_dir);

        -- This is the similarity threshold for deeming a new query the same as
        -- an existing question in the `langdata$question_stats` table 
        INSERT INTO langdata$config (variable_name, variable_value)
        VALUES ('LANG_DATA_QUESTION_SIMILARITY_THRESHOLD', '0.9');
        INSERT INTO langdata$config (variable_name, variable_value)
        VALUES ('LANG_DATA_JOB_CLASS_NAME', 'LangdataJobClass');
        
        INSERT INTO langdata$config (variable_name, variable_value)
        VALUES ('LANG_DATA_RESOURCE_PLAN_NAME', 'langdataResourcePlan');

        INSERT INTO langdata$config (variable_name, variable_value)
        VALUES ('LANG_DATA_CONSUMER_GROUP_NAME', 'langdataResourceGroup');

        -- Dimensions of the vector embedding based on the embedding model used.
        INSERT INTO langdata$config (variable_name, variable_value)
        VALUES ('LANG_DATA_MODEL_VECTOR_DIMS', '768');

        -- expected minimum distance based on the embedding model used
        INSERT INTO langdata$config (variable_name, variable_value)
        VALUES ('LANG_DATA_MODEL_MIN_DIST', '0');

        -- expected maximum distance based on the embedding model used
        INSERT INTO langdata$config (variable_name, variable_value)
        VALUES ('LANG_DATA_MODEL_MAX_DIST', '0.3');

        -- shaping factor to make the scale non-linear, for custom confidence 
        -- scaling. It helps control the curve:
        -- Gamme = 1: linear scaling
        -- Gamma > 1: makes the curve sharper
        --            (only very close matches get high confidence)
        -- Gamma < 1: makes the curve flatter
        --            (even worse matches get some confidence)
        -- Example: If vector distance is 0.172, then the match confidence
        -- based on the gamme values are as follows:
        --     1. Gamma = 1 => Match Confidence = 43%
        --     2. Gamma = 2 => Match Confidence = 18%
        --     3. Gamme = 0.5 => Match Confidence = 65%
        INSERT INTO langdata$config (variable_name, variable_value)
        VALUES ('LANG_DATA_MODEL_GAMMA', '1');
    EXCEPTION
        WHEN OTHERS THEN
            lang_data_logger_pkg.log_fatal(
                'An unknown error occurred in populating ' || 
                'langdata$config table: ' ||
                '. Error: ' || SQLERRM
            );
            RAISE;
    END populate_config_table;

    FUNCTION get_config_variable_names
    RETURN VARCHAR2
    AS
        result VARCHAR2(32767);
    BEGIN
        SELECT LISTAGG(variable_name, ', ') WITHIN GROUP (ORDER BY variable_name)
        INTO result
        FROM langdata$config;
        
        RETURN result;
    END get_config_variable_names;

    FUNCTION get_config_parameter (
        p_name IN VARCHAR2
    ) RETURN VARCHAR2 IS
        v_value VARCHAR2(200);
    BEGIN
        SELECT variable_value INTO v_value
        FROM langdata$config
        WHERE variable_name = p_name;
        
        RETURN v_value;
    EXCEPTION
        WHEN NO_DATA_FOUND THEN
            lang_data_logger_pkg.log_error(
                'No configuration parameter found with name = ' || p_name
            );
            lang_data_errors_pkg.raise_error(
                lang_data_errors_pkg.c_resource_not_found
            );
        WHEN OTHERS THEN
            IF SQLCODE = lang_data_errors_pkg.c_resource_not_found THEN
                RAISE;
            END IF;
            lang_data_logger_pkg.log_fatal(
                'An unknown error occurred in fetching config parameter ' ||
                '. Error: ' || SQLERRM
            );
            RAISE;
    END get_config_parameter;

    PROCEDURE update_config_parameter (
        p_name IN VARCHAR2,
        p_value IN VARCHAR2
    )
    IS
        v_dummy             INTEGER;
        is_valid_profile    BOOLEAN;
        v_model             VARCHAR2(125);
    BEGIN
        -- Check if User is Authorized to perform the action
        IF SYS_CONTEXT('USERENV', 'SESSION_USER') != 'LANGDATA' AND 
           NOT lang_data_auth_pkg.is_role_enabled(
            lang_data_auth_pkg.c_lang_data_app_expert
        ) THEN
            lang_data_errors_pkg.raise_error(
                lang_data_errors_pkg.c_unauthorized_code
            );
        END IF;

        IF p_name = lang_data_logger_pkg.C_LOG_LEVEL THEN
            IF p_value NOT IN (
                lang_data_logger_pkg.C_LOG_LEVEL_DEBUG,
                lang_data_logger_pkg.C_LOG_LEVEL_TRACE,
                lang_data_logger_pkg.C_LOG_LEVEL_INFO,
                lang_data_logger_pkg.C_LOG_LEVEL_WARN,
                lang_data_logger_pkg.C_LOG_LEVEL_ERROR,
                lang_data_logger_pkg.C_LOG_LEVEL_FATAL
            ) THEN
                ld_logger.fatal(
                    'Invalid paramter for parameter' || 
                    lang_data_logger_pkg.C_LOG_LEVEL
                );
                lang_data_errors_pkg.raise_error(
                    lang_data_errors_pkg.c_invalid_parameters_code
                );
            END IF;
        END IF;

        IF p_name IN (
            'LANG_DATA_SAMPLE_QUERY_WEIGHT',
            'LANG_DATA_POST_VALIDATION_FUZZY_MATCH_THRESHOLD',
            'LANG_DATA_AUGMENT_QUERY_FUZZY_MATCH_THRESHOLD',
            'LANG_DATA_REPORT_SIMILARITY_K',
            'LANG_DATA_DRILLDOWN_SIMILARITY_K',
            'LANG_DATA_PREV_CONTEXT_LEN',
            'LANG_DATA_POST_CONTEXT_LEN',
            'LANG_DATA_CPU_LIMIT',
            'LANG_DATA_CPU_LIMIT_OTHER_GROUPS',
            'LANG_DATA_TABLESPACE_MIN_SIZE',
            'LANG_DATA_TABLESPACE_MAX_SIZE',
            'LANG_DATA_FLASHBACK_LOOKBACK_MINUTES',
            'LANG_DATA_MODEL_VECTOR_DIMS',
            'LANG_DATA_MODEL_MIN_DIST',
            'LANG_DATA_MODEL_MAX_DIST',
            'LANG_DATA_MODEL_GAMMA'
        ) THEN
            BEGIN
                DECLARE
                    v_dummy NUMBER;
                BEGIN
                    v_dummy := TO_NUMBER(p_value);
                EXCEPTION
                    WHEN VALUE_ERROR THEN
                        lang_data_errors_pkg.raise_error(
                            lang_data_errors_pkg.c_invalid_parameters_code
                        );
                END;
            END;
        END IF;
        IF p_name IN (
            'LANG_DATA_MODEL_MIN_DIST',
            'LANG_DATA_MODEL_MAX_DIST',
            'LANG_DATA_MODEL_GAMMA'
        ) THEN
            DECLARE
                v_dummy NUMBER;
            BEGIN
                v_dummy := TO_NUMBER(p_value);
                IF v_dummy < 0 OR v_dummy > 1 THEN
                    lang_data_errors_pkg.raise_error(
                        lang_data_errors_pkg.c_invalid_parameters_code
                    );
                END IF;
                IF p_name = 'LANG_DATA_MODEL_MIN_DIST' AND
                    v_dummy > lang_data_config_pkg.get_config_parameter(
                        'LANG_DATA_MODEL_MAX_DIST'
                    ) THEN
                    lang_data_errors_pkg.raise_error(
                        lang_data_errors_pkg.c_invalid_parameters_code
                    );
                END IF;
                IF p_name = 'LANG_DATA_MODEL_MAX_DIST' AND
                    v_dummy < lang_data_config_pkg.get_config_parameter(
                        'LANG_DATA_MODEL_MIN_DIST'
                    ) THEN
                    lang_data_errors_pkg.raise_error(
                        lang_data_errors_pkg.c_invalid_parameters_code
                    );
                END IF;
                IF v_dummy < 0 THEN
                    lang_data_errors_pkg.raise_error(
                        lang_data_errors_pkg.c_invalid_parameters_code
                    );
                END IF;
            END;
        END IF;
        IF p_name = 'LANG_DATA_QUESTION_SIMILARITY_THRESHOLD' THEN
            BEGIN
                DECLARE
                    v_dummy NUMBER;
                BEGIN
                    v_dummy := TO_NUMBER(p_value);
                    IF v_dummy < -1 OR v_dummy > 1 THEN
                        lang_data_errors_pkg.raise_error(
                            lang_data_errors_pkg.c_invalid_parameters_code
                        );
                    END IF;
                EXCEPTION
                    WHEN VALUE_ERROR THEN
                        lang_data_errors_pkg.raise_error(
                            lang_data_errors_pkg.c_invalid_parameters_code
                        );
                END;
            END;
        END IF;

        IF p_name = 'LANG_DATA_VECTOR_TABLE_ENUMERATION_LIMIT' THEN
            IF LOWER(p_value) != 'unlimited' THEN
                BEGIN
                    DECLARE
                        v_dummy NUMBER;
                    BEGIN
                        v_dummy := TO_NUMBER(p_value);
                    EXCEPTION
                        WHEN VALUE_ERROR THEN
                            lang_data_errors_pkg.raise_error(
                                lang_data_errors_pkg.c_invalid_parameters_code
                            );
                    END;
                END;
            END IF;
        END IF;

        IF p_name IN (
            'LANG_DATA_USING_CENTROID',
            'LANG_DATA_NER_AUGMENTATION_ENABLED',
            'LANG_DATA_USE_LLM'
        ) THEN
            IF LOWER(p_value) NOT IN ('true', 'false') THEN
                lang_data_errors_pkg.raise_error(
                    lang_data_errors_pkg.c_invalid_parameters_code
                );
            END IF;
        END IF;

        IF p_name = 'LANG_DATA_SEARCH_TYPE' AND
            p_value NOT IN ('Hierarchical', 'Flat') THEN
            lang_data_errors_pkg.raise_error(
                lang_data_errors_pkg.c_invalid_parameters_code
            );
        END IF;

        -- Check if the profile is valid
        IF p_name = 'LANG_DATA_DBMS_CLOUD_AI_PROFILE_NAME' AND 
            p_value IS NOT NULL AND
            TRIM(p_value) IS NOT NULL 
        THEN
            is_valid_profile := lang_data_llm_pkg.validate_llm_profile(p_value);
        END IF;


        IF p_name IN (
            'LANG_DATA_GENAI_ENDPOINT',
            'LANG_DATA_GENAI_RERANK_ENDPOINT_ID',
            'LANG_DATA_OCI_CRED',
            'LANG_DATA_OCI_COMPARTMENT',
            'LANG_DATA_OCI_REGION'
        ) THEN
            lang_data_logger_pkg.log_warn(
                'Please use set_oci_credential for updating OCI related '||
                'configs. Updating ' || p_name || ' individually will bypass '||
                'config validation process.'
            );
        END IF;
        -- This is prohibited as once any vector is generated that column is 
        -- restricted to use the same dimension vectors in the future, due to 
        -- vector indexes being created, hence once dimension is set by a 
        -- particular embedding model, it cannot be changed.
        IF p_name = 'LANG_DATA_EMBEDDING_MODEL' THEN
            lang_data_logger_pkg.log_warn(
                'Once set, this parameter should not be changed, as it '||
                'invalidates vector indexes for vectors created with '||
                'previous model');
            v_model := SUBSTR(p_value, INSTR(p_value, '_') + 1);
            IF p_value like 'DB_%' THEN
                IF v_model not in (
                    'ALL_MINILM_L12_V2', 
                    'MULTILINGUAL_E5_BASE' ) THEN
                    lang_data_logger_pkg.log_error(
                        'Unsupported embedding model'
                    );
                    lang_data_errors_pkg.raise_error(
                        lang_data_errors_pkg.c_invalid_parameters_code
                    );
                END IF;
            ELSIF p_value like 'REST_%' THEN
                null;
            ELSE
                lang_data_logger_pkg.log_error(
                    'Unsupported format for embedding model'
                );
                lang_data_errors_pkg.raise_error(
                    lang_data_errors_pkg.c_invalid_parameters_code
                );
            END IF;
        END IF;

        UPDATE langdata$config
        SET variable_value = p_value
        WHERE variable_name = p_name;

        IF SQL%ROWCOUNT = 0 THEN
            lang_data_logger_pkg.log_error(
                'No configuration parameter found with name = ' || p_name
            );
            lang_data_errors_pkg.raise_error(
                lang_data_errors_pkg.c_resource_not_found
            );
        END IF;
    EXCEPTION
        WHEN OTHERS THEN
            IF SQLCODE IN (
                lang_data_errors_pkg.c_unauthorized_code,
                lang_data_errors_pkg.c_resource_not_found,
                lang_data_errors_pkg.c_invalid_parameters_code
            ) THEN
                RAISE;
            END IF;

            lang_data_logger_pkg.log_fatal(
                'An unknown error occurred in updating config parameter ' ||
                '. Error: ' || SQLERRM
            );
            RAISE;
    END update_config_parameter;

    FUNCTION set_oci_credential (
        p_cred_name IN VARCHAR2,
        p_compartment_id IN VARCHAR2,
        p_region_code IN VARCHAR2,
        p_genAI_endpoint IN VARCHAR2,
        p_genAI_rerank_endpoint_id IN VARCHAR2
    ) RETURN VARCHAR2
    IS
        v_return_status VARCHAR2(100):= 'Failure';
        v_json          JSON;
        v_is_adb        VARCHAR2(100);
        v_is_cred       BOOLEAN;

        -- Variables for validation
        v_query         VARCHAR2(200);
        v_doc_json_obj  JSON_OBJECT_T;
        v_doc_json_array JSON_ARRAY_T;
        v_req_body_json JSON_OBJECT_T;
        v_hash          VARCHAR2(4000);
        v_body_hash     VARCHAR2(4000);
        v_req_headers_json   JSON_OBJECT_T;
        v_base_url      VARCHAR2(4000);
        v_second_level_domain   VARCHAR2(4000);
        v_full_resp     DBMS_CLOUD_TYPES.resp;
        v_serving_mode_json JSON_OBJECT_T;
        v_model  VARCHAR2(200);
        v_embedding_model   VARCHAR2(200);
    BEGIN
        -- Check if User is Authorized to perform the action
        IF NOT lang_data_auth_pkg.is_role_enabled(
            lang_data_auth_pkg.c_lang_data_app_expert
        ) THEN
            lang_data_errors_pkg.raise_error(
                lang_data_errors_pkg.c_unauthorized_code
            );
        END IF;

        -- Validate credential exits
        SELECT 1 INTO v_is_cred FROM ALL_CREDENTIALS
        WHERE CREDENTIAL_NAME = UPPER(p_cred_name);
        IF NOT v_is_cred THEN
            lang_data_logger_pkg.log_error(
                'Credential name '||p_cred_name||' does not exist.'
            );
            lang_data_errors_pkg.raise_error(
                lang_data_errors_pkg.c_invalid_parameters_code
            );
        END IF;

        -- Validate OCI call for NER
        BEGIN
            v_embedding_model := lang_data_config_pkg.get_config_parameter(
                'LANG_DATA_EMBEDDING_MODEL'
            );
            v_model := SUBSTR(v_embedding_model, INSTR(v_embedding_model, '_') + 1);

            v_query := 'John Smith booked a flight to New York with '||
                'Delta Airlines on March 15, 2025.';
            v_doc_json_obj := JSON_OBJECT_T('{}');
            v_doc_json_obj.put('key', 'doc1');
            v_doc_json_obj.put('text', REPLACE(v_query, '''',''''''));

            -- Create doc array
            v_doc_json_array := JSON_ARRAY_T('[]');
            v_doc_json_array.append(v_doc_json_obj);

            -- Create details json
            v_req_body_json := JSON_OBJECT_T('{}');
            IF p_compartment_id IS NOT NULL THEN
                v_req_body_json.put('compartmentId', p_compartment_id);
            END IF;

            v_req_body_json.put('documents', v_doc_json_array);

            v_hash := DBMS_CRYPTO.hash(
                v_req_body_json.to_blob, DBMS_CRYPTO.HASH_SH256);
            v_body_hash := UTL_RAW.cast_to_varchar2(
                UTL_ENCODE.base64_encode(v_hash));

            v_req_headers_json := JSON_OBJECT_T('{}');
            v_req_headers_json.PUT('accept', 'application/json');
            v_req_headers_json.PUT('content-type', 'application/json');
            v_req_headers_json.PUT('opc-request-id',UPPER(sys_guid()));
            -- Emulating PLSQL SDK for now
            v_req_headers_json.PUT('opc-client-info','Oracle-PlsqlSDK/1.9');
            v_req_headers_json.PUT('x-content-sha256',v_body_hash);
            v_req_headers_json.PUT('content-type','application/json');

            v_base_url :=  
                'https://language.aiservice.{region}.oci.{secondLevelDomain}/20221001/actions/batchDetectLanguageEntities';

            -- Using Endpoint reference:
            -- https://docs.oracle.com/en-us/iaas/api/#/en/language/20221001/
            IF p_region_code = 'eu-jovanovac-1' THEN
                v_second_level_domain := 'oraclecloud20.com';
            ELSE
                v_second_level_domain := 'oraclecloud.com';
            END IF;

            v_base_url := REGEXP_REPLACE(
                v_base_url, 
                '{region}',
                p_region_code);

            v_base_url := REGEXP_REPLACE(
                v_base_url, 
                '{secondLevelDomain}',
                v_second_level_domain);

            lang_Data_logger_pkg.log_debug(
                'NER REST request header: '|| v_req_headers_json.to_clob()
            );
            lang_data_logger_pkg.log_debug(
                'NER REST request body: '|| v_req_body_json.to_clob()
            );

            -- Send the request
            v_full_resp := DBMS_CLOUD.send_request(
                credential_name => p_cred_name,
                uri             => v_base_url,
                method          => 'POST',
                headers         => v_req_headers_json.to_clob(),
                body            => v_req_body_json.to_blob
            );
        EXCEPTION
            WHEN OTHERS THEN
                lang_data_logger_pkg.log_error(
                    'Error in validation of NER call to OCI: '||SQLERRM
                );
                lang_data_errors_pkg.raise_error(
                    lang_data_errors_pkg.c_invalid_parameters_code
                );
        END;
        lang_data_logger_pkg.log_debug('OCI NER call validation successful');

        -- Validate OCI call for Embedding text
        BEGIN
            v_base_url := 
                RTRIM(p_genAI_endpoint,'/') 
                || '/20231130/actions/embedText';

            -- Create servingMode Json
            v_serving_mode_json := JSON_OBJECT_T('{}');
            v_serving_mode_json.put('servingType', 'ON_DEMAND');
            v_serving_mode_json.put('modelId', v_model);

            -- Create documents json array
            v_doc_json_array := JSON_ARRAY_T('[]');
            v_doc_json_array.append('John Smith booked a flight to New York');

            -- Create request body
            v_req_body_json := JSON_OBJECT_T('{}');
            v_req_body_json.put('compartmentId', p_compartment_id);
            v_req_body_json.put('servingMode', v_serving_mode_json);
            v_req_body_json.put('inputs', v_doc_json_array);
            
            v_hash := DBMS_CRYPTO.hash(
                v_req_body_json.to_blob, DBMS_CRYPTO.HASH_SH256);
            v_body_hash := UTL_RAW.cast_to_varchar2(
                UTL_ENCODE.base64_encode(v_hash));
            
            -- Create request headers
            v_req_headers_json := JSON_OBJECT_T('{}');
            v_req_headers_json.put('accept', 'application/json');
            v_req_headers_json.put('content-type', 'application/json');
            v_req_headers_json.put('opc-request-id', UPPER(sys_guid()));
            v_req_headers_json.put('opc-client-info','Oracle-PlsqlSDK/1.9');
            v_req_headers_json.put('x-content-sha256', v_body_hash);
            
            lang_data_logger_pkg.log_debug(
                'Embedding Request URL: '|| v_base_url);
            lang_data_logger_pkg.log_debug(
                'Embedding Request Header: '|| v_req_headers_json.to_clob());
            lang_data_logger_pkg.log_debug(
                'Embedding Request Body: '|| v_req_body_json.to_clob());
            
            -- Send REST request
            v_full_resp := DBMS_CLOUD.send_request(
                credential_name => p_cred_name,
                uri             => v_base_url,
                method          => 'POST',
                headers         => v_req_headers_json.to_clob(),
                body            => v_req_body_json.to_blob()
            );
        EXCEPTION
            WHEN OTHERS THEN
                lang_data_logger_pkg.log_error(
                    'Error in validation of Embed text call to OCI: '||SQLERRM
                );
                lang_data_errors_pkg.raise_error(
                    lang_data_errors_pkg.c_invalid_parameters_code
                );
        END;
        lang_data_logger_pkg.log_debug(
            'OCI Embed text call validation successful');


        UPDATE langdata$config
        SET variable_value = p_cred_name
        WHERE variable_name = 'LANG_DATA_OCI_CRED';

        UPDATE langdata$config
        SET variable_value = p_compartment_id
        WHERE variable_name = 'LANG_DATA_OCI_COMPARTMENT';

        UPDATE langdata$config
        SET variable_value = p_region_code
        WHERE variable_name = 'LANG_DATA_OCI_REGION';

        UPDATE langdata$config
        SET variable_value = p_genAI_endpoint
        WHERE variable_name = 'LANG_DATA_GENAI_ENDPOINT';

        UPDATE langdata$config
        SET variable_value = p_genAI_rerank_endpoint_id
        WHERE variable_name = 'LANG_DATA_GENAI_RERANK_ENDPOINT_ID';

        v_return_status := 'Success';
        RETURN v_return_status;
    EXCEPTION
        WHEN NO_DATA_FOUND THEN
            lang_data_logger_pkg.log_error(
            'Credential name '||p_cred_name||' does not exist.');
            lang_data_errors_pkg.raise_error(
                lang_data_errors_pkg.c_invalid_parameters_code
            );
            RETURN v_return_status;
        WHEN OTHERS THEN
            RAISE;
    END set_oci_credential;

END lang_data_config_pkg;
/


