Rem
Rem $Header: dbgendev/src/langdata/plsql/auth/auth_pkg.pks
Rem saloshah_dbai_399/1 2024/10/21 15:26:07 saloshah Exp $
Rem
Rem auth_pkg.pls
Rem
Rem Copyright (c) 2024, 2025, Oracle and/or its affiliates.
Rem
Rem    NAME
Rem      auth_pkg.pls - Package specification of auth_pkg
Rem
Rem    DESCRIPTION
Rem      Declaration of the procedures/functions used for authorization of 
Rem	 the user in the current session
Rem
Rem    NOTES
Rem      NONE
Rem
Rem    BEGIN SQL_FILE_METADATA
Rem    SQL_SOURCE_FILE: dbgendev/src/langdata/plsql/auth/auth_pkg.pks
Rem    SQL_SHIPPED_FILE:
Rem    SQL_PHASE:
Rem    SQL_STARTUP_MODE: NORMAL
Rem    SQL_IGNORABLE_ERRORS: NONE
Rem    END SQL_FILE_METADATA
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    jiangnhu    03/08/25 - Add assert_minimum_role_access
Rem    jiangnhu    02/06/25 - Add assert_app_expert_role
Rem    saloshah    10/21/24 - DBAI-399 Modify the header
Rem    pryarla     10/16/24 - Created
Rem

CREATE OR REPLACE PACKAGE lang_data_auth_pkg IS
    -- Constants for role names
    c_lang_data_user CONSTANT VARCHAR2(30) := 'LANG_DATA_USER';
    c_lang_data_app_expert CONSTANT VARCHAR2(30) := 'LANG_DATA_APP_EXPERT';

    -- Function to return TRUE if the role is enabled, FALSE otherwise
    FUNCTION is_role_enabled (
        role_name IN VARCHAR2
    ) RETURN BOOLEAN;
    
    PROCEDURE assert_app_expert_role;

    PROCEDURE assert_minimum_role_access;
END lang_data_auth_pkg;
/

