Rem
Rem $Header: dbgendev/src/langdata/install/create_app_user.sql /main/3 2025/06/30 17:14:25 deveverm Exp $
Rem
Rem create_app_user.sql
Rem
Rem Copyright (c) 2025, Oracle and/or its affiliates.
Rem
Rem    NAME
Rem      create_app_user.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    BEGIN SQL_FILE_METADATA
Rem    SQL_SOURCE_FILE: dbgendev/src/langdata/install/create_app_user.sql
Rem    SQL_SHIPPED_FILE:
Rem    SQL_PHASE:
Rem    SQL_STARTUP_MODE: NORMAL
Rem    SQL_IGNORABLE_ERRORS: NONE
Rem    END SQL_FILE_METADATA
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    deveverm    06/25/25 - DBAI-771: added auto tablespace detection for ADB
Rem    arevathi    04/22/25 - Make create user generic
Rem    pryarla     03/14/25 - Created
Rem


-- SET ECHO ON
SET FEEDBACK 1
SET NUMWIDTH 10
SET LINESIZE 80
SET TRIMSPOOL ON
SET TAB OFF
SET PAGESIZE 100

-- Enable script to continue on error
WHENEVER SQLERROR CONTINUE;

-- Define variables for arguments
DEFINE pdb_name = '&1'
DEFINE tablespace_name = '&2'
DEFINE langdata_app_user = '&3'
DEFINE langdata_app_user_password = '&4'

show con_name;
show parameter service_name;
ALTER SESSION SET CONTAINER=&pdb_name;
select username from all_users order by username;
show con_name;


DECLARE
    user_exists NUMBER;
BEGIN
    -- Check if the user exists
    SELECT COUNT(*) INTO user_exists FROM dba_users WHERE username = UPPER('&&langdata_app_user');

    -- Create the user if not exists
    IF user_exists = 0 THEN
        EXECUTE IMMEDIATE 'CREATE USER ' || UPPER('&&langdata_app_user') || ' IDENTIFIED BY ' || '&&langdata_app_user_password';
    END IF;
END;
/

GRANT CREATE SESSION TO &langdata_app_user;
GRANT CREATE TABLE TO &langdata_app_user;

-- Privileges 
DECLARE
    v_cloud_service VARCHAR2(10);
    v_tablespace_name VARCHAR2(30);
BEGIN
    SELECT sys_context('USERENV', 'CLOUD_SERVICE') 
    INTO v_cloud_service FROM dual;

    IF v_cloud_service IS NULL THEN
        EXECUTE IMMEDIATE 
            'ALTER USER &langdata_app_user DEFAULT TABLESPACE &tablespace_name';

        EXECUTE IMMEDIATE
            'ALTER USER &langdata_app_user QUOTA UNLIMITED ON &tablespace_name';

    ELSE
        EXECUTE IMMEDIATE
            'SELECT default_tablespace FROM dba_users '||
            'WHERE username = ''' || UPPER('&langdata_app_user') || ''''
        INTO v_tablespace_name;
        EXECUTE IMMEDIATE
            'ALTER USER &langdata_app_user QUOTA UNLIMITED ON '|| 
            v_tablespace_name;
    END IF;
END;
/

GRANT CREATE SYNONYM TO &langdata_app_user;
GRANT CREATE SEQUENCE TO &langdata_app_user;
