/* iod-telemetry _xmeta.sql version 2019.05.12.1 stkolev */
with
    v$metricname as (
        /* version 3 */
        select
            ''              as project
            ,'oracle_db'    as fleet
            ,host_name      as host
            ,'"lifecycle":"'||
                case
                    when
                        (regexp_like(instance_name,'(9[0-9])') and host_name not like '%.r1') or
                        regexp_like(host_name,'(dev|sandbox)') or
                        regexp_like(lower(sys_context('USERENV','DB_DOMAIN')),'(dev|sand)')
                        then 'DEV'
                    when
                        (regexp_like(instance_name,'(9[0-9])') and host_name like '%.r1%') or
                        regexp_like(host_name,'(test|tst)') or
                        regexp_like(lower(sys_context('USERENV','DB_DOMAIN')),'(test|tst)')
                        then 'TEST'
                    else 'PROD'
                end || '"' ||
            ',"hostclass":"'|| regexp_substr(host_name,'^([^.]*)-',1,1,NULL,1) || '"' ||
            ',"instance_name":"'     || instance_name    || '"' ||
            ',"db_name":"'           || name             || '"' ||
            ',"db_domain":"'         || sys_context('USERENV','DB_DOMAIN') || '"' ||
            ',"db_unique_name":"'    || db_unique_name   || '"' ||
            ',"database_role":"'     || database_role    || '"' ||
            ',"fsfo_role":"'||
                case
                    when database_role = 'PRIMARY' then 'PRIMARY'
                    when database_role = 'PHYSICAL STANDBY' and lower(db_unique_name)  = lower(fs_failover_current_target) then 'STANDBY'
                    when database_role = 'PHYSICAL STANDBY' and lower(db_unique_name) != lower(fs_failover_current_target) then 'BYSTANDER'
                    else 'NONE'
                end || '"' as metric_dimensions
        from v$database, v$instance
    ),
    v$metric as (
        select
            ',"con_name":"'     || name                                     ||'"' as metric_dimensions
            ,'_metadata.'||sys_context('USERENV','INSTANCE_NAME')||'.'||sys_context('USERENV','DB_NAME')||'.'||name||'.'||sys_context('USERENV','DB_DOMAIN') as metric_name
            ,1 as metric_value
        from
            v$containers
     )
select
    v$metricname.project                        as project
    ,v$metricname.fleet                         as fleet
    ,v$metricname.host                          as host
    ,v$metric.metric_name                       as metric_name
    ,'{'||v$metricname.metric_dimensions||v$metric.metric_dimensions||'}' as metric_dimensions
    ,v$metric.metric_value                      as metric_value
from v$metricname,v$metric
