/* iod-telemetry BackupRedolog.sql version 2019.05.12.1 stkolev */
with
    v$metricname as (
        /* version 3 */
        select
            ''              as project
            ,'oracle_db'    as fleet
            ,host_name      as host
            ,'"lifecycle":"'||
                case
                    when
                        (regexp_like(instance_name,'(9[0-9])') and host_name not like '%.r1') or
                        regexp_like(host_name,'(dev|sandbox)') or
                        regexp_like(lower(sys_context('USERENV','DB_DOMAIN')),'(dev|sand)')
                        then 'DEV'
                    when
                        (regexp_like(instance_name,'(9[0-9])') and host_name like '%.r1%') or
                        regexp_like(host_name,'(test|tst)') or
                        regexp_like(lower(sys_context('USERENV','DB_DOMAIN')),'(test|tst)')
                        then 'TEST'
                    else 'PROD'
                end || '"' ||
            ',"hostclass":"'|| nvl(regexp_substr(host_name,'^([^.]*)-',1,1,NULL,1),'N/A') || '"' ||
            ',"instance_name":"'     || instance_name    || '"' ||
            ',"db_name":"'           || nvl(name,'N/A')             || '"' ||
            ',"db_domain":"'         || nvl(sys_context('USERENV','DB_DOMAIN'),'N/A') || '"' ||
            ',"db_unique_name":"'    || db_unique_name   || '"' ||
            ',"database_role":"'     || database_role    || '"' ||
            ',"fsfo_role":"'||
                case
                    when database_role = 'PRIMARY' then 'PRIMARY'
                    when database_role = 'PHYSICAL STANDBY' and lower(db_unique_name)  = lower(fs_failover_current_target) then 'STANDBY'
                    when database_role = 'PHYSICAL STANDBY' and lower(db_unique_name) != lower(fs_failover_current_target) then 'BYSTANDER'
                    else 'NONE'
                end || '"' as metric_dimensions
        from v$database, v$instance
    ),
    v$metric_history as (
        select
             decode(br.con_id,0,'0',con.name) name
            ,br.thread#
            ,br.sequence#
            ,br.resetlogs_change#
            ,br.first_change#
            ,br.next_change#
            ,br.next_time
            ,decode(nvl(br.first_change# - lag(br.next_change#) over (order by br.first_change#),0),0,0,1) gap
            ,sum(br.blocks*br.block_size)  bytes
            ,max(completion_time) completion_time
            from
                v$containers con
                ,(
                    select
                         br.*
                        ,bs.completion_time
                    from
                         v$backup_redolog br
                        ,v$backup_set bs
                        ,(
                            select
                                con_id
                                ,set_stamp
                                ,set_count
                                ,sum(decode(status,'A',1,0)) available
                                ,count(*) total
                            from
                                v$backup_piece_details
                            group by
                                con_id
                                ,set_stamp
                                ,set_count
                        ) pbd
                    where
                            br.con_id    = bs.con_id
                        and br.set_stamp = bs.set_stamp
                        and br.set_count = bs.set_count
                        and bs.con_id    = pbd.con_id
                        and bs.set_stamp = pbd.set_stamp
                        and bs.set_count = pbd.set_count
                        and pbd.available = pbd.total
                ) br
            where
                br.con_id = con.con_id (+)
            group by
                 decode(br.con_id,0,'0',con.name)
                ,br.thread#
                ,br.sequence#
                ,br.resetlogs_change#
                ,br.first_change#
                ,br.next_change#
                ,br.next_time
    ),
    v$metric as (
        select
            'BackupRedolog.'|| metric_name as metric_name
            ,'' as metric_dimensions
            ,metric_value as metric_value
        from (
            select
                (sysdate-max(completion_time))*86400    as "LatestBackupAgeSeconds"
                ,(sysdate-max(next_time))*86400         as "LatestArchivedlogAgeSeconds"
                ,sum(gap)                               as "ArchivedlogSequenceGaps"
            from
                v$metric_history
        ) unpivot (
            metric_value FOR metric_name IN (
                 "LatestBackupAgeSeconds"
                ,"LatestArchivedlogAgeSeconds"
                ,"ArchivedlogSequenceGaps"
            )
        )
    )
select
    v$metricname.project                        as project
    ,v$metricname.fleet                         as fleet
    ,v$metricname.host                          as host
    ,v$metric.metric_name                       as metric_name
    ,v$metric.metric_value                      as metric_value
    ,'{'||v$metricname.metric_dimensions||v$metric.metric_dimensions||'}' as metric_dimensions
from v$metricname,v$metric
