/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.premigration.reports.text.serialization;

import com.oracle.premigration.commons.enums.ResultLevel;
import com.oracle.premigration.dbinspector.Check;
import com.oracle.premigration.dbinspector.CheckResult;
import com.oracle.premigration.reports.text.TextReportContext;
import com.oracle.premigration.reports.text.TextReportSection;
import com.oracle.premigration.reports.text.serialization.TextReportCheck;
import com.oracle.premigration.reports.text.serialization.TextReportField;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class TextReportCheckList
extends TextReportField {
    List<TextReportCheck> checkList = new ArrayList<TextReportCheck>();

    public TextReportCheckList(TextReportContext reportContext, Field field, Object owningObject) {
        super(reportContext, field, owningObject);
        this.ingestCheckList(owningObject);
    }

    private void ingestCheckList(Object owningObject) {
        List<Check> checks = (List<Check>)this.value;
        checks = this.filterChecksByResultLevel(checks);
        for (Check check : checks) {
            TextReportCheck reportCheck = new TextReportCheck(this.reportContext, this.field, owningObject, check);
            this.checkList.add(reportCheck);
        }
    }

    private List<Check> filterChecksByResultLevel(List<Check> checks) {
        ArrayList<Check> filteredList = new ArrayList<Check>();
        Set<CheckResult> checkResultsToReport = ResultLevel.fromResultLevel(this.reportContext.getResultLevel());
        for (Check c : checks) {
            if (!checkResultsToReport.contains((Object)c.getResult())) continue;
            filteredList.add(c);
        }
        return filteredList;
    }

    @Override
    public void printText(TextReportSection section) {
        for (TextReportCheck textCheck : this.checkList) {
            textCheck.printText(section);
        }
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TextReportCheckList)) {
            return false;
        }
        TextReportCheckList other = (TextReportCheckList)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        List<TextReportCheck> this$checkList = this.checkList;
        List<TextReportCheck> other$checkList = other.checkList;
        return !(this$checkList == null ? other$checkList != null : !((Object)this$checkList).equals(other$checkList));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof TextReportCheckList;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        List<TextReportCheck> $checkList = this.checkList;
        result = result * 59 + ($checkList == null ? 43 : ((Object)$checkList).hashCode());
        return result;
    }
}

