/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.premigration.reports;

import com.oracle.premigration.reports.PDBAnalysisSummary;
import com.oracle.premigration.reports.html.sections.HtmlProperty;
import com.oracle.premigration.reports.html.sections.HtmlReportSectionName;
import com.oracle.premigration.reports.json.CpatJsonIgnoreIfNull;
import com.oracle.premigration.reports.json.CpatJsonPropertyDescription;
import com.oracle.premigration.reports.text.TextProperty;
import com.oracle.premigration.reports.text.TextReportSectionName;
import com.oracle.premigration.reports.text.TextValueHint;
import com.oracle.premigration.reports.text.serialization.TextReportLabeledValue;
import com.oracle.premigration.reports.text.serialization.TextReportPdbSummaryList;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class CDBReportSummary {
    @TextProperty(labelKey="APP_VERSION_LABEL", section=TextReportSectionName.REPORT_DETAILS, serializationClass=TextReportLabeledValue.class, valueHint=TextValueHint.METADATA)
    @HtmlProperty(labelKey="APP_VERSION_LABEL", section=HtmlReportSectionName.REPORT_DETAILS, isClassInfo=false)
    @CpatJsonPropertyDescription(value="Version of the Premigration Advisor Application in standard Oracle version number format with between 3 and 5 segments")
    private String appVersion;
    @CpatJsonPropertyDescription(value="The date-time Premigration Advisor Application was built in ISO_DATE_TIME format.For example: 2019-12-15T08:43:41Z")
    private Date appBuildDate;
    @TextProperty(labelKey="REPORT_DATE_LABEL", section=TextReportSectionName.REPORT_DETAILS, serializationClass=TextReportLabeledValue.class, valueHint=TextValueHint.METADATA)
    @HtmlProperty(labelKey="REPORT_DATE_LABEL", section=HtmlReportSectionName.REPORT_DETAILS, isClassInfo=false)
    @CpatJsonPropertyDescription(value="The date-time the analysis was done in ISO_DATE_TIME format. For example: 2019-12-15T08:43:41Z")
    private Date reportDate;
    @TextProperty(labelKey="REPORT_PDB_0_OPEN_LIST_LABEL", section=TextReportSectionName.REPORT_DETAILS, serializationClass=TextReportLabeledValue.class, valueHint=TextValueHint.METADATA)
    @CpatJsonPropertyDescription(value="The full set of open PDBs in the CDB")
    private List<String> openPDBs;
    @TextProperty(labelKey="REPORT_PDB_1_CLOSED_LIST_LABEL", section=TextReportSectionName.REPORT_DETAILS, serializationClass=TextReportLabeledValue.class, valueHint=TextValueHint.METADATA)
    @CpatJsonPropertyDescription(value="The full set of closed PDBs in the CDB")
    private List<String> closedPDBs;
    @TextProperty(labelKey="REPORT_PDB_2_ANALYSIS_LIST_LABEL", section=TextReportSectionName.REPORT_DETAILS, serializationClass=TextReportPdbSummaryList.class, valueHint=TextValueHint.METADATA)
    @HtmlProperty(labelKey="REPORT_PDB_2_ANALYSIS_LIST_LABEL", section=HtmlReportSectionName.REPORT_DETAILS, isClassInfo=false)
    @CpatJsonPropertyDescription(value="PDB Analysis Summaries")
    private List<PDBAnalysisSummary> pdbAnalysisResults = new ArrayList<PDBAnalysisSummary>();
    @CpatJsonPropertyDescription(value="The output folder path for files generated by CPAT source analysis. Reports, logfiles, and any other output files will be created at or below this ")
    private String absoluteOutputPath;
    @CpatJsonIgnoreIfNull
    @CpatJsonPropertyDescription(value="Message indicating what prevented the tool from completing the analysis. Only present when 'result' indicates a fatal error.")
    private String errorMessage;
    @CpatJsonPropertyDescription(value="The host name of the machine where the analysis is running")
    private String hostName;
    @CpatJsonIgnoreIfNull
    @HtmlProperty(labelKey="REPORT_DETAILS_COMMAND_LINE_LABEL_HTML", section=HtmlReportSectionName.REPORT_DETAILS, isClassInfo=false)
    @CpatJsonPropertyDescription(value="The resultant command line used to invoke the Cloud Premigration Advisor Tool")
    private String commandLineOptions;

    public String getAppVersion() {
        return this.appVersion;
    }

    public Date getAppBuildDate() {
        return this.appBuildDate;
    }

    public Date getReportDate() {
        return this.reportDate;
    }

    public List<String> getOpenPDBs() {
        return this.openPDBs;
    }

    public List<String> getClosedPDBs() {
        return this.closedPDBs;
    }

    public List<PDBAnalysisSummary> getPdbAnalysisResults() {
        return this.pdbAnalysisResults;
    }

    public String getAbsoluteOutputPath() {
        return this.absoluteOutputPath;
    }

    public String getHostName() {
        return this.hostName;
    }

    public void setAppVersion(String appVersion) {
        this.appVersion = appVersion;
    }

    public void setAppBuildDate(Date appBuildDate) {
        this.appBuildDate = appBuildDate;
    }

    public void setReportDate(Date reportDate) {
        this.reportDate = reportDate;
    }

    public void setOpenPDBs(List<String> openPDBs) {
        this.openPDBs = openPDBs;
    }

    public void setClosedPDBs(List<String> closedPDBs) {
        this.closedPDBs = closedPDBs;
    }

    public void setPdbAnalysisResults(List<PDBAnalysisSummary> pdbAnalysisResults) {
        this.pdbAnalysisResults = pdbAnalysisResults;
    }

    public void setAbsoluteOutputPath(String absoluteOutputPath) {
        this.absoluteOutputPath = absoluteOutputPath;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    public void setHostName(String hostName) {
        this.hostName = hostName;
    }

    public void setCommandLineOptions(String commandLineOptions) {
        this.commandLineOptions = commandLineOptions;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CDBReportSummary)) {
            return false;
        }
        CDBReportSummary other = (CDBReportSummary)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$appVersion = this.getAppVersion();
        String other$appVersion = other.getAppVersion();
        if (this$appVersion == null ? other$appVersion != null : !this$appVersion.equals(other$appVersion)) {
            return false;
        }
        Date this$appBuildDate = this.getAppBuildDate();
        Date other$appBuildDate = other.getAppBuildDate();
        if (this$appBuildDate == null ? other$appBuildDate != null : !((Object)this$appBuildDate).equals(other$appBuildDate)) {
            return false;
        }
        Date this$reportDate = this.getReportDate();
        Date other$reportDate = other.getReportDate();
        if (this$reportDate == null ? other$reportDate != null : !((Object)this$reportDate).equals(other$reportDate)) {
            return false;
        }
        List<String> this$openPDBs = this.getOpenPDBs();
        List<String> other$openPDBs = other.getOpenPDBs();
        if (this$openPDBs == null ? other$openPDBs != null : !((Object)this$openPDBs).equals(other$openPDBs)) {
            return false;
        }
        List<String> this$closedPDBs = this.getClosedPDBs();
        List<String> other$closedPDBs = other.getClosedPDBs();
        if (this$closedPDBs == null ? other$closedPDBs != null : !((Object)this$closedPDBs).equals(other$closedPDBs)) {
            return false;
        }
        List<PDBAnalysisSummary> this$pdbAnalysisResults = this.getPdbAnalysisResults();
        List<PDBAnalysisSummary> other$pdbAnalysisResults = other.getPdbAnalysisResults();
        if (this$pdbAnalysisResults == null ? other$pdbAnalysisResults != null : !((Object)this$pdbAnalysisResults).equals(other$pdbAnalysisResults)) {
            return false;
        }
        String this$absoluteOutputPath = this.getAbsoluteOutputPath();
        String other$absoluteOutputPath = other.getAbsoluteOutputPath();
        if (this$absoluteOutputPath == null ? other$absoluteOutputPath != null : !this$absoluteOutputPath.equals(other$absoluteOutputPath)) {
            return false;
        }
        String this$errorMessage = this.getErrorMessage();
        String other$errorMessage = other.getErrorMessage();
        if (this$errorMessage == null ? other$errorMessage != null : !this$errorMessage.equals(other$errorMessage)) {
            return false;
        }
        String this$hostName = this.getHostName();
        String other$hostName = other.getHostName();
        if (this$hostName == null ? other$hostName != null : !this$hostName.equals(other$hostName)) {
            return false;
        }
        String this$commandLineOptions = this.getCommandLineOptions();
        String other$commandLineOptions = other.getCommandLineOptions();
        return !(this$commandLineOptions == null ? other$commandLineOptions != null : !this$commandLineOptions.equals(other$commandLineOptions));
    }

    protected boolean canEqual(Object other) {
        return other instanceof CDBReportSummary;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $appVersion = this.getAppVersion();
        result = result * 59 + ($appVersion == null ? 43 : $appVersion.hashCode());
        Date $appBuildDate = this.getAppBuildDate();
        result = result * 59 + ($appBuildDate == null ? 43 : ((Object)$appBuildDate).hashCode());
        Date $reportDate = this.getReportDate();
        result = result * 59 + ($reportDate == null ? 43 : ((Object)$reportDate).hashCode());
        List<String> $openPDBs = this.getOpenPDBs();
        result = result * 59 + ($openPDBs == null ? 43 : ((Object)$openPDBs).hashCode());
        List<String> $closedPDBs = this.getClosedPDBs();
        result = result * 59 + ($closedPDBs == null ? 43 : ((Object)$closedPDBs).hashCode());
        List<PDBAnalysisSummary> $pdbAnalysisResults = this.getPdbAnalysisResults();
        result = result * 59 + ($pdbAnalysisResults == null ? 43 : ((Object)$pdbAnalysisResults).hashCode());
        String $absoluteOutputPath = this.getAbsoluteOutputPath();
        result = result * 59 + ($absoluteOutputPath == null ? 43 : $absoluteOutputPath.hashCode());
        String $errorMessage = this.getErrorMessage();
        result = result * 59 + ($errorMessage == null ? 43 : $errorMessage.hashCode());
        String $hostName = this.getHostName();
        result = result * 59 + ($hostName == null ? 43 : $hostName.hashCode());
        String $commandLineOptions = this.getCommandLineOptions();
        result = result * 59 + ($commandLineOptions == null ? 43 : $commandLineOptions.hashCode());
        return result;
    }

    public String toString() {
        return "CDBReportSummary(appVersion=" + this.getAppVersion() + ", appBuildDate=" + this.getAppBuildDate() + ", reportDate=" + this.getReportDate() + ", openPDBs=" + this.getOpenPDBs() + ", closedPDBs=" + this.getClosedPDBs() + ", pdbAnalysisResults=" + this.getPdbAnalysisResults() + ", absoluteOutputPath=" + this.getAbsoluteOutputPath() + ", errorMessage=" + this.getErrorMessage() + ", hostName=" + this.getHostName() + ", commandLineOptions=" + this.getCommandLineOptions() + ")";
    }

    @CpatJsonIgnoreIfNull
    public String getErrorMessage() {
        return this.errorMessage;
    }

    @CpatJsonIgnoreIfNull
    public String getCommandLineOptions() {
        return this.commandLineOptions;
    }
}

