/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.premigration.loadpwd.security.keystorage;

import com.oracle.premigration.commons.EnvironmentContext;
import com.oracle.premigration.exceptions.PremigrationException;
import com.oracle.premigration.helpers.Utilities;
import com.oracle.premigration.loadpwd.security.keystorage.KeyStorage;
import com.oracle.premigration.loadpwd.security.keystorage.KeyStoreManager;
import com.oracle.premigration.loadpwd.security.keystorage.PasswordConsumer;
import com.oracle.premigration.logger.PremigrationLogger;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import oracle.security.pki.OracleSecretStoreException;

public class PopulatedKeyStore
extends KeyStorage {
    private static final PremigrationLogger log = PremigrationLogger.getLogger(PopulatedKeyStore.class.getName());
    protected final KeyStoreManager keyStoreManager;

    public PopulatedKeyStore(Path keyStore, EnvironmentContext envCtx) throws PremigrationException {
        this(keyStore, null, envCtx);
    }

    public PopulatedKeyStore(Path keyStore, char[] pw, EnvironmentContext envCtx) throws PremigrationException {
        this.keyStoreManager = new KeyStoreManager(keyStore, envCtx);
        this.load(pw);
    }

    public PopulatedKeyStore(KeyStoreManager keyStoreManager) {
        this.keyStoreManager = keyStoreManager;
    }

    void load(char[] pw) throws PremigrationException {
        this.keyStoreManager.load(pw);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void usePassword(PasswordConsumer passwordConsumer, String keystoreAlias) throws PremigrationException {
        char[] pw = null;
        try {
            pw = this.getPassword(keystoreAlias);
            passwordConsumer.usePassword(pw);
        }
        finally {
            Utilities.clearCharArray(pw);
        }
    }

    @Override
    public Optional<Path> getKeyStoreDir() {
        return Optional.of(Paths.get(this.keyStoreManager.getKeyStoreDir(), new String[0]));
    }

    @Override
    public List<String> getAllAliases() throws PremigrationException {
        try {
            return Collections.list(this.keyStoreManager.getOracleWallet().getSecretStore().internalAliases());
        }
        catch (IOException | OracleSecretStoreException e) {
            throw new PremigrationException("Keystore operation failed", e);
        }
    }

    private char[] getPassword(String keystoreAlias) throws PremigrationException {
        if (keystoreAlias == null) {
            return null;
        }
        try {
            return this.keyStoreManager.getOracleWallet().getSecretStore().getSecret(keystoreAlias);
        }
        catch (IOException | OracleSecretStoreException e) {
            throw new PremigrationException("Keystore operation failed", e);
        }
    }
}

