/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.premigration.loadpwd.security.keystorage;

import com.oracle.premigration.commons.EnvironmentContext;
import com.oracle.premigration.commons.lang.Language;
import com.oracle.premigration.exceptions.PremigrationException;
import com.oracle.premigration.loadpwd.security.keystorage.EmptyKeyStore;
import com.oracle.premigration.loadpwd.security.keystorage.ModifiableKeyStore;
import com.oracle.premigration.loadpwd.security.keystorage.PasswordConsumer;
import com.oracle.premigration.loadpwd.security.keystorage.PopulatedKeyStore;
import com.oracle.premigration.loadpwd.security.pojos.WalletFile;
import com.oracle.premigration.logger.PremigrationLogger;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public abstract class KeyStorage {
    private static final PremigrationLogger log = PremigrationLogger.getLogger(KeyStorage.class.getName());
    private static KeyStorage instance = null;
    private static final Language lang = Language.getInstance();

    protected KeyStorage() {
    }

    public static void setKeyStore(Path keyStore, boolean isLoadPassword, EnvironmentContext envCtx) throws PremigrationException {
        boolean eWalletFileExists;
        if (instance != null) {
            throw new IllegalStateException();
        }
        boolean bl = eWalletFileExists = keyStore != null && Files.exists(WalletFile.EWALLET.getFileName(keyStore.toString()), new LinkOption[0]);
        instance = eWalletFileExists ? (isLoadPassword ? ModifiableKeyStore.newInstanceForExistingKeystore(keyStore, envCtx) : new PopulatedKeyStore(keyStore, envCtx)) : (keyStore == null || isLoadPassword ? new EmptyKeyStore(keyStore) : new EmptyKeyStore(keyStore));
        log.info(lang.txt("KS_CREATED"));
    }

    static void replaceKeyStore(KeyStorage keyStore) {
        KeyStorage.reset();
        instance = keyStore;
        log.info(lang.txt("KS_CREATED"));
    }

    public static void reset() {
        instance = null;
    }

    public abstract void usePassword(PasswordConsumer var1, String var2) throws PremigrationException;

    public static KeyStorage getInstance() {
        return Objects.requireNonNull(instance);
    }

    public abstract Optional<Path> getKeyStoreDir();

    public abstract List<String> getAllAliases() throws PremigrationException;
}

