/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.premigration.loadpwd.helpers;

import com.oracle.premigration.dbinspector.CheckResult;
import com.oracle.premigration.helpers.Utilities;
import com.oracle.premigration.loadpwd.helpers.Job;
import com.oracle.premigration.logger.PremigrationLogger;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Arrays;

public class PremigrationAppRunner
implements Runnable {
    private static final PremigrationLogger log = PremigrationLogger.getLogger(PremigrationAppRunner.class.getName());
    private static final String SPACE = " ";
    private final String[] commands;
    private final char[] password;
    private final String name;
    private final Job job;
    private Integer exitCode = -1;
    Long elapsedMilliSeconds = null;

    public PremigrationAppRunner(String[] commands, char[] password, String pdbName, Job job) {
        this.commands = commands;
        this.password = Arrays.copyOf(password, password.length);
        this.name = pdbName;
        this.job = job;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        long startTime = System.currentTimeMillis();
        String logPrefix = "Running analysis on namespace: " + this.name;
        try {
            Process cpatProcess = Runtime.getRuntime().exec(this.commands);
            if (this.password != null) {
                for (char c : this.password) {
                    cpatProcess.getOutputStream().write(c);
                }
                cpatProcess.getOutputStream().write(10);
                cpatProcess.getOutputStream().flush();
            }
            try (BufferedReader stdInput = new BufferedReader(new InputStreamReader(cpatProcess.getInputStream()));
                 BufferedReader stdError = new BufferedReader(new InputStreamReader(cpatProcess.getErrorStream()));){
                String s;
                while ((s = stdInput.readLine()) != null) {
                    log.info(logPrefix + SPACE + s);
                }
                while ((s = stdError.readLine()) != null) {
                    log.info(logPrefix + SPACE + s);
                }
            }
            this.exitCode = cpatProcess.waitFor();
            log.info(logPrefix + " exitCode = " + this.exitCode);
            this.elapsedMilliSeconds = System.currentTimeMillis() - startTime;
            log.fine(logPrefix + " Elapsed time running CPAT statement: " + Utilities.formatTimeInterval(this.elapsedMilliSeconds));
            if (CheckResult.FATAL.getExitCode() == this.exitCode.intValue()) {
                this.job.setStage(Job.Stage.FAILED);
            } else {
                this.job.setStage(Job.Stage.ANALYZED);
            }
            this.job.setStatus(Job.Status.DONE);
            log.info("Job completed.");
        }
        catch (IOException | InterruptedException e) {
            log.severe("Exception during analysis, Name Space " + this.name, e);
            this.exitCode = CheckResult.FATAL.getExitCode();
            this.job.setStage(Job.Stage.FAILED);
            if (e instanceof InterruptedException) {
                Thread.currentThread().interrupt();
            }
        }
        finally {
            Utilities.clearCharArray(this.password);
        }
    }

    public Integer getExitCode() {
        return this.exitCode;
    }

    public String getName() {
        return this.name;
    }
}

