/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.premigration.loadpwd;

import com.oracle.premigration.PremigrationApp;
import com.oracle.premigration.api.Premigration;
import com.oracle.premigration.cli.CliOption;
import com.oracle.premigration.cli.CommandLineArgs;
import com.oracle.premigration.cli.configuration.ConfigurationFile;
import com.oracle.premigration.cli.configuration.ConfigurationFileReader;
import com.oracle.premigration.cli.configuration.NameSpace;
import com.oracle.premigration.commons.EnvironmentContext;
import com.oracle.premigration.commons.io.OutputFilenamesContainer;
import com.oracle.premigration.commons.lang.Language;
import com.oracle.premigration.exceptions.AccessDeniedException;
import com.oracle.premigration.exceptions.PremigrationException;
import com.oracle.premigration.helpers.AppVersion;
import com.oracle.premigration.helpers.Utilities;
import com.oracle.premigration.loadpwd.helpers.Command;
import com.oracle.premigration.loadpwd.helpers.Job;
import com.oracle.premigration.loadpwd.helpers.PremigrationAppRunner;
import com.oracle.premigration.loadpwd.helpers.TablePrinter;
import com.oracle.premigration.loadpwd.security.keystorage.KeyStorage;
import com.oracle.premigration.loadpwd.security.keystorage.PasswordConsole;
import com.oracle.premigration.loadpwd.security.pojos.KeystoreEntryAdderUser;
import com.oracle.premigration.logger.PremigrationLogger;
import java.io.Console;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import oracle.jdbc.OracleDriver;
import org.apache.commons.cli.ParseException;

public class CliMode {
    private static final PremigrationLogger log = PremigrationLogger.getLogger(CliMode.class.getName());
    private static final Map<Integer, Job> jobs = new HashMap<Integer, Job>();
    private static final Language lang = Language.getInstance();
    public static final String DEFAULT_PREFIX = "cpat_cli_mode";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void start(CommandLineArgs parsedCla, EnvironmentContext envCtx) {
        PremigrationLogger log = null;
        String outputPath = parsedCla.getOutdir();
        String outFilePrefix = CliMode.getOutFilePrefix(parsedCla.getOutFilePrefix());
        OutputFilenamesContainer outputFilenamesContainer = new OutputFilenamesContainer(outFilePrefix, parsedCla.getOutdir());
        try {
            String logFilePath = outputFilenamesContainer.getValidatedLogFilePath();
            PremigrationLogger.newConfig(logFilePath, parsedCla.getLoggingLevel(), envCtx.getCommandInvocationMode());
            log = PremigrationLogger.getLogger(CliMode.class.getName());
            if (Utilities.isWindows()) {
                String warningMessage = Utilities.getErrorText("ERROR5001", new String[0]);
                Utilities.printAndLogMessage(warningMessage, envCtx, Level.INFO);
                return;
            }
            ConfigurationFileReader configurationFileReader = new ConfigurationFileReader(parsedCla.getConfigurationFile());
            if (configurationFileReader.getNoPrefixConfigurationFile() != null) {
                String[] args = configurationFileReader.getNoPrefixConfigurationFile().getArguments();
                new PremigrationApp().runFromCLI(args);
            }
            List<NameSpace> nameSpaceConfigurations = CliMode.loadNamespaces(parsedCla, envCtx);
            CliMode.createJobs(nameSpaceConfigurations);
            ConfigurationFile<List<NameSpace>> configurationFile = configurationFileReader.getPrefixConfigurationFile();
            try {
                KeyStorage.setKeyStore(configurationFile.getAndValidateKeyStore(outputPath), parsedCla.isLoadPassword(), envCtx);
            }
            catch (NullPointerException e) {
                String warningMessage = Utilities.getErrorText("ERROR5000", new String[0]);
                Utilities.printAndLogErrorMessage(warningMessage, envCtx, Level.INFO, e);
                if (log != null) {
                    log.shutdown();
                }
                return;
            }
            String banner = lang.txt("APP_CLI_MODE_BANNER_MSG");
            Utilities.printAndLogMessage(banner, envCtx, Level.INFO);
            log.info("Days since the jar was built: " + AppVersion.getAppAgeInDays());
            Utilities.logEnvironmentVariables();
            Utilities.logJavaProperties();
            Utilities.logMemorySize(envCtx);
            log.info("JDBC Driver Version: " + OracleDriver.getDriverVersion());
            if (parsedCla.isLoadPassword()) {
                CliMode.loadPassword(envCtx);
                return;
            }
            LinkedBlockingQueue<Runnable> threadQueue = new LinkedBlockingQueue<Runnable>();
            int threadPoolSize = CliMode.getThreadPoolSize(parsedCla.getMaxSubprocesses());
            ThreadPoolExecutor executor = new ThreadPoolExecutor(threadPoolSize, threadPoolSize, 0L, TimeUnit.MILLISECONDS, threadQueue);
            Runtime.getRuntime().addShutdownHook(new Thread(executor::shutdown));
            if (parsedCla.isNoConsole()) {
                CliMode.noConsole(envCtx, executor, outputPath);
            } else {
                CliMode.cliMode(envCtx, executor, outputPath);
            }
        }
        catch (AccessDeniedException | IOException e) {
            String ioErrorMsg = PremigrationLogger.isLoggerInitialized() ? Utilities.getErrorText("ERROR3000", e, new String[0]) : Utilities.getErrorTextNoAction("ERROR3000", e, new String[0]);
            CliMode.commonErrorHandling(log, envCtx, ioErrorMsg, e);
        }
        catch (Exception e) {
            String fatalMsg = Utilities.getErrorText("ERROR1005", e, new String[0]);
            CliMode.commonErrorHandling(log, envCtx, fatalMsg, e);
            if (e instanceof ArithmeticException) {
                String msg = lang.txt("APP_POSSIBLE_EXPIRED_ACCOUNT_MSG");
                Utilities.printAndLogErrorMessage(msg, envCtx, Level.SEVERE);
            }
        }
        finally {
            if (log != null) {
                log.shutdown();
            }
        }
    }

    private static void cliMode(EnvironmentContext envCtx, ThreadPoolExecutor executor, String outputPath) throws PremigrationException {
        Scanner scanner = new Scanner(System.in);
        while (true) {
            System.out.print(lang.txt("APP_CLI_MODE_SYMBOL"));
            String commandString = scanner.nextLine().trim().toLowerCase();
            try {
                Command command = Command.valueOf(commandString.split(" ")[0].toUpperCase());
                switch (command) {
                    case EXIT: {
                        Utilities.printAndLogMessage(lang.txt("APP_CLI_MODE_EXIT"), envCtx, Level.INFO);
                        scanner.close();
                        return;
                    }
                    case LSJ: {
                        CliMode.listJobs();
                        break;
                    }
                    case HELP: {
                        CliMode.showHelp(envCtx);
                        break;
                    }
                    case RUN: {
                        String allCommand = commandString.split(" ")[1].toUpperCase();
                        if (Command.ALL.name().equalsIgnoreCase(allCommand)) {
                            CliMode.runJob(envCtx, executor, outputPath, false);
                            break;
                        }
                        String namespace = commandString.split(" ")[1];
                        CliMode.runJob(namespace, envCtx, executor, outputPath);
                        break;
                    }
                    default: {
                        Utilities.printAndLogErrorMessage("APP_CLI_MODE_INVALID_COMMAND", envCtx, Level.INFO);
                        break;
                    }
                }
                continue;
            }
            catch (IllegalArgumentException e) {
                Utilities.printAndLogMessage(lang.txt("APP_CLI_MODE_INVALID_COMMAND"), envCtx, Level.INFO);
                continue;
            }
            break;
        }
    }

    private static void loadPassword(EnvironmentContext envCtx) throws PremigrationException, IOException {
        System.out.println();
        Utilities.printAndLogMessage(lang.txt("PC_STARTING"), envCtx, Level.INFO);
        ArrayList<Job> jobList = new ArrayList<Job>();
        for (Map.Entry<Integer, Job> entry : jobs.entrySet()) {
            Job job = entry.getValue();
            jobList.add(job);
        }
        new PasswordConsole(envCtx, jobList).runKeyStoreConsole();
    }

    private static void noConsole(EnvironmentContext envCtx, ThreadPoolExecutor executor, String outputPath) throws PremigrationException {
        CliMode.runJob(envCtx, executor, outputPath, true);
        executor.shutdown();
        if (executor.getQueue().isEmpty() && executor.getActiveCount() == 0) {
            return;
        }
        try {
            do {
                Utilities.printAndLogMessage(CliMode.getProgressMessage(executor), envCtx, Level.INFO);
            } while (!executor.awaitTermination(10L, TimeUnit.SECONDS));
        }
        catch (InterruptedException e) {
            String errorMessage = Utilities.getErrorText("ERROR2008", new String[0]);
            Utilities.printAndLogErrorMessage(errorMessage, envCtx, Level.SEVERE, e);
            log.warning("There were " + (executor.getTaskCount() - executor.getCompletedTaskCount()) + " tasks that were not completed");
            Thread.currentThread().interrupt();
        }
        Utilities.printAndLogMessage(CliMode.getProgressMessage(executor), envCtx, Level.INFO);
    }

    private static String getProgressMessage(ThreadPoolExecutor executor) {
        long taskCount = executor.getTaskCount();
        long activeCount = executor.getActiveCount();
        long completedCount = executor.getCompletedTaskCount();
        String localDateTime = Utilities.getLocalizedDateTimeString(new Date());
        return lang.txt("APP_CLI_PROGRESS_SPAWNED_TASKS", completedCount, taskCount, localDateTime, activeCount);
    }

    private static void showHelp(EnvironmentContext envCtx) {
        String helpText = lang.txt("APP_CLI_MODE_HELP_INFO");
        Utilities.printAndLogMessage(helpText, envCtx, Level.INFO);
    }

    private static void listJobs() {
        ArrayList<String[]> rows = new ArrayList<String[]>();
        rows.add(new String[]{"ID", "DB_NAME", "STAGE", "STATUS"});
        for (Map.Entry<Integer, Job> entry : jobs.entrySet()) {
            int jobId = entry.getKey();
            Job job = entry.getValue();
            String[] row = new String[]{jobId + "", job.getDbName(), job.getStage().name(), job.getStatus().get().name()};
            rows.add(row);
        }
        TablePrinter.printTable(rows);
    }

    private static void runJob(EnvironmentContext envCtx, ThreadPoolExecutor executor, String outputPath, boolean noConsole) throws PremigrationException {
        for (Map.Entry<Integer, Job> entry : jobs.entrySet()) {
            int jobId = entry.getKey();
            CliMode.runJob(jobId, envCtx, executor, outputPath, noConsole);
        }
    }

    private static void runJob(String nameSpace, EnvironmentContext envCtx, ThreadPoolExecutor executor, String outputPath) throws PremigrationException {
        for (Map.Entry<Integer, Job> entry : jobs.entrySet()) {
            int jobId = entry.getKey();
            Job job = entry.getValue();
            if (!job.getNameSpace().getName().equals(nameSpace)) continue;
            CliMode.runJob(jobId, envCtx, executor, outputPath, false);
        }
    }

    private static void runJob(int jobId, EnvironmentContext envCtx, ThreadPoolExecutor executor, String outputPath, boolean noConsole) throws PremigrationException {
        Job job = jobs.get(jobId);
        String usernameCommandLine = job.getNameSpace().getArgumentValue("--username");
        if (job == null) {
            System.out.println("Job " + jobId + " not found.");
            return;
        }
        KeyStorage keyStore = KeyStorage.getInstance();
        String username = PasswordConsole.lookUpPasswordInfo(job.getNameSpace().getName(), usernameCommandLine);
        String globalUsername = PasswordConsole.lookUpPasswordInfo("global", usernameCommandLine);
        if (!job.setStatus(Job.Status.RUNNING)) {
            System.out.println("Job " + jobId + " is already " + job.getStatus() + ".");
            return;
        }
        String[] args = job.getNameSpace().getArgs();
        String name = job.getDbName();
        String[] premigrationScript = CliMode.getPremigrationScriptPath(envCtx, outputPath, args, name);
        if (" ".equalsIgnoreCase(username) && " ".equalsIgnoreCase(globalUsername) && !noConsole) {
            CliMode.runnerRequestPassword(job, premigrationScript, executor);
        } else if (!" ".equalsIgnoreCase(globalUsername)) {
            CliMode.runnerKeyStoreGlobal(job, globalUsername, keyStore, premigrationScript, executor);
        } else {
            CliMode.runnerKeyStore(job, username, keyStore, premigrationScript, executor);
        }
    }

    public static void runnerRequestPassword(Job job, String[] premigrationScript, ThreadPoolExecutor executor) {
        String[] args = job.getNameSpace().getArgs();
        String name = job.getDbName();
        char[] password = CliMode.getPassword(name, args);
        PremigrationAppRunner thread = new PremigrationAppRunner(premigrationScript, password, name, job);
        log.info("Calling executor with thread for the name space named " + name);
        executor.submit(thread);
    }

    public static void runnerKeyStore(Job job, String username, KeyStorage keyStore, String[] premigrationScript, ThreadPoolExecutor executor) throws PremigrationException {
        String name = job.getDbName();
        String alias = PasswordConsole.getAlias(job.getNameSpace().getName(), username);
        if (!PasswordConsole.existsPasswordInfo(alias)) {
            String errorMsg = "Namespace: '" + job.getNameSpace().getName() + "' is not saved in the keystore";
            System.out.println(errorMsg);
            log.warning(errorMsg);
            return;
        }
        keyStore.usePassword(pw -> {
            PremigrationAppRunner thread = new PremigrationAppRunner(premigrationScript, pw, name, job);
            log.info("Calling executor with thread for the name space named " + name);
            executor.submit(thread);
            System.out.println("Running job " + job.getNameSpace().getName() + "...");
        }, alias);
    }

    public static void runnerKeyStoreGlobal(Job job, String username, KeyStorage keyStore, String[] premigrationScript, ThreadPoolExecutor executor) throws PremigrationException {
        String name = job.getDbName();
        String alias = PasswordConsole.getAlias("global", username);
        keyStore.usePassword(pw -> {
            try {
                if (KeystoreEntryAdderUser.verifyPassword(job.getNameSpace(), job.getNameSpace().getArgumentValue("--username"), pw)) {
                    String passwordSavedIsNotValid = lang.txt("API_CLI_PASSWORD_SAVED_IS_NOT_VALID", job.getNameSpace().getArgumentValue("--username"));
                    log.info(passwordSavedIsNotValid);
                    CliMode.runnerRequestPassword(job, premigrationScript, executor);
                    return;
                }
            }
            catch (SQLException | ParseException e) {
                e.printStackTrace();
                return;
            }
            PremigrationAppRunner thread = new PremigrationAppRunner(premigrationScript, pw, name, job);
            log.info("Calling executor with thread for the name space named " + name);
            executor.submit(thread);
            System.out.println("Running job " + job.getNameSpace().getName() + "...");
        }, alias);
    }

    private static int getThreadPoolSize(Integer commandLineMaxSubProcesses) {
        int threadPoolSize;
        if (commandLineMaxSubProcesses != null) {
            threadPoolSize = commandLineMaxSubProcesses;
        } else {
            int numberOfCores = Runtime.getRuntime().availableProcessors();
            threadPoolSize = numberOfCores * 2;
        }
        return Math.max(threadPoolSize, 1);
    }

    private static String[] getPremigrationScriptPath(EnvironmentContext envCtx, String outDir, String[] args, String name) throws PremigrationException {
        try {
            String basePath = CliMode.getPremigrationLocation();
            String cpatCommand = basePath + File.separator + Utilities.getPremigrationCommand();
            ArrayList<String> cpatCommandLine = new ArrayList<String>();
            cpatCommandLine.add(cpatCommand);
            cpatCommandLine.addAll(Arrays.asList(args));
            if (!cpatCommandLine.contains(CliOption.OUTDIR.getDashedLongOpt())) {
                cpatCommandLine.add(CliOption.OUTDIR.getDashedLongOpt());
                cpatCommandLine.add(CliMode.getOutputPath(outDir, name));
            }
            return cpatCommandLine.toArray(new String[0]);
        }
        catch (URISyntaxException e) {
            String errorText = Utilities.getErrorText("ERROR4009", new String[0]);
            Utilities.printAndLogErrorMessage(errorText, envCtx, Level.SEVERE, e);
            throw new PremigrationException(errorText, e);
        }
    }

    private static String getPremigrationLocation() throws URISyntaxException {
        URI jarLocation = Premigration.class.getProtectionDomain().getCodeSource().getLocation().toURI();
        File jarFile = new File(jarLocation);
        return jarFile.getParentFile().getParentFile().getPath();
    }

    private static List<NameSpace> loadNamespaces(CommandLineArgs parsedCla, EnvironmentContext envCtx) {
        try {
            ConfigurationFileReader configurationFileReader = new ConfigurationFileReader(parsedCla.getConfigurationFile());
            return configurationFileReader.getPrefixConfigurationFile().getArguments();
        }
        catch (PremigrationException e) {
            envCtx.getErrWriter().println(e.getMessage());
            if (e.getCause() != null) {
                envCtx.getErrWriter().println(e.getCause().getMessage());
            }
            return Collections.emptyList();
        }
    }

    private static char[] getPassword(String name, String[] args) {
        ArrayList<String> cpatCommandLine = new ArrayList<String>(Arrays.asList(args));
        if (!cpatCommandLine.contains(CliOption.USERNAME.getDashedLongOpt())) {
            return new char[0];
        }
        int usernameIndex = cpatCommandLine.indexOf(CliOption.USERNAME.getDashedLongOpt());
        String username = (String)cpatCommandLine.get(usernameIndex + 1);
        String promptPassword = lang.txt("PASSWORD_PROMPT_MSG", username);
        String promptNamespace = lang.txt("APP_CLI_MODE_PASSWORD_PROMPT_MSG", name, promptPassword);
        Console console = System.console();
        if (console != null) {
            return console.readPassword(promptNamespace, new Object[0]);
        }
        System.out.print(promptNamespace);
        Scanner sysInScanner = new Scanner(System.in);
        System.out.println();
        char[] password = sysInScanner.hasNext() ? sysInScanner.next().toCharArray() : "".toCharArray();
        return password;
    }

    private static void createJobs(List<NameSpace> nameSpaceConfigurations) {
        int jobId = 0;
        for (NameSpace nameSpace : nameSpaceConfigurations) {
            String dbName = nameSpace.getName();
            Job job = new Job(dbName, Job.Stage.NOT_ANALYZED, Job.Status.WAITING, nameSpace);
            jobs.put(++jobId, job);
        }
    }

    private static void commonErrorHandling(PremigrationLogger log, EnvironmentContext envCtx, String errorMsg, Throwable t) {
        envCtx.getErrWriter().println(errorMsg);
        if (log != null) {
            log.severe(errorMsg, t);
        }
    }

    private static String getOutputPath(String outDir, String name) {
        return outDir + File.separator + name;
    }

    private static String getOutFilePrefix(String OutFilePrefix) {
        if (OutFilePrefix == null || OutFilePrefix.isEmpty()) {
            return DEFAULT_PREFIX;
        }
        return OutFilePrefix;
    }
}

