/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.premigration.helpers;

import com.oracle.premigration.reports.filters.FilterCriteria;
import com.oracle.premigration.reports.filters.RelevantObjectFilter;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class ResultSetProcessor {
    private ResultSetProcessor() {
    }

    public static RSProcessorOutputs processResultSet(RSProcessorInputs inputs) throws SQLException {
        ResultSet rs = inputs.getResultSet();
        FilterCriteria filterCriteria = inputs.getFilterCriteria();
        RelevantObjectFilter filter = inputs.getFilter();
        int maxRelevantObjects = inputs.getMaxRelevantObjects() == null ? -1 : inputs.getMaxRelevantObjects();
        ResultSetMetaData metaData = rs.getMetaData();
        int columnCount = metaData.getColumnCount();
        String[] columnName = new String[columnCount];
        for (int i = 1; i <= columnCount; ++i) {
            columnName[i - 1] = metaData.getColumnLabel(i);
        }
        ArrayList<Map<String, String>> relevantObjects = new ArrayList<Map<String, String>>();
        ArrayList<Map<String, String>> filteredObjects = new ArrayList<Map<String, String>>();
        boolean filteredObjectCapReached = maxRelevantObjects != 0;
        int omittedFilteredObjectsCount = 0;
        while (rs.next()) {
            LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
            for (int i = 1; i <= columnCount; ++i) {
                map.put(columnName[i - 1], rs.getString(i));
                if (!rs.wasNull()) continue;
                map.put(columnName[i - 1], "");
            }
            if (filterCriteria == null || filter.acceptRelevantObject(map, filterCriteria)) {
                relevantObjects.add(map);
                continue;
            }
            if (!filteredObjectCapReached) {
                filteredObjects.add(map);
                filteredObjectCapReached = filteredObjects.size() == maxRelevantObjects;
                continue;
            }
            ++omittedFilteredObjectsCount;
        }
        return RSProcessorOutputs.builder().relevantObjects(relevantObjects).filteredObjects(filteredObjects).omittedFilteredObjectsCount(omittedFilteredObjectsCount).build();
    }

    public static final class RSProcessorInputs {
        private final ResultSet resultSet;
        private final Integer maxRelevantObjects;
        private final RelevantObjectFilter filter;
        private final FilterCriteria filterCriteria;

        RSProcessorInputs(ResultSet resultSet, Integer maxRelevantObjects, RelevantObjectFilter filter, FilterCriteria filterCriteria) {
            this.resultSet = resultSet;
            this.maxRelevantObjects = maxRelevantObjects;
            this.filter = filter;
            this.filterCriteria = filterCriteria;
        }

        public static RSProcessorInputsBuilder builder() {
            return new RSProcessorInputsBuilder();
        }

        public ResultSet getResultSet() {
            return this.resultSet;
        }

        public Integer getMaxRelevantObjects() {
            return this.maxRelevantObjects;
        }

        public RelevantObjectFilter getFilter() {
            return this.filter;
        }

        public FilterCriteria getFilterCriteria() {
            return this.filterCriteria;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof RSProcessorInputs)) {
                return false;
            }
            RSProcessorInputs other = (RSProcessorInputs)o;
            Integer this$maxRelevantObjects = this.getMaxRelevantObjects();
            Integer other$maxRelevantObjects = other.getMaxRelevantObjects();
            if (this$maxRelevantObjects == null ? other$maxRelevantObjects != null : !((Object)this$maxRelevantObjects).equals(other$maxRelevantObjects)) {
                return false;
            }
            ResultSet this$resultSet = this.getResultSet();
            ResultSet other$resultSet = other.getResultSet();
            if (this$resultSet == null ? other$resultSet != null : !this$resultSet.equals(other$resultSet)) {
                return false;
            }
            RelevantObjectFilter this$filter = this.getFilter();
            RelevantObjectFilter other$filter = other.getFilter();
            if (this$filter == null ? other$filter != null : !this$filter.equals(other$filter)) {
                return false;
            }
            FilterCriteria this$filterCriteria = this.getFilterCriteria();
            FilterCriteria other$filterCriteria = other.getFilterCriteria();
            return !(this$filterCriteria == null ? other$filterCriteria != null : !((Object)this$filterCriteria).equals(other$filterCriteria));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Integer $maxRelevantObjects = this.getMaxRelevantObjects();
            result = result * 59 + ($maxRelevantObjects == null ? 43 : ((Object)$maxRelevantObjects).hashCode());
            ResultSet $resultSet = this.getResultSet();
            result = result * 59 + ($resultSet == null ? 43 : $resultSet.hashCode());
            RelevantObjectFilter $filter = this.getFilter();
            result = result * 59 + ($filter == null ? 43 : $filter.hashCode());
            FilterCriteria $filterCriteria = this.getFilterCriteria();
            result = result * 59 + ($filterCriteria == null ? 43 : ((Object)$filterCriteria).hashCode());
            return result;
        }

        public String toString() {
            return "ResultSetProcessor.RSProcessorInputs(resultSet=" + this.getResultSet() + ", maxRelevantObjects=" + this.getMaxRelevantObjects() + ", filter=" + this.getFilter() + ", filterCriteria=" + this.getFilterCriteria() + ")";
        }

        public static class RSProcessorInputsBuilder {
            private ResultSet resultSet;
            private Integer maxRelevantObjects;
            private RelevantObjectFilter filter;
            private FilterCriteria filterCriteria;

            RSProcessorInputsBuilder() {
            }

            public RSProcessorInputsBuilder resultSet(ResultSet resultSet) {
                this.resultSet = resultSet;
                return this;
            }

            public RSProcessorInputsBuilder maxRelevantObjects(Integer maxRelevantObjects) {
                this.maxRelevantObjects = maxRelevantObjects;
                return this;
            }

            public RSProcessorInputsBuilder filter(RelevantObjectFilter filter) {
                this.filter = filter;
                return this;
            }

            public RSProcessorInputsBuilder filterCriteria(FilterCriteria filterCriteria) {
                this.filterCriteria = filterCriteria;
                return this;
            }

            public RSProcessorInputs build() {
                return new RSProcessorInputs(this.resultSet, this.maxRelevantObjects, this.filter, this.filterCriteria);
            }

            public String toString() {
                return "ResultSetProcessor.RSProcessorInputs.RSProcessorInputsBuilder(resultSet=" + this.resultSet + ", maxRelevantObjects=" + this.maxRelevantObjects + ", filter=" + this.filter + ", filterCriteria=" + this.filterCriteria + ")";
            }
        }
    }

    public static final class RSProcessorOutputs {
        private final List<Map<String, String>> relevantObjects;
        private final List<Map<String, String>> filteredObjects;
        private final Integer omittedFilteredObjectsCount;

        RSProcessorOutputs(List<Map<String, String>> relevantObjects, List<Map<String, String>> filteredObjects, Integer omittedFilteredObjectsCount) {
            this.relevantObjects = relevantObjects;
            this.filteredObjects = filteredObjects;
            this.omittedFilteredObjectsCount = omittedFilteredObjectsCount;
        }

        public static RSProcessorOutputsBuilder builder() {
            return new RSProcessorOutputsBuilder();
        }

        public List<Map<String, String>> getRelevantObjects() {
            return this.relevantObjects;
        }

        public List<Map<String, String>> getFilteredObjects() {
            return this.filteredObjects;
        }

        public Integer getOmittedFilteredObjectsCount() {
            return this.omittedFilteredObjectsCount;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof RSProcessorOutputs)) {
                return false;
            }
            RSProcessorOutputs other = (RSProcessorOutputs)o;
            Integer this$omittedFilteredObjectsCount = this.getOmittedFilteredObjectsCount();
            Integer other$omittedFilteredObjectsCount = other.getOmittedFilteredObjectsCount();
            if (this$omittedFilteredObjectsCount == null ? other$omittedFilteredObjectsCount != null : !((Object)this$omittedFilteredObjectsCount).equals(other$omittedFilteredObjectsCount)) {
                return false;
            }
            List<Map<String, String>> this$relevantObjects = this.getRelevantObjects();
            List<Map<String, String>> other$relevantObjects = other.getRelevantObjects();
            if (this$relevantObjects == null ? other$relevantObjects != null : !((Object)this$relevantObjects).equals(other$relevantObjects)) {
                return false;
            }
            List<Map<String, String>> this$filteredObjects = this.getFilteredObjects();
            List<Map<String, String>> other$filteredObjects = other.getFilteredObjects();
            return !(this$filteredObjects == null ? other$filteredObjects != null : !((Object)this$filteredObjects).equals(other$filteredObjects));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Integer $omittedFilteredObjectsCount = this.getOmittedFilteredObjectsCount();
            result = result * 59 + ($omittedFilteredObjectsCount == null ? 43 : ((Object)$omittedFilteredObjectsCount).hashCode());
            List<Map<String, String>> $relevantObjects = this.getRelevantObjects();
            result = result * 59 + ($relevantObjects == null ? 43 : ((Object)$relevantObjects).hashCode());
            List<Map<String, String>> $filteredObjects = this.getFilteredObjects();
            result = result * 59 + ($filteredObjects == null ? 43 : ((Object)$filteredObjects).hashCode());
            return result;
        }

        public String toString() {
            return "ResultSetProcessor.RSProcessorOutputs(relevantObjects=" + this.getRelevantObjects() + ", filteredObjects=" + this.getFilteredObjects() + ", omittedFilteredObjectsCount=" + this.getOmittedFilteredObjectsCount() + ")";
        }

        public static class RSProcessorOutputsBuilder {
            private List<Map<String, String>> relevantObjects;
            private List<Map<String, String>> filteredObjects;
            private Integer omittedFilteredObjectsCount;

            RSProcessorOutputsBuilder() {
            }

            public RSProcessorOutputsBuilder relevantObjects(List<Map<String, String>> relevantObjects) {
                this.relevantObjects = relevantObjects;
                return this;
            }

            public RSProcessorOutputsBuilder filteredObjects(List<Map<String, String>> filteredObjects) {
                this.filteredObjects = filteredObjects;
                return this;
            }

            public RSProcessorOutputsBuilder omittedFilteredObjectsCount(Integer omittedFilteredObjectsCount) {
                this.omittedFilteredObjectsCount = omittedFilteredObjectsCount;
                return this;
            }

            public RSProcessorOutputs build() {
                return new RSProcessorOutputs(this.relevantObjects, this.filteredObjects, this.omittedFilteredObjectsCount);
            }

            public String toString() {
                return "ResultSetProcessor.RSProcessorOutputs.RSProcessorOutputsBuilder(relevantObjects=" + this.relevantObjects + ", filteredObjects=" + this.filteredObjects + ", omittedFilteredObjectsCount=" + this.omittedFilteredObjectsCount + ")";
            }
        }
    }
}

