/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.premigration.dbinspector.checks;

import com.oracle.premigration.commons.enums.LockdownProfile;
import com.oracle.premigration.commons.enums.MigrationMethod;
import com.oracle.premigration.commons.enums.TargetCloud;
import com.oracle.premigration.dbinspector.Check;
import com.oracle.premigration.dbinspector.CheckResult;
import com.oracle.premigration.dbinspector.ExecutionContext;
import com.oracle.premigration.logger.PremigrationLogger;
import java.util.Arrays;

public class has_user_defined_pvfs
extends Check {
    private static final PremigrationLogger log = PremigrationLogger.getLogger(has_user_defined_pvfs.class.getName());

    public has_user_defined_pvfs() {
        this.getLockdownProfiles().addAll(Arrays.asList(LockdownProfile.NONE, LockdownProfile.NOT_AUTONOMOUS));
        this.getTargetCloud().addAll(Arrays.asList(TargetCloud.ATPS, TargetCloud.ADWS, TargetCloud.ATPD, TargetCloud.ADWD));
        this.getMigrationMethods().addAll(Arrays.asList(MigrationMethod.DATAPUMP, MigrationMethod.DATAPUMP_DBLINK, MigrationMethod.GOLDENGATE));
        this.setScope(Check.Scope.INSTANCE);
        this.setGrouping(Check.Group.TARGET);
        this.setDeclarativeResult(CheckResult.INFORMATIONAL);
    }

    @Override
    public void prepare(ExecutionContext exeCtx) {
        if (!exeCtx.hasOracleMaintained()) {
            this.skipCheck(this.lang.txt("CHECK_SKIPPED_BECAUSE_OBJECT_MISSING", this.getName(), "ORACLE_MAINTAINED", "COLUMN"));
            return;
        }
        String sqlQuery = "SELECT O.OWNER, O.OBJECT_NAME, P.RESOURCE_NAME, P.PROFILE FROM  SYS.DBA_OBJECTS  O,  SYS.DBA_PROFILES P  WHERE   O.ORACLE_MAINTAINED = 'N'  AND O.OWNER = 'SYS'   AND P.RESOURCE_TYPE = 'PASSWORD'  AND P.RESOURCE_NAME = 'PASSWORD_VERIFY_FUNCTION'  AND P.LIMIT = O.OBJECT_NAME";
        this.setSqlQuery("SELECT O.OWNER, O.OBJECT_NAME, P.RESOURCE_NAME, P.PROFILE FROM  SYS.DBA_OBJECTS  O,  SYS.DBA_PROFILES P  WHERE   O.ORACLE_MAINTAINED = 'N'  AND O.OWNER = 'SYS'   AND P.RESOURCE_TYPE = 'PASSWORD'  AND P.RESOURCE_NAME = 'PASSWORD_VERIFY_FUNCTION'  AND P.LIMIT = O.OBJECT_NAME");
    }
}

