/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.premigration.dbinspector.checks;

import com.oracle.premigration.dbinspector.ExecutionContext;
import com.oracle.premigration.dbinspector.checks.has_logging_off;
import com.oracle.premigration.helpers.SqlUtils;
import com.oracle.premigration.reports.CheckFiltrationMetadata;

public class has_logging_off_for_subpartitions
extends has_logging_off {
    @Override
    public void initFiltrationMetadata() {
        this.setFiltrationMetadata(CheckFiltrationMetadata.builder().schemaOwnerColumn("TABLE_OWNER").objectNameColumn("TABLE_NAME").objectTypeFixed("TABLE").build());
    }

    @Override
    public void prepare(ExecutionContext exeCtx) {
        super.prepare(exeCtx);
        if (!this.isSkipExecution()) {
            String whereClause = SqlUtils.createWhereClauseForColumn(exeCtx, "TABLE_OWNER");
            String sqlQuery = "SELECT  SP.TABLE_OWNER, SP.TABLE_NAME, SP.PARTITION_NAME  FROM SYS.DBA_TAB_SUBPARTITIONS SP, SYS.DBA_TABLESPACES TS " + whereClause + "  AND NVL(SP.LOGGING,       (CASE TS.LOGGING         WHEN 'LOGGING' THEN 'YES'         WHEN 'NOLOGGING' THEN 'NO'         ELSE NULL        END)     ) = 'NO'   AND SP.TABLESPACE_NAME = TS.TABLESPACE_NAME   AND NOT NVL(TS.FORCE_LOGGING, 'NO') = 'YES'  ORDER BY 1,2,3";
            this.setSqlQuery(sqlQuery);
        }
    }
}

