/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.premigration.dbinspector.checks;

import com.oracle.premigration.commons.enums.LockdownProfile;
import com.oracle.premigration.commons.enums.MigrationMethod;
import com.oracle.premigration.commons.enums.TargetCloud;
import com.oracle.premigration.commons.enums.Version;
import com.oracle.premigration.dbinspector.Check;
import com.oracle.premigration.dbinspector.CheckResult;
import com.oracle.premigration.dbinspector.ExecutionContext;
import com.oracle.premigration.dbinspector.FilterableCheck;
import com.oracle.premigration.helpers.SqlUtils;
import com.oracle.premigration.reports.CheckFiltrationMetadata;
import java.util.Arrays;

public class has_illegal_characters_in_comments
extends FilterableCheck {
    public has_illegal_characters_in_comments() {
        this.getTargetCloud().addAll(Arrays.asList(TargetCloud.ADWD, TargetCloud.ADWS, TargetCloud.ATPD, TargetCloud.ATPS, TargetCloud.DEFAULT));
        this.getMigrationMethods().addAll(Arrays.asList(MigrationMethod.DATAPUMP, MigrationMethod.DATAPUMP_DBLINK, MigrationMethod.GOLDENGATE));
        this.setScope(Check.Scope.SCHEMA);
        this.setDeclarativeResult(CheckResult.WARNING);
        this.getLockdownProfiles().addAll(Arrays.asList(LockdownProfile.PAAS_ATPD, LockdownProfile.ADW_ADWD, LockdownProfile.OLTP_ATPS, LockdownProfile.DWCS_ADWS, LockdownProfile.ADB_UNSUPPORTED, LockdownProfile.NONE, LockdownProfile.NOT_AUTONOMOUS));
        this.setGrouping(Check.Group.SOURCE);
    }

    @Override
    public void initFiltrationMetadata() {
        this.setFiltrationMetadata(CheckFiltrationMetadata.builder().schemaOwnerColumn("OWNER").objectNameColumn("OBJECT_NAME").objectTypeColumn("TYPE").build());
    }

    @Override
    public void prepare(ExecutionContext exeCtx) {
        if (Version.V18_0_0_0.compare(exeCtx.getDatabaseVersion()) >= 0) {
            String skipMessage = this.lang.txt("CHECK_SKIPPED_BECAUSE_OBJECT_MISSING", this.getName(), "UTL_I18N.VALIDATE_CHARACTER_ENCODING", "FUNCTION");
            this.skipCheck(skipMessage);
            return;
        }
        String ownerWhereClause = SqlUtils.createWhereClauseForOwnerColumn(exeCtx);
        String sqlQuery = "SELECT OWNER, TABLE_NAME AS OBJECT_NAME, 'COMMENT' AS TYPE, 'Table Comment' AS INFO, UTL_I18N.VALIDATE_CHARACTER_ENCODING(COMMENTS) INVALID_CHAR_OFFSET, COMMENTS AS TEXT FROM SYS.DBA_TAB_COMMENTS " + ownerWhereClause + "   AND COMMENTS IS NOT NULL   AND UTL_I18N.VALIDATE_CHARACTER_ENCODING(COMMENTS) <> 0 UNION ALL  SELECT OWNER, TABLE_NAME AS OBJECT_NAME, 'COMMENT' AS TYPE, 'Column ' || COLUMN_NAME AS INFO,    UTL_I18N.VALIDATE_CHARACTER_ENCODING(COMMENTS) INVALID_CHAR_OFFSET, COMMENTS AS TEXT FROM SYS.DBA_COL_COMMENTS " + ownerWhereClause + "    AND COMMENTS IS NOT NULL    AND UTL_I18N.VALIDATE_CHARACTER_ENCODING(COMMENTS) <> 0 UNION ALL  SELECT OWNER, NAME AS OBJECT_NAME, TYPE, 'Line ' || TO_CHAR(LINE) AS INFO,    UTL_I18N.VALIDATE_CHARACTER_ENCODING(TEXT) INVALID_CHAR_OFFSET, TEXT FROM DBA_SOURCE " + ownerWhereClause + "    AND TEXT IS NOT NULL    AND UTL_I18N.VALIDATE_CHARACTER_ENCODING(TEXT) <> 0";
        this.setSqlQuery(sqlQuery);
    }
}

