/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.premigration.dbinspector.checks;

import com.oracle.premigration.commons.enums.LockdownProfile;
import com.oracle.premigration.commons.enums.MigrationMethod;
import com.oracle.premigration.dbinspector.Check;
import com.oracle.premigration.dbinspector.CheckResult;
import com.oracle.premigration.dbinspector.ExecutionContext;
import com.oracle.premigration.dbinspector.FilterableCheck;
import com.oracle.premigration.helpers.SqlUtils;
import com.oracle.premigration.logger.PremigrationLogger;
import com.oracle.premigration.reports.CheckFiltrationMetadata;
import java.util.Arrays;

public abstract class has_external_tables
extends FilterableCheck {
    private static final PremigrationLogger log = PremigrationLogger.getLogger(has_external_tables.class.getName());
    protected static final String BASE_EXTERNAL_TABLES_QUERY = "SELECT OWNER,TABLE_NAME,TYPE_OWNER,TYPE_NAME,DEFAULT_DIRECTORY_OWNER,DEFAULT_DIRECTORY_NAME FROM SYS.DBA_EXTERNAL_TABLES ";
    protected static final String BASE_EXTERNAL_TABLES_ORDER_BY = " ORDER BY 1, 2";

    protected has_external_tables() {
        this.getLockdownProfiles().addAll(Arrays.asList(LockdownProfile.OLTP_ATPS, LockdownProfile.DWCS_ADWS, LockdownProfile.NONE, LockdownProfile.NOT_AUTONOMOUS));
        this.getMigrationMethods().addAll(Arrays.asList(MigrationMethod.DATAPUMP, MigrationMethod.DATAPUMP_DBLINK, MigrationMethod.GOLDENGATE));
        this.setScope(Check.Scope.SCHEMA);
        this.setDeclarativeResult(CheckResult.WARNING);
        this.setGrouping(Check.Group.TARGET);
    }

    @Override
    public void initFiltrationMetadata() {
        this.setFiltrationMetadata(CheckFiltrationMetadata.builder().schemaOwnerColumn("OWNER").objectNameColumn("TABLE_NAME").objectTypeFixed("TABLE").build());
    }

    @Override
    public void prepare(ExecutionContext exeCtx) {
        String excludeCloudStorageExternalTables = exeCtx.hasDbmsCloudPkg() ? " AND TABLE_NAME NOT IN (SELECT TABLE_NAME FROM SYS.DBA_EXTERNAL_LOCATIONS WHERE LOCATION LIKE 'https://%')" : "";
        String whereClause = SqlUtils.createWhereClauseForOwnerColumn(exeCtx);
        String externalTablesSql = BASE_EXTERNAL_TABLES_QUERY + whereClause + excludeCloudStorageExternalTables + BASE_EXTERNAL_TABLES_ORDER_BY;
        this.setSqlQuery(externalTablesSql);
    }
}

