/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.premigration.dbinspector.checks;

import com.oracle.premigration.commons.enums.LockdownProfile;
import com.oracle.premigration.commons.enums.MigrationMethod;
import com.oracle.premigration.commons.enums.TargetCloud;
import com.oracle.premigration.dbinspector.Check;
import com.oracle.premigration.dbinspector.CheckResult;
import com.oracle.premigration.dbinspector.ExecutionContext;
import com.oracle.premigration.helpers.SqlUtils;
import java.util.Arrays;

public class has_disallowed_triggers
extends Check {
    public has_disallowed_triggers() {
        this.getLockdownProfiles().addAll(Arrays.asList(LockdownProfile.PAAS_ATPD, LockdownProfile.ADW_ADWD, LockdownProfile.NONE, LockdownProfile.ADB_UNSUPPORTED, LockdownProfile.NOT_AUTONOMOUS));
        this.getTargetCloud().addAll(Arrays.asList(TargetCloud.ADWS, TargetCloud.ATPS));
        this.getMigrationMethods().addAll(Arrays.asList(MigrationMethod.DATAPUMP, MigrationMethod.GOLDENGATE, MigrationMethod.DATAPUMP_DBLINK));
        this.setScope(Check.Scope.SCHEMA);
        this.setDeclarativeResult(CheckResult.WARNING);
        this.setGrouping(Check.Group.TARGET);
    }

    @Override
    public void prepare(ExecutionContext exeCtx) {
        String whereClause = SqlUtils.createWhereClauseForColumn(exeCtx, "OWNER");
        String sqlQuery = "SELECT OWNER, TRIGGER_NAME, TRIM(TRIGGERING_EVENT) AS TRIGGERING_EVENT, TRIM(BASE_OBJECT_TYPE) AS BASE_OBJECT_TYPE, STATUS FROM SYS.DBA_TRIGGERS " + whereClause + " AND STATUS = 'ENABLED' AND BASE_OBJECT_TYPE LIKE 'DATABASE%' AND (TRIGGERING_EVENT LIKE 'STARTUP%' OR TRIGGERING_EVENT LIKE 'SHUTDOWN%')";
        this.setSqlQuery(sqlQuery);
    }
}

