/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.premigration.dbinspector.checks;

import com.oracle.premigration.commons.enums.LockdownProfile;
import com.oracle.premigration.commons.enums.MigrationMethod;
import com.oracle.premigration.commons.enums.SourceAnalysisProp;
import com.oracle.premigration.commons.enums.TargetCloud;
import com.oracle.premigration.dbinspector.Check;
import com.oracle.premigration.dbinspector.CheckResult;
import com.oracle.premigration.dbinspector.ExecutionContext;
import com.oracle.premigration.dbinspector.FilterableCheck;
import com.oracle.premigration.helpers.SqlUtils;
import com.oracle.premigration.logger.PremigrationLogger;
import com.oracle.premigration.reports.CheckFiltrationMetadata;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class has_directories
extends FilterableCheck {
    private static final PremigrationLogger log = PremigrationLogger.getLogger(has_directories.class.getName());
    private static final String BASE_QUERY = "SELECT OWNER, DIRECTORY_NAME, DIRECTORY_PATH FROM SYS.DBA_DIRECTORIES";
    private static final String ORDER_BY = " ORDER BY 1,2";

    public has_directories() {
        this.getLockdownProfiles().addAll(Arrays.asList(LockdownProfile.PAAS_ATPD, LockdownProfile.ADW_ADWD, LockdownProfile.OLTP_ATPS, LockdownProfile.DWCS_ADWS, LockdownProfile.ADB_UNSUPPORTED, LockdownProfile.NONE, LockdownProfile.NOT_AUTONOMOUS));
        this.getTargetCloud().addAll(Arrays.asList(TargetCloud.ATPD, TargetCloud.ATPS, TargetCloud.ADWD, TargetCloud.ADWS));
        this.getMigrationMethods().addAll(Arrays.asList(MigrationMethod.DATAPUMP, MigrationMethod.DATAPUMP_DBLINK, MigrationMethod.GOLDENGATE));
        this.setScope(Check.Scope.INSTANCE);
        this.setDeclarativeResult(CheckResult.WARNING);
        this.setGrouping(Check.Group.TARGET);
    }

    @Override
    public void initFiltrationMetadata() {
        this.setFiltrationMetadata(CheckFiltrationMetadata.builder().schemaOwnerColumn("OWNER").objectNameColumn("DIRECTORY_NAME").objectTypeFixed("DIRECTORY").build());
    }

    @Override
    public void prepare(ExecutionContext exeCtx) {
        this.setSqlQuery("SELECT OWNER, DIRECTORY_NAME, DIRECTORY_PATH FROM SYS.DBA_DIRECTORIES ORDER BY 1,2");
        String targetDirectoriesString = exeCtx.getAnalysisProperty(SourceAnalysisProp.DIRECTORIES.getKey());
        if (targetDirectoriesString != null && targetDirectoriesString.trim().length() != 0) {
            try {
                ArrayList<String> srcDirectoryList = new ArrayList<String>();
                List<String> dirsNotOnTarget = SqlUtils.getDirectoryNamesNotOnTarget(exeCtx, srcDirectoryList);
                if (srcDirectoryList.size() == dirsNotOnTarget.size()) {
                    return;
                }
                boolean whereIn = !dirsNotOnTarget.isEmpty();
                List<String> dirsList = whereIn ? dirsNotOnTarget : srcDirectoryList;
                String sqlQuery = BASE_QUERY + SqlUtils.createWhereClause("DIRECTORY_NAME", whereIn, dirsList) + ORDER_BY;
                this.setSqlQuery(sqlQuery);
            }
            catch (SQLException e) {
                log.warning("Unexpected exception querying directory names", e);
            }
        }
    }
}

