/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.premigration.dbinspector.checks;

import com.oracle.premigration.commons.enums.TargetCloud;
import com.oracle.premigration.dbinspector.CheckResult;
import com.oracle.premigration.dbinspector.ExecutionContext;
import com.oracle.premigration.dbinspector.checks.has_data_in_other_tablespaces;
import com.oracle.premigration.helpers.SqlUtils;
import com.oracle.premigration.helpers.Utilities;
import com.oracle.premigration.logger.PremigrationLogger;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.List;

public class has_data_in_other_tablespaces_serverless
extends has_data_in_other_tablespaces {
    private static final PremigrationLogger log = PremigrationLogger.getLogger(has_data_in_other_tablespaces_serverless.class.getName());

    public has_data_in_other_tablespaces_serverless() {
        this.getTargetCloud().addAll(Arrays.asList(TargetCloud.ATPS, TargetCloud.ADWS));
        this.setDeclarativeResult(CheckResult.WARNING);
    }

    @Override
    public void prepare(ExecutionContext exeCtx) {
        List<String> usersWithSingleQuotaList;
        super.prepare(exeCtx);
        String usersWhereClause = SqlUtils.createWhereClauseForColumn(exeCtx, "USERNAME");
        String granteeWhereClause = SqlUtils.createWhereClauseForColumn(exeCtx, "GRANTEE");
        String usersWithSingleQuotaQuery = "SELECT USERNAME FROM SYS.DBA_TS_QUOTAS " + usersWhereClause + " GROUP BY USERNAME HAVING COUNT(*) = 1  UNION  SELECT GRANTEE AS USERNAME FROM SYS.DBA_SYS_PRIVS " + granteeWhereClause + " AND PRIVILEGE = 'UNLIMITED TABLESPACE'";
        try {
            usersWithSingleQuotaList = SqlUtils.getStringList(usersWithSingleQuotaQuery, exeCtx);
            log.info("Users with quota on a single tablespace or granted UNLIMITED TABLESPACE: " + Utilities.join(",", usersWithSingleQuotaList));
        }
        catch (SQLException e) {
            log.severe("Exception calling SqlUtils.getStringList with '" + usersWithSingleQuotaQuery + "'", e);
            this.skipCheck(e.getMessage(), CheckResult.FATAL);
            return;
        }
        String usersWithSingleQuota = SqlUtils.createAndClause("S.OWNER", false, usersWithSingleQuotaList);
        String sqlQuery = "SELECT S.TABLESPACE_NAME, O.OWNER, O.OBJECT_NAME, O.OBJECT_TYPE FROM DBA_SEGMENTS S, DBA_OBJECTS O " + this.whereClause + this.andClause + usersWithSingleQuota + " AND S.SEGMENT_NAME=O.OBJECT_NAME AND S.OWNER = O.OWNER " + " GROUP BY S.TABLESPACE_NAME, O.OWNER, O.OBJECT_NAME, O.OBJECT_TYPE ORDER BY S.TABLESPACE_NAME, O.OWNER, O.OBJECT_NAME, O.OBJECT_TYPE ";
        this.setSqlQuery(sqlQuery);
    }
}

