/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.premigration.dbinspector.checks;

import com.oracle.premigration.commons.enums.LockdownProfile;
import com.oracle.premigration.commons.enums.MigrationMethod;
import com.oracle.premigration.commons.enums.TargetCloud;
import com.oracle.premigration.dbinspector.Check;
import com.oracle.premigration.dbinspector.CheckResult;
import com.oracle.premigration.dbinspector.ExecutionContext;
import com.oracle.premigration.dbinspector.fixups.Fixable;
import com.oracle.premigration.dbinspector.fixups.Fixup;
import java.io.IOException;
import java.util.Arrays;

public class gg_supplemental_log_data_min
extends Check
implements Fixable {
    public gg_supplemental_log_data_min() {
        this.getLockdownProfiles().addAll(Arrays.asList(LockdownProfile.PAAS_ATPD, LockdownProfile.ADW_ADWD, LockdownProfile.OLTP_ATPS, LockdownProfile.DWCS_ADWS, LockdownProfile.ADB_UNSUPPORTED, LockdownProfile.NONE, LockdownProfile.NOT_AUTONOMOUS));
        this.getTargetCloud().addAll(Arrays.asList(TargetCloud.ADWD, TargetCloud.ADWS, TargetCloud.ATPD, TargetCloud.ATPS, TargetCloud.DEFAULT));
        this.getMigrationMethods().add(MigrationMethod.GOLDENGATE);
        this.setScope(Check.Scope.UNIVERSAL);
        this.setDeclarativeResult(CheckResult.BLOCKER);
        this.setGrouping(Check.Group.SOURCE);
    }

    @Override
    public void prepare(ExecutionContext exeCtx) {
        String sqlQuery = "SELECT SUPPLEMENTAL_LOG_DATA_MIN AS SUPP_LOG_DATA_MIN_ENABLED FROM V$DATABASE WHERE SUPPLEMENTAL_LOG_DATA_MIN = 'NO'";
        this.setSqlQuery("SELECT SUPPLEMENTAL_LOG_DATA_MIN AS SUPP_LOG_DATA_MIN_ENABLED FROM V$DATABASE WHERE SUPPLEMENTAL_LOG_DATA_MIN = 'NO'");
    }

    @Override
    public void generateFixups(ExecutionContext exeCtx) throws IOException {
        String parentFolderPath = exeCtx.getOutputFilenamesContainer().getOutDir();
        String fixupName = "gg_add_supplemental_log_data";
        Fixup.Locus locus = Fixup.Locus.source;
        Fixup fixupObject = Fixup.createStaticSqlFixupBuilder("gg_add_supplemental_log_data", locus, parentFolderPath).runAtCDBLevel(true).build();
        this.generateStaticFixup(fixupObject);
    }
}

