/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.premigration.dbinspector.addinform.schemasummary;

import com.oracle.premigration.dbinspector.ExecutionContext;
import com.oracle.premigration.helpers.SqlUtils;
import com.oracle.premigration.helpers.Utilities;
import com.oracle.premigration.logger.PremigrationLogger;
import com.oracle.premigration.reports.html.sections.HtmlProperty;
import com.oracle.premigration.reports.html.sections.HtmlReportSectionName;
import com.oracle.premigration.reports.json.CpatJsonPropertyDescription;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public class Largest50Tables {
    private static final PremigrationLogger log = PremigrationLogger.getLogger(Largest50Tables.class.getName());
    @HtmlProperty(labelKey="SRC_SCH_SUMM_OWNER", section=HtmlReportSectionName.SRC_SCHEMA_SUMMARY_INFORMATION, isClassInfo=false)
    @CpatJsonPropertyDescription(value="The owner of the table")
    private String owner;
    @HtmlProperty(labelKey="SRC_SCH_SUMM_TABLE_NAME", section=HtmlReportSectionName.SRC_SCHEMA_SUMMARY_INFORMATION, isClassInfo=false)
    @CpatJsonPropertyDescription(value="The name of the table")
    private String tableName;
    @HtmlProperty(labelKey="SRC_SCH_SUMM_SIZE_GB", section=HtmlReportSectionName.SRC_SCHEMA_SUMMARY_INFORMATION, isClassInfo=false)
    @CpatJsonPropertyDescription(value="The size of the table in gigabytes")
    private double sizeInGB;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Largest50Tables> getLargest50Tables(ExecutionContext exeCtx) throws SQLException {
        String whereClause = SqlUtils.createWhereClauseForColumn(exeCtx, "S.OWNER");
        String query = "SELECT OWNER, TABLE_NAME, SIZE_IN_GB FROM (  SELECT OWNER, TABLE_NAME, ROUND(SUM(BYTES)/1073741824, 6) SIZE_IN_GB   FROM (    SELECT S.OWNER, T.TABLE_NAME, SUM(BYTES) BYTES     FROM DBA_SEGMENTS S, DBA_TABLES T " + whereClause + "      AND S.OWNER=T.OWNER AND S.SEGMENT_NAME=T.TABLE_NAME       AND T.TABLE_NAME NOT LIKE 'BIN$%'     GROUP BY S.OWNER, T.TABLE_NAME     UNION ALL     SELECT S.OWNER, L.TABLE_NAME, SUM(BYTES) BYTES     FROM DBA_SEGMENTS S, DBA_LOBS L " + whereClause + "      AND S.OWNER=L.OWNER AND S.SEGMENT_NAME=L.SEGMENT_NAME       AND L.TABLE_NAME NOT LIKE 'BIN$%'     GROUP BY S.OWNER, L.TABLE_NAME   )   GROUP BY OWNER, TABLE_NAME   ORDER BY SUM(BYTES) DESC ) WHERE ROWNUM <= 50";
        log.fine("Fetching Largest 50 Tables with query: " + query);
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        ArrayList<Largest50Tables> largest50Tables = new ArrayList<Largest50Tables>();
        long startTime = System.currentTimeMillis();
        try {
            conn = exeCtx.getConnection();
            stmt = SqlUtils.createPreparedStatement(conn, query);
            rs = stmt.executeQuery();
            while (rs.next()) {
                Largest50Tables largest50Table = new Largest50Tables(rs.getString("OWNER"), rs.getString("TABLE_NAME"), rs.getDouble("SIZE_IN_GB"));
                largest50Tables.add(largest50Table);
            }
            log.info("Elapsed time for query: " + Utilities.formatTimeInterval(System.currentTimeMillis() - startTime));
        }
        catch (Throwable throwable) {
            exeCtx.closeIfNotNull(rs, stmt, conn);
            throw throwable;
        }
        exeCtx.closeIfNotNull(rs, stmt, conn);
        return largest50Tables;
    }

    public static Largest50TablesBuilder builder() {
        return new Largest50TablesBuilder();
    }

    private Largest50Tables(String owner, String tableName, double sizeInGB) {
        this.owner = owner;
        this.tableName = tableName;
        this.sizeInGB = sizeInGB;
    }

    public String getOwner() {
        return this.owner;
    }

    public String getTableName() {
        return this.tableName;
    }

    public double getSizeInGB() {
        return this.sizeInGB;
    }

    public static class Largest50TablesBuilder {
        private String owner;
        private String tableName;
        private double sizeInGB;

        Largest50TablesBuilder() {
        }

        public Largest50TablesBuilder owner(String owner) {
            this.owner = owner;
            return this;
        }

        public Largest50TablesBuilder tableName(String tableName) {
            this.tableName = tableName;
            return this;
        }

        public Largest50TablesBuilder sizeInGB(double sizeInGB) {
            this.sizeInGB = sizeInGB;
            return this;
        }

        public Largest50Tables build() {
            return new Largest50Tables(this.owner, this.tableName, this.sizeInGB);
        }

        public String toString() {
            return "Largest50Tables.Largest50TablesBuilder(owner=" + this.owner + ", tableName=" + this.tableName + ", sizeInGB=" + this.sizeInGB + ")";
        }
    }
}

