/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.premigration.dbinspector.addinform.oee;

import com.oracle.premigration.dbinspector.DatabaseObject;
import com.oracle.premigration.dbinspector.ExecutionContext;
import com.oracle.premigration.helpers.SqlUtils;
import com.oracle.premigration.helpers.Utilities;
import com.oracle.premigration.logger.PremigrationLogger;
import com.oracle.premigration.reports.html.sections.HtmlProperty;
import com.oracle.premigration.reports.html.sections.HtmlReportSectionName;
import com.oracle.premigration.reports.json.CpatJsonPropertyDescription;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public class DatabaseOption {
    private static final PremigrationLogger log = PremigrationLogger.getLogger(DatabaseOption.class.getName());
    @HtmlProperty(labelKey="SRC_OPTIONS_COMPID", section=HtmlReportSectionName.SRC_OPTIONS_INFORMATION, isClassInfo=false)
    @CpatJsonPropertyDescription(value="Unique identifier for the component.")
    String compId;
    @HtmlProperty(labelKey="SRC_OPTIONS_COMPNAME", section=HtmlReportSectionName.SRC_OPTIONS_INFORMATION, isClassInfo=false)
    @CpatJsonPropertyDescription(value="Name of the component.")
    String compName;
    @HtmlProperty(labelKey="SRC_OPTIONS_VERSION", section=HtmlReportSectionName.SRC_OPTIONS_INFORMATION, isClassInfo=false)
    @CpatJsonPropertyDescription(value="Version of the component.")
    String version;
    @HtmlProperty(labelKey="SRC_OPTIONS_VERSIONFULL", section=HtmlReportSectionName.SRC_OPTIONS_INFORMATION, isClassInfo=false)
    @CpatJsonPropertyDescription(value="Full version string of the component, if available.")
    String versionFull;
    @HtmlProperty(labelKey="SRC_OPTIONS_STATUS", section=HtmlReportSectionName.SRC_OPTIONS_INFORMATION, isClassInfo=false)
    @CpatJsonPropertyDescription(value="Status of the component.")
    String status;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<DatabaseOption> getDatabaseOptions(ExecutionContext exeCtx) throws SQLException {
        ArrayList<DatabaseOption> databaseOptions = new ArrayList<DatabaseOption>();
        long startTime = System.currentTimeMillis();
        boolean hasVersionFull = exeCtx.hasDatabaseObject(DatabaseObject.builder().table("DBA_REGISTRY").column("VERSION_FULL").schema("SYS").build());
        String versionFullColumn = hasVersionFull ? ", VERSION_FULL" : ", NULL AS VERSION_FULL";
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        String dbOptionQuery = "SELECT COMP_ID, COMP_NAME, STATUS, VERSION " + versionFullColumn + " FROM SYS.DBA_REGISTRY  ORDER BY COMP_ID";
        log.fine("Fetching Database Options with query: " + dbOptionQuery);
        try {
            conn = exeCtx.getConnection();
            stmt = SqlUtils.createPreparedStatement(conn, dbOptionQuery);
            rs = stmt.executeQuery();
            while (rs.next()) {
                DatabaseOption databaseOption = DatabaseOption.builder().compId(rs.getString("COMP_ID")).compName(rs.getString("COMP_NAME")).status(rs.getString("STATUS")).version(rs.getString("VERSION")).versionFull(rs.getString("VERSION_FULL")).build();
                databaseOptions.add(databaseOption);
            }
            log.info("Elapsed time for query: " + Utilities.formatTimeInterval(System.currentTimeMillis() - startTime));
        }
        catch (Throwable throwable) {
            exeCtx.closeIfNotNull(rs, stmt, conn);
            throw throwable;
        }
        exeCtx.closeIfNotNull(rs, stmt, conn);
        return databaseOptions;
    }

    public static DatabaseOptionBuilder builder() {
        return new DatabaseOptionBuilder();
    }

    private DatabaseOption(String compId, String compName, String version, String versionFull, String status) {
        this.compId = compId;
        this.compName = compName;
        this.version = version;
        this.versionFull = versionFull;
        this.status = status;
    }

    public String getCompId() {
        return this.compId;
    }

    public String getCompName() {
        return this.compName;
    }

    public String getVersion() {
        return this.version;
    }

    public String getVersionFull() {
        return this.versionFull;
    }

    public String getStatus() {
        return this.status;
    }

    public static class DatabaseOptionBuilder {
        private String compId;
        private String compName;
        private String version;
        private String versionFull;
        private String status;

        DatabaseOptionBuilder() {
        }

        public DatabaseOptionBuilder compId(String compId) {
            this.compId = compId;
            return this;
        }

        public DatabaseOptionBuilder compName(String compName) {
            this.compName = compName;
            return this;
        }

        public DatabaseOptionBuilder version(String version) {
            this.version = version;
            return this;
        }

        public DatabaseOptionBuilder versionFull(String versionFull) {
            this.versionFull = versionFull;
            return this;
        }

        public DatabaseOptionBuilder status(String status) {
            this.status = status;
            return this;
        }

        public DatabaseOption build() {
            return new DatabaseOption(this.compId, this.compName, this.version, this.versionFull, this.status);
        }

        public String toString() {
            return "DatabaseOption.DatabaseOptionBuilder(compId=" + this.compId + ", compName=" + this.compName + ", version=" + this.version + ", versionFull=" + this.versionFull + ", status=" + this.status + ")";
        }
    }
}

