/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.premigration.dbinspector.addinform;

import com.oracle.premigration.dbinspector.ExecutionContext;
import com.oracle.premigration.dbinspector.addinform.tablespace.DataFiles;
import com.oracle.premigration.dbinspector.addinform.tablespace.TablespaceDetails;
import com.oracle.premigration.helpers.Utilities;
import com.oracle.premigration.logger.PremigrationLogger;
import com.oracle.premigration.reports.html.sections.HtmlProperty;
import com.oracle.premigration.reports.html.sections.HtmlReportSectionName;
import com.oracle.premigration.reports.json.CpatJsonPropertyDescription;
import java.sql.SQLException;
import java.util.List;
import java.util.logging.Level;

public final class TablespaceData {
    private static final PremigrationLogger log = PremigrationLogger.getLogger(TablespaceData.class.getName());
    @HtmlProperty(labelKey="SRC_DB_TBS_DETAILS_INFO", section=HtmlReportSectionName.SRC_TABLESPACE_INFORMATION, isClassInfo=false)
    @CpatJsonPropertyDescription(value="Tablespace Information")
    private final List<TablespaceDetails> tablespaceDetails;
    @HtmlProperty(labelKey="SRC_DB_DATA_FILES_DETAILS_INFO", section=HtmlReportSectionName.SRC_TABLESPACE_INFORMATION, isClassInfo=false)
    @CpatJsonPropertyDescription(value="Data File Information")
    private final List<DataFiles> dataFilesDetails;

    public static TablespaceData getTablespaceData(ExecutionContext exeCtx) {
        TablespaceData tablespaceData = null;
        long startFetchingTablespaceInfo = System.currentTimeMillis();
        try {
            List<TablespaceDetails> tablespaceDetails = TablespaceDetails.getTablespaceDetails(exeCtx);
            List<DataFiles> dataFilesDetails = DataFiles.getDataFiles(exeCtx);
            tablespaceData = new TablespaceData(tablespaceDetails, dataFilesDetails);
        }
        catch (SQLException e) {
            String errorMessage = Utilities.getErrorText("ERROR2011", new String[0]);
            Utilities.printAndLogErrorMessage(errorMessage, exeCtx.getEnvCtx(), Level.WARNING, e);
        }
        log.info("Elapsed time fetching tablespace information: " + Utilities.formatTimeInterval(System.currentTimeMillis() - startFetchingTablespaceInfo));
        return tablespaceData;
    }

    public List<TablespaceDetails> getTablespaceDetails() {
        return this.tablespaceDetails;
    }

    public List<DataFiles> getDataFilesDetails() {
        return this.dataFilesDetails;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TablespaceData)) {
            return false;
        }
        TablespaceData other = (TablespaceData)o;
        List<TablespaceDetails> this$tablespaceDetails = this.getTablespaceDetails();
        List<TablespaceDetails> other$tablespaceDetails = other.getTablespaceDetails();
        if (this$tablespaceDetails == null ? other$tablespaceDetails != null : !((Object)this$tablespaceDetails).equals(other$tablespaceDetails)) {
            return false;
        }
        List<DataFiles> this$dataFilesDetails = this.getDataFilesDetails();
        List<DataFiles> other$dataFilesDetails = other.getDataFilesDetails();
        return !(this$dataFilesDetails == null ? other$dataFilesDetails != null : !((Object)this$dataFilesDetails).equals(other$dataFilesDetails));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<TablespaceDetails> $tablespaceDetails = this.getTablespaceDetails();
        result = result * 59 + ($tablespaceDetails == null ? 43 : ((Object)$tablespaceDetails).hashCode());
        List<DataFiles> $dataFilesDetails = this.getDataFilesDetails();
        result = result * 59 + ($dataFilesDetails == null ? 43 : ((Object)$dataFilesDetails).hashCode());
        return result;
    }

    public String toString() {
        return "TablespaceData(tablespaceDetails=" + this.getTablespaceDetails() + ", dataFilesDetails=" + this.getDataFilesDetails() + ")";
    }

    public TablespaceData(List<TablespaceDetails> tablespaceDetails, List<DataFiles> dataFilesDetails) {
        this.tablespaceDetails = tablespaceDetails;
        this.dataFilesDetails = dataFilesDetails;
    }
}

