/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.premigration.dbinspector.addinform;

import com.oracle.premigration.dbinspector.ExecutionContext;
import com.oracle.premigration.dbinspector.addinform.redo.RedoHistory;
import com.oracle.premigration.dbinspector.addinform.redo.RedoLogs;
import com.oracle.premigration.dbinspector.addinform.redo.RedoSize;
import com.oracle.premigration.dbinspector.addinform.redo.StandByLogs;
import com.oracle.premigration.helpers.SqlUtils;
import com.oracle.premigration.helpers.Utilities;
import com.oracle.premigration.logger.PremigrationLogger;
import com.oracle.premigration.reports.html.sections.HtmlProperty;
import com.oracle.premigration.reports.html.sections.HtmlReportSectionName;
import com.oracle.premigration.reports.json.CpatJsonPropertyDescription;
import java.sql.SQLException;
import java.util.List;
import java.util.logging.Level;

public final class RedoData {
    private static final PremigrationLogger log = PremigrationLogger.getLogger(RedoData.class.getName());
    @HtmlProperty(labelKey="SRC_LOG_MODE", section=HtmlReportSectionName.SRC_REDO_INFORMATION, isClassInfo=false)
    @CpatJsonPropertyDescription(value="The LOG_MODE from V$DATABASE; typically ARCHIVELOG or NOARCHIVELOG")
    private final String logMode;
    @HtmlProperty(labelKey="SRC_REDO_SIZE_INFO", section=HtmlReportSectionName.SRC_REDO_INFORMATION, isClassInfo=false)
    @CpatJsonPropertyDescription(value="GV$SYSSTAT Redo size information")
    private final List<RedoSize> sysStatRedoSize;
    @HtmlProperty(labelKey="SRC_REDO_HISTORY_INFO", section=HtmlReportSectionName.SRC_REDO_INFORMATION, isClassInfo=false)
    @CpatJsonPropertyDescription(value="Redo history data")
    private final List<RedoHistory> redoHistory;
    @HtmlProperty(labelKey="SRC_REDO_LOGS_INFO", section=HtmlReportSectionName.SRC_REDO_INFORMATION, isClassInfo=false)
    @CpatJsonPropertyDescription(value="Redo logs data")
    private final List<RedoLogs> redoLogs;
    @HtmlProperty(labelKey="SRC_STANDBY_LOGS_INFO", section=HtmlReportSectionName.SRC_REDO_INFORMATION, isClassInfo=false)
    @CpatJsonPropertyDescription(value="Stand By logs data")
    private final List<StandByLogs> standByLogs;

    public static RedoData getRedoData(ExecutionContext exeCtx) {
        RedoData redoData = null;
        long startFetchingRedoInfo = System.currentTimeMillis();
        try {
            String logMode = SqlUtils.getSingleString("SELECT LOG_MODE FROM V$DATABASE", exeCtx);
            List<RedoHistory> redoHistory = RedoHistory.getRedoHistory(exeCtx);
            List<RedoSize> redoSizes = RedoSize.getRedoSizeData(exeCtx);
            List<RedoLogs> redoLogs = RedoLogs.getRedoLogs(exeCtx);
            List<StandByLogs> standByLogs = StandByLogs.getStandByLogs(exeCtx);
            redoData = new RedoData(logMode, redoSizes, redoHistory, redoLogs, standByLogs);
        }
        catch (SQLException e) {
            String errorMessage = Utilities.getErrorText("ERROR2011", new String[0]);
            Utilities.printAndLogErrorMessage(errorMessage, exeCtx.getEnvCtx(), Level.WARNING, e);
        }
        log.info("Elapsed time fetching Redo information: " + Utilities.formatTimeInterval(System.currentTimeMillis() - startFetchingRedoInfo));
        return redoData;
    }

    public String getLogMode() {
        return this.logMode;
    }

    public List<RedoSize> getSysStatRedoSize() {
        return this.sysStatRedoSize;
    }

    public List<RedoHistory> getRedoHistory() {
        return this.redoHistory;
    }

    public List<RedoLogs> getRedoLogs() {
        return this.redoLogs;
    }

    public List<StandByLogs> getStandByLogs() {
        return this.standByLogs;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RedoData)) {
            return false;
        }
        RedoData other = (RedoData)o;
        String this$logMode = this.getLogMode();
        String other$logMode = other.getLogMode();
        if (this$logMode == null ? other$logMode != null : !this$logMode.equals(other$logMode)) {
            return false;
        }
        List<RedoSize> this$sysStatRedoSize = this.getSysStatRedoSize();
        List<RedoSize> other$sysStatRedoSize = other.getSysStatRedoSize();
        if (this$sysStatRedoSize == null ? other$sysStatRedoSize != null : !((Object)this$sysStatRedoSize).equals(other$sysStatRedoSize)) {
            return false;
        }
        List<RedoHistory> this$redoHistory = this.getRedoHistory();
        List<RedoHistory> other$redoHistory = other.getRedoHistory();
        if (this$redoHistory == null ? other$redoHistory != null : !((Object)this$redoHistory).equals(other$redoHistory)) {
            return false;
        }
        List<RedoLogs> this$redoLogs = this.getRedoLogs();
        List<RedoLogs> other$redoLogs = other.getRedoLogs();
        if (this$redoLogs == null ? other$redoLogs != null : !((Object)this$redoLogs).equals(other$redoLogs)) {
            return false;
        }
        List<StandByLogs> this$standByLogs = this.getStandByLogs();
        List<StandByLogs> other$standByLogs = other.getStandByLogs();
        return !(this$standByLogs == null ? other$standByLogs != null : !((Object)this$standByLogs).equals(other$standByLogs));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $logMode = this.getLogMode();
        result = result * 59 + ($logMode == null ? 43 : $logMode.hashCode());
        List<RedoSize> $sysStatRedoSize = this.getSysStatRedoSize();
        result = result * 59 + ($sysStatRedoSize == null ? 43 : ((Object)$sysStatRedoSize).hashCode());
        List<RedoHistory> $redoHistory = this.getRedoHistory();
        result = result * 59 + ($redoHistory == null ? 43 : ((Object)$redoHistory).hashCode());
        List<RedoLogs> $redoLogs = this.getRedoLogs();
        result = result * 59 + ($redoLogs == null ? 43 : ((Object)$redoLogs).hashCode());
        List<StandByLogs> $standByLogs = this.getStandByLogs();
        result = result * 59 + ($standByLogs == null ? 43 : ((Object)$standByLogs).hashCode());
        return result;
    }

    public String toString() {
        return "RedoData(logMode=" + this.getLogMode() + ", sysStatRedoSize=" + this.getSysStatRedoSize() + ", redoHistory=" + this.getRedoHistory() + ", redoLogs=" + this.getRedoLogs() + ", standByLogs=" + this.getStandByLogs() + ")";
    }

    public RedoData(String logMode, List<RedoSize> sysStatRedoSize, List<RedoHistory> redoHistory, List<RedoLogs> redoLogs, List<StandByLogs> standByLogs) {
        this.logMode = logMode;
        this.sysStatRedoSize = sysStatRedoSize;
        this.redoHistory = redoHistory;
        this.redoLogs = redoLogs;
        this.standByLogs = standByLogs;
    }
}

