/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.datapump.common;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import oracle.dbtools.extension.datapump.common.DataPumpOption;

public class DataPumpGenOptions {
    public static final String COLUMNENCRYPTION = "columnencryption";
    public static final String COLUMNENCRYPTION_S = "ce";
    public static final String COMPRESSION = "compression";
    public static final String COMPRESSION_S = "cm";
    public static final String COPYCLOUD = "copycloud";
    public static final String COPYCLOUD_S = "cc";
    public static final String CREDENTIAL = "credential";
    public static final String CREDENTIAL_S = "c";
    public static final String DATAPUMP = "datapump";
    public static final String DATAPUMP_S = "dp";
    public static final String DATAACCESSMETHOD = "dataaccessmethod";
    public static final String DEBUG = "debug";
    public static final String DEBUG_S = "de";
    public static final String DIRECTORY = "directory";
    public static final String DIRECTORY_S = "d";
    public static final String DUMPDIRECTORY = "dumpdirectory";
    public static final String DUMPDIRECTORY_S = "dd";
    public static final String DUMPFILE = "dumpfile";
    public static final String DUMPFILE_S = "f";
    public static final String DUMPURI = "dumpuri";
    public static final String DUMPURI_S = "u";
    public static final String DWCSCVTIOTS = "dwcscvtiots";
    public static final String DWCSCVTCONSTRAINTS = "dwcscvtconstraints";
    public static final String ENCRYPTION = "encryption";
    public static final String ENCRYPTION_S = "en";
    public static final String ENCRYPTIONALGORITHM = "encryptionalgorithm";
    public static final String ENCRYPTIONALGORITHM_S = "ena";
    public static final String ENCRYPTIONMODE = "encryptionmode";
    public static final String ENCRYPTIONMODE_S = "enm";
    public static final String ENCRYPTIONPASSWORD = "encryptionpassword";
    public static final String ENCRYPTIONPASSWORD_S = "enp";
    public static final String ESTIMATE = "estimate";
    public static final String ESTIMATE_S = "e";
    public static final String EXCLUDEDWCS = "excludedwcs";
    public static final String EXAMPLES = "examples";
    public static final String EXCLUDEEXPR = "excludeexpr";
    public static final String EXCLUDEEXPR_S = "ex";
    public static final String EXCLUDELIST = "excludelist";
    public static final String EXCLUDELIST_S = "el";
    public static final String EXPORT = "export";
    public static final String FILESIZE = "filesize";
    public static final String FILESIZE_S = "fs";
    public static final String FLASHBACKSCN = "flashbackscn";
    public static final String FLASHBACKSCN_S = "fb";
    public static final String HELP = "help";
    public static final String IMPORT = "import";
    public static final String INCLUDEEXPR = "includeexpr";
    public static final String INCLUDEEXPR_S = "ix";
    public static final String INCLUDELIST = "includelist";
    public static final String INCLUDELIST_S = "il";
    public static final String INCLUDEMETADATA = "includemetadata";
    public static final String INCLUDEMETADATA_S = "im";
    public static final String INCLUDEROWS = "includerows";
    public static final String INCLUDEROWS_S = "ir";
    public static final String JOBMODE = "jobmode";
    public static final String JOBNAME = "jobname";
    public static final String JOBNAME_S = "j";
    public static final String KEEPMASTER = "keepmaster";
    public static final String KEEPMASTER_S = "k";
    public static final String LOGDIRECTORY = "logdirectory";
    public static final String LOGDIRECTORY_S = "ld";
    public static final String LOGFILE = "logfile";
    public static final String LOGFILE_S = "lf";
    public static final String NAMEEXPR = "nameexpr";
    public static final String NAMEEXPR_S = "nx";
    public static final String NAMELIST = "namelist";
    public static final String NAMELIST_S = "nl";
    public static final String NOEXEC = "noexec";
    public static final String NOEXEC_S = "ne";
    public static final String OBJECTID = "objectid";
    public static final String OBJECTID_S = "oid";
    public static final String OPERATION = "operation";
    public static final String PARALLEL = "parallel";
    public static final String PARALLEL_S = "p";
    public static final String PARTITIONOPTIONS = "partitionoptions";
    public static final String REMAPSCHEMAS = "remapschemas";
    public static final String REMAPSCHEMAS_S = "rs";
    public static final String REMAPTABLESPACES = "remaptablespaces";
    public static final String REMAPTABLESPACES_S = "rt";
    public static final String REUSEFILE = "reusefile";
    public static final String REUSEFILE_S = "r";
    public static final String SCHEMAS = "schemas";
    public static final String SCHEMAS_S = "s";
    public static final String SEGMENTATTRIBUTES = "segmentattributes";
    public static final String SEGMENTATTRIBUTES_S = "sa";
    public static final String SKIPUNUSABLEINDEXES = "skipunusableindexes";
    public static final String SKIPUNUSABLEINDEXES_S = "sui";
    public static final String STORAGE = "storage";
    public static final String STORAGE_S = "st";
    public static final String SYNTAX = "syntax";
    public static final String TABLEEXISTS = "tableexists";
    public static final String TABLEEXISTS_S = "te";
    public static final String TRACE = "trace";
    public static final String TABLECOMPRESSION = "tablecompression";
    public static final String TABLECOMPRESSION_S = "tc";
    public static final String VERBOSE = "verbose";
    public static final String VERBOSE_S = "ve";
    public static final String VERSION = "version";
    public static final String VERSION_S = "v";
    public static final String WAIT = "wait";
    public static final String WAIT_S = "w";
    public static final String GEN_BOOL_FALSE = "s";
    public static final String GEN_BOOL_TRUE = "t";
    public static final ArrayList<String> subCommands = new ArrayList<String>(){
        private static final long serialVersionUID = 1L;
        {
            this.add(DataPumpGenOptions.EXAMPLES);
            this.add(DataPumpGenOptions.EXPORT);
            this.add(DataPumpGenOptions.HELP);
            this.add(DataPumpGenOptions.IMPORT);
            this.add(DataPumpGenOptions.SYNTAX);
        }
    };
    public static final ArrayList<String> setSubCommands = new ArrayList<String>(){
        private static final long serialVersionUID = 1L;
        {
            this.add(DataPumpGenOptions.EXAMPLES);
            this.add(DataPumpGenOptions.HELP);
            this.add(DataPumpGenOptions.DATAPUMP);
            this.add(DataPumpGenOptions.DATAPUMP_S);
            this.add(DataPumpGenOptions.SYNTAX);
        }
    };
    public static final HashMap<String, String> coreOptions = new HashMap<String, String>(){
        private static final long serialVersionUID = 1L;
        {
            this.put(DataPumpGenOptions.COLUMNENCRYPTION, "BooleanFlagValidator");
            this.put(DataPumpGenOptions.COLUMNENCRYPTION_S, "BooleanFlagValidator");
            this.put(DataPumpGenOptions.COMPRESSION, "StringValidator");
            this.put(DataPumpGenOptions.COMPRESSION_S, "StringValidator");
            this.put(DataPumpGenOptions.COPYCLOUD, "BooleanFlagValidator");
            this.put(DataPumpGenOptions.COPYCLOUD_S, "BooleanFlagValidator");
            this.put(DataPumpGenOptions.CREDENTIAL, "StringValidator");
            this.put(DataPumpGenOptions.CREDENTIAL_S, "StringValidator");
            this.put(DataPumpGenOptions.DEBUG, "BooleanFlagValidator");
            this.put(DataPumpGenOptions.DEBUG_S, "BooleanFlagValidator");
            this.put(DataPumpGenOptions.DIRECTORY, "StringValidator");
            this.put(DataPumpGenOptions.DIRECTORY_S, "StringValidator");
            this.put(DataPumpGenOptions.DUMPDIRECTORY, "StringValidator");
            this.put(DataPumpGenOptions.DUMPDIRECTORY_S, "StringValidator");
            this.put(DataPumpGenOptions.DUMPFILE, "StringValidator");
            this.put(DataPumpGenOptions.DUMPFILE_S, "StringValidator");
            this.put(DataPumpGenOptions.DUMPURI, "StringOrNullValidator");
            this.put(DataPumpGenOptions.DUMPURI_S, "StringOrNullValidator");
            this.put(DataPumpGenOptions.ENCRYPTION, "StringValidator");
            this.put(DataPumpGenOptions.ENCRYPTION_S, "StringValidator");
            this.put(DataPumpGenOptions.ENCRYPTIONALGORITHM, "StringValidator");
            this.put(DataPumpGenOptions.ENCRYPTIONALGORITHM_S, "StringValidator");
            this.put(DataPumpGenOptions.ENCRYPTIONMODE, "StringValidator");
            this.put(DataPumpGenOptions.ENCRYPTIONMODE_S, "StringValidator");
            this.put(DataPumpGenOptions.ENCRYPTIONPASSWORD, "StringOrNullValidator");
            this.put(DataPumpGenOptions.ENCRYPTIONPASSWORD_S, "StringOrNullValidator");
            this.put(DataPumpGenOptions.EXCLUDEEXPR, "StringValidator");
            this.put(DataPumpGenOptions.EXCLUDEEXPR_S, "StringValidator");
            this.put(DataPumpGenOptions.EXCLUDELIST, "StringValidator");
            this.put(DataPumpGenOptions.EXCLUDELIST_S, "StringValidator");
            this.put(DataPumpGenOptions.ESTIMATE, "StringValidator");
            this.put(DataPumpGenOptions.ESTIMATE_S, "StringValidator");
            this.put(DataPumpGenOptions.FILESIZE, "StringValidator");
            this.put(DataPumpGenOptions.FILESIZE_S, "StringValidator");
            this.put(DataPumpGenOptions.FLASHBACKSCN, "BooleanFlagValidator");
            this.put(DataPumpGenOptions.FLASHBACKSCN_S, "BooleanFlagValidator");
            this.put(DataPumpGenOptions.HELP, "NullValidator");
            this.put(DataPumpGenOptions.INCLUDEEXPR, "StringValidator");
            this.put(DataPumpGenOptions.INCLUDEEXPR_S, "StringValidator");
            this.put(DataPumpGenOptions.INCLUDELIST, "StringValidator");
            this.put(DataPumpGenOptions.INCLUDELIST_S, "StringValidator");
            this.put(DataPumpGenOptions.INCLUDEMETADATA, "BooleanFlagValidator");
            this.put(DataPumpGenOptions.INCLUDEMETADATA_S, "BooleanFlagValidator");
            this.put(DataPumpGenOptions.INCLUDEROWS, "BooleanFlagValidator");
            this.put(DataPumpGenOptions.INCLUDEROWS_S, "BooleanFlagValidator");
            this.put(DataPumpGenOptions.JOBNAME, "StringValidator");
            this.put(DataPumpGenOptions.JOBNAME_S, "StringValidator");
            this.put(DataPumpGenOptions.KEEPMASTER, "BooleanFlagValidator");
            this.put(DataPumpGenOptions.KEEPMASTER_S, "BooleanFlagValidator");
            this.put(DataPumpGenOptions.LOGDIRECTORY, "StringValidator");
            this.put(DataPumpGenOptions.LOGDIRECTORY_S, "StringValidator");
            this.put(DataPumpGenOptions.LOGFILE, "StringValidator");
            this.put(DataPumpGenOptions.LOGFILE_S, "StringValidator");
            this.put(DataPumpGenOptions.NAMEEXPR, "StringValidator");
            this.put(DataPumpGenOptions.NAMEEXPR_S, "StringValidator");
            this.put(DataPumpGenOptions.NAMELIST, "StringValidator");
            this.put(DataPumpGenOptions.NAMELIST_S, "StringValidator");
            this.put(DataPumpGenOptions.NOEXEC, "BooleanFlagValidator");
            this.put(DataPumpGenOptions.NOEXEC_S, "BooleanFlagValidator");
            this.put(DataPumpGenOptions.OBJECTID, "BooleanFlagValidator");
            this.put(DataPumpGenOptions.OBJECTID_S, "BooleanFlagValidator");
            this.put(DataPumpGenOptions.PARALLEL, "IntegerValidator");
            this.put(DataPumpGenOptions.PARALLEL_S, "IntegerValidator");
            this.put(DataPumpGenOptions.REMAPSCHEMAS, "StringListValidator");
            this.put(DataPumpGenOptions.REMAPSCHEMAS_S, "StringListValidator");
            this.put(DataPumpGenOptions.REMAPTABLESPACES, "StringListValidator");
            this.put(DataPumpGenOptions.REMAPTABLESPACES_S, "StringListValidator");
            this.put(DataPumpGenOptions.REUSEFILE, "BooleanFlagValidator");
            this.put(DataPumpGenOptions.REUSEFILE_S, "BooleanFlagValidator");
            this.put(DataPumpGenOptions.SCHEMAS, "StringListValidator");
            this.put("s", "StringListValidator");
            this.put(DataPumpGenOptions.SEGMENTATTRIBUTES, "BooleanFlagValidator");
            this.put(DataPumpGenOptions.SEGMENTATTRIBUTES_S, "BooleanFlagValidator");
            this.put(DataPumpGenOptions.SKIPUNUSABLEINDEXES, "BooleanFlagValidator");
            this.put(DataPumpGenOptions.SKIPUNUSABLEINDEXES_S, "BooleanFlagValidator");
            this.put(DataPumpGenOptions.STORAGE, "BooleanFlagValidator");
            this.put(DataPumpGenOptions.STORAGE_S, "BooleanFlagValidator");
            this.put(DataPumpGenOptions.TABLEEXISTS, "StringValidator");
            this.put(DataPumpGenOptions.TABLEEXISTS_S, "StringValidator");
            this.put(DataPumpGenOptions.TABLECOMPRESSION, "BooleanFlagValidator");
            this.put(DataPumpGenOptions.TABLECOMPRESSION_S, "BooleanFlagValidator");
            this.put(DataPumpGenOptions.VERBOSE, "BooleanFlagValidator");
            this.put(DataPumpGenOptions.VERBOSE_S, "BooleanFlagValidator");
            this.put(DataPumpGenOptions.VERSION, "StringValidator");
            this.put(DataPumpGenOptions.VERSION_S, "StringValidator");
            this.put(DataPumpGenOptions.WAIT, "BooleanFlagValidator");
            this.put(DataPumpGenOptions.WAIT_S, "BooleanFlagValidator");
            this.put("dummy", "DummyValidator");
        }
    };
    public static final HashMap<String, DataPumpOption> options = new HashMap<String, DataPumpOption>(){
        private static final long serialVersionUID = 1L;
        {
            this.put(DataPumpGenOptions.COLUMNENCRYPTION, new DataPumpOption(DataPumpOption.Operation.IMPORT, DataPumpOption.SubProgram.METADATA_TRANSFORM, "OMIT_ENCRYPTION_CLAUSE", DataPumpOption.ParameterType.BOOLEAN));
            this.put(DataPumpGenOptions.COMPRESSION, new DataPumpOption(DataPumpOption.Operation.EXPORT, DataPumpOption.SubProgram.PARAMETER, "COMPRESSION", DataPumpOption.ParameterType.STRING, null, COMPRESSION_VALUES.class));
            this.put(DataPumpGenOptions.COPYCLOUD, new DataPumpOption(DataPumpOption.Operation.BOTH, DataPumpOption.SubProgram.UNKNOWN, "COPYCLOUD", DataPumpOption.ParameterType.BOOLEAN));
            this.put(DataPumpGenOptions.CREDENTIAL, new DataPumpOption(DataPumpOption.Operation.BOTH, DataPumpOption.SubProgram.FILE, "CREDENTIAL", DataPumpOption.ParameterType.STRING));
            this.put(DataPumpGenOptions.DATAACCESSMETHOD, new DataPumpOption(DataPumpOption.Operation.BOTH, DataPumpOption.SubProgram.PARAMETER, "DATA_ACCESS_METHOD"));
            this.put(DataPumpGenOptions.DEBUG, new DataPumpOption(DataPumpOption.Operation.BOTH, DataPumpOption.SubProgram.UNKNOWN, "DEBUG", DataPumpOption.ParameterType.BOOLEAN));
            this.put(DataPumpGenOptions.DIRECTORY, new DataPumpOption(DataPumpOption.Operation.BOTH, DataPumpOption.SubProgram.FILE, "DIRECTORY", DataPumpOption.ParameterType.STRING));
            this.put(DataPumpGenOptions.DUMPDIRECTORY, new DataPumpOption(DataPumpOption.Operation.BOTH, DataPumpOption.SubProgram.FILE, "DIRECTORY", DataPumpOption.ParameterType.STRING));
            this.put(DataPumpGenOptions.DUMPFILE, new DataPumpOption(DataPumpOption.Operation.BOTH, DataPumpOption.SubProgram.FILE, "FILENAME", DataPumpOption.ParameterType.STRING));
            this.put(DataPumpGenOptions.DUMPURI, new DataPumpOption(DataPumpOption.Operation.BOTH, DataPumpOption.SubProgram.FILE, "FILENAME", DataPumpOption.ParameterType.STRING));
            this.put(DataPumpGenOptions.DWCSCVTIOTS, new DataPumpOption(DataPumpOption.Operation.IMPORT, DataPumpOption.SubProgram.METADATA_TRANSFORM, "DWCS_CVT_IOTS", DataPumpOption.ParameterType.BOOLEAN));
            this.put(DataPumpGenOptions.DWCSCVTCONSTRAINTS, new DataPumpOption(DataPumpOption.Operation.IMPORT, DataPumpOption.SubProgram.METADATA_TRANSFORM, "DWCS_CVT_CONSTRAINTS", DataPumpOption.ParameterType.BOOLEAN));
            this.put(DataPumpGenOptions.ENCRYPTION, new DataPumpOption(DataPumpOption.Operation.EXPORT, DataPumpOption.SubProgram.PARAMETER, "ENCRYPTION", DataPumpOption.ParameterType.STRING, null, ENCRYPTION_VALUES.class));
            this.put(DataPumpGenOptions.ENCRYPTIONALGORITHM, new DataPumpOption(DataPumpOption.Operation.EXPORT, DataPumpOption.SubProgram.PARAMETER, "ENCRYPTION_ALGORITHM", DataPumpOption.ParameterType.STRING, null, ENCRYPTIONALGORITHM_VALUES.class));
            this.put(DataPumpGenOptions.ENCRYPTIONMODE, new DataPumpOption(DataPumpOption.Operation.EXPORT, DataPumpOption.SubProgram.PARAMETER, "ENCRYPTION_MODE", DataPumpOption.ParameterType.STRING, null, ENCRYPTIONMODE_VALUES.class));
            this.put(DataPumpGenOptions.ENCRYPTIONPASSWORD, new DataPumpOption(DataPumpOption.Operation.BOTH, DataPumpOption.SubProgram.PARAMETER, "ENCRYPTION_PASSWORD", DataPumpOption.ParameterType.STRING));
            this.put(DataPumpGenOptions.ESTIMATE, new DataPumpOption(DataPumpOption.Operation.EXPORT, DataPumpOption.SubProgram.PARAMETER, "ESTIMATE", DataPumpOption.ParameterType.STRING, null, ESTIMATE_VALUES.class));
            this.put(DataPumpGenOptions.EXCLUDEEXPR, new DataPumpOption(DataPumpOption.Operation.BOTH, DataPumpOption.SubProgram.FILTER, "EXCLUDE_PATH_EXPR", DataPumpOption.ParameterType.STRING));
            this.put(DataPumpGenOptions.EXCLUDELIST, new DataPumpOption(DataPumpOption.Operation.BOTH, DataPumpOption.SubProgram.FILTER, "EXCLUDE_PATH_LIST", DataPumpOption.ParameterType.STRING));
            this.put(DataPumpGenOptions.EXCLUDEDWCS, new DataPumpOption(DataPumpOption.Operation.IMPORT, DataPumpOption.SubProgram.FILTER, "EXCLUDE_PATH_EXPR", DataPumpOption.ParameterType.STRING));
            this.put(DataPumpGenOptions.FILESIZE, new DataPumpOption(DataPumpOption.Operation.EXPORT, DataPumpOption.SubProgram.FILE, "FILESIZE", DataPumpOption.ParameterType.STRING));
            this.put(DataPumpGenOptions.FLASHBACKSCN, new DataPumpOption(DataPumpOption.Operation.EXPORT, DataPumpOption.SubProgram.PARAMETER, "FLASHBACK_SCN", DataPumpOption.ParameterType.PLSQL));
            this.put(DataPumpGenOptions.HELP, new DataPumpOption(DataPumpOption.Operation.BOTH, DataPumpOption.SubProgram.UNKNOWN, "HELP"));
            this.put(DataPumpGenOptions.IMPORT, new DataPumpOption(DataPumpOption.Operation.IMPORT, DataPumpOption.SubProgram.UNKNOWN, "IMPORT"));
            this.put(DataPumpGenOptions.INCLUDEEXPR, new DataPumpOption(DataPumpOption.Operation.BOTH, DataPumpOption.SubProgram.FILTER, "INCLUDE_PATH_EXPR", DataPumpOption.ParameterType.STRING));
            this.put(DataPumpGenOptions.INCLUDELIST, new DataPumpOption(DataPumpOption.Operation.BOTH, DataPumpOption.SubProgram.FILTER, "INCLUDE_PATH_LIST", DataPumpOption.ParameterType.STRING));
            this.put(DataPumpGenOptions.INCLUDEMETADATA, new DataPumpOption(DataPumpOption.Operation.BOTH, DataPumpOption.SubProgram.PARAMETER, "INCLUDE_METADATA", DataPumpOption.ParameterType.BOOLEAN, "s"));
            this.put(DataPumpGenOptions.INCLUDEROWS, new DataPumpOption(DataPumpOption.Operation.BOTH, DataPumpOption.SubProgram.DATA_FILTER, "INCLUDE_ROWS", DataPumpOption.ParameterType.BOOLEAN, "s"));
            this.put(DataPumpGenOptions.JOBNAME, new DataPumpOption(DataPumpOption.Operation.BOTH, DataPumpOption.SubProgram.START, "JOBNAME", DataPumpOption.ParameterType.STRING));
            this.put(DataPumpGenOptions.JOBMODE, new DataPumpOption(DataPumpOption.Operation.BOTH, DataPumpOption.SubProgram.OPEN, "JOB_MODE", DataPumpOption.ParameterType.STRING));
            this.put(DataPumpGenOptions.KEEPMASTER, new DataPumpOption(DataPumpOption.Operation.BOTH, DataPumpOption.SubProgram.PARAMETER, "KEEP_MASTER", DataPumpOption.ParameterType.BOOLEAN));
            this.put(DataPumpGenOptions.LOGDIRECTORY, new DataPumpOption(DataPumpOption.Operation.BOTH, DataPumpOption.SubProgram.FILE, "DIRECTORY", DataPumpOption.ParameterType.STRING));
            this.put(DataPumpGenOptions.LOGFILE, new DataPumpOption(DataPumpOption.Operation.BOTH, DataPumpOption.SubProgram.FILE, "FILENAME", DataPumpOption.ParameterType.STRING));
            this.put(DataPumpGenOptions.NAMEEXPR, new DataPumpOption(DataPumpOption.Operation.BOTH, DataPumpOption.SubProgram.FILTER, "NAME_EXPR", DataPumpOption.ParameterType.STRING));
            this.put(DataPumpGenOptions.NAMELIST, new DataPumpOption(DataPumpOption.Operation.BOTH, DataPumpOption.SubProgram.FILTER, "NAME_LIST", DataPumpOption.ParameterType.STRING));
            this.put(DataPumpGenOptions.NOEXEC, new DataPumpOption(DataPumpOption.Operation.BOTH, DataPumpOption.SubProgram.UNKNOWN, "NOEXEC", DataPumpOption.ParameterType.BOOLEAN));
            this.put(DataPumpGenOptions.OBJECTID, new DataPumpOption(DataPumpOption.Operation.IMPORT, DataPumpOption.SubProgram.METADATA_TRANSFORM, "OID", DataPumpOption.ParameterType.BOOLEAN, "s"));
            this.put(DataPumpGenOptions.OPERATION, new DataPumpOption(DataPumpOption.Operation.BOTH, DataPumpOption.SubProgram.OPEN, "OPERATION", DataPumpOption.ParameterType.STRING));
            this.put(DataPumpGenOptions.PARALLEL, new DataPumpOption(DataPumpOption.Operation.BOTH, DataPumpOption.SubProgram.PARALLEL, "PARALLEL", DataPumpOption.ParameterType.NUMBER));
            this.put(DataPumpGenOptions.PARTITIONOPTIONS, new DataPumpOption(DataPumpOption.Operation.IMPORT, DataPumpOption.SubProgram.PARAMETER, "PARTITION_OPTIONS"));
            this.put(DataPumpGenOptions.REMAPSCHEMAS, new DataPumpOption(DataPumpOption.Operation.IMPORT, DataPumpOption.SubProgram.REMAP, "REMAP_SCHEMA", DataPumpOption.ParameterType.STRING));
            this.put(DataPumpGenOptions.REMAPTABLESPACES, new DataPumpOption(DataPumpOption.Operation.IMPORT, DataPumpOption.SubProgram.REMAP, "REMAP_TABLESPACE", DataPumpOption.ParameterType.STRING));
            this.put(DataPumpGenOptions.REUSEFILE, new DataPumpOption(DataPumpOption.Operation.EXPORT, DataPumpOption.SubProgram.FILE, "REUSEFILE", DataPumpOption.ParameterType.BOOLEAN));
            this.put(DataPumpGenOptions.SCHEMAS, new DataPumpOption(DataPumpOption.Operation.BOTH, DataPumpOption.SubProgram.FILTER, "SCHEMA_EXPR", DataPumpOption.ParameterType.STRING));
            this.put(DataPumpGenOptions.SEGMENTATTRIBUTES, new DataPumpOption(DataPumpOption.Operation.IMPORT, DataPumpOption.SubProgram.METADATA_TRANSFORM, "SEGMENT_ATTRIBUTES", DataPumpOption.ParameterType.BOOLEAN, "s"));
            this.put(DataPumpGenOptions.SKIPUNUSABLEINDEXES, new DataPumpOption(DataPumpOption.Operation.IMPORT, DataPumpOption.SubProgram.PARAMETER, "SKIP_UNUSABLE_INDEXES", DataPumpOption.ParameterType.BOOLEAN, null));
            this.put(DataPumpGenOptions.STORAGE, new DataPumpOption(DataPumpOption.Operation.IMPORT, DataPumpOption.SubProgram.METADATA_TRANSFORM, "STORAGE", DataPumpOption.ParameterType.BOOLEAN, "s"));
            this.put(DataPumpGenOptions.TABLEEXISTS, new DataPumpOption(DataPumpOption.Operation.IMPORT, DataPumpOption.SubProgram.PARAMETER, "TABLE_EXISTS_ACTION", DataPumpOption.ParameterType.STRING, null, TABLEEXISTS_VALUES.class));
            this.put(DataPumpGenOptions.TABLECOMPRESSION, new DataPumpOption(DataPumpOption.Operation.IMPORT, DataPumpOption.SubProgram.METADATA_TRANSFORM, "TABLE_COMPRESSION_CLAUSE", DataPumpOption.ParameterType.STRING));
            this.put(DataPumpGenOptions.TRACE, new DataPumpOption(DataPumpOption.Operation.IMPORT, DataPumpOption.SubProgram.PARAMETER, "TRACE", DataPumpOption.ParameterType.NUMBER));
            this.put(DataPumpGenOptions.VERBOSE, new DataPumpOption(DataPumpOption.Operation.BOTH, DataPumpOption.SubProgram.UNKNOWN, "VERBOSE", DataPumpOption.ParameterType.BOOLEAN));
            this.put(DataPumpGenOptions.VERSION, new DataPumpOption(DataPumpOption.Operation.BOTH, DataPumpOption.SubProgram.OPEN, "VERSION", DataPumpOption.ParameterType.STRING));
            this.put(DataPumpGenOptions.WAIT, new DataPumpOption(DataPumpOption.Operation.BOTH, DataPumpOption.SubProgram.WAIT, "WAIT", DataPumpOption.ParameterType.BOOLEAN));
        }
    };
    public static final HashMap<String, String> aliases = new HashMap<String, String>(){
        {
            this.put(DataPumpGenOptions.COLUMNENCRYPTION_S, DataPumpGenOptions.COLUMNENCRYPTION);
            this.put(DataPumpGenOptions.COMPRESSION_S, DataPumpGenOptions.COMPRESSION);
            this.put(DataPumpGenOptions.COPYCLOUD_S, DataPumpGenOptions.COPYCLOUD);
            this.put(DataPumpGenOptions.CREDENTIAL_S, DataPumpGenOptions.CREDENTIAL);
            this.put(DataPumpGenOptions.DEBUG_S, DataPumpGenOptions.DEBUG);
            this.put(DataPumpGenOptions.DIRECTORY_S, DataPumpGenOptions.DIRECTORY);
            this.put(DataPumpGenOptions.DUMPDIRECTORY_S, DataPumpGenOptions.DUMPDIRECTORY);
            this.put(DataPumpGenOptions.DUMPFILE_S, DataPumpGenOptions.DUMPFILE);
            this.put(DataPumpGenOptions.DUMPURI_S, DataPumpGenOptions.DUMPURI);
            this.put(DataPumpGenOptions.ENCRYPTION_S, DataPumpGenOptions.ENCRYPTION);
            this.put(DataPumpGenOptions.ENCRYPTIONALGORITHM_S, DataPumpGenOptions.ENCRYPTIONALGORITHM);
            this.put(DataPumpGenOptions.ENCRYPTIONMODE_S, DataPumpGenOptions.ENCRYPTIONMODE);
            this.put(DataPumpGenOptions.ENCRYPTIONPASSWORD_S, DataPumpGenOptions.ENCRYPTIONPASSWORD);
            this.put(DataPumpGenOptions.ESTIMATE_S, DataPumpGenOptions.ESTIMATE);
            this.put(DataPumpGenOptions.EXCLUDEEXPR_S, DataPumpGenOptions.EXCLUDEEXPR);
            this.put(DataPumpGenOptions.EXCLUDELIST_S, DataPumpGenOptions.EXCLUDELIST);
            this.put(DataPumpGenOptions.FILESIZE_S, DataPumpGenOptions.FILESIZE);
            this.put(DataPumpGenOptions.FLASHBACKSCN_S, DataPumpGenOptions.FLASHBACKSCN);
            this.put(DataPumpGenOptions.INCLUDEEXPR_S, DataPumpGenOptions.INCLUDEEXPR);
            this.put(DataPumpGenOptions.INCLUDELIST_S, DataPumpGenOptions.INCLUDELIST);
            this.put(DataPumpGenOptions.INCLUDEMETADATA_S, DataPumpGenOptions.INCLUDEMETADATA);
            this.put(DataPumpGenOptions.INCLUDEROWS_S, DataPumpGenOptions.INCLUDEROWS);
            this.put(DataPumpGenOptions.JOBNAME_S, DataPumpGenOptions.JOBNAME);
            this.put(DataPumpGenOptions.KEEPMASTER_S, DataPumpGenOptions.KEEPMASTER);
            this.put(DataPumpGenOptions.LOGDIRECTORY_S, DataPumpGenOptions.LOGDIRECTORY);
            this.put(DataPumpGenOptions.LOGFILE_S, DataPumpGenOptions.LOGFILE);
            this.put(DataPumpGenOptions.NAMEEXPR_S, DataPumpGenOptions.NAMEEXPR);
            this.put(DataPumpGenOptions.NAMELIST_S, DataPumpGenOptions.NAMELIST);
            this.put(DataPumpGenOptions.OBJECTID_S, DataPumpGenOptions.OBJECTID);
            this.put(DataPumpGenOptions.PARALLEL_S, DataPumpGenOptions.PARALLEL);
            this.put(DataPumpGenOptions.NOEXEC_S, DataPumpGenOptions.NOEXEC);
            this.put(DataPumpGenOptions.REMAPSCHEMAS_S, DataPumpGenOptions.REMAPSCHEMAS);
            this.put(DataPumpGenOptions.REUSEFILE_S, DataPumpGenOptions.REUSEFILE);
            this.put(DataPumpGenOptions.REMAPTABLESPACES_S, DataPumpGenOptions.REMAPTABLESPACES);
            this.put("s", DataPumpGenOptions.SCHEMAS);
            this.put(DataPumpGenOptions.SEGMENTATTRIBUTES_S, DataPumpGenOptions.SEGMENTATTRIBUTES);
            this.put(DataPumpGenOptions.STORAGE_S, DataPumpGenOptions.STORAGE);
            this.put(DataPumpGenOptions.SKIPUNUSABLEINDEXES_S, DataPumpGenOptions.SKIPUNUSABLEINDEXES);
            this.put(DataPumpGenOptions.TABLEEXISTS_S, DataPumpGenOptions.TABLEEXISTS);
            this.put(DataPumpGenOptions.TABLECOMPRESSION_S, DataPumpGenOptions.TABLECOMPRESSION);
            this.put(DataPumpGenOptions.VERBOSE_S, DataPumpGenOptions.VERBOSE);
            this.put(DataPumpGenOptions.VERSION_S, DataPumpGenOptions.VERSION);
            this.put(DataPumpGenOptions.WAIT_S, DataPumpGenOptions.WAIT);
        }
    };

    public static void setArgumentDefaults(Map<String, Object> args) {
        args.put(COLUMNENCRYPTION, "TRUE");
        args.put(COPYCLOUD, "FALSE");
        args.put(DEBUG, "FALSE");
        args.put(DIRECTORY, "DATA_PUMP_DIR");
        args.put(FILESIZE, "500MB");
        args.put(INCLUDEMETADATA, "TRUE");
        args.put(INCLUDEROWS, "TRUE");
        args.put(JOBMODE, "SCHEMA");
        args.put(KEEPMASTER, "TRUE");
        args.put(NOEXEC, "FALSE");
        args.put(REUSEFILE, "TRUE");
        args.put(VERBOSE, "FALSE");
        args.put(VERSION, "COMPATIBLE");
        args.put(TABLECOMPRESSION, "TRUE");
        args.put(WAIT, "TRUE");
    }

    public static DataPumpOption getOption(String key) {
        String aKey;
        String lKey = key.toLowerCase();
        DataPumpOption opt = options.get(lKey);
        if (opt == null && (aKey = aliases.get(lKey)) != null) {
            return options.get(aKey);
        }
        return opt;
    }

    public static String getName(String nameOrAlias) {
        if (options.get(nameOrAlias) != null) {
            return nameOrAlias;
        }
        return aliases.get(nameOrAlias);
    }

    public static Map<String, DataPumpOption> getOptions() {
        return options;
    }

    public static Map<String, DataPumpOption> getOptions(DataPumpOption.Operation operation) {
        HashMap<String, DataPumpOption> opts = new HashMap<String, DataPumpOption>();
        for (Map.Entry<String, DataPumpOption> entry : options.entrySet()) {
            DataPumpOption opt = entry.getValue();
            if (opt.getOperation() != operation && opt.getOperation() != DataPumpOption.Operation.BOTH) continue;
            opts.put(entry.getKey(), entry.getValue());
        }
        return opts;
    }

    public static Map<String, DataPumpOption> getOptions(DataPumpOption.Operation operation, DataPumpOption.SubProgram subProgram) {
        HashMap<String, DataPumpOption> opts = new HashMap<String, DataPumpOption>();
        for (Map.Entry<String, DataPumpOption> entry : options.entrySet()) {
            DataPumpOption opt = entry.getValue();
            if (opt.getSubProgram() != subProgram || opt.getOperation() != operation && opt.getOperation() != DataPumpOption.Operation.BOTH) continue;
            opts.put(entry.getKey(), entry.getValue());
        }
        return opts;
    }

    public static Map<String, DataPumpOption> getGenBooleanOptions() {
        HashMap<String, DataPumpOption> opts = new HashMap<String, DataPumpOption>();
        for (Map.Entry<String, DataPumpOption> entry : options.entrySet()) {
            DataPumpOption opt = entry.getValue();
            if (opt.getGenBoolean() == null) continue;
            opts.put(entry.getKey(), entry.getValue());
        }
        return opts;
    }

    public static enum TABLEEXISTS_VALUES {
        TRUNCATE,
        REPLACE,
        APPEND,
        SKIP;

    }

    public static enum ESTIMATE_VALUES {
        BLOCKS,
        STATISTICS;

    }

    public static enum ENCRYPTIONMODE_VALUES {
        DUAL,
        PASSWORD,
        TRANSPARENT;

    }

    public static enum ENCRYPTIONALGORITHM_VALUES {
        AES128,
        AES192,
        AES256;

    }

    public static enum ENCRYPTION_VALUES {
        ALL,
        DATA_ONLY,
        ENCRYPTED_COLUMNS_ONLY,
        METADATA_ONLY,
        NONE;

    }

    public static enum COMPRESSION_VALUES {
        ALL,
        DATA_ONLY,
        METADATA_ONLY,
        NONE;

    }
}

