/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.parsson;

import jakarta.json.JsonArray;
import jakarta.json.JsonException;
import jakarta.json.JsonObject;
import jakarta.json.JsonStructure;
import jakarta.json.JsonValue;
import org.eclipse.parsson.JsonArrayBuilderImpl;
import org.eclipse.parsson.JsonContext;
import org.eclipse.parsson.JsonMessages;
import org.eclipse.parsson.JsonObjectBuilderImpl;

abstract class NodeReference {
    NodeReference() {
    }

    public abstract boolean contains();

    public abstract JsonValue get();

    public abstract JsonStructure add(JsonValue var1);

    public abstract JsonStructure remove();

    public abstract JsonStructure replace(JsonValue var1);

    static NodeReference of(JsonStructure structure) {
        return new RootReference(structure);
    }

    static NodeReference of(JsonObject object, String name, JsonContext jsonContext) {
        return new ObjectReference(object, name, jsonContext);
    }

    static NodeReference of(JsonArray array, int index, JsonContext jsonContext) {
        return new ArrayReference(array, index, jsonContext);
    }

    static class RootReference
    extends NodeReference {
        private JsonStructure root;

        RootReference(JsonStructure root) {
            this.root = root;
        }

        @Override
        public boolean contains() {
            return this.root != null;
        }

        @Override
        public JsonValue get() {
            return this.root;
        }

        @Override
        public JsonStructure add(JsonValue value) {
            switch (value.getValueType()) {
                case OBJECT: 
                case ARRAY: {
                    this.root = (JsonStructure)value;
                    break;
                }
                default: {
                    throw new JsonException(JsonMessages.NODEREF_VALUE_ADD_ERR());
                }
            }
            return this.root;
        }

        @Override
        public JsonStructure remove() {
            throw new JsonException(JsonMessages.NODEREF_VALUE_CANNOT_REMOVE());
        }

        @Override
        public JsonStructure replace(JsonValue value) {
            return this.add(value);
        }
    }

    static class ObjectReference
    extends NodeReference {
        private final JsonObject object;
        private final String key;
        private final JsonContext jsonContext;

        ObjectReference(JsonObject object, String key, JsonContext jsonContext) {
            this.object = object;
            this.key = key;
            this.jsonContext = jsonContext;
        }

        @Override
        public boolean contains() {
            return this.object != null && this.object.containsKey((Object)this.key);
        }

        @Override
        public JsonValue get() {
            if (!this.contains()) {
                throw new JsonException(JsonMessages.NODEREF_OBJECT_MISSING(this.key));
            }
            return (JsonValue)this.object.get((Object)this.key);
        }

        public JsonObject add(JsonValue value) {
            return new JsonObjectBuilderImpl(this.object, this.jsonContext).add(this.key, value).build();
        }

        public JsonObject remove() {
            if (!this.contains()) {
                throw new JsonException(JsonMessages.NODEREF_OBJECT_MISSING(this.key));
            }
            return new JsonObjectBuilderImpl(this.object, this.jsonContext).remove(this.key).build();
        }

        public JsonObject replace(JsonValue value) {
            if (!this.contains()) {
                throw new JsonException(JsonMessages.NODEREF_OBJECT_MISSING(this.key));
            }
            return this.add(value);
        }
    }

    static class ArrayReference
    extends NodeReference {
        private final JsonArray array;
        private final int index;
        private final JsonContext jsonContext;

        ArrayReference(JsonArray array, int index, JsonContext jsonContext) {
            this.array = array;
            this.index = index;
            this.jsonContext = jsonContext;
        }

        @Override
        public boolean contains() {
            return this.array != null && this.index > -1 && this.index < this.array.size();
        }

        @Override
        public JsonValue get() {
            if (!this.contains()) {
                throw new JsonException(JsonMessages.NODEREF_ARRAY_INDEX_ERR(this.index, this.array.size()));
            }
            return (JsonValue)this.array.get(this.index);
        }

        public JsonArray add(JsonValue value) {
            JsonArrayBuilderImpl builder = new JsonArrayBuilderImpl(this.array, this.jsonContext);
            if (this.index == -1 || this.index == this.array.size()) {
                builder.add(value);
            } else if (this.index < this.array.size()) {
                builder.add(this.index, value);
            } else {
                throw new JsonException(JsonMessages.NODEREF_ARRAY_INDEX_ERR(this.index, this.array.size()));
            }
            return builder.build();
        }

        public JsonArray remove() {
            if (!this.contains()) {
                throw new JsonException(JsonMessages.NODEREF_ARRAY_INDEX_ERR(this.index, this.array.size()));
            }
            JsonArrayBuilderImpl builder = new JsonArrayBuilderImpl(this.array, this.jsonContext);
            return builder.remove(this.index).build();
        }

        public JsonArray replace(JsonValue value) {
            if (!this.contains()) {
                throw new JsonException(JsonMessages.NODEREF_ARRAY_INDEX_ERR(this.index, this.array.size()));
            }
            JsonArrayBuilderImpl builder = new JsonArrayBuilderImpl(this.array, this.jsonContext);
            return builder.set(this.index, value).build();
        }
    }
}

