/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.apex.utility;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import oracle.dbtools.extension.apex.help.ApexMessages;
import oracle.dbtools.raptor.newscriptrunner.parameterparser.exception.InvalidParameterException;

public class APEXLangUtils {
    public static final String SUPPORTED_APEXLANG_APEX_VERSION = "25.1";
    public static final String APPLICATION_APEX = "application/apex";
    public static final String APPLICATION_ZIP = "application/zip";
    public static final String FILE_EXPORT_DIR_TO_REMOVE = "application/";

    public static boolean isDirectory(Path filepath) {
        return Files.isDirectory(filepath, new LinkOption[0]);
    }

    public static boolean isZip(Path filepath) {
        return filepath.toString().endsWith(".zip");
    }

    public static boolean isAPEXLangFile(Path filepath) {
        return filepath.toString().endsWith(".apx");
    }

    public static boolean isDirectoryOrZip(Path filepath) {
        return APEXLangUtils.isDirectory(filepath) || APEXLangUtils.isZip(filepath);
    }

    public static Path resolveRelativePathOption(String pathStr, String cwd) throws InvalidParameterException {
        if (pathStr == null) {
            return null;
        }
        Path path = Paths.get(pathStr, new String[0]);
        if (path.isAbsolute()) {
            return path;
        }
        if (cwd != null) {
            return Paths.get(cwd, new String[0]).resolve(APEXLangUtils.expandTilde(path.toString()));
        }
        throw new InvalidParameterException(ApexMessages.getString("CWD_ERROR"));
    }

    public static boolean directoryContainsManifestOrAPEXlang(Path dir) throws InvalidParameterException, IOException {
        if (APEXLangUtils.isDirectory(dir)) {
            if (Files.exists(dir.resolve("config.json"), new LinkOption[0])) {
                return true;
            }
            try (Stream<Path> stream = Files.list(dir);){
                List results = stream.filter(file -> APEXLangUtils.isAPEXLangFile(file)).collect(Collectors.toList());
                boolean bl = results.size() > 0;
                return bl;
            }
        }
        throw new InvalidParameterException(ApexMessages.getString("DIRECTORY_PATH_ERROR"));
    }

    public static boolean isApplicationFile(String filename) {
        return filename.equals("application.apx");
    }

    public static String expandTilde(String path) {
        Path inputPath = Path.of(path, new String[0]);
        String firstSubPath = inputPath.subpath(0, 1).toString();
        if (firstSubPath.equals("~")) {
            Path userHomePath = Path.of(System.getProperty("user.home"), new String[0]);
            Path inputPathWithoutTilde = inputPath.subpath(1, inputPath.getNameCount());
            return userHomePath.resolve(inputPathWithoutTilde).toString();
        }
        return path;
    }

    public static String getAPEXlangExtension() {
        return ".apx";
    }
}

