/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.apex.core.apexlang;

import oracle.dbtools.extension.apex.core.apexlang.APEXLangPosition;

public class APEXLangRange {
    private final APEXLangPosition start;
    private final APEXLangPosition end;

    private APEXLangRange(Builder builder) {
        this.start = builder.start;
        this.end = builder.end;
    }

    public static Builder builder() {
        return new Builder();
    }

    public APEXLangPosition start() {
        return this.start;
    }

    public APEXLangPosition end() {
        return this.end;
    }

    static APEXLangRange of(int startLine, int startChar, int endLine, int endChar) {
        return APEXLangRange.builder().start(APEXLangPosition.builder().line(startLine).character(startChar).build()).end(APEXLangPosition.builder().line(endLine).character(endChar).build()).build();
    }

    public static class Builder {
        private APEXLangPosition start;
        private APEXLangPosition end;

        private Builder() {
        }

        public Builder start(APEXLangPosition start) {
            this.start = start;
            return this;
        }

        public Builder end(APEXLangPosition end) {
            this.end = end;
            return this;
        }

        public APEXLangRange build() {
            return new APEXLangRange(this);
        }
    }
}

